/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class MD5Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 16;
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X;
    private int xOff;

    public MD5Digest() {
        MD5Digest mD5Digest = this;
        mD5Digest.X = new int[16];
        mD5Digest.reset();
    }

    public MD5Digest(byte[] byArray) {
        super(byArray);
        this.X = new int[16];
        this.H1 = Pack.bigEndianToInt(byArray, 16);
        this.H2 = Pack.bigEndianToInt(byArray, 20);
        this.H3 = Pack.bigEndianToInt(byArray, 24);
        this.H4 = Pack.bigEndianToInt(byArray, 28);
        this.xOff = Pack.bigEndianToInt(byArray, 32);
        for (int i3 = 0; i3 != this.xOff; ++i3) {
            this.X[i3] = Pack.bigEndianToInt(byArray, i3 * 4 + 36);
        }
    }

    public MD5Digest(MD5Digest mD5Digest) {
        super(mD5Digest);
        this.X = new int[16];
        this.copyIn(mD5Digest);
    }

    private void copyIn(MD5Digest mD5Digest) {
        MD5Digest mD5Digest2 = object;
        MD5Digest mD5Digest3 = mD5Digest;
        super.copyIn(mD5Digest);
        ((MD5Digest)object).H1 = mD5Digest.H1;
        ((MD5Digest)object).H2 = mD5Digest.H2;
        ((MD5Digest)object).H3 = mD5Digest.H3;
        ((MD5Digest)object).H4 = mD5Digest.H4;
        Object object = ((MD5Digest)object).X;
        int n3 = mD5Digest3.X.length;
        System.arraycopy(mD5Digest3.X, 0, object, 0, n3);
        mD5Digest2.xOff = mD5Digest3.xOff;
    }

    private void unpackWord(int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)n3;
        int n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >>> 8);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >>> 16);
        n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >>> 24);
    }

    private int rotateLeft(int n3, int n4) {
        return n3 << n4 | n3 >>> 32 - n4;
    }

    private int F(int n3, int n4, int n5) {
        return n3 & n4 | ~n3 & n5;
    }

    private int G(int n3, int n4, int n5) {
        return n3 & n5 | n4 & ~n5;
    }

    private int H(int n3, int n4, int n5) {
        return n3 ^ n4 ^ n5;
    }

    private int K(int n3, int n4, int n5) {
        return n4 ^ (n3 | ~n5);
    }

    @Override
    public String getAlgorithmName() {
        return "MD5";
    }

    @Override
    public int getDigestSize() {
        return 16;
    }

    @Override
    public void processWord(byte[] byArray, int n3) {
        int n4;
        MD5Digest mD5Digest = this;
        int[] nArray = mD5Digest.X;
        int n5 = mD5Digest.xOff;
        this.xOff = n4 = n5 + 1;
        nArray[n5] = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 3] & 0xFF) << 24;
        if (n4 == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l3) {
        if (((MD5Digest)object).xOff > 14) {
            ((MD5Digest)object).processBlock();
        }
        Object object = ((MD5Digest)object).X;
        object[14] = (int)(l3 & 0xFFFFFFFFFFFFFFFFL);
        ((MD5Digest)object).X[15] = (int)(l3 >>> 32);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        MD5Digest mD5Digest = this;
        mD5Digest.finish();
        mD5Digest.unpackWord(mD5Digest.H1, byArray, n3);
        mD5Digest.unpackWord(mD5Digest.H2, byArray, n3 + 4);
        mD5Digest.unpackWord(mD5Digest.H3, byArray, n3 + 8);
        mD5Digest.unpackWord(mD5Digest.H4, byArray, n3 + 12);
        mD5Digest.reset();
        return 16;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.xOff = 0;
        int n3 = 0;
        while (true) {
            int[] nArray = this.X;
            if (n3 == this.X.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    @Override
    public void processBlock() {
        MD5Digest mD5Digest = this;
        int n3 = mD5Digest.H1;
        int n4 = mD5Digest.H2;
        int n5 = n4;
        MD5Digest mD5Digest2 = this;
        int n6 = mD5Digest2.H3;
        int n7 = n6;
        MD5Digest mD5Digest3 = this;
        int n8 = mD5Digest3.H4;
        MD5Digest mD5Digest4 = this;
        n3 = mD5Digest4.rotateLeft(n3 + this.F(n5, n7, n8) + this.X[0] + -680876936, 7) + n5;
        n7 = mD5Digest3.rotateLeft(n8 + mD5Digest4.F(n3, n5, n7) + this.X[1] + -389564586, 12) + n3;
        n5 = mD5Digest2.rotateLeft(n6 + mD5Digest3.F(n7, n3, n5) + this.X[2] + 606105819, 17) + n7;
        n8 = mD5Digest.rotateLeft(n4 + mD5Digest2.F(n5, n7, n3) + this.X[3] + -1044525330, 22) + n5;
        MD5Digest mD5Digest5 = this;
        int n9 = n5;
        MD5Digest mD5Digest6 = this;
        MD5Digest mD5Digest7 = this;
        n3 = mD5Digest7.rotateLeft(n3 + this.F(n8, n5, n7) + this.X[4] + -176418897, 7) + n8;
        n5 = mD5Digest6.rotateLeft(n7 + mD5Digest7.F(n3, n8, n5) + this.X[5] + 1200080426, 12) + n3;
        n7 = mD5Digest5.rotateLeft(n9 + mD5Digest6.F(n5, n3, n8) + this.X[6] + -1473231341, 17) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest5.F(n7, n5, n3) + this.X[7] + -45705983, 22) + n7;
        MD5Digest mD5Digest8 = this;
        MD5Digest mD5Digest9 = this;
        MD5Digest mD5Digest10 = this;
        n3 = mD5Digest10.rotateLeft(n3 + this.F(n8, n7, n5) + this.X[8] + 1770035416, 7) + n8;
        n5 = mD5Digest9.rotateLeft(n5 + mD5Digest10.F(n3, n8, n7) + this.X[9] + -1958414417, 12) + n3;
        n7 = mD5Digest8.rotateLeft(n7 + mD5Digest9.F(n5, n3, n8) + this.X[10] + -42063, 17) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest8.F(n7, n5, n3) + this.X[11] + -1990404162, 22) + n7;
        MD5Digest mD5Digest11 = this;
        MD5Digest mD5Digest12 = this;
        MD5Digest mD5Digest13 = this;
        n3 = mD5Digest13.rotateLeft(n3 + this.F(n8, n7, n5) + this.X[12] + 1804603682, 7) + n8;
        n5 = mD5Digest12.rotateLeft(n5 + mD5Digest13.F(n3, n8, n7) + this.X[13] + -40341101, 12) + n3;
        n7 = mD5Digest11.rotateLeft(n7 + mD5Digest12.F(n5, n3, n8) + this.X[14] + -1502002290, 17) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest11.F(n7, n5, n3) + this.X[15] + 1236535329, 22) + n7;
        MD5Digest mD5Digest14 = this;
        MD5Digest mD5Digest15 = this;
        MD5Digest mD5Digest16 = this;
        n3 = mD5Digest16.rotateLeft(n3 + this.G(n8, n7, n5) + this.X[1] + -165796510, 5) + n8;
        n5 = mD5Digest15.rotateLeft(n5 + mD5Digest16.G(n3, n8, n7) + this.X[6] + -1069501632, 9) + n3;
        n7 = mD5Digest14.rotateLeft(n7 + mD5Digest15.G(n5, n3, n8) + this.X[11] + 643717713, 14) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest14.G(n7, n5, n3) + this.X[0] + -373897302, 20) + n7;
        MD5Digest mD5Digest17 = this;
        MD5Digest mD5Digest18 = this;
        MD5Digest mD5Digest19 = this;
        n3 = mD5Digest19.rotateLeft(n3 + this.G(n8, n7, n5) + this.X[5] + -701558691, 5) + n8;
        n5 = mD5Digest18.rotateLeft(n5 + mD5Digest19.G(n3, n8, n7) + this.X[10] + 38016083, 9) + n3;
        n7 = mD5Digest17.rotateLeft(n7 + mD5Digest18.G(n5, n3, n8) + this.X[15] + -660478335, 14) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest17.G(n7, n5, n3) + this.X[4] + -405537848, 20) + n7;
        MD5Digest mD5Digest20 = this;
        MD5Digest mD5Digest21 = this;
        MD5Digest mD5Digest22 = this;
        n3 = mD5Digest22.rotateLeft(n3 + this.G(n8, n7, n5) + this.X[9] + 568446438, 5) + n8;
        n5 = mD5Digest21.rotateLeft(n5 + mD5Digest22.G(n3, n8, n7) + this.X[14] + -1019803690, 9) + n3;
        n7 = mD5Digest20.rotateLeft(n7 + mD5Digest21.G(n5, n3, n8) + this.X[3] + -187363961, 14) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest20.G(n7, n5, n3) + this.X[8] + 1163531501, 20) + n7;
        MD5Digest mD5Digest23 = this;
        MD5Digest mD5Digest24 = this;
        MD5Digest mD5Digest25 = this;
        n3 = mD5Digest25.rotateLeft(n3 + this.G(n8, n7, n5) + this.X[13] + -1444681467, 5) + n8;
        n5 = mD5Digest24.rotateLeft(n5 + mD5Digest25.G(n3, n8, n7) + this.X[2] + -51403784, 9) + n3;
        n7 = mD5Digest23.rotateLeft(n7 + mD5Digest24.G(n5, n3, n8) + this.X[7] + 1735328473, 14) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest23.G(n7, n5, n3) + this.X[12] + -1926607734, 20) + n7;
        MD5Digest mD5Digest26 = this;
        MD5Digest mD5Digest27 = this;
        MD5Digest mD5Digest28 = this;
        n3 = mD5Digest28.rotateLeft(n3 + this.H(n8, n7, n5) + this.X[5] + -378558, 4) + n8;
        n5 = mD5Digest27.rotateLeft(n5 + mD5Digest28.H(n3, n8, n7) + this.X[8] + -2022574463, 11) + n3;
        n7 = mD5Digest26.rotateLeft(n7 + mD5Digest27.H(n5, n3, n8) + this.X[11] + 1839030562, 16) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest26.H(n7, n5, n3) + this.X[14] + -35309556, 23) + n7;
        MD5Digest mD5Digest29 = this;
        MD5Digest mD5Digest30 = this;
        MD5Digest mD5Digest31 = this;
        n3 = mD5Digest31.rotateLeft(n3 + this.H(n8, n7, n5) + this.X[1] + -1530992060, 4) + n8;
        n5 = mD5Digest30.rotateLeft(n5 + mD5Digest31.H(n3, n8, n7) + this.X[4] + 1272893353, 11) + n3;
        n7 = mD5Digest29.rotateLeft(n7 + mD5Digest30.H(n5, n3, n8) + this.X[7] + -155497632, 16) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest29.H(n7, n5, n3) + this.X[10] + -1094730640, 23) + n7;
        MD5Digest mD5Digest32 = this;
        MD5Digest mD5Digest33 = this;
        MD5Digest mD5Digest34 = this;
        n3 = mD5Digest34.rotateLeft(n3 + this.H(n8, n7, n5) + this.X[13] + 681279174, 4) + n8;
        n5 = mD5Digest33.rotateLeft(n5 + mD5Digest34.H(n3, n8, n7) + this.X[0] + -358537222, 11) + n3;
        n7 = mD5Digest32.rotateLeft(n7 + mD5Digest33.H(n5, n3, n8) + this.X[3] + -722521979, 16) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest32.H(n7, n5, n3) + this.X[6] + 76029189, 23) + n7;
        MD5Digest mD5Digest35 = this;
        MD5Digest mD5Digest36 = this;
        MD5Digest mD5Digest37 = this;
        n3 = mD5Digest37.rotateLeft(n3 + this.H(n8, n7, n5) + this.X[9] + -640364487, 4) + n8;
        n5 = mD5Digest36.rotateLeft(n5 + mD5Digest37.H(n3, n8, n7) + this.X[12] + -421815835, 11) + n3;
        n7 = mD5Digest35.rotateLeft(n7 + mD5Digest36.H(n5, n3, n8) + this.X[15] + 530742520, 16) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest35.H(n7, n5, n3) + this.X[2] + -995338651, 23) + n7;
        MD5Digest mD5Digest38 = this;
        MD5Digest mD5Digest39 = this;
        MD5Digest mD5Digest40 = this;
        n3 = mD5Digest40.rotateLeft(n3 + this.K(n8, n7, n5) + this.X[0] + -198630844, 6) + n8;
        n5 = mD5Digest39.rotateLeft(n5 + mD5Digest40.K(n3, n8, n7) + this.X[7] + 1126891415, 10) + n3;
        n7 = mD5Digest38.rotateLeft(n7 + mD5Digest39.K(n5, n3, n8) + this.X[14] + -1416354905, 15) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest38.K(n7, n5, n3) + this.X[5] + -57434055, 21) + n7;
        MD5Digest mD5Digest41 = this;
        MD5Digest mD5Digest42 = this;
        MD5Digest mD5Digest43 = this;
        n3 = mD5Digest43.rotateLeft(n3 + this.K(n8, n7, n5) + this.X[12] + 1700485571, 6) + n8;
        n5 = mD5Digest42.rotateLeft(n5 + mD5Digest43.K(n3, n8, n7) + this.X[3] + -1894986606, 10) + n3;
        n7 = mD5Digest41.rotateLeft(n7 + mD5Digest42.K(n5, n3, n8) + this.X[10] + -1051523, 15) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest41.K(n7, n5, n3) + this.X[1] + -2054922799, 21) + n7;
        MD5Digest mD5Digest44 = this;
        MD5Digest mD5Digest45 = this;
        MD5Digest mD5Digest46 = this;
        n3 = mD5Digest46.rotateLeft(n3 + this.K(n8, n7, n5) + this.X[8] + 1873313359, 6) + n8;
        n5 = mD5Digest45.rotateLeft(n5 + mD5Digest46.K(n3, n8, n7) + this.X[15] + -30611744, 10) + n3;
        n7 = mD5Digest44.rotateLeft(n7 + mD5Digest45.K(n5, n3, n8) + this.X[6] + -1560198380, 15) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest44.K(n7, n5, n3) + this.X[13] + 1309151649, 21) + n7;
        MD5Digest mD5Digest47 = this;
        MD5Digest mD5Digest48 = this;
        MD5Digest mD5Digest49 = this;
        n3 = mD5Digest49.rotateLeft(n3 + this.K(n8, n7, n5) + this.X[4] + -145523070, 6) + n8;
        n5 = mD5Digest48.rotateLeft(n5 + mD5Digest49.K(n3, n8, n7) + this.X[11] + -1120210379, 10) + n3;
        n7 = mD5Digest47.rotateLeft(n7 + mD5Digest48.K(n5, n3, n8) + this.X[2] + 718787259, 15) + n5;
        n8 = mD5Digest.rotateLeft(n8 + mD5Digest47.K(n7, n5, n3) + this.X[9] + -343485551, 21) + n7;
        mD5Digest.H1 += n3;
        mD5Digest.H2 += n8;
        mD5Digest.H3 += n7;
        mD5Digest.H4 += n5;
        mD5Digest.xOff = 0;
        n3 = 0;
        while (true) {
            int[] nArray = this.X;
            if (n3 == this.X.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    @Override
    public Memoable copy() {
        return new MD5Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((MD5Digest)memoable);
    }

    @Override
    public byte[] getEncodedState() {
        MD5Digest mD5Digest = this;
        byte[] byArray = new byte[mD5Digest.xOff * 4 + 36];
        super.populateState(byArray);
        Pack.intToBigEndian(mD5Digest.H1, byArray, 16);
        Pack.intToBigEndian(mD5Digest.H2, byArray, 20);
        Pack.intToBigEndian(mD5Digest.H3, byArray, 24);
        Pack.intToBigEndian(mD5Digest.H4, byArray, 28);
        Pack.intToBigEndian(mD5Digest.xOff, byArray, 32);
        for (int i3 = 0; i3 != this.xOff; ++i3) {
            Pack.intToBigEndian(this.X[i3], byArray, i3 * 4 + 36);
        }
        return byArray;
    }
}

