/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public class RIPEMD160Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 20;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X;
    private int xOff;

    public RIPEMD160Digest() {
        RIPEMD160Digest rIPEMD160Digest = this;
        rIPEMD160Digest.X = new int[16];
        rIPEMD160Digest.reset();
    }

    public RIPEMD160Digest(RIPEMD160Digest rIPEMD160Digest) {
        super(rIPEMD160Digest);
        this.X = new int[16];
        this.copyIn(rIPEMD160Digest);
    }

    private void copyIn(RIPEMD160Digest rIPEMD160Digest) {
        RIPEMD160Digest rIPEMD160Digest2 = object;
        RIPEMD160Digest rIPEMD160Digest3 = rIPEMD160Digest;
        super.copyIn(rIPEMD160Digest);
        ((RIPEMD160Digest)object).H0 = rIPEMD160Digest.H0;
        ((RIPEMD160Digest)object).H1 = rIPEMD160Digest.H1;
        ((RIPEMD160Digest)object).H2 = rIPEMD160Digest.H2;
        ((RIPEMD160Digest)object).H3 = rIPEMD160Digest.H3;
        ((RIPEMD160Digest)object).H4 = rIPEMD160Digest.H4;
        Object object = ((RIPEMD160Digest)object).X;
        int n3 = rIPEMD160Digest3.X.length;
        System.arraycopy(rIPEMD160Digest3.X, 0, object, 0, n3);
        rIPEMD160Digest2.xOff = rIPEMD160Digest3.xOff;
    }

    private void unpackWord(int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)n3;
        int n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >>> 8);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >>> 16);
        n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >>> 24);
    }

    private int RL(int n3, int n4) {
        return n3 << n4 | n3 >>> 32 - n4;
    }

    private int f1(int n3, int n4, int n5) {
        return n3 ^ n4 ^ n5;
    }

    private int f2(int n3, int n4, int n5) {
        return n3 & n4 | ~n3 & n5;
    }

    private int f3(int n3, int n4, int n5) {
        return (n3 | ~n4) ^ n5;
    }

    private int f4(int n3, int n4, int n5) {
        return n3 & n5 | n4 & ~n5;
    }

    private int f5(int n3, int n4, int n5) {
        return n3 ^ (n4 | ~n5);
    }

    @Override
    public String getAlgorithmName() {
        return "RIPEMD160";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    public void processWord(byte[] byArray, int n3) {
        int n4;
        RIPEMD160Digest rIPEMD160Digest = this;
        int[] nArray = rIPEMD160Digest.X;
        int n5 = rIPEMD160Digest.xOff;
        this.xOff = n4 = n5 + 1;
        nArray[n5] = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 3] & 0xFF) << 24;
        if (n4 == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l3) {
        if (((RIPEMD160Digest)object).xOff > 14) {
            ((RIPEMD160Digest)object).processBlock();
        }
        Object object = ((RIPEMD160Digest)object).X;
        object[14] = (int)(l3 & 0xFFFFFFFFFFFFFFFFL);
        ((RIPEMD160Digest)object).X[15] = (int)(l3 >>> 32);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        RIPEMD160Digest rIPEMD160Digest = this;
        rIPEMD160Digest.finish();
        rIPEMD160Digest.unpackWord(rIPEMD160Digest.H0, byArray, n3);
        rIPEMD160Digest.unpackWord(rIPEMD160Digest.H1, byArray, n3 + 4);
        rIPEMD160Digest.unpackWord(rIPEMD160Digest.H2, byArray, n3 + 8);
        rIPEMD160Digest.unpackWord(rIPEMD160Digest.H3, byArray, n3 + 12);
        rIPEMD160Digest.unpackWord(rIPEMD160Digest.H4, byArray, n3 + 16);
        rIPEMD160Digest.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.xOff = 0;
        int n3 = 0;
        while (true) {
            int[] nArray = this.X;
            if (n3 == this.X.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    @Override
    public void processBlock() {
        RIPEMD160Digest rIPEMD160Digest = this;
        int n3 = rIPEMD160Digest.H0;
        RIPEMD160Digest rIPEMD160Digest2 = this;
        int n4 = rIPEMD160Digest2.H1;
        int n5 = rIPEMD160Digest2.H2;
        int n6 = rIPEMD160Digest2.H3;
        int n7 = rIPEMD160Digest2.H4;
        int n8 = rIPEMD160Digest.RL(n3 + rIPEMD160Digest2.f1(n4, n5, n6) + this.X[0], 11) + n7;
        int n9 = rIPEMD160Digest.RL(n5, 10);
        int n10 = n9;
        RIPEMD160Digest rIPEMD160Digest3 = this;
        int n11 = n8;
        RIPEMD160Digest rIPEMD160Digest4 = this;
        int n12 = this.RL(n7 + this.f1(n8, n4, n10) + this.X[1], 14) + n6;
        int n13 = rIPEMD160Digest4.RL(n4, 10);
        n8 = this.RL(n6 + rIPEMD160Digest4.f1(n12, n8, n13) + this.X[2], 15) + n10;
        n10 = rIPEMD160Digest3.RL(n11, 10);
        int n14 = rIPEMD160Digest.RL(n9 + rIPEMD160Digest3.f1(n8, n12, n10) + this.X[3], 12) + n13;
        int n15 = rIPEMD160Digest.RL(n12, 10);
        n12 = n15;
        RIPEMD160Digest rIPEMD160Digest5 = this;
        int n16 = n10;
        RIPEMD160Digest rIPEMD160Digest6 = this;
        int n17 = n8;
        n8 = this.RL(n13 + this.f1(n14, n8, n12) + this.X[4], 5) + n10;
        n10 = rIPEMD160Digest6.RL(n17, 10);
        n12 = this.RL(n16 + rIPEMD160Digest6.f1(n8, n14, n10) + this.X[5], 8) + n12;
        n13 = rIPEMD160Digest5.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n15 + rIPEMD160Digest5.f1(n12, n8, n13) + this.X[6], 7) + n10;
        int n18 = rIPEMD160Digest.RL(n8, 10);
        n8 = n18;
        RIPEMD160Digest rIPEMD160Digest7 = this;
        RIPEMD160Digest rIPEMD160Digest8 = this;
        n10 = this.RL(n10 + this.f1(n14, n12, n8) + this.X[7], 9) + n13;
        n12 = rIPEMD160Digest8.RL(n12, 10);
        n8 = this.RL(n13 + rIPEMD160Digest8.f1(n10, n14, n12) + this.X[8], 11) + n8;
        n13 = rIPEMD160Digest7.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n18 + rIPEMD160Digest7.f1(n8, n10, n13) + this.X[9], 13) + n12;
        int n19 = rIPEMD160Digest.RL(n10, 10);
        n10 = n19;
        RIPEMD160Digest rIPEMD160Digest9 = this;
        RIPEMD160Digest rIPEMD160Digest10 = this;
        int n20 = n8;
        n8 = this.RL(n12 + this.f1(n14, n8, n10) + this.X[10], 14) + n13;
        n12 = rIPEMD160Digest10.RL(n20, 10);
        n10 = this.RL(n13 + rIPEMD160Digest10.f1(n8, n14, n12) + this.X[11], 15) + n10;
        n13 = rIPEMD160Digest9.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n19 + rIPEMD160Digest9.f1(n10, n8, n13) + this.X[12], 6) + n12;
        int n21 = rIPEMD160Digest.RL(n8, 10);
        n8 = n21;
        RIPEMD160Digest rIPEMD160Digest11 = this;
        RIPEMD160Digest rIPEMD160Digest12 = this;
        int n22 = n10;
        n10 = this.RL(n12 + this.f1(n14, n10, n8) + this.X[13], 7) + n13;
        n12 = rIPEMD160Digest12.RL(n22, 10);
        n8 = this.RL(n13 + rIPEMD160Digest12.f1(n10, n14, n12) + this.X[14], 9) + n8;
        n13 = rIPEMD160Digest11.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n21 + rIPEMD160Digest11.f1(n8, n10, n13) + this.X[15], 8) + n12;
        int n23 = rIPEMD160Digest.RL(n10, 10);
        n10 = n23;
        RIPEMD160Digest rIPEMD160Digest13 = this;
        RIPEMD160Digest rIPEMD160Digest14 = this;
        int n24 = n8;
        RIPEMD160Digest rIPEMD160Digest15 = this;
        n3 = this.RL(n3 + this.f5(n4, n5, n6) + this.X[5] + 1352829926, 8) + n7;
        int n25 = rIPEMD160Digest15.RL(n5, 10);
        n5 = n25;
        RIPEMD160Digest rIPEMD160Digest16 = this;
        int n26 = n3;
        int n27 = n6;
        RIPEMD160Digest rIPEMD160Digest17 = this;
        int n28 = n4;
        n4 = this.RL(n7 + this.f5(n3, n4, n5) + this.X[14] + 1352829926, 9) + n6;
        n6 = rIPEMD160Digest17.RL(n28, 10);
        n3 = this.RL(n27 + rIPEMD160Digest17.f5(n4, n3, n6) + this.X[7] + 1352829926, 9) + n5;
        n5 = rIPEMD160Digest16.RL(n26, 10);
        n7 = rIPEMD160Digest15.RL(n25 + rIPEMD160Digest16.f5(n3, n4, n5) + this.X[0] + 1352829926, 11) + n6;
        int n29 = rIPEMD160Digest15.RL(n4, 10);
        n4 = n29;
        RIPEMD160Digest rIPEMD160Digest18 = this;
        int n30 = n5;
        RIPEMD160Digest rIPEMD160Digest19 = this;
        int n31 = n3;
        n3 = this.RL(n6 + this.f5(n7, n3, n4) + this.X[9] + 1352829926, 13) + n5;
        n5 = rIPEMD160Digest19.RL(n31, 10);
        n4 = this.RL(n30 + rIPEMD160Digest19.f5(n3, n7, n5) + this.X[2] + 1352829926, 15) + n4;
        n6 = rIPEMD160Digest18.RL(n7, 10);
        n7 = rIPEMD160Digest15.RL(n29 + rIPEMD160Digest18.f5(n4, n3, n6) + this.X[11] + 1352829926, 15) + n5;
        int n32 = rIPEMD160Digest15.RL(n3, 10);
        n3 = n32;
        RIPEMD160Digest rIPEMD160Digest20 = this;
        RIPEMD160Digest rIPEMD160Digest21 = this;
        int n33 = n4;
        n4 = this.RL(n5 + this.f5(n7, n4, n3) + this.X[4] + 1352829926, 5) + n6;
        n5 = rIPEMD160Digest21.RL(n33, 10);
        n3 = this.RL(n6 + rIPEMD160Digest21.f5(n4, n7, n5) + this.X[13] + 1352829926, 7) + n3;
        n6 = rIPEMD160Digest20.RL(n7, 10);
        n7 = rIPEMD160Digest15.RL(n32 + rIPEMD160Digest20.f5(n3, n4, n6) + this.X[6] + 1352829926, 7) + n5;
        int n34 = rIPEMD160Digest15.RL(n4, 10);
        n4 = n34;
        RIPEMD160Digest rIPEMD160Digest22 = this;
        RIPEMD160Digest rIPEMD160Digest23 = this;
        int n35 = n3;
        n3 = this.RL(n5 + this.f5(n7, n3, n4) + this.X[15] + 1352829926, 8) + n6;
        n5 = rIPEMD160Digest23.RL(n35, 10);
        n4 = this.RL(n6 + rIPEMD160Digest23.f5(n3, n7, n5) + this.X[8] + 1352829926, 11) + n4;
        n6 = rIPEMD160Digest22.RL(n7, 10);
        n7 = rIPEMD160Digest15.RL(n34 + rIPEMD160Digest22.f5(n4, n3, n6) + this.X[1] + 1352829926, 14) + n5;
        int n36 = rIPEMD160Digest15.RL(n3, 10);
        n3 = n36;
        RIPEMD160Digest rIPEMD160Digest24 = this;
        RIPEMD160Digest rIPEMD160Digest25 = this;
        int n37 = n4;
        n4 = this.RL(n5 + this.f5(n7, n4, n3) + this.X[10] + 1352829926, 14) + n6;
        n5 = rIPEMD160Digest25.RL(n37, 10);
        n3 = this.RL(n6 + rIPEMD160Digest25.f5(n4, n7, n5) + this.X[3] + 1352829926, 12) + n3;
        n6 = rIPEMD160Digest24.RL(n7, 10);
        n7 = rIPEMD160Digest15.RL(n36 + rIPEMD160Digest24.f5(n3, n4, n6) + this.X[12] + 1352829926, 6) + n5;
        n4 = rIPEMD160Digest15.RL(n4, 10);
        n8 = this.RL(n12 + this.f2(n14, n8, n10) + this.X[7] + 1518500249, 7) + n13;
        n12 = rIPEMD160Digest14.RL(n24, 10);
        n10 = this.RL(n13 + rIPEMD160Digest14.f2(n8, n14, n12) + this.X[4] + 1518500249, 6) + n10;
        n13 = rIPEMD160Digest13.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n23 + rIPEMD160Digest13.f2(n10, n8, n13) + this.X[13] + 1518500249, 8) + n12;
        int n38 = rIPEMD160Digest.RL(n8, 10);
        n8 = n38;
        RIPEMD160Digest rIPEMD160Digest26 = this;
        RIPEMD160Digest rIPEMD160Digest27 = this;
        int n39 = n10;
        n10 = this.RL(n12 + this.f2(n14, n10, n8) + this.X[1] + 1518500249, 13) + n13;
        n12 = rIPEMD160Digest27.RL(n39, 10);
        n8 = this.RL(n13 + rIPEMD160Digest27.f2(n10, n14, n12) + this.X[10] + 1518500249, 11) + n8;
        n13 = rIPEMD160Digest26.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n38 + rIPEMD160Digest26.f2(n8, n10, n13) + this.X[6] + 1518500249, 9) + n12;
        int n40 = rIPEMD160Digest.RL(n10, 10);
        n10 = n40;
        RIPEMD160Digest rIPEMD160Digest28 = this;
        RIPEMD160Digest rIPEMD160Digest29 = this;
        int n41 = n8;
        n8 = this.RL(n12 + this.f2(n14, n8, n10) + this.X[15] + 1518500249, 7) + n13;
        n12 = rIPEMD160Digest29.RL(n41, 10);
        n10 = this.RL(n13 + rIPEMD160Digest29.f2(n8, n14, n12) + this.X[3] + 1518500249, 15) + n10;
        n13 = rIPEMD160Digest28.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n40 + rIPEMD160Digest28.f2(n10, n8, n13) + this.X[12] + 1518500249, 7) + n12;
        int n42 = rIPEMD160Digest.RL(n8, 10);
        n8 = n42;
        RIPEMD160Digest rIPEMD160Digest30 = this;
        RIPEMD160Digest rIPEMD160Digest31 = this;
        int n43 = n10;
        n10 = this.RL(n12 + this.f2(n14, n10, n8) + this.X[0] + 1518500249, 12) + n13;
        n12 = rIPEMD160Digest31.RL(n43, 10);
        n8 = this.RL(n13 + rIPEMD160Digest31.f2(n10, n14, n12) + this.X[9] + 1518500249, 15) + n8;
        n13 = rIPEMD160Digest30.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n42 + rIPEMD160Digest30.f2(n8, n10, n13) + this.X[5] + 1518500249, 9) + n12;
        int n44 = rIPEMD160Digest.RL(n10, 10);
        n10 = n44;
        RIPEMD160Digest rIPEMD160Digest32 = this;
        RIPEMD160Digest rIPEMD160Digest33 = this;
        int n45 = n8;
        n8 = this.RL(n12 + this.f2(n14, n8, n10) + this.X[2] + 1518500249, 11) + n13;
        n12 = rIPEMD160Digest33.RL(n45, 10);
        n10 = this.RL(n13 + rIPEMD160Digest33.f2(n8, n14, n12) + this.X[14] + 1518500249, 7) + n10;
        n13 = rIPEMD160Digest32.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n44 + rIPEMD160Digest32.f2(n10, n8, n13) + this.X[11] + 1518500249, 13) + n12;
        int n46 = rIPEMD160Digest.RL(n8, 10);
        n8 = n46;
        RIPEMD160Digest rIPEMD160Digest34 = this;
        RIPEMD160Digest rIPEMD160Digest35 = this;
        int n47 = n3;
        int n48 = n5;
        n5 = this.RL(n12 + this.f2(n14, n10, n8) + this.X[8] + 1518500249, 12) + n13;
        n10 = this.RL(n10, 10);
        n3 = this.RL(n48 + this.f4(n7, n3, n4) + this.X[6] + 1548603684, 9) + n6;
        n12 = rIPEMD160Digest35.RL(n47, 10);
        RIPEMD160Digest rIPEMD160Digest36 = this;
        int n49 = n3;
        int n50 = n4;
        RIPEMD160Digest rIPEMD160Digest37 = this;
        n4 = this.RL(n6 + this.f4(n3, n7, n12) + this.X[11] + 1548603684, 13) + n4;
        n6 = rIPEMD160Digest37.RL(n7, 10);
        n3 = this.RL(n50 + rIPEMD160Digest37.f4(n4, n3, n6) + this.X[3] + 1548603684, 15) + n12;
        n7 = rIPEMD160Digest36.RL(n49, 10);
        n12 = rIPEMD160Digest35.RL(n12 + rIPEMD160Digest36.f4(n3, n4, n7) + this.X[7] + 1548603684, 7) + n6;
        int n51 = rIPEMD160Digest35.RL(n4, 10);
        n4 = n51;
        RIPEMD160Digest rIPEMD160Digest38 = this;
        RIPEMD160Digest rIPEMD160Digest39 = this;
        int n52 = n3;
        n3 = this.RL(n6 + this.f4(n12, n3, n4) + this.X[0] + 1548603684, 12) + n7;
        n6 = rIPEMD160Digest39.RL(n52, 10);
        n4 = this.RL(n7 + rIPEMD160Digest39.f4(n3, n12, n6) + this.X[13] + 1548603684, 8) + n4;
        n7 = rIPEMD160Digest38.RL(n12, 10);
        n12 = rIPEMD160Digest35.RL(n51 + rIPEMD160Digest38.f4(n4, n3, n7) + this.X[5] + 1548603684, 9) + n6;
        int n53 = rIPEMD160Digest35.RL(n3, 10);
        n3 = n53;
        RIPEMD160Digest rIPEMD160Digest40 = this;
        RIPEMD160Digest rIPEMD160Digest41 = this;
        int n54 = n4;
        n4 = this.RL(n6 + this.f4(n12, n4, n3) + this.X[10] + 1548603684, 11) + n7;
        n6 = rIPEMD160Digest41.RL(n54, 10);
        n3 = this.RL(n7 + rIPEMD160Digest41.f4(n4, n12, n6) + this.X[14] + 1548603684, 7) + n3;
        n7 = rIPEMD160Digest40.RL(n12, 10);
        n12 = rIPEMD160Digest35.RL(n53 + rIPEMD160Digest40.f4(n3, n4, n7) + this.X[15] + 1548603684, 7) + n6;
        int n55 = rIPEMD160Digest35.RL(n4, 10);
        n4 = n55;
        RIPEMD160Digest rIPEMD160Digest42 = this;
        RIPEMD160Digest rIPEMD160Digest43 = this;
        int n56 = n3;
        n3 = this.RL(n6 + this.f4(n12, n3, n4) + this.X[8] + 1548603684, 12) + n7;
        n6 = rIPEMD160Digest43.RL(n56, 10);
        n4 = this.RL(n7 + rIPEMD160Digest43.f4(n3, n12, n6) + this.X[12] + 1548603684, 7) + n4;
        n7 = rIPEMD160Digest42.RL(n12, 10);
        n12 = rIPEMD160Digest35.RL(n55 + rIPEMD160Digest42.f4(n4, n3, n7) + this.X[4] + 1548603684, 6) + n6;
        int n57 = rIPEMD160Digest35.RL(n3, 10);
        n3 = n57;
        RIPEMD160Digest rIPEMD160Digest44 = this;
        RIPEMD160Digest rIPEMD160Digest45 = this;
        int n58 = n4;
        n4 = this.RL(n6 + this.f4(n12, n4, n3) + this.X[9] + 1548603684, 15) + n7;
        n6 = rIPEMD160Digest45.RL(n58, 10);
        n3 = this.RL(n7 + rIPEMD160Digest45.f4(n4, n12, n6) + this.X[1] + 1548603684, 13) + n3;
        n7 = rIPEMD160Digest44.RL(n12, 10);
        n12 = rIPEMD160Digest35.RL(n57 + rIPEMD160Digest44.f4(n3, n4, n7) + this.X[2] + 1548603684, 11) + n6;
        n4 = rIPEMD160Digest35.RL(n4, 10);
        n8 = this.RL(n13 + rIPEMD160Digest35.f3(n5, n14, n10) + this.X[3] + 1859775393, 11) + n8;
        n13 = rIPEMD160Digest34.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n46 + rIPEMD160Digest34.f3(n8, n5, n13) + this.X[10] + 1859775393, 13) + n10;
        int n59 = rIPEMD160Digest.RL(n5, 10);
        n5 = n59;
        RIPEMD160Digest rIPEMD160Digest46 = this;
        RIPEMD160Digest rIPEMD160Digest47 = this;
        int n60 = n8;
        n8 = this.RL(n10 + this.f3(n14, n8, n5) + this.X[14] + 1859775393, 6) + n13;
        n10 = rIPEMD160Digest47.RL(n60, 10);
        n5 = this.RL(n13 + rIPEMD160Digest47.f3(n8, n14, n10) + this.X[4] + 1859775393, 7) + n5;
        n13 = rIPEMD160Digest46.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n59 + rIPEMD160Digest46.f3(n5, n8, n13) + this.X[9] + 1859775393, 14) + n10;
        int n61 = rIPEMD160Digest.RL(n8, 10);
        n8 = n61;
        RIPEMD160Digest rIPEMD160Digest48 = this;
        RIPEMD160Digest rIPEMD160Digest49 = this;
        int n62 = n5;
        n5 = this.RL(n10 + this.f3(n14, n5, n8) + this.X[15] + 1859775393, 9) + n13;
        n10 = rIPEMD160Digest49.RL(n62, 10);
        n8 = this.RL(n13 + rIPEMD160Digest49.f3(n5, n14, n10) + this.X[8] + 1859775393, 13) + n8;
        n13 = rIPEMD160Digest48.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n61 + rIPEMD160Digest48.f3(n8, n5, n13) + this.X[1] + 1859775393, 15) + n10;
        int n63 = rIPEMD160Digest.RL(n5, 10);
        n5 = n63;
        RIPEMD160Digest rIPEMD160Digest50 = this;
        RIPEMD160Digest rIPEMD160Digest51 = this;
        int n64 = n8;
        n8 = this.RL(n10 + this.f3(n14, n8, n5) + this.X[2] + 1859775393, 14) + n13;
        n10 = rIPEMD160Digest51.RL(n64, 10);
        n5 = this.RL(n13 + rIPEMD160Digest51.f3(n8, n14, n10) + this.X[7] + 1859775393, 8) + n5;
        n13 = rIPEMD160Digest50.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n63 + rIPEMD160Digest50.f3(n5, n8, n13) + this.X[0] + 1859775393, 13) + n10;
        int n65 = rIPEMD160Digest.RL(n8, 10);
        n8 = n65;
        RIPEMD160Digest rIPEMD160Digest52 = this;
        RIPEMD160Digest rIPEMD160Digest53 = this;
        int n66 = n5;
        n5 = this.RL(n10 + this.f3(n14, n5, n8) + this.X[6] + 1859775393, 6) + n13;
        n10 = rIPEMD160Digest53.RL(n66, 10);
        n8 = this.RL(n13 + rIPEMD160Digest53.f3(n5, n14, n10) + this.X[13] + 1859775393, 5) + n8;
        n13 = rIPEMD160Digest52.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n65 + rIPEMD160Digest52.f3(n8, n5, n13) + this.X[11] + 1859775393, 12) + n10;
        int n67 = rIPEMD160Digest.RL(n5, 10);
        n5 = n67;
        RIPEMD160Digest rIPEMD160Digest54 = this;
        int n68 = n3;
        int n69 = n6;
        RIPEMD160Digest rIPEMD160Digest55 = this;
        n6 = this.RL(n10 + this.f3(n14, n8, n5) + this.X[5] + 1859775393, 7) + n13;
        n8 = rIPEMD160Digest55.RL(n8, 10);
        n5 = this.RL(n13 + rIPEMD160Digest55.f3(n6, n14, n8) + this.X[12] + 1859775393, 5) + n5;
        n10 = this.RL(n14, 10);
        n3 = this.RL(n69 + this.f3(n12, n3, n4) + this.X[15] + 1836072691, 9) + n7;
        n13 = rIPEMD160Digest54.RL(n68, 10);
        RIPEMD160Digest rIPEMD160Digest56 = this;
        int n70 = n3;
        int n71 = n4;
        RIPEMD160Digest rIPEMD160Digest57 = this;
        n4 = this.RL(n7 + this.f3(n3, n12, n13) + this.X[5] + 1836072691, 7) + n4;
        n7 = rIPEMD160Digest57.RL(n12, 10);
        n3 = this.RL(n71 + rIPEMD160Digest57.f3(n4, n3, n7) + this.X[1] + 1836072691, 15) + n13;
        n12 = rIPEMD160Digest56.RL(n70, 10);
        n13 = rIPEMD160Digest54.RL(n13 + rIPEMD160Digest56.f3(n3, n4, n12) + this.X[3] + 1836072691, 11) + n7;
        int n72 = rIPEMD160Digest54.RL(n4, 10);
        n4 = n72;
        RIPEMD160Digest rIPEMD160Digest58 = this;
        RIPEMD160Digest rIPEMD160Digest59 = this;
        int n73 = n3;
        n3 = this.RL(n7 + this.f3(n13, n3, n4) + this.X[7] + 1836072691, 8) + n12;
        n7 = rIPEMD160Digest59.RL(n73, 10);
        n4 = this.RL(n12 + rIPEMD160Digest59.f3(n3, n13, n7) + this.X[14] + 1836072691, 6) + n4;
        n12 = rIPEMD160Digest58.RL(n13, 10);
        n13 = rIPEMD160Digest54.RL(n72 + rIPEMD160Digest58.f3(n4, n3, n12) + this.X[6] + 1836072691, 6) + n7;
        int n74 = rIPEMD160Digest54.RL(n3, 10);
        n3 = n74;
        RIPEMD160Digest rIPEMD160Digest60 = this;
        RIPEMD160Digest rIPEMD160Digest61 = this;
        int n75 = n4;
        n4 = this.RL(n7 + this.f3(n13, n4, n3) + this.X[9] + 1836072691, 14) + n12;
        n7 = rIPEMD160Digest61.RL(n75, 10);
        n3 = this.RL(n12 + rIPEMD160Digest61.f3(n4, n13, n7) + this.X[11] + 1836072691, 12) + n3;
        n12 = rIPEMD160Digest60.RL(n13, 10);
        n13 = rIPEMD160Digest54.RL(n74 + rIPEMD160Digest60.f3(n3, n4, n12) + this.X[8] + 1836072691, 13) + n7;
        int n76 = rIPEMD160Digest54.RL(n4, 10);
        n4 = n76;
        RIPEMD160Digest rIPEMD160Digest62 = this;
        RIPEMD160Digest rIPEMD160Digest63 = this;
        int n77 = n3;
        n3 = this.RL(n7 + this.f3(n13, n3, n4) + this.X[12] + 1836072691, 5) + n12;
        n7 = rIPEMD160Digest63.RL(n77, 10);
        n4 = this.RL(n12 + rIPEMD160Digest63.f3(n3, n13, n7) + this.X[2] + 1836072691, 14) + n4;
        n12 = rIPEMD160Digest62.RL(n13, 10);
        n13 = rIPEMD160Digest54.RL(n76 + rIPEMD160Digest62.f3(n4, n3, n12) + this.X[10] + 1836072691, 13) + n7;
        int n78 = rIPEMD160Digest54.RL(n3, 10);
        n3 = n78;
        RIPEMD160Digest rIPEMD160Digest64 = this;
        RIPEMD160Digest rIPEMD160Digest65 = this;
        int n79 = n4;
        n4 = this.RL(n7 + this.f3(n13, n4, n3) + this.X[0] + 1836072691, 13) + n12;
        n7 = rIPEMD160Digest65.RL(n79, 10);
        n3 = this.RL(n12 + rIPEMD160Digest65.f3(n4, n13, n7) + this.X[4] + 1836072691, 7) + n3;
        n12 = rIPEMD160Digest64.RL(n13, 10);
        n13 = rIPEMD160Digest54.RL(n78 + rIPEMD160Digest64.f3(n3, n4, n12) + this.X[13] + 1836072691, 5) + n7;
        n4 = rIPEMD160Digest54.RL(n4, 10);
        n14 = rIPEMD160Digest.RL(n67 + rIPEMD160Digest54.f4(n5, n6, n10) + this.X[1] + -1894007588, 11) + n8;
        int n80 = rIPEMD160Digest.RL(n6, 10);
        n6 = n80;
        RIPEMD160Digest rIPEMD160Digest66 = this;
        RIPEMD160Digest rIPEMD160Digest67 = this;
        int n81 = n5;
        n5 = this.RL(n8 + this.f4(n14, n5, n6) + this.X[9] + -1894007588, 12) + n10;
        n8 = rIPEMD160Digest67.RL(n81, 10);
        n6 = this.RL(n10 + rIPEMD160Digest67.f4(n5, n14, n8) + this.X[11] + -1894007588, 14) + n6;
        n10 = rIPEMD160Digest66.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n80 + rIPEMD160Digest66.f4(n6, n5, n10) + this.X[10] + -1894007588, 15) + n8;
        int n82 = rIPEMD160Digest.RL(n5, 10);
        n5 = n82;
        RIPEMD160Digest rIPEMD160Digest68 = this;
        RIPEMD160Digest rIPEMD160Digest69 = this;
        int n83 = n6;
        n6 = this.RL(n8 + this.f4(n14, n6, n5) + this.X[0] + -1894007588, 14) + n10;
        n8 = rIPEMD160Digest69.RL(n83, 10);
        n5 = this.RL(n10 + rIPEMD160Digest69.f4(n6, n14, n8) + this.X[8] + -1894007588, 15) + n5;
        n10 = rIPEMD160Digest68.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n82 + rIPEMD160Digest68.f4(n5, n6, n10) + this.X[12] + -1894007588, 9) + n8;
        int n84 = rIPEMD160Digest.RL(n6, 10);
        n6 = n84;
        RIPEMD160Digest rIPEMD160Digest70 = this;
        RIPEMD160Digest rIPEMD160Digest71 = this;
        int n85 = n5;
        n5 = this.RL(n8 + this.f4(n14, n5, n6) + this.X[4] + -1894007588, 8) + n10;
        n8 = rIPEMD160Digest71.RL(n85, 10);
        n6 = this.RL(n10 + rIPEMD160Digest71.f4(n5, n14, n8) + this.X[13] + -1894007588, 9) + n6;
        n10 = rIPEMD160Digest70.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n84 + rIPEMD160Digest70.f4(n6, n5, n10) + this.X[3] + -1894007588, 14) + n8;
        int n86 = rIPEMD160Digest.RL(n5, 10);
        n5 = n86;
        RIPEMD160Digest rIPEMD160Digest72 = this;
        RIPEMD160Digest rIPEMD160Digest73 = this;
        int n87 = n6;
        n6 = this.RL(n8 + this.f4(n14, n6, n5) + this.X[7] + -1894007588, 5) + n10;
        n8 = rIPEMD160Digest73.RL(n87, 10);
        n5 = this.RL(n10 + rIPEMD160Digest73.f4(n6, n14, n8) + this.X[15] + -1894007588, 6) + n5;
        n10 = rIPEMD160Digest72.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n86 + rIPEMD160Digest72.f4(n5, n6, n10) + this.X[14] + -1894007588, 8) + n8;
        int n88 = rIPEMD160Digest.RL(n6, 10);
        n6 = n88;
        RIPEMD160Digest rIPEMD160Digest74 = this;
        RIPEMD160Digest rIPEMD160Digest75 = this;
        int n89 = n5;
        n5 = this.RL(n8 + this.f4(n14, n5, n6) + this.X[5] + -1894007588, 6) + n10;
        n8 = rIPEMD160Digest75.RL(n89, 10);
        n6 = this.RL(n10 + rIPEMD160Digest75.f4(n5, n14, n8) + this.X[6] + -1894007588, 5) + n6;
        n10 = rIPEMD160Digest74.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n88 + rIPEMD160Digest74.f4(n6, n5, n10) + this.X[2] + -1894007588, 12) + n8;
        int n90 = rIPEMD160Digest.RL(n5, 10);
        n5 = n90;
        RIPEMD160Digest rIPEMD160Digest76 = this;
        int n91 = n10;
        RIPEMD160Digest rIPEMD160Digest77 = this;
        int n92 = n6;
        int n93 = n8;
        RIPEMD160Digest rIPEMD160Digest78 = this;
        int n94 = n3;
        n3 = this.RL(n7 + this.f2(n13, n3, n4) + this.X[8] + 2053994217, 15) + n12;
        int n95 = rIPEMD160Digest78.RL(n94, 10);
        n7 = n95;
        RIPEMD160Digest rIPEMD160Digest79 = this;
        int n96 = n3;
        int n97 = n4;
        RIPEMD160Digest rIPEMD160Digest80 = this;
        n4 = this.RL(n12 + this.f2(n3, n13, n7) + this.X[6] + 2053994217, 5) + n4;
        n8 = rIPEMD160Digest80.RL(n13, 10);
        n3 = this.RL(n97 + rIPEMD160Digest80.f2(n4, n3, n8) + this.X[4] + 2053994217, 8) + n7;
        n7 = rIPEMD160Digest79.RL(n96, 10);
        n12 = rIPEMD160Digest78.RL(n95 + rIPEMD160Digest79.f2(n3, n4, n7) + this.X[1] + 2053994217, 11) + n8;
        int n98 = rIPEMD160Digest78.RL(n4, 10);
        n4 = n98;
        RIPEMD160Digest rIPEMD160Digest81 = this;
        int n99 = n7;
        RIPEMD160Digest rIPEMD160Digest82 = this;
        int n100 = n3;
        n3 = this.RL(n8 + this.f2(n12, n3, n4) + this.X[3] + 2053994217, 14) + n7;
        n7 = rIPEMD160Digest82.RL(n100, 10);
        n4 = this.RL(n99 + rIPEMD160Digest82.f2(n3, n12, n7) + this.X[11] + 2053994217, 14) + n4;
        n8 = rIPEMD160Digest81.RL(n12, 10);
        n12 = rIPEMD160Digest78.RL(n98 + rIPEMD160Digest81.f2(n4, n3, n8) + this.X[15] + 2053994217, 6) + n7;
        int n101 = rIPEMD160Digest78.RL(n3, 10);
        n3 = n101;
        RIPEMD160Digest rIPEMD160Digest83 = this;
        RIPEMD160Digest rIPEMD160Digest84 = this;
        int n102 = n4;
        n4 = this.RL(n7 + this.f2(n12, n4, n3) + this.X[0] + 2053994217, 14) + n8;
        n7 = rIPEMD160Digest84.RL(n102, 10);
        n3 = this.RL(n8 + rIPEMD160Digest84.f2(n4, n12, n7) + this.X[5] + 2053994217, 6) + n3;
        n8 = rIPEMD160Digest83.RL(n12, 10);
        n12 = rIPEMD160Digest78.RL(n101 + rIPEMD160Digest83.f2(n3, n4, n8) + this.X[12] + 2053994217, 9) + n7;
        int n103 = rIPEMD160Digest78.RL(n4, 10);
        n4 = n103;
        RIPEMD160Digest rIPEMD160Digest85 = this;
        RIPEMD160Digest rIPEMD160Digest86 = this;
        int n104 = n3;
        n3 = this.RL(n7 + this.f2(n12, n3, n4) + this.X[2] + 2053994217, 12) + n8;
        n7 = rIPEMD160Digest86.RL(n104, 10);
        n4 = this.RL(n8 + rIPEMD160Digest86.f2(n3, n12, n7) + this.X[13] + 2053994217, 9) + n4;
        n8 = rIPEMD160Digest85.RL(n12, 10);
        n12 = rIPEMD160Digest78.RL(n103 + rIPEMD160Digest85.f2(n4, n3, n8) + this.X[9] + 2053994217, 12) + n7;
        int n105 = rIPEMD160Digest78.RL(n3, 10);
        n3 = n105;
        RIPEMD160Digest rIPEMD160Digest87 = this;
        RIPEMD160Digest rIPEMD160Digest88 = this;
        int n106 = n4;
        n4 = this.RL(n7 + this.f2(n12, n4, n3) + this.X[7] + 2053994217, 5) + n8;
        n7 = rIPEMD160Digest88.RL(n106, 10);
        n3 = this.RL(n8 + rIPEMD160Digest88.f2(n4, n12, n7) + this.X[10] + 2053994217, 15) + n3;
        n8 = rIPEMD160Digest87.RL(n12, 10);
        n12 = rIPEMD160Digest78.RL(n105 + rIPEMD160Digest87.f2(n3, n4, n8) + this.X[14] + 2053994217, 8) + n7;
        n4 = rIPEMD160Digest78.RL(n4, 10);
        n6 = this.RL(n93 + this.f5(n14, n6, n5) + this.X[4] + -1454113458, 9) + n10;
        n10 = rIPEMD160Digest77.RL(n92, 10);
        n5 = this.RL(n91 + rIPEMD160Digest77.f5(n6, n14, n10) + this.X[0] + -1454113458, 15) + n5;
        n13 = rIPEMD160Digest76.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n90 + rIPEMD160Digest76.f5(n5, n6, n13) + this.X[5] + -1454113458, 5) + n10;
        int n107 = rIPEMD160Digest.RL(n6, 10);
        n6 = n107;
        RIPEMD160Digest rIPEMD160Digest89 = this;
        RIPEMD160Digest rIPEMD160Digest90 = this;
        int n108 = n5;
        n5 = this.RL(n10 + this.f5(n14, n5, n6) + this.X[9] + -1454113458, 11) + n13;
        n10 = rIPEMD160Digest90.RL(n108, 10);
        n6 = this.RL(n13 + rIPEMD160Digest90.f5(n5, n14, n10) + this.X[7] + -1454113458, 6) + n6;
        n13 = rIPEMD160Digest89.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n107 + rIPEMD160Digest89.f5(n6, n5, n13) + this.X[12] + -1454113458, 8) + n10;
        int n109 = rIPEMD160Digest.RL(n5, 10);
        n5 = n109;
        RIPEMD160Digest rIPEMD160Digest91 = this;
        RIPEMD160Digest rIPEMD160Digest92 = this;
        int n110 = n6;
        n6 = this.RL(n10 + this.f5(n14, n6, n5) + this.X[2] + -1454113458, 13) + n13;
        n10 = rIPEMD160Digest92.RL(n110, 10);
        n5 = this.RL(n13 + rIPEMD160Digest92.f5(n6, n14, n10) + this.X[10] + -1454113458, 12) + n5;
        n13 = rIPEMD160Digest91.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n109 + rIPEMD160Digest91.f5(n5, n6, n13) + this.X[14] + -1454113458, 5) + n10;
        int n111 = rIPEMD160Digest.RL(n6, 10);
        n6 = n111;
        RIPEMD160Digest rIPEMD160Digest93 = this;
        RIPEMD160Digest rIPEMD160Digest94 = this;
        int n112 = n5;
        n5 = this.RL(n10 + this.f5(n14, n5, n6) + this.X[1] + -1454113458, 12) + n13;
        n10 = rIPEMD160Digest94.RL(n112, 10);
        n6 = this.RL(n13 + rIPEMD160Digest94.f5(n5, n14, n10) + this.X[3] + -1454113458, 13) + n6;
        n13 = rIPEMD160Digest93.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n111 + rIPEMD160Digest93.f5(n6, n5, n13) + this.X[8] + -1454113458, 14) + n10;
        int n113 = rIPEMD160Digest.RL(n5, 10);
        n5 = n113;
        RIPEMD160Digest rIPEMD160Digest95 = this;
        RIPEMD160Digest rIPEMD160Digest96 = this;
        int n114 = n6;
        n6 = this.RL(n10 + this.f5(n14, n6, n5) + this.X[11] + -1454113458, 11) + n13;
        n10 = rIPEMD160Digest96.RL(n114, 10);
        n5 = this.RL(n13 + rIPEMD160Digest96.f5(n6, n14, n10) + this.X[6] + -1454113458, 8) + n5;
        n13 = rIPEMD160Digest95.RL(n14, 10);
        n14 = rIPEMD160Digest.RL(n113 + rIPEMD160Digest95.f5(n5, n6, n13) + this.X[15] + -1454113458, 5) + n10;
        RIPEMD160Digest rIPEMD160Digest97 = this;
        int n115 = n3;
        int n116 = n7;
        int n117 = n5;
        n6 = this.RL(n6, 10);
        n5 = this.RL(n10 + this.f5(n14, n5, n6) + this.X[13] + -1454113458, 6) + n13;
        n7 = this.RL(n117, 10);
        n3 = this.RL(n116 + this.f1(n12, n3, n4) + this.X[12], 8) + n8;
        int n118 = rIPEMD160Digest97.RL(n115, 10);
        n10 = n118;
        RIPEMD160Digest rIPEMD160Digest98 = this;
        int n119 = n3;
        int n120 = n4;
        RIPEMD160Digest rIPEMD160Digest99 = this;
        n4 = this.RL(n8 + this.f1(n3, n12, n10) + this.X[15], 5) + n4;
        n8 = rIPEMD160Digest99.RL(n12, 10);
        n3 = this.RL(n120 + rIPEMD160Digest99.f1(n4, n3, n8) + this.X[10], 12) + n10;
        n10 = rIPEMD160Digest98.RL(n119, 10);
        n12 = rIPEMD160Digest97.RL(n118 + rIPEMD160Digest98.f1(n3, n4, n10) + this.X[4], 9) + n8;
        int n121 = rIPEMD160Digest97.RL(n4, 10);
        n4 = n121;
        RIPEMD160Digest rIPEMD160Digest100 = this;
        RIPEMD160Digest rIPEMD160Digest101 = this;
        int n122 = n3;
        n3 = this.RL(n8 + this.f1(n12, n3, n4) + this.X[1], 12) + n10;
        n8 = rIPEMD160Digest101.RL(n122, 10);
        n4 = this.RL(n10 + rIPEMD160Digest101.f1(n3, n12, n8) + this.X[5], 5) + n4;
        n10 = rIPEMD160Digest100.RL(n12, 10);
        n12 = rIPEMD160Digest97.RL(n121 + rIPEMD160Digest100.f1(n4, n3, n10) + this.X[8], 14) + n8;
        int n123 = rIPEMD160Digest97.RL(n3, 10);
        n3 = n123;
        RIPEMD160Digest rIPEMD160Digest102 = this;
        RIPEMD160Digest rIPEMD160Digest103 = this;
        int n124 = n4;
        n4 = this.RL(n8 + this.f1(n12, n4, n3) + this.X[7], 6) + n10;
        n8 = rIPEMD160Digest103.RL(n124, 10);
        n3 = this.RL(n10 + rIPEMD160Digest103.f1(n4, n12, n8) + this.X[6], 8) + n3;
        n10 = rIPEMD160Digest102.RL(n12, 10);
        n12 = rIPEMD160Digest97.RL(n123 + rIPEMD160Digest102.f1(n3, n4, n10) + this.X[2], 13) + n8;
        int n125 = rIPEMD160Digest97.RL(n4, 10);
        n4 = n125;
        RIPEMD160Digest rIPEMD160Digest104 = this;
        RIPEMD160Digest rIPEMD160Digest105 = this;
        int n126 = n3;
        n3 = this.RL(n8 + this.f1(n12, n3, n4) + this.X[13], 6) + n10;
        n8 = rIPEMD160Digest105.RL(n126, 10);
        n4 = this.RL(n10 + rIPEMD160Digest105.f1(n3, n12, n8) + this.X[14], 5) + n4;
        n10 = rIPEMD160Digest104.RL(n12, 10);
        n12 = rIPEMD160Digest97.RL(n125 + rIPEMD160Digest104.f1(n4, n3, n10) + this.X[0], 15) + n8;
        int n127 = rIPEMD160Digest97.RL(n3, 10);
        n3 = n127;
        RIPEMD160Digest rIPEMD160Digest106 = this;
        RIPEMD160Digest rIPEMD160Digest107 = this;
        int n128 = n4;
        n4 = this.RL(n8 + this.f1(n12, n4, n3) + this.X[3], 13) + n10;
        n8 = rIPEMD160Digest107.RL(n128, 10);
        n3 = this.RL(n10 + rIPEMD160Digest107.f1(n4, n12, n8) + this.X[9], 11) + n3;
        n10 = rIPEMD160Digest106.RL(n12, 10);
        n12 = rIPEMD160Digest97.RL(n127 + rIPEMD160Digest106.f1(n3, n4, n10) + this.X[11], 11) + n8;
        n4 = rIPEMD160Digest97.RL(n4, 10);
        n4 = n14 + rIPEMD160Digest97.H1 + n4;
        rIPEMD160Digest.H1 = rIPEMD160Digest.H2 + n7 + n10;
        rIPEMD160Digest.H2 = rIPEMD160Digest.H3 + n6 + n8;
        rIPEMD160Digest.H3 = rIPEMD160Digest.H4 + n13 + n12;
        rIPEMD160Digest.H4 = rIPEMD160Digest.H0 + n5 + n3;
        rIPEMD160Digest.H0 = n4;
        rIPEMD160Digest.xOff = 0;
        n3 = 0;
        while (true) {
            int[] nArray = this.X;
            if (n3 == this.X.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    @Override
    public Memoable copy() {
        return new RIPEMD160Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((RIPEMD160Digest)memoable);
    }
}

