/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA1Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 20;
    private static final int Y1 = 1518500249;
    private static final int Y2 = 1859775393;
    private static final int Y3 = -1894007588;
    private static final int Y4 = -899497514;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int[] X;
    private int xOff;

    public SHA1Digest() {
        SHA1Digest sHA1Digest = this;
        sHA1Digest.X = new int[80];
        sHA1Digest.reset();
    }

    public SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.X = new int[80];
        this.copyIn(sHA1Digest);
    }

    public SHA1Digest(byte[] byArray) {
        super(byArray);
        this.X = new int[80];
        this.H1 = Pack.bigEndianToInt(byArray, 16);
        this.H2 = Pack.bigEndianToInt(byArray, 20);
        this.H3 = Pack.bigEndianToInt(byArray, 24);
        this.H4 = Pack.bigEndianToInt(byArray, 28);
        this.H5 = Pack.bigEndianToInt(byArray, 32);
        this.xOff = Pack.bigEndianToInt(byArray, 36);
        for (int i3 = 0; i3 != this.xOff; ++i3) {
            this.X[i3] = Pack.bigEndianToInt(byArray, i3 * 4 + 40);
        }
    }

    private void copyIn(SHA1Digest sHA1Digest) {
        SHA1Digest sHA1Digest2 = object;
        SHA1Digest sHA1Digest3 = sHA1Digest;
        ((SHA1Digest)object).H1 = sHA1Digest.H1;
        ((SHA1Digest)object).H2 = sHA1Digest.H2;
        ((SHA1Digest)object).H3 = sHA1Digest.H3;
        ((SHA1Digest)object).H4 = sHA1Digest.H4;
        ((SHA1Digest)object).H5 = sHA1Digest.H5;
        Object object = ((SHA1Digest)object).X;
        int n3 = sHA1Digest3.X.length;
        System.arraycopy(sHA1Digest3.X, 0, object, 0, n3);
        sHA1Digest2.xOff = sHA1Digest3.xOff;
    }

    private int f(int n3, int n4, int n5) {
        return n3 & n4 | ~n3 & n5;
    }

    private int h(int n3, int n4, int n5) {
        return n3 ^ n4 ^ n5;
    }

    private int g(int n3, int n4, int n5) {
        return n3 & n4 | n3 & n5 | n4 & n5;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-1";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    public void processWord(byte[] byArray, int n3) {
        int n4 = byArray[n3] << 24;
        n3 = n3 + 1;
        int n5 = n4 | (byArray[n3] & 0xFF) << 16 | (byArray[++n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
        n3 = this.xOff;
        this.X[n3] = n5;
        this.xOff = n3 + 1;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l3) {
        if (((SHA1Digest)object).xOff > 14) {
            ((SHA1Digest)object).processBlock();
        }
        Object object = ((SHA1Digest)object).X;
        object[14] = (int)(l3 >>> 32);
        ((SHA1Digest)object).X[15] = (int)l3;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        SHA1Digest sHA1Digest = this;
        sHA1Digest.finish();
        Pack.intToBigEndian(sHA1Digest.H1, byArray, n3);
        Pack.intToBigEndian(sHA1Digest.H2, byArray, n3 + 4);
        Pack.intToBigEndian(sHA1Digest.H3, byArray, n3 + 8);
        Pack.intToBigEndian(sHA1Digest.H4, byArray, n3 + 12);
        Pack.intToBigEndian(sHA1Digest.H5, byArray, n3 + 16);
        sHA1Digest.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.H5 = -1009589776;
        this.xOff = 0;
        int n3 = 0;
        while (true) {
            int[] nArray = this.X;
            if (n3 == this.X.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    @Override
    public void processBlock() {
        int n3;
        int n4;
        int n5;
        for (n5 = 16; n5 < 80; ++n5) {
            int[] nArray = this.X;
            n4 = nArray[n5 - 3] ^ nArray[n5 - 8] ^ nArray[n5 - 14] ^ nArray[n5 - 16];
            this.X[n5] = n4 << 1 | n4 >>> 31;
        }
        SHA1Digest sHA1Digest = this;
        n5 = sHA1Digest.H1;
        n4 = sHA1Digest.H2;
        int n6 = sHA1Digest.H3;
        int n7 = sHA1Digest.H4;
        int n8 = sHA1Digest.H5;
        int n9 = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            n8 = b.a((n5 << 5 | n5 >>> 27) + this.f(n4, n6, n7), this.X[n9++], 1518500249, n8);
            n4 = n4 << 30 | n4 >>> 2;
            n7 = b.a((n8 << 5 | n8 >>> 27) + this.f(n5, n4, n6), this.X[n9++], 1518500249, n7);
            n5 = n5 << 30 | n5 >>> 2;
            n6 = b.a((n7 << 5 | n7 >>> 27) + this.f(n8, n5, n4), this.X[n9++], 1518500249, n6);
            n8 = n8 << 30 | n8 >>> 2;
            n4 = b.a((n6 << 5 | n6 >>> 27) + this.f(n7, n8, n5), this.X[n9++], 1518500249, n4);
            n7 = n7 << 30 | n7 >>> 2;
            n5 = b.a((n4 << 5 | n4 >>> 27) + this.f(n6, n7, n8), this.X[n9++], 1518500249, n5);
            n6 = n6 << 30 | n6 >>> 2;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            n8 = b.a((n5 << 5 | n5 >>> 27) + this.h(n4, n6, n7), this.X[n9++], 1859775393, n8);
            n4 = n4 << 30 | n4 >>> 2;
            n7 = b.a((n8 << 5 | n8 >>> 27) + this.h(n5, n4, n6), this.X[n9++], 1859775393, n7);
            n5 = n5 << 30 | n5 >>> 2;
            n6 = b.a((n7 << 5 | n7 >>> 27) + this.h(n8, n5, n4), this.X[n9++], 1859775393, n6);
            n8 = n8 << 30 | n8 >>> 2;
            n4 = b.a((n6 << 5 | n6 >>> 27) + this.h(n7, n8, n5), this.X[n9++], 1859775393, n4);
            n7 = n7 << 30 | n7 >>> 2;
            n5 = b.a((n4 << 5 | n4 >>> 27) + this.h(n6, n7, n8), this.X[n9++], 1859775393, n5);
            n6 = n6 << 30 | n6 >>> 2;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            n8 = b.a((n5 << 5 | n5 >>> 27) + this.g(n4, n6, n7), this.X[n9++], -1894007588, n8);
            n4 = n4 << 30 | n4 >>> 2;
            n7 = b.a((n8 << 5 | n8 >>> 27) + this.g(n5, n4, n6), this.X[n9++], -1894007588, n7);
            n5 = n5 << 30 | n5 >>> 2;
            n6 = b.a((n7 << 5 | n7 >>> 27) + this.g(n8, n5, n4), this.X[n9++], -1894007588, n6);
            n8 = n8 << 30 | n8 >>> 2;
            n4 = b.a((n6 << 5 | n6 >>> 27) + this.g(n7, n8, n5), this.X[n9++], -1894007588, n4);
            n7 = n7 << 30 | n7 >>> 2;
            n5 = b.a((n4 << 5 | n4 >>> 27) + this.g(n6, n7, n8), this.X[n9++], -1894007588, n5);
            n6 = n6 << 30 | n6 >>> 2;
        }
        for (n3 = 0; n3 <= 3; ++n3) {
            n8 = b.a((n5 << 5 | n5 >>> 27) + this.h(n4, n6, n7), this.X[n9++], -899497514, n8);
            n4 = n4 << 30 | n4 >>> 2;
            n7 = b.a((n8 << 5 | n8 >>> 27) + this.h(n5, n4, n6), this.X[n9++], -899497514, n7);
            n5 = n5 << 30 | n5 >>> 2;
            n6 = b.a((n7 << 5 | n7 >>> 27) + this.h(n8, n5, n4), this.X[n9++], -899497514, n6);
            n8 = n8 << 30 | n8 >>> 2;
            n4 = b.a((n6 << 5 | n6 >>> 27) + this.h(n7, n8, n5), this.X[n9++], -899497514, n4);
            n7 = n7 << 30 | n7 >>> 2;
            n5 = b.a((n4 << 5 | n4 >>> 27) + this.h(n6, n7, n8), this.X[n9++], -899497514, n5);
            n6 = n6 << 30 | n6 >>> 2;
        }
        SHA1Digest sHA1Digest2 = this;
        sHA1Digest2.H1 += n5;
        sHA1Digest2.H2 += n4;
        sHA1Digest2.H3 += n6;
        sHA1Digest2.H4 += n7;
        sHA1Digest2.H5 += n8;
        sHA1Digest2.xOff = 0;
        for (n5 = 0; n5 < 16; ++n5) {
            this.X[n5] = 0;
        }
    }

    @Override
    public Memoable copy() {
        return new SHA1Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA1Digest sHA1Digest = sHA1Digest2;
        SHA1Digest sHA1Digest2 = (SHA1Digest)memoable;
        super.copyIn(sHA1Digest2);
        sHA1Digest.copyIn(sHA1Digest2);
    }

    @Override
    public byte[] getEncodedState() {
        SHA1Digest sHA1Digest = this;
        byte[] byArray = new byte[sHA1Digest.xOff * 4 + 40];
        super.populateState(byArray);
        Pack.intToBigEndian(sHA1Digest.H1, byArray, 16);
        Pack.intToBigEndian(sHA1Digest.H2, byArray, 20);
        Pack.intToBigEndian(sHA1Digest.H3, byArray, 24);
        Pack.intToBigEndian(sHA1Digest.H4, byArray, 28);
        Pack.intToBigEndian(sHA1Digest.H5, byArray, 32);
        Pack.intToBigEndian(sHA1Digest.xOff, byArray, 36);
        for (int i3 = 0; i3 != this.xOff; ++i3) {
            Pack.intToBigEndian(this.X[i3], byArray, i3 * 4 + 40);
        }
        return byArray;
    }
}

