/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.KeccakDigest;

public class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n3) {
        if (n3 != 224 && n3 != 256 && n3 != 384 && n3 != 512) {
            throw new IllegalArgumentException(f.a("'bitLength' ", n3, " not supported for SHA-3"));
        }
        return n3;
    }

    public SHA3Digest() {
        this(256);
    }

    public SHA3Digest(int n3) {
        super(SHA3Digest.checkBitLength(n3));
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    @Override
    public String getAlgorithmName() {
        return b.a("SHA3-").append(this.fixedOutputLength).toString();
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n3, byte by, int n4) {
        if (n4 >= 0 && n4 <= 7) {
            by = (byte)(by & (1 << n4) - 1 | 2 << n4);
            if ((n4 += 2) >= 8) {
                this.absorb(by);
                n4 -= 8;
                by = (byte)(by >>> 8);
            }
            return super.doFinal(byArray, n3, by, n4);
        }
        throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
    }
}

