/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.LongDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA512Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 64;

    public SHA512Digest() {
    }

    public SHA512Digest(SHA512Digest sHA512Digest) {
        super(sHA512Digest);
    }

    public SHA512Digest(byte[] byArray) {
        SHA512Digest sHA512Digest = this;
        sHA512Digest.restoreState(byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        SHA512Digest sHA512Digest = this;
        sHA512Digest.finish();
        Pack.longToBigEndian(sHA512Digest.H1, byArray, n3);
        Pack.longToBigEndian(sHA512Digest.H2, byArray, n3 + 8);
        Pack.longToBigEndian(sHA512Digest.H3, byArray, n3 + 16);
        Pack.longToBigEndian(sHA512Digest.H4, byArray, n3 + 24);
        Pack.longToBigEndian(sHA512Digest.H5, byArray, n3 + 32);
        Pack.longToBigEndian(sHA512Digest.H6, byArray, n3 + 40);
        Pack.longToBigEndian(sHA512Digest.H7, byArray, n3 + 48);
        Pack.longToBigEndian(sHA512Digest.H8, byArray, n3 + 56);
        sHA512Digest.reset();
        return 64;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 7640891576956012808L;
        this.H2 = -4942790177534073029L;
        this.H3 = 4354685564936845355L;
        this.H4 = -6534734903238641935L;
        this.H5 = 5840696475078001361L;
        this.H6 = -7276294671716946913L;
        this.H7 = 2270897969802886507L;
        this.H8 = 6620516959819538809L;
    }

    @Override
    public Memoable copy() {
        return new SHA512Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((SHA512Digest)memoable);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[this.getEncodedStateSize()];
        super.populateState(byArray);
        return byArray;
    }
}

