/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.LongDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.MemoableResetException;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA512tDigest
extends LongDigest {
    private int digestLength;
    private long H1t;
    private long H2t;
    private long H3t;
    private long H4t;
    private long H5t;
    private long H6t;
    private long H7t;
    private long H8t;

    public SHA512tDigest(int n3) {
        if (n3 < 512) {
            if (n3 % 8 == 0) {
                if (n3 != 384) {
                    SHA512tDigest sHA512tDigest = this;
                    this.digestLength = n3 / 8;
                    sHA512tDigest.tIvGenerate(this.digestLength * 8);
                    sHA512tDigest.reset();
                    return;
                }
                throw new IllegalArgumentException("bitLength cannot be 384 use SHA384 instead");
            }
            throw new IllegalArgumentException("bitLength needs to be a multiple of 8");
        }
        throw new IllegalArgumentException("bitLength cannot be >= 512");
    }

    public SHA512tDigest(SHA512tDigest sHA512tDigest) {
        super(sHA512tDigest);
        this.digestLength = sHA512tDigest.digestLength;
        this.reset(sHA512tDigest);
    }

    public SHA512tDigest(byte[] byArray) {
        this(SHA512tDigest.readDigestLength(byArray));
        this.restoreState(byArray);
    }

    private static int readDigestLength(byte[] byArray) {
        return Pack.bigEndianToInt(byArray, byArray.length - 4);
    }

    private void tIvGenerate(int n3) {
        SHA512tDigest sHA512tDigest = this;
        sHA512tDigest.H1 = -3482333909917012819L;
        sHA512tDigest.H2 = 2216346199247487646L;
        sHA512tDigest.H3 = -7364697282686394994L;
        sHA512tDigest.H4 = 65953792586715988L;
        sHA512tDigest.H5 = -816286391624063116L;
        sHA512tDigest.H6 = 4512832404995164602L;
        sHA512tDigest.H7 = -5033199132376557362L;
        sHA512tDigest.H8 = -124578254951840548L;
        sHA512tDigest.update((byte)83);
        sHA512tDigest.update((byte)72);
        sHA512tDigest.update((byte)65);
        sHA512tDigest.update((byte)45);
        sHA512tDigest.update((byte)53);
        sHA512tDigest.update((byte)49);
        sHA512tDigest.update((byte)50);
        sHA512tDigest.update((byte)47);
        if (n3 > 100) {
            this.update((byte)(n3 / 100 + 48));
            int n4 = n3 % 100;
            this.update((byte)(n4 / 10 + 48));
            this.update((byte)(n4 % 10 + 48));
        } else if (n3 > 10) {
            this.update((byte)(n3 / 10 + 48));
            this.update((byte)(n3 % 10 + 48));
        } else {
            this.update((byte)(n3 + 48));
        }
        SHA512tDigest sHA512tDigest2 = this;
        sHA512tDigest2.finish();
        sHA512tDigest2.H1t = sHA512tDigest2.H1;
        sHA512tDigest2.H2t = sHA512tDigest2.H2;
        sHA512tDigest2.H3t = sHA512tDigest2.H3;
        sHA512tDigest2.H4t = sHA512tDigest2.H4;
        sHA512tDigest2.H5t = sHA512tDigest2.H5;
        sHA512tDigest2.H6t = sHA512tDigest2.H6;
        sHA512tDigest2.H7t = sHA512tDigest2.H7;
        sHA512tDigest2.H8t = sHA512tDigest2.H8;
    }

    private static void longToBigEndian(long l3, byte[] byArray, int n3, int n4) {
        if (n4 > 0) {
            SHA512tDigest.intToBigEndian((int)(l3 >>> 32), byArray, n3, n4);
            if (n4 > 4) {
                int n5 = n3 + 4;
                SHA512tDigest.intToBigEndian((int)(l3 & 0xFFFFFFFFL), byArray, n5, n4 - 4);
            }
        }
    }

    private static void intToBigEndian(int n3, byte[] byArray, int n4, int n5) {
        n5 = Math.min(4, n5);
        while ((n5 += -1) >= 0) {
            int n6 = (3 - n5) * 8;
            int n7 = n4 + n5;
            byArray[n7] = (byte)(n3 >>> n6);
        }
    }

    @Override
    public String getAlgorithmName() {
        return b.a("SHA-512/").append(Integer.toString(this.digestLength * 8)).toString();
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        SHA512tDigest sHA512tDigest = this;
        sHA512tDigest.finish();
        SHA512tDigest.longToBigEndian(sHA512tDigest.H1, byArray, n3, this.digestLength);
        int n4 = n3 + 8;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H2, byArray, n4, this.digestLength - 8);
        n4 = n3 + 16;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H3, byArray, n4, this.digestLength - 16);
        n4 = n3 + 24;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H4, byArray, n4, this.digestLength - 24);
        n4 = n3 + 32;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H5, byArray, n4, this.digestLength - 32);
        n4 = n3 + 40;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H6, byArray, n4, this.digestLength - 40);
        n4 = n3 + 48;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H7, byArray, n4, this.digestLength - 48);
        int n5 = n3 + 56;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H8, byArray, n5, this.digestLength - 56);
        sHA512tDigest.reset();
        return sHA512tDigest.digestLength;
    }

    @Override
    public void reset() {
        SHA512tDigest sHA512tDigest = this;
        super.reset();
        sHA512tDigest.H1 = sHA512tDigest.H1t;
        sHA512tDigest.H2 = sHA512tDigest.H2t;
        sHA512tDigest.H3 = sHA512tDigest.H3t;
        sHA512tDigest.H4 = sHA512tDigest.H4t;
        sHA512tDigest.H5 = sHA512tDigest.H5t;
        sHA512tDigest.H6 = sHA512tDigest.H6t;
        sHA512tDigest.H7 = sHA512tDigest.H7t;
        sHA512tDigest.H8 = sHA512tDigest.H8t;
    }

    @Override
    public Memoable copy() {
        return new SHA512tDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        memoable = (SHA512tDigest)memoable;
        if (this.digestLength == ((SHA512tDigest)memoable).digestLength) {
            super.copyIn((LongDigest)memoable);
            this.H1t = ((SHA512tDigest)memoable).H1t;
            this.H2t = ((SHA512tDigest)memoable).H2t;
            this.H3t = ((SHA512tDigest)memoable).H3t;
            this.H4t = ((SHA512tDigest)memoable).H4t;
            this.H5t = ((SHA512tDigest)memoable).H5t;
            this.H6t = ((SHA512tDigest)memoable).H6t;
            this.H7t = ((SHA512tDigest)memoable).H7t;
            this.H8t = ((SHA512tDigest)memoable).H8t;
            return;
        }
        throw new MemoableResetException("digestLength inappropriate in other");
    }

    @Override
    public byte[] getEncodedState() {
        int n3 = this.getEncodedStateSize();
        byte[] byArray = new byte[n3 + 4];
        SHA512tDigest sHA512tDigest = this;
        sHA512tDigest.populateState(byArray);
        Pack.intToBigEndian(sHA512tDigest.digestLength * 8, byArray, n3);
        return byArray;
    }
}

