/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.KeccakDigest;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int checkBitLength(int n3) {
        if (n3 != 128 && n3 != 256) {
            throw new IllegalArgumentException(f.a("'bitLength' ", n3, " not supported for SHAKE"));
        }
        return n3;
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int n3) {
        super(SHAKEDigest.checkBitLength(n3));
    }

    public SHAKEDigest(SHAKEDigest sHAKEDigest) {
        super(sHAKEDigest);
    }

    @Override
    public String getAlgorithmName() {
        return b.a("SHAKE").append(this.fixedOutputLength).toString();
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        return this.doFinal(byArray, n3, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] byArray, int n3, int n4) {
        int n5 = this.doOutput(byArray, n3, n4);
        this.reset();
        return n5;
    }

    @Override
    public int doOutput(byte[] byArray, int n3, int n4) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        long l3 = (long)n4 * 8L;
        this.squeeze(byArray, n3, l3);
        return n4;
    }

    @Override
    public int doFinal(byte[] byArray, int n3, byte by, int n4) {
        return this.doFinal(byArray, n3, this.getDigestSize(), by, n4);
    }

    public int doFinal(byte[] byArray, int n3, int n4, byte by, int n5) {
        if (n5 >= 0 && n5 <= 7) {
            by = (byte)(by & (1 << n5) - 1 | 15 << n5);
            if ((n5 += 4) >= 8) {
                this.absorb(by);
                n5 -= 8;
                by = (byte)(by >>> 8);
            }
            if (n5 > 0) {
                this.absorbBits(by, n5);
            }
            SHAKEDigest sHAKEDigest = this;
            long l3 = (long)n4 * 8L;
            sHAKEDigest.squeeze(byArray, n3, l3);
            sHAKEDigest.reset();
            return n4;
        }
        throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
    }
}

