/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SM3Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private static final int[] T;
    private int[] V;
    private int[] inwords;
    private int xOff;
    private int[] W;

    public SM3Digest() {
        SM3Digest sM3Digest = this;
        sM3Digest.V = new int[8];
        sM3Digest.inwords = new int[16];
        sM3Digest.W = new int[68];
        sM3Digest.reset();
    }

    public SM3Digest(SM3Digest sM3Digest) {
        super(sM3Digest);
        this.V = new int[8];
        this.inwords = new int[16];
        this.W = new int[68];
        this.copyIn(sM3Digest);
    }

    private void copyIn(SM3Digest object) {
        SM3Digest sM3Digest = object2;
        SM3Digest sM3Digest2 = object;
        object = ((SM3Digest)object2).V;
        int n3 = ((SM3Digest)object2).V.length;
        System.arraycopy(sM3Digest2.V, 0, object, 0, n3);
        Object object2 = ((SM3Digest)object2).inwords;
        int n4 = ((SM3Digest)object2).inwords.length;
        System.arraycopy(sM3Digest2.inwords, 0, object2, 0, n4);
        sM3Digest.xOff = sM3Digest2.xOff;
    }

    private int P0(int n3) {
        int n4 = n3;
        int n5 = n4 << 9 | n3 >>> 23;
        n3 = n4 << 17 | n3 >>> 15;
        return n4 ^ n5 ^ n3;
    }

    private int P1(int n3) {
        int n4 = n3;
        int n5 = n4 << 15 | n3 >>> 17;
        n3 = n4 << 23 | n3 >>> 9;
        return n4 ^ n5 ^ n3;
    }

    private int FF0(int n3, int n4, int n5) {
        return n3 ^ n4 ^ n5;
    }

    private int FF1(int n3, int n4, int n5) {
        return n3 & n4 | n3 & n5 | n4 & n5;
    }

    private int GG0(int n3, int n4, int n5) {
        return n3 ^ n4 ^ n5;
    }

    private int GG1(int n3, int n4, int n5) {
        return n3 & n4 | ~n3 & n5;
    }

    static {
        int n3;
        T = new int[64];
        for (n3 = 0; n3 < 16; ++n3) {
            SM3Digest.T[n3] = 2043430169 << n3 | 2043430169 >>> 32 - n3;
        }
        for (n3 = 16; n3 < 64; ++n3) {
            int n4 = n3 % 32;
            SM3Digest.T[n3] = 2055708042 << n4 | 2055708042 >>> 32 - n4;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SM3";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public Memoable copy() {
        return new SM3Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SM3Digest sM3Digest = sM3Digest2;
        SM3Digest sM3Digest2 = (SM3Digest)memoable;
        super.copyIn(sM3Digest2);
        sM3Digest.copyIn(sM3Digest2);
    }

    @Override
    public void reset() {
        SM3Digest sM3Digest = this;
        super.reset();
        int[] nArray = sM3Digest.V;
        int[] nArray2 = sM3Digest.V;
        nArray[0] = 1937774191;
        nArray2[1] = 1226093241;
        nArray[2] = 388252375;
        nArray2[3] = -628488704;
        nArray[4] = -1452330820;
        nArray2[5] = 372324522;
        nArray[6] = -477237683;
        nArray2[7] = -1325724082;
        sM3Digest.xOff = 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        SM3Digest sM3Digest = this;
        sM3Digest.finish();
        Pack.intToBigEndian(sM3Digest.V, byArray, n3);
        sM3Digest.reset();
        return 32;
    }

    @Override
    public void processWord(byte[] byArray, int n3) {
        int n4 = (byArray[n3] & 0xFF) << 24;
        n3 = n3 + 1;
        int n5 = n4 | (byArray[n3] & 0xFF) << 16 | (byArray[++n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
        n3 = this.xOff;
        this.inwords[n3] = n5;
        this.xOff = n3 + 1;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l3) {
        int n3 = this.xOff;
        if (n3 > 14) {
            this.inwords[n3] = 0;
            this.xOff = n3 + 1;
            this.processBlock();
        }
        while ((n3 = this.xOff) < 14) {
            this.inwords[n3] = 0;
            this.xOff = n3 + 1;
        }
        int[] nArray = this.inwords;
        int n4 = n3 + 1;
        nArray[n3] = (int)(l3 >>> 32);
        this.xOff = n4 + 1;
        this.inwords[n4] = (int)l3;
    }

    @Override
    public void processBlock() {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 0; n10 < 16; ++n10) {
            this.W[n10] = this.inwords[n10];
        }
        for (n10 = 16; n10 < 68; ++n10) {
            int[] nArray = this.W;
            n9 = nArray[n10 - 3];
            n9 = n9 << 15 | n9 >>> 17;
            n8 = nArray[n10 - 13];
            n8 = n8 << 7 | n8 >>> 25;
            this.W[n10] = this.P1(nArray[n10 - 16] ^ nArray[n10 - 9] ^ n9) ^ n8 ^ this.W[n10 - 6];
        }
        n10 = this.V[0];
        int n11 = this.V[1];
        n9 = this.V[2];
        n8 = this.V[3];
        int n12 = this.V[4];
        int n13 = this.V[5];
        int n14 = this.V[6];
        int n15 = this.V[7];
        int n16 = n10;
        int n17 = n9;
        int n18 = n12;
        int n19 = n14;
        n14 = n15;
        n15 = n19;
        n12 = n13;
        n13 = n18;
        n9 = n8;
        n8 = n17;
        n10 = n11;
        n11 = n16;
        for (n7 = 0; n7 < 16; ++n7) {
            n6 = n11 << 12 | n11 >>> 20;
            n5 = n6 + n13 + T[n7];
            n5 = n5 << 7 | n5 >>> 25;
            n6 = n5 ^ n6;
            int[] nArray = this.W;
            n4 = this.W[n7];
            n3 = n4 ^ nArray[n7 + 4];
            n9 = b.a(this.FF0(n11, n10, n8), n9, n6, n3);
            n14 = b.a(this.GG0(n13, n12, n15), n14, n5, n4);
            n10 = n10 << 9 | n10 >>> 23;
            n12 = n12 << 19 | n12 >>> 13;
            n14 = this.P0(n14);
            int n20 = n9;
            int n21 = n14;
            n14 = n15;
            n15 = n12;
            n12 = n13;
            n13 = n21;
            n9 = n8;
            n8 = n10;
            n10 = n11;
            n11 = n20;
        }
        int n22 = n11;
        int n23 = n8;
        int n24 = n13;
        int n25 = n15;
        n15 = n14;
        n14 = n25;
        n13 = n12;
        n12 = n24;
        n8 = n9;
        n9 = n23;
        n11 = n10;
        n10 = n22;
        for (n7 = 16; n7 < 64; ++n7) {
            n6 = n10 << 12 | n10 >>> 20;
            n5 = n6 + n12 + T[n7];
            n5 = n5 << 7 | n5 >>> 25;
            n6 = n5 ^ n6;
            int[] nArray = this.W;
            n4 = this.W[n7];
            n3 = n4 ^ nArray[n7 + 4];
            n8 = b.a(this.FF1(n10, n11, n9), n8, n6, n3);
            n15 = b.a(this.GG1(n12, n13, n14), n15, n5, n4);
            n11 = n11 << 9 | n11 >>> 23;
            n13 = n13 << 19 | n13 >>> 13;
            n15 = this.P0(n15);
            int n26 = n8;
            int n27 = n15;
            n15 = n14;
            n14 = n13;
            n13 = n12;
            n12 = n27;
            n8 = n9;
            n9 = n11;
            n11 = n10;
            n10 = n26;
        }
        SM3Digest sM3Digest = this;
        int[] nArray = sM3Digest.V;
        nArray[0] = sM3Digest.V[0] ^ n10;
        nArray[1] = sM3Digest.V[1] ^ n11;
        nArray[2] = sM3Digest.V[2] ^ n9;
        nArray[3] = sM3Digest.V[3] ^ n8;
        nArray[4] = sM3Digest.V[4] ^ n12;
        nArray[5] = sM3Digest.V[5] ^ n13;
        nArray[6] = sM3Digest.V[6] ^ n14;
        nArray[7] = sM3Digest.V[7] ^ n15;
        sM3Digest.xOff = 0;
    }
}

