/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;

public class ShortenedDigest
implements ExtendedDigest {
    private ExtendedDigest baseDigest;
    private int length;

    public ShortenedDigest(ExtendedDigest extendedDigest, int n3) {
        if (extendedDigest != null) {
            if (n3 <= extendedDigest.getDigestSize()) {
                ShortenedDigest shortenedDigest = this;
                shortenedDigest.baseDigest = extendedDigest;
                shortenedDigest.length = n3;
                return;
            }
            throw new IllegalArgumentException("baseDigest output not large enough to support length");
        }
        throw new IllegalArgumentException("baseDigest must not be null");
    }

    @Override
    public String getAlgorithmName() {
        return this.baseDigest.getAlgorithmName() + "(" + this.length * 8 + ")";
    }

    @Override
    public int getDigestSize() {
        return this.length;
    }

    @Override
    public void update(byte by) {
        this.baseDigest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.baseDigest.update(byArray, n3, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        ShortenedDigest shortenedDigest = this;
        byte[] byArray2 = new byte[shortenedDigest.baseDigest.getDigestSize()];
        ShortenedDigest shortenedDigest2 = this;
        shortenedDigest2.baseDigest.doFinal(byArray2, 0);
        int n4 = shortenedDigest2.length;
        System.arraycopy(byArray2, 0, byArray, n3, n4);
        return shortenedDigest.length;
    }

    @Override
    public void reset() {
        this.baseDigest.reset();
    }

    @Override
    public int getByteLength() {
        return this.baseDigest.getByteLength();
    }
}

