/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public final class WhirlpoolDigest
implements ExtendedDigest,
Memoable {
    private static final int BYTE_LENGTH = 64;
    private static final int DIGEST_LENGTH_BYTES = 64;
    private static final int ROUNDS = 10;
    private static final int REDUCTION_POLYNOMIAL = 285;
    private static final int[] SBOX = new int[]{24, 35, 198, 232, 135, 184, 1, 79, 54, 166, 210, 245, 121, 111, 145, 82, 96, 188, 155, 142, 163, 12, 123, 53, 29, 224, 215, 194, 46, 75, 254, 87, 21, 119, 55, 229, 159, 240, 74, 218, 88, 201, 41, 10, 177, 160, 107, 133, 189, 93, 16, 244, 203, 62, 5, 103, 228, 39, 65, 139, 167, 125, 149, 216, 251, 238, 124, 102, 221, 23, 71, 158, 202, 45, 191, 7, 173, 90, 131, 51, 99, 2, 170, 113, 200, 25, 73, 217, 242, 227, 91, 136, 154, 38, 50, 176, 233, 15, 213, 128, 190, 205, 52, 72, 255, 122, 144, 95, 32, 104, 26, 174, 180, 84, 147, 34, 100, 241, 115, 18, 64, 8, 195, 236, 219, 161, 141, 61, 151, 0, 207, 43, 118, 130, 214, 27, 181, 175, 106, 80, 69, 243, 48, 239, 63, 85, 162, 234, 101, 186, 47, 192, 222, 28, 253, 77, 146, 117, 6, 138, 178, 230, 14, 31, 98, 212, 168, 150, 249, 197, 37, 89, 132, 114, 57, 76, 94, 120, 56, 140, 209, 165, 226, 97, 179, 33, 156, 30, 67, 199, 252, 4, 81, 153, 109, 13, 250, 223, 126, 36, 59, 171, 206, 17, 143, 78, 183, 235, 60, 129, 148, 247, 185, 19, 44, 211, 231, 110, 196, 3, 86, 68, 127, 169, 42, 187, 193, 83, 220, 11, 157, 108, 49, 116, 246, 70, 172, 137, 20, 225, 22, 58, 105, 9, 112, 182, 208, 237, 204, 66, 152, 164, 40, 92, 248, 134};
    private static final long[] C0 = new long[256];
    private static final long[] C1 = new long[256];
    private static final long[] C2 = new long[256];
    private static final long[] C3 = new long[256];
    private static final long[] C4 = new long[256];
    private static final long[] C5 = new long[256];
    private static final long[] C6 = new long[256];
    private static final long[] C7 = new long[256];
    private static final int BITCOUNT_ARRAY_SIZE = 32;
    private static final short[] EIGHT;
    private final long[] _rc = new long[11];
    private byte[] _buffer = new byte[64];
    private int _bufferPos = 0;
    private short[] _bitCount = new short[32];
    private long[] _hash = new long[8];
    private long[] _K = new long[8];
    private long[] _L = new long[8];
    private long[] _block = new long[8];
    private long[] _state = new long[8];

    public WhirlpoolDigest() {
        int n3;
        int n4;
        for (n4 = 0; n4 < 256; ++n4) {
            WhirlpoolDigest whirlpoolDigest = this;
            n3 = SBOX[n4];
            int n5 = whirlpoolDigest.maskWithReductionPolynomial(n3 << 1);
            int n6 = whirlpoolDigest.maskWithReductionPolynomial(n5 << 1);
            int n7 = n6 ^ n3;
            int n8 = whirlpoolDigest.maskWithReductionPolynomial(n6 << 1);
            int n9 = n8 ^ n3;
            int n10 = n3;
            WhirlpoolDigest.C0[n4] = this.packIntoLong(n10, n10, n6, n3, n8, n7, n5, n9);
            int n11 = n3;
            WhirlpoolDigest.C1[n4] = this.packIntoLong(n9, n11, n11, n6, n3, n8, n7, n5);
            int n12 = n3;
            WhirlpoolDigest.C2[n4] = this.packIntoLong(n5, n9, n12, n12, n6, n3, n8, n7);
            int n13 = n3;
            WhirlpoolDigest.C3[n4] = this.packIntoLong(n7, n5, n9, n13, n13, n6, n3, n8);
            int n14 = n3;
            WhirlpoolDigest.C4[n4] = this.packIntoLong(n8, n7, n5, n9, n14, n14, n6, n3);
            int n15 = n3;
            WhirlpoolDigest.C5[n4] = this.packIntoLong(n3, n8, n7, n5, n9, n15, n15, n6);
            int n16 = n3;
            WhirlpoolDigest.C6[n4] = this.packIntoLong(n6, n3, n8, n7, n5, n9, n16, n16);
            WhirlpoolDigest.C7[n4] = this.packIntoLong(n3, n6, n3, n8, n7, n5, n9, n3);
        }
        this._rc[0] = 0L;
        for (n4 = 1; n4 <= 10; ++n4) {
            n3 = (n4 - 1) * 8;
            this._rc[n4] = C0[n3] & 0xFF00000000000000L ^ C1[n3 + 1] & 0xFF000000000000L ^ C2[n3 + 2] & 0xFF0000000000L ^ C3[n3 + 3] & 0xFF00000000L ^ C4[n3 + 4] & 0xFF000000L ^ C5[n3 + 5] & 0xFF0000L ^ C6[n3 + 6] & 0xFF00L ^ C7[n3 + 7] & 0xFFL;
        }
    }

    private long packIntoLong(int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return (long)n3 << 56 ^ (long)n4 << 48 ^ (long)n5 << 40 ^ (long)n6 << 32 ^ (long)n7 << 24 ^ (long)n8 << 16 ^ (long)n9 << 8 ^ (long)n10;
    }

    private int maskWithReductionPolynomial(int n3) {
        if ((long)n3 >= 256L) {
            n3 ^= 0x11D;
        }
        return n3;
    }

    public WhirlpoolDigest(WhirlpoolDigest whirlpoolDigest) {
        this.reset(whirlpoolDigest);
    }

    private void processFilledBuffer(byte[] byArray, int n3) {
        for (int i3 = 0; i3 < this._state.length; ++i3) {
            byte[] byArray2 = this._buffer;
            this._block[i3] = this.bytesToLongFromBuffer(byArray2, i3 * 8);
        }
        WhirlpoolDigest whirlpoolDigest = this;
        whirlpoolDigest.processBlock();
        whirlpoolDigest._bufferPos = 0;
        Arrays.fill(whirlpoolDigest._buffer, (byte)0);
    }

    private long bytesToLongFromBuffer(byte[] byArray, int n3) {
        return ((long)byArray[n3 + 0] & 0xFFL) << 56 | ((long)byArray[n3 + 1] & 0xFFL) << 48 | ((long)byArray[n3 + 2] & 0xFFL) << 40 | ((long)byArray[n3 + 3] & 0xFFL) << 32 | ((long)byArray[n3 + 4] & 0xFFL) << 24 | ((long)byArray[n3 + 5] & 0xFFL) << 16 | ((long)byArray[n3 + 6] & 0xFFL) << 8 | (long)byArray[n3 + 7] & 0xFFL;
    }

    private void convertLongToByteArray(long l3, byte[] byArray, int n3) {
        for (int i3 = 0; i3 < 8; ++i3) {
            int n4 = n3 + i3;
            byArray[n4] = (byte)(l3 >> 56 - i3 * 8 & 0xFFL);
        }
    }

    private void increment() {
        int n3 = 0;
        for (int i3 = this._bitCount.length - 1; i3 >= 0; --i3) {
            int n4 = (this._bitCount[i3] & 0xFF) + EIGHT[i3] + n3;
            n3 = n4 >>> 8;
            this._bitCount[i3] = (short)(n4 & 0xFF);
        }
    }

    private void finish() {
        int n3;
        WhirlpoolDigest whirlpoolDigest = object;
        byte[] byArray = whirlpoolDigest.copyBitLength();
        byte[] byArray2 = whirlpoolDigest._buffer;
        int n4 = whirlpoolDigest._bufferPos;
        ((WhirlpoolDigest)object)._bufferPos = n3 = n4 + 1;
        byArray2[n4] = (byte)(byArray2[n4] | 0x80);
        if (n3 == byArray2.length) {
            ((WhirlpoolDigest)object).processFilledBuffer(byArray2, 0);
        }
        if (((WhirlpoolDigest)object)._bufferPos > 32) {
            while (((WhirlpoolDigest)object)._bufferPos != 0) {
                ((WhirlpoolDigest)object).update((byte)0);
            }
        }
        while (((WhirlpoolDigest)object)._bufferPos <= 32) {
            ((WhirlpoolDigest)object).update((byte)0);
        }
        WhirlpoolDigest whirlpoolDigest2 = object;
        Object object = ((WhirlpoolDigest)object)._buffer;
        int n5 = byArray.length;
        System.arraycopy(byArray, 0, object, 32, n5);
        whirlpoolDigest2.processFilledBuffer(whirlpoolDigest2._buffer, 0);
    }

    private byte[] copyBitLength() {
        int n3 = 32;
        byte[] byArray = new byte[32];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray[i3] = (byte)(this._bitCount[i3] & 0xFF);
        }
        return byArray;
    }

    static {
        short[] sArray = new short[32];
        EIGHT = sArray;
        sArray[31] = 8;
    }

    @Override
    public String getAlgorithmName() {
        return "Whirlpool";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public int doFinal(byte[] byArray, int n3) {
        this.finish();
        for (int i3 = 0; i3 < 8; ++i3) {
            long l3 = this._hash[i3];
            int n4 = i3 * 8 + n3;
            this.convertLongToByteArray(l3, byArray, n4);
        }
        WhirlpoolDigest whirlpoolDigest = this;
        whirlpoolDigest.reset();
        return whirlpoolDigest.getDigestSize();
    }

    @Override
    public void reset() {
        WhirlpoolDigest whirlpoolDigest = this;
        whirlpoolDigest._bufferPos = 0;
        Arrays.fill(whirlpoolDigest._bitCount, (short)0);
        Arrays.fill(whirlpoolDigest._buffer, (byte)0);
        Arrays.fill(whirlpoolDigest._hash, 0L);
        Arrays.fill(whirlpoolDigest._K, 0L);
        Arrays.fill(whirlpoolDigest._L, 0L);
        Arrays.fill(whirlpoolDigest._block, 0L);
        Arrays.fill(whirlpoolDigest._state, 0L);
    }

    public void processBlock() {
        int n3;
        for (n3 = 0; n3 < 8; ++n3) {
            long l3;
            this._K[n3] = l3 = this._hash[n3];
            this._state[n3] = this._block[n3] ^ l3;
        }
        for (n3 = 1; n3 <= 10; ++n3) {
            long l4;
            long l5;
            long[] lArray;
            for (int i3 = 0; i3 < 8; ++i3) {
                long[] lArray2 = this._L;
                lArray2[i3] = 0L;
                lArray = this._K;
                l5 = C0[(int)(this._K[i3 - 0 & 7] >>> 56) & 0xFF];
                lArray2[i3] = l5 = 0L ^ l5;
                lArray2[i3] = l5 ^= C1[(int)(lArray[i3 - 1 & 7] >>> 48) & 0xFF];
                lArray2[i3] = l5 ^= C2[(int)(lArray[i3 - 2 & 7] >>> 40) & 0xFF];
                lArray2[i3] = l5 ^= C3[(int)(lArray[i3 - 3 & 7] >>> 32) & 0xFF];
                lArray2[i3] = l5 ^= C4[(int)(lArray[i3 - 4 & 7] >>> 24) & 0xFF];
                lArray2[i3] = l5 ^= C5[(int)(lArray[i3 - 5 & 7] >>> 16) & 0xFF];
                lArray2[i3] = l5 ^= C6[(int)(lArray[i3 - 6 & 7] >>> 8) & 0xFF];
                this._L[i3] = l5 ^ C7[(int)lArray[i3 - 7 & 7] & 0xFF];
            }
            WhirlpoolDigest whirlpoolDigest = this;
            long[] lArray3 = this._K;
            int n4 = this._K.length;
            System.arraycopy(whirlpoolDigest._L, 0, lArray3, 0, n4);
            whirlpoolDigest._K[0] = l4 = whirlpoolDigest._K[0] ^ this._rc[n3];
            for (int i4 = 0; i4 < 8; ++i4) {
                long l6;
                long[] lArray4 = this._L;
                lArray4[i4] = l6 = this._K[i4];
                lArray = this._state;
                lArray4[i4] = l5 = l6 ^ C0[(int)(this._state[i4 - 0 & 7] >>> 56) & 0xFF];
                lArray4[i4] = l5 ^= C1[(int)(lArray[i4 - 1 & 7] >>> 48) & 0xFF];
                lArray4[i4] = l5 ^= C2[(int)(lArray[i4 - 2 & 7] >>> 40) & 0xFF];
                lArray4[i4] = l5 ^= C3[(int)(lArray[i4 - 3 & 7] >>> 32) & 0xFF];
                lArray4[i4] = l5 ^= C4[(int)(lArray[i4 - 4 & 7] >>> 24) & 0xFF];
                lArray4[i4] = l5 ^= C5[(int)(lArray[i4 - 5 & 7] >>> 16) & 0xFF];
                lArray4[i4] = l5 ^= C6[(int)(lArray[i4 - 6 & 7] >>> 8) & 0xFF];
                this._L[i4] = l5 ^ C7[(int)lArray[i4 - 7 & 7] & 0xFF];
            }
            long[] lArray5 = this._state;
            int n5 = this._state.length;
            System.arraycopy(this._L, 0, lArray5, 0, n5);
        }
        for (n3 = 0; n3 < 8; ++n3) {
            this._hash[n3] = this._hash[n3] ^ (this._state[n3] ^ this._block[n3]);
        }
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this._buffer;
        int n3 = this._bufferPos;
        this._buffer[n3] = by;
        int n4 = n3 + 1;
        by = (byte)n4;
        this._bufferPos = by;
        if (n4 == byArray.length) {
            this.processFilledBuffer(byArray, 0);
        }
        this.increment();
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        while (n4 > 0) {
            this.update(byArray[n3]);
            ++n3;
            --n4;
        }
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    @Override
    public Memoable copy() {
        return new WhirlpoolDigest(this);
    }

    @Override
    public void reset(Memoable object) {
        object = (WhirlpoolDigest)object;
        Object[] objectArray = ((WhirlpoolDigest)object2)._rc;
        int n3 = ((WhirlpoolDigest)object2)._rc.length;
        System.arraycopy(((WhirlpoolDigest)object)._rc, 0, objectArray, 0, n3);
        objectArray = ((WhirlpoolDigest)object2)._buffer;
        n3 = ((WhirlpoolDigest)object2)._buffer.length;
        System.arraycopy(((WhirlpoolDigest)object)._buffer, 0, objectArray, 0, n3);
        ((WhirlpoolDigest)object2)._bufferPos = ((WhirlpoolDigest)object)._bufferPos;
        Memoable memoable = object;
        object = ((WhirlpoolDigest)object2)._bitCount;
        int n4 = ((WhirlpoolDigest)object2)._bitCount.length;
        System.arraycopy(((WhirlpoolDigest)memoable)._bitCount, 0, object, 0, n4);
        object = ((WhirlpoolDigest)object2)._hash;
        n4 = ((WhirlpoolDigest)object2)._hash.length;
        System.arraycopy(((WhirlpoolDigest)memoable)._hash, 0, object, 0, n4);
        object = ((WhirlpoolDigest)object2)._K;
        n4 = ((WhirlpoolDigest)object2)._K.length;
        System.arraycopy(((WhirlpoolDigest)memoable)._K, 0, object, 0, n4);
        object = ((WhirlpoolDigest)object2)._L;
        n4 = ((WhirlpoolDigest)object2)._L.length;
        System.arraycopy(((WhirlpoolDigest)memoable)._L, 0, object, 0, n4);
        object = ((WhirlpoolDigest)object2)._block;
        n4 = ((WhirlpoolDigest)object2)._block.length;
        System.arraycopy(((WhirlpoolDigest)memoable)._block, 0, object, 0, n4);
        Object object2 = ((WhirlpoolDigest)object2)._state;
        int n5 = ((WhirlpoolDigest)object2)._state.length;
        System.arraycopy(((WhirlpoolDigest)memoable)._state, 0, object2, 0, n5);
    }
}

