/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

public class ISO9796d1Encoding
implements AsymmetricBlockCipher {
    private static final BigInteger SIXTEEN = BigInteger.valueOf(16L);
    private static final BigInteger SIX = BigInteger.valueOf(6L);
    private static byte[] shadows = new byte[]{14, 3, 5, 8, 9, 4, 2, 15, 0, 13, 11, 6, 7, 10, 12, 1};
    private static byte[] inverse = new byte[]{8, 15, 6, 1, 5, 2, 11, 12, 3, 4, 13, 10, 14, 9, 0, 7};
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private int bitSize;
    private int padBits = 0;
    private BigInteger modulus;

    public ISO9796d1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
    }

    private byte[] encodeBlock(byte[] byArray, int n3, int n4) {
        int n5;
        int n6 = this.bitSize;
        int n7 = (n6 + 7) / 8;
        byte[] byArray2 = new byte[n7];
        int n8 = this.padBits + 1;
        int n9 = (n6 + 13) / 16;
        for (int i3 = 0; i3 < n9; i3 += n4) {
            if (i3 > n9 - n4) {
                int n10 = n9 - i3;
                int n11 = n3 + n4 - n10;
                int n12 = n7 - n9;
                System.arraycopy(byArray, n11, byArray2, n12, n10);
                continue;
            }
            System.arraycopy(byArray, n3, byArray2, n7 - (i3 + n4), n4);
        }
        for (n5 = n7 - n9 * 2; n5 != n7; n5 += 2) {
            n3 = n7 - n9;
            n3 = byArray2[n5 / 2 + n3];
            byte[] byArray3 = shadows;
            byArray2[n5] = (byte)(shadows[(n3 & 0xFF) >>> 4] << 4 | byArray3[n3 & 0xF]);
            byArray2[n5 + 1] = n3;
        }
        n5 = n7 - n4 * 2;
        byArray2[n5] = (byte)(byArray2[n5] ^ n8);
        n5 = n7 - 1;
        byArray2[n5] = (byte)(byArray2[n5] << 4 | 6);
        n5 = 8 - (this.bitSize - 1) % 8;
        n3 = 0;
        if (n5 != 8) {
            byte by = (byte)(byArray2[0] & 255 >>> n5);
            byArray2[0] = n4 = (int)by;
            byArray2[0] = (byte)(by | 128 >>> n5);
        } else {
            byte[] byArray4 = byArray2;
            byArray4[0] = 0;
            byArray2[1] = (byte)(byArray4[1] | 0x80);
            n3 = 1;
        }
        return this.engine.processBlock(byArray2, n3, n7 - n3);
    }

    private byte[] decodeBlock(byte[] object, int n3, int n4) {
        block8: {
            BigInteger bigInteger;
            block7: {
                BigInteger bigInteger2;
                ISO9796d1Encoding iSO9796d1Encoding = this;
                object = iSO9796d1Encoding.engine.processBlock((byte[])object, n3, n4);
                n3 = 1;
                n4 = (iSO9796d1Encoding.bitSize + 13) / 16;
                bigInteger = bigInteger2;
                bigInteger2 = new BigInteger(1, (byte[])object);
                BigInteger bigInteger3 = SIXTEEN;
                object = bigInteger3;
                BigInteger bigInteger4 = SIX;
                if (bigInteger2.mod(bigInteger3).equals(bigInteger4)) break block7;
                if (!this.modulus.subtract(bigInteger).mod((BigInteger)object).equals(bigInteger4)) break block8;
                bigInteger = this.modulus.subtract(bigInteger);
            }
            if (((object = ISO9796d1Encoding.convertOutputDecryptOnly(bigInteger))[((byte[])object).length - 1] & 0xF) == 6) {
                int n5;
                Object object2 = object;
                Object object3 = object;
                int n6 = ((byte[])object2).length - 1;
                object3[n6] = (byte)((object2[((byte[])object3).length - 1] & 0xFF) >>> 4 | inverse[(object[((byte[])object).length - 2] & 0xFF) >> 4] << 4);
                byte[] byArray = shadows;
                int n7 = object[1];
                object2[0] = (byte)(shadows[(n7 & 0xFF) >>> 4] << 4 | byArray[n7 & 0xF]);
                int n8 = 0;
                n7 = 0;
                for (n5 = ((byte[])(v649296)).length - 1; n5 >= ((byte[])object).length - n4 * 2; n5 -= 2) {
                    byte[] byArray2 = shadows;
                    int n9 = object[n5];
                    n9 = n5 - 1;
                    byte by = object[n9];
                    int n10 = shadows[(n9 & 0xFF) >>> 4] << 4 | byArray2[n9 & 0xF];
                    if (((by ^ n10) & 0xFF) == 0) continue;
                    if (n8 == 0) {
                        n3 = 1;
                        n8 = (by ^ n10) & 0xFF;
                        int n11 = n3;
                        n3 = n8;
                        n8 = n11;
                        n7 = n9;
                        continue;
                    }
                    throw new InvalidCipherTextException("invalid tsums in block");
                }
                object[n7] = 0;
                n4 = (((byte[])object).length - n7) / 2;
                byte[] byArray3 = new byte[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    byArray3[n5] = object[n5 * 2 + n7 + 1];
                }
                this.padBits = n3 - 1;
                return byArray3;
            }
            throw new InvalidCipherTextException("invalid forcing byte in block");
        }
        throw new InvalidCipherTextException("resulting integer iS or (modulus - iS) is not congruent to 6 mod 16");
    }

    private static byte[] convertOutputDecryptOnly(BigInteger object) {
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray[0] == 0) {
            int n3 = ((Object)object).length - 1;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(object, 1, byArray2, 0, n3);
            return byArray2;
        }
        return object;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = cipherParameters instanceof ParametersWithRandom ? (RSAKeyParameters)((ParametersWithRandom)cipherParameters).getParameters() : (RSAKeyParameters)cipherParameters;
        ISO9796d1Encoding iSO9796d1Encoding = bigInteger;
        ISO9796d1Encoding iSO9796d1Encoding2 = bigInteger;
        ((ISO9796d1Encoding)((Object)bigInteger)).engine.init(bl, cipherParameters);
        BigInteger bigInteger = rSAKeyParameters.getModulus();
        iSO9796d1Encoding2.modulus = bigInteger;
        iSO9796d1Encoding2.bitSize = bigInteger.bitLength();
        iSO9796d1Encoding.forEncryption = bl;
    }

    @Override
    public int getInputBlockSize() {
        ISO9796d1Encoding iSO9796d1Encoding = this;
        int n3 = iSO9796d1Encoding.engine.getInputBlockSize();
        if (iSO9796d1Encoding.forEncryption) {
            return (n3 + 1) / 2;
        }
        return n3;
    }

    @Override
    public int getOutputBlockSize() {
        ISO9796d1Encoding iSO9796d1Encoding = this;
        int n3 = iSO9796d1Encoding.engine.getOutputBlockSize();
        if (iSO9796d1Encoding.forEncryption) {
            return n3;
        }
        return (n3 + 1) / 2;
    }

    public void setPadBits(int n3) {
        if (n3 <= 7) {
            this.padBits = n3;
            return;
        }
        throw new IllegalArgumentException("padBits > 7");
    }

    public int getPadBits() {
        return this.padBits;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n3, int n4) {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n3, n4);
        }
        return this.decodeBlock(byArray, n3, n4);
    }
}

