/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        Digest digest2 = digest;
        this(asymmetricBlockCipher, digest2, digest2, byArray);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.mgf1Hash = digest2;
        this.defHash = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            int n3 = byArray.length;
            digest.update(byArray, 0, n3);
        }
        digest.doFinal(this.defHash, 0);
    }

    private void ItoOSP(int n3, byte[] byArray) {
        byArray[0] = (byte)(n3 >>> 24);
        byArray[1] = (byte)(n3 >>> 16);
        byArray[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)(n3 >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n3, int n4, int n5) {
        int n6;
        OAEPEncoding oAEPEncoding = this;
        byte[] byArray2 = new byte[n5];
        int n7 = oAEPEncoding.mgf1Hash.getDigestSize();
        byte[] byArray3 = new byte[n7];
        int n8 = 4;
        byte[] byArray4 = new byte[4];
        oAEPEncoding.mgf1Hash.reset();
        for (n6 = 0; n6 < n5 / n7; ++n6) {
            OAEPEncoding oAEPEncoding2 = this;
            oAEPEncoding2.ItoOSP(n6, byArray4);
            oAEPEncoding2.mgf1Hash.update(byArray, n3, n4);
            oAEPEncoding2.mgf1Hash.update(byArray4, 0, n8);
            oAEPEncoding2.mgf1Hash.doFinal(byArray3, 0);
            int n9 = n6 * n7;
            System.arraycopy(byArray3, 0, byArray2, n9, n7);
        }
        if ((n7 = n6 * n7) < n5) {
            OAEPEncoding oAEPEncoding3 = this;
            oAEPEncoding3.ItoOSP(n6, byArray4);
            oAEPEncoding3.mgf1Hash.update(byArray, n3, n4);
            oAEPEncoding3.mgf1Hash.update(byArray4, 0, n8);
            oAEPEncoding3.mgf1Hash.doFinal(byArray3, 0);
            int n10 = n5 - n7;
            System.arraycopy(byArray3, 0, byArray2, n7, n10);
        }
        return byArray2;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.random = cipherParameters instanceof ParametersWithRandom ? ((ParametersWithRandom)cipherParameters).getRandom() : CryptoServicesRegistrar.getSecureRandom();
        this.engine.init(bl, cipherParameters);
        this.forEncryption = bl;
    }

    @Override
    public int getInputBlockSize() {
        OAEPEncoding oAEPEncoding = this;
        int n3 = oAEPEncoding.engine.getInputBlockSize();
        if (oAEPEncoding.forEncryption) {
            return n3 - 1 - this.defHash.length * 2;
        }
        return n3;
    }

    @Override
    public int getOutputBlockSize() {
        OAEPEncoding oAEPEncoding = this;
        int n3 = oAEPEncoding.engine.getOutputBlockSize();
        if (oAEPEncoding.forEncryption) {
            return n3;
        }
        return n3 - 1 - this.defHash.length * 2;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n3, int n4) {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n3, n4);
        }
        return this.decodeBlock(byArray, n3, n4);
    }

    public byte[] encodeBlock(byte[] byArray, int n3, int n4) {
        if (n4 <= this.getInputBlockSize()) {
            OAEPEncoding oAEPEncoding = this;
            int n5 = oAEPEncoding.getInputBlockSize() + 1;
            n5 = oAEPEncoding.defHash.length * 2 + n5;
            OAEPEncoding oAEPEncoding2 = this;
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = byArray2;
            int n6 = n5 - n4;
            System.arraycopy(byArray, n3, byArray3, n6, n4);
            byArray2[n6 - 1] = 1;
            int n7 = oAEPEncoding2.defHash.length;
            n3 = oAEPEncoding2.defHash.length;
            System.arraycopy(oAEPEncoding2.defHash, 0, byArray3, n7, n3);
            n7 = oAEPEncoding2.defHash.length;
            byte[] byArray4 = new byte[n7];
            oAEPEncoding2.random.nextBytes(byArray4);
            n4 = n5 - oAEPEncoding2.defHash.length;
            byte[] byArray5 = oAEPEncoding.maskGeneratorFunction1(byArray4, 0, n7, n4);
            for (n4 = (v649932).defHash.length; n4 != n5; ++n4) {
                byArray3[n4] = (byte)(byArray3[n4] ^ byArray5[n4 - this.defHash.length]);
            }
            int n8 = this.defHash.length;
            System.arraycopy(byArray4, 0, byArray3, 0, n8);
            n8 = this.defHash.length;
            int n9 = n5 - this.defHash.length;
            n4 = this.defHash.length;
            byte[] byArray6 = this.maskGeneratorFunction1(byArray3, n8, n9, n4);
            for (n9 = 0; n9 != this.defHash.length; ++n9) {
                byArray3[n9] = (byte)(byArray3[n9] ^ byArray6[n9]);
            }
            return this.engine.processBlock(byArray3, 0, n5);
        }
        throw new DataLengthException("input data too long");
    }

    public byte[] decodeBlock(byte[] byArray, int n3, int n4) {
        int n5;
        byte[] byArray2;
        int n6;
        OAEPEncoding oAEPEncoding = this;
        byArray = oAEPEncoding.engine.processBlock(byArray, n3, n4);
        n3 = oAEPEncoding.engine.getOutputBlockSize();
        byte[] byArray3 = new byte[n3];
        int n7 = n3 < this.defHash.length * 2 + 1 ? 1 : 0;
        if (byArray.length <= n3) {
            int n8 = n3 - byArray.length;
            n6 = byArray.length;
            System.arraycopy(byArray, 0, byArray3, n8, n6);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, n3);
            n7 = 1;
        }
        int n9 = this.defHash.length;
        n6 = n3 - this.defHash.length;
        int n10 = this.defHash.length;
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, n9, n6, n10);
        n6 = 0;
        while (true) {
            byArray2 = this.defHash;
            if (n6 == this.defHash.length) break;
            byArray3[n6] = (byte)(byArray3[n6] ^ byArray4[n6]);
            ++n6;
        }
        int n11 = byArray2.length;
        n6 = n3 - byArray2.length;
        byte[] byArray5 = this.maskGeneratorFunction1(byArray3, 0, n11, n6);
        for (n6 = (v650147).defHash.length; n6 != n3; ++n6) {
            byArray3[n6] = (byte)(byArray3[n6] ^ byArray5[n6 - this.defHash.length]);
        }
        int n12 = 0;
        n6 = 0;
        while (true) {
            byArray2 = this.defHash;
            if (n6 == this.defHash.length) break;
            if (byArray2[n6] != byArray3[byArray2.length + n6]) {
                n12 = 1;
            }
            ++n6;
        }
        n6 = n3;
        for (n5 = byArray2.length * 2; n5 != n3; ++n5) {
            boolean bl;
            boolean bl2 = byArray3[n5] != 0;
            if (!(bl2 & (bl = n6 == n3))) continue;
            n6 = n5;
        }
        n5 = n6 > n3 - 1 ? 1 : 0;
        int n13 = byArray3[n6] != 1 ? 1 : 0;
        int n14 = n12;
        n12 = n6 + 1;
        if ((n14 | n7 | (n5 |= n13)) == 0) {
            n5 = n3 - n12;
            byte[] byArray6 = new byte[n5];
            System.arraycopy(byArray3, n12, byArray6, 0, n5);
            return byArray6;
        }
        Arrays.fill(byArray3, (byte)0);
        throw new InvalidCipherTextException("data wrong");
    }
}

