/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.fis.ekyc.nfc.build_in.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "com.fis.ekyc.nfc.build_in.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private int pLen = -1;
    private byte[] fallback = null;
    private byte[] blockBuffer;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, int n3) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.pLen = n3;
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.fallback = byArray;
        this.pLen = byArray.length;
    }

    private boolean useStrict() {
        if (Properties.isOverrideSetTo(NOT_STRICT_LENGTH_ENABLED_PROPERTY, true)) {
            return false;
        }
        return Properties.isOverrideSetTo(STRICT_LENGTH_ENABLED_PROPERTY, false) ^ true;
    }

    private byte[] encodeBlock(byte[] byArray, int n3, int n4) {
        if (n4 <= this.getInputBlockSize()) {
            PKCS1Encoding pKCS1Encoding = this;
            int n5 = pKCS1Encoding.engine.getInputBlockSize();
            byte[] byArray2 = new byte[n5];
            if (pKCS1Encoding.forPrivateKey) {
                byArray2[0] = 1;
                for (int i3 = 1; i3 != n5 - n4 - 1; ++i3) {
                    byArray2[i3] = -1;
                }
            } else {
                this.random.nextBytes(byArray2);
                byArray2[0] = 2;
                for (int i4 = 1; i4 != n5 - n4 - 1; ++i4) {
                    while (byArray2[i4] == 0) {
                        byArray2[i4] = (byte)this.random.nextInt();
                    }
                }
            }
            int n6 = n5 - n4;
            byArray2[n6 - 1] = 0;
            System.arraycopy(byArray, n3, byArray2, n6, n4);
            return this.engine.processBlock(byArray2, 0, n5);
        }
        throw new IllegalArgumentException("input data too large");
    }

    private static int checkPkcs1Encoding(byte[] byArray, int n3) {
        int n4 = byArray[0] ^ 2 | 0;
        int n5 = byArray.length - ++n3;
        for (int i3 = 1; i3 < n5; ++i3) {
            byte by = byArray[i3];
            int n6 = by | by >> 1;
            int n7 = n6 | n6 >> 2;
            n4 |= ((n7 | n7 >> 4) & 1) - 1;
        }
        int n8 = n4 | byArray[byArray.length - n3];
        int n9 = n8 | n8 >> 1;
        int n10 = n9 | n9 >> 2;
        return ~(((n10 | n10 >> 4) & 1) - 1);
    }

    private byte[] decodeBlockOrRandom(byte[] byArray, int n3, int n4) {
        if (this.forPrivateKey) {
            int n5;
            int n6;
            PKCS1Encoding pKCS1Encoding = this;
            byArray = pKCS1Encoding.engine.processBlock(byArray, n3, n4);
            byte[] byArray2 = pKCS1Encoding.fallback;
            if (pKCS1Encoding.fallback == null) {
                PKCS1Encoding pKCS1Encoding2 = this;
                byArray2 = new byte[pKCS1Encoding2.pLen];
                pKCS1Encoding2.random.nextBytes(byArray2);
            }
            if (((n4 = (int)(this.useStrictLength ? 1 : 0)) & (n6 = byArray.length != this.engine.getOutputBlockSize() ? 1 : 0)) != 0) {
                byArray = this.blockBuffer;
            }
            n4 = PKCS1Encoding.checkPkcs1Encoding(byArray, this.pLen);
            byte[] byArray3 = new byte[this.pLen];
            for (int i3 = 0; i3 < (n5 = this.pLen); ++i3) {
                byArray3[i3] = (byte)(byArray[byArray.length - n5 + i3] & ~n4 | byArray2[i3] & n4);
            }
            Arrays.fill(byArray, (byte)0);
            return byArray3;
        }
        throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
    }

    /*
     * Enabled aggressive block sorting
     */
    private byte[] decodeBlock(byte[] byArray, int n3, int n4) {
        int n5;
        if (this.pLen != -1) {
            return this.decodeBlockOrRandom(byArray, n3, n4);
        }
        PKCS1Encoding pKCS1Encoding = this;
        byArray = pKCS1Encoding.engine.processBlock(byArray, n3, n4);
        n3 = pKCS1Encoding.useStrictLength ? 1 : 0;
        n4 = byArray.length != this.engine.getOutputBlockSize() ? 1 : 0;
        n3 &= n4;
        if (byArray.length < this.getOutputBlockSize()) {
            byArray = this.blockBuffer;
        }
        n4 = byArray[0];
        int n6 = (this.forPrivateKey ? n4 != 2 : n4 != 1) ? 1 : 0;
        if ((n6 | (n4 = (n5 = this.findStart((byte)n4, byArray) + 1) < 10 ? 1 : 0)) != 0) {
            Arrays.fill(byArray, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (n3 == 0) {
            n3 = byArray.length - n5;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n5, byArray2, 0, n3);
            return byArray2;
        }
        Arrays.fill(byArray, (byte)0);
        throw new InvalidCipherTextException("block incorrect size");
    }

    private int findStart(byte by, byte[] byArray) {
        int n3 = -1;
        int n4 = 0;
        for (int i3 = 1; i3 != byArray.length; ++i3) {
            byte by2;
            byte by3 = byArray[i3];
            byte by4 = by3 == 0 ? (byte)1 : 0;
            if (by4 & (by2 = n3 < 0 ? (byte)1 : 0)) {
                n3 = i3;
            }
            by4 = by == 1 ? (byte)1 : 0;
            by2 = n3 < 0 ? (byte)1 : 0;
            byte by5 = by3;
            by3 = by4 & by2;
            by4 = by5 != -1 ? (byte)1 : 0;
            n4 |= by3 & by4;
        }
        if (n4 != 0) {
            return -1;
        }
        return n3;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)cipherParameters;
            this.random = ((ParametersWithRandom)cipherParameters2).getRandom();
            cipherParameters2 = (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters2).getParameters();
        } else {
            cipherParameters2 = (AsymmetricKeyParameter)cipherParameters;
            if (!((AsymmetricKeyParameter)cipherParameters2).isPrivate() && bl) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        PKCS1Encoding pKCS1Encoding = this;
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = ((AsymmetricKeyParameter)cipherParameters2).isPrivate();
        pKCS1Encoding.forEncryption = bl;
        pKCS1Encoding.blockBuffer = new byte[pKCS1Encoding.engine.getOutputBlockSize()];
        if (pKCS1Encoding.pLen > 0 && this.fallback == null && this.random == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    @Override
    public int getInputBlockSize() {
        PKCS1Encoding pKCS1Encoding = this;
        int n3 = pKCS1Encoding.engine.getInputBlockSize();
        if (pKCS1Encoding.forEncryption) {
            return n3 - 10;
        }
        return n3;
    }

    @Override
    public int getOutputBlockSize() {
        PKCS1Encoding pKCS1Encoding = this;
        int n3 = pKCS1Encoding.engine.getOutputBlockSize();
        if (pKCS1Encoding.forEncryption) {
            return n3;
        }
        return n3 - 10;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n3, int n4) {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n3, n4);
        }
        return this.decodeBlock(byArray, n3, n4);
    }
}

