/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class AESLightEngine
implements BlockCipher {
    private static final byte[] S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final int[] rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    private static final int m1 = -2139062144;
    private static final int m2 = 0x7F7F7F7F;
    private static final int m3 = 27;
    private static final int m4 = -1061109568;
    private static final int m5 = 0x3F3F3F3F;
    private static final int BLOCK_SIZE = 16;
    private int ROUNDS;
    private int[][] WorkingKey = null;
    private int C0;
    private int C1;
    private int C2;
    private int C3;
    private boolean forEncryption;

    private static int shift(int n3, int n4) {
        return n3 >>> n4 | n3 << -n4;
    }

    private static int FFmulX(int n3) {
        return (n3 & 0x7F7F7F7F) << 1 ^ ((n3 & 0x80808080) >>> 7) * 27;
    }

    private static int FFmulX2(int n3) {
        int n4 = (n3 & 0x3F3F3F3F) << 2;
        int n5 = n3 & 0xC0C0C0C0;
        n3 = n5 ^ n5 >>> 1;
        return n4 ^ n3 >>> 2 ^ n3 >>> 5;
    }

    private static int mcol(int n3) {
        int n4 = n3;
        n3 = AESLightEngine.shift(n4, 8);
        int n5 = n4 ^ n3;
        return AESLightEngine.shift(n5, 16) ^ n3 ^ AESLightEngine.FFmulX(n5);
    }

    private static int inv_mcol(int n3) {
        int n4 = n3;
        n3 = n4 ^ AESLightEngine.shift(n4, 8);
        int n5 = n4 ^ AESLightEngine.FFmulX(n3);
        int n6 = n3 ^ AESLightEngine.FFmulX2(n5);
        return n5 ^ (n6 ^ AESLightEngine.shift(n6, 16));
    }

    private static int subWord(int n3) {
        byte[] byArray = S;
        return S[n3 & 0xFF] & 0xFF | (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 | (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 | byArray[n3 >> 24 & 0xFF] << 24;
    }

    private int[][] generateWorkingKey(byte[] byArray, boolean n3) {
        int n4 = byArray.length;
        if (n4 >= 16 && n4 <= 32 && (n4 & 7) == 0) {
            int n5;
            int[][] nArray;
            block12: {
                int n6;
                int n7;
                int n8;
                this.ROUNDS = (n4 >>>= 2) + 6;
                nArray = new int[this.ROUNDS + 1][4];
                if (n4 != 4) {
                    int n9;
                    int n10;
                    if (n4 != 6) {
                        if (n4 == 8) {
                            int n11;
                            nArray[0][0] = n5 = Pack.littleEndianToInt(byArray, 0);
                            nArray[0][1] = n4 = Pack.littleEndianToInt(byArray, 4);
                            nArray[0][2] = n8 = Pack.littleEndianToInt(byArray, 8);
                            nArray[0][3] = n7 = Pack.littleEndianToInt(byArray, 12);
                            nArray[1][0] = n6 = Pack.littleEndianToInt(byArray, 16);
                            nArray[1][1] = n11 = Pack.littleEndianToInt(byArray, 20);
                            nArray[1][2] = n10 = Pack.littleEndianToInt(byArray, 24);
                            nArray[1][3] = n9 = Pack.littleEndianToInt(byArray, 28);
                            int n12 = 2;
                            int n13 = 1;
                            while (true) {
                                int n14 = n5;
                                n5 = AESLightEngine.subWord(AESLightEngine.shift(n9, 8)) ^ n13;
                                n13 <<= 1;
                                n5 = n14 ^ n5;
                                int[] nArray2 = nArray[n12];
                                int[] nArray3 = nArray2;
                                nArray3[0] = n5;
                                nArray3[1] = n4 ^= n5;
                                nArray3[2] = n8 ^= n4;
                                nArray2[3] = n7 ^= n8;
                                if (++n12 < 15) {
                                    int[] nArray4 = nArray[n12];
                                    nArray3 = nArray4;
                                    nArray3[0] = n6 ^= AESLightEngine.subWord(n7);
                                    nArray3[1] = n11 ^= n6;
                                    nArray3[2] = n10 ^= n11;
                                    nArray4[3] = n9 ^= n10;
                                    ++n12;
                                    continue;
                                }
                                break block12;
                                break;
                            }
                        }
                        throw new IllegalStateException("Should never get here");
                    }
                    nArray[0][0] = n5 = Pack.littleEndianToInt(byArray, 0);
                    nArray[0][1] = n4 = Pack.littleEndianToInt(byArray, 4);
                    nArray[0][2] = n8 = Pack.littleEndianToInt(byArray, 8);
                    nArray[0][3] = n7 = Pack.littleEndianToInt(byArray, 12);
                    n6 = Pack.littleEndianToInt(byArray, 16);
                    int n15 = Pack.littleEndianToInt(byArray, 20);
                    n10 = 1;
                    n9 = 1;
                    while (true) {
                        int n16 = n5;
                        int[] nArray5 = nArray[n10];
                        nArray5[0] = n6;
                        nArray5[1] = n15;
                        n5 = AESLightEngine.subWord(AESLightEngine.shift(n15, 8)) ^ n9;
                        n9 <<= 1;
                        int n17 = n16 ^ n5;
                        n5 = n17;
                        int[] nArray6 = nArray[n10];
                        int[] nArray7 = nArray6;
                        nArray7[2] = n5;
                        nArray6[3] = n5 = n4 ^ n5;
                        n4 = n8 ^ n5;
                        int[] nArray8 = nArray[n10 + 1];
                        nArray7 = nArray8;
                        nArray7[0] = n4;
                        nArray7[1] = n7 ^= n4;
                        nArray8[2] = n6 ^= n7;
                        nArray7[3] = n15 ^= n6;
                        n8 = AESLightEngine.subWord(AESLightEngine.shift(n15, 8)) ^ n9;
                        n9 <<= 1;
                        n8 = n17 ^ n8;
                        int[] nArray9 = nArray[n10 + 2];
                        int[] nArray10 = nArray9;
                        int n18 = n4;
                        nArray10[0] = n8;
                        nArray10[1] = n4 = n5 ^ n8;
                        nArray10[2] = n5 = n18 ^ n4;
                        nArray9[3] = n7 ^= n5;
                        if ((n10 += 3) < 13) {
                            n15 ^= (n6 ^= n7);
                            int n19 = n8;
                            n8 = n5;
                            n5 = n19;
                            continue;
                        }
                        break block12;
                        break;
                    }
                }
                nArray[0][0] = n5 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n4 = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n8 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n7 = Pack.littleEndianToInt(byArray, 12);
                for (n6 = 1; n6 <= 10; ++n6) {
                    int[] nArray11 = nArray[n6];
                    int[] nArray12 = nArray11;
                    nArray12[0] = n5 ^= AESLightEngine.subWord(AESLightEngine.shift(n7, 8)) ^ rcon[n6 - 1];
                    nArray12[1] = n4 ^= n5;
                    nArray12[2] = n8 ^= n4;
                    nArray11[3] = n7 ^= n8;
                }
            }
            if (n3 == 0) {
                for (n5 = 1; n5 < this.ROUNDS; ++n5) {
                    for (n3 = 0; n3 < 4; ++n3) {
                        int[] nArray13 = nArray[n5];
                        nArray13[n3] = AESLightEngine.inv_mcol(nArray13[n3]);
                    }
                }
            }
            return nArray;
        }
        throw new IllegalArgumentException("Key length not 128/192/256 bits.");
    }

    private void unpackBlock(byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n4 + 1;
        this.C0 = byArray[n4] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5++] << 24;
        this.C1 = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5++] << 24;
        this.C2 = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5++] << 24;
        this.C3 = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5] << 24;
    }

    private void packBlock(byte[] byArray, int n3) {
        int n4 = n3 + 1;
        int n5 = this.C0;
        byArray[n3] = (byte)n5;
        byArray[n4++] = (byte)(n5 >> 8);
        n3 = n4 + 1;
        byArray[n4] = (byte)(n5 >> 16);
        n4 = n3 + 1;
        byArray[n3] = (byte)(n5 >> 24);
        n3 = n4 + 1;
        n5 = this.C1;
        byArray[n4] = (byte)n5;
        n4 = n3 + 1;
        byArray[n3] = (byte)(n5 >> 8);
        n3 = n4 + 1;
        byArray[n4] = (byte)(n5 >> 16);
        n4 = n3 + 1;
        byArray[n3] = (byte)(n5 >> 24);
        n3 = n4 + 1;
        n5 = this.C2;
        byArray[n4] = (byte)n5;
        n4 = n3 + 1;
        byArray[n3] = (byte)(n5 >> 8);
        n3 = n4 + 1;
        byArray[n4] = (byte)(n5 >> 16);
        n4 = n3 + 1;
        byArray[n3] = (byte)(n5 >> 24);
        n3 = n4 + 1;
        n5 = this.C3;
        byArray[n4] = (byte)n5;
        n4 = n3 + 1;
        byArray[n3] = (byte)(n5 >> 8);
        int n6 = n4 + 1;
        byArray[n4] = (byte)(n5 >> 16);
        byArray[n6] = (byte)(n5 >> 24);
    }

    private void encryptBlock(int[][] nArray) {
        int n3;
        int n4;
        byte[] byArray;
        AESLightEngine aESLightEngine = object;
        int[] nArray2 = nArray[0];
        int n5 = aESLightEngine.C0 ^ nArray2[0];
        int n6 = aESLightEngine.C1 ^ nArray2[1];
        int n7 = aESLightEngine.C2 ^ nArray2[2];
        int n8 = 1;
        int n9 = aESLightEngine.C3 ^ nArray2[3];
        while (n8 < ((AESLightEngine)object).ROUNDS - 1) {
            byArray = S;
            int n10 = n9;
            n4 = AESLightEngine.mcol(byArray[n5 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
            n3 = AESLightEngine.mcol(byArray[n6 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
            n9 = AESLightEngine.mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
            int n11 = AESLightEngine.mcol(byArray[n10 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24);
            int n12 = n8;
            n5 = n12 + 1;
            int n13 = n11 ^ nArray[n12][3];
            n6 = n13;
            n7 = AESLightEngine.mcol(byArray[n4 & 0xFF] & 0xFF ^ (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24) ^ nArray[n5][0];
            n8 = AESLightEngine.mcol(byArray[n3 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
            n6 = AESLightEngine.mcol(byArray[n9 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n3 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
            int n14 = AESLightEngine.mcol(S[n13 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24);
            int n15 = n5;
            n9 = n15 + 1;
            n5 = n14 ^ nArray[n15][3];
            int n16 = n9;
            int n17 = n7;
            n9 = n5;
            n7 = n6;
            n6 = n8;
            n5 = n17;
            n8 = n16;
        }
        AESLightEngine aESLightEngine2 = object;
        byArray = S;
        int n18 = n9;
        n4 = AESLightEngine.mcol(byArray[n5 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
        n3 = AESLightEngine.mcol(byArray[n6 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
        n9 = AESLightEngine.mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
        int n19 = AESLightEngine.mcol(byArray[n18 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24);
        int n20 = n8;
        n5 = n20 + 1;
        n6 = n19 ^ nArray[n20][3];
        AESLightEngine aESLightEngine3 = object;
        AESLightEngine aESLightEngine4 = object;
        AESLightEngine aESLightEngine5 = object;
        int[] nArray3 = nArray[n5];
        Object object = nArray3;
        aESLightEngine5.C0 = byArray[n4 & 0xFF] & 0xFF ^ (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24 ^ nArray3[0];
        aESLightEngine4.C1 = byArray[n3 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24 ^ object[1];
        aESLightEngine3.C2 = byArray[n9 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n3 >> 24 & 0xFF] << 24 ^ object[2];
        aESLightEngine2.C3 = S[n6 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24 ^ object[3];
    }

    private void decryptBlock(int[][] nArray) {
        int n3;
        int n4;
        byte[] byArray;
        AESLightEngine aESLightEngine = object;
        int n5 = aESLightEngine.C0;
        int n6 = aESLightEngine.ROUNDS;
        int n7 = n6;
        AESLightEngine aESLightEngine2 = object;
        int[] nArray2 = nArray[n7];
        n7 = n5 ^ nArray2[0];
        int n8 = aESLightEngine2.C1 ^ nArray2[1];
        int n9 = aESLightEngine2.C2 ^ nArray2[2];
        int n10 = n6 - 1;
        int n11 = aESLightEngine.C3 ^ nArray2[3];
        while (n10 > 1) {
            byArray = Si;
            int n12 = n11;
            n4 = AESLightEngine.inv_mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n11 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n8 >> 24 & 0xFF] << 24) ^ nArray[n10][0];
            n3 = AESLightEngine.inv_mcol(byArray[n8 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n11 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n10][1];
            n11 = AESLightEngine.inv_mcol(byArray[n9 & 0xFF] & 0xFF ^ (byArray[n8 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n11 >> 24 & 0xFF] << 24) ^ nArray[n10][2];
            int n13 = AESLightEngine.inv_mcol(byArray[n12 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n8 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24);
            int n14 = n10;
            n7 = n14 + -1;
            int n15 = n13 ^ nArray[n14][3];
            n8 = n15;
            n9 = AESLightEngine.inv_mcol(byArray[n4 & 0xFF] & 0xFF ^ (byArray[n8 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n11 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n3 >> 24 & 0xFF] << 24) ^ nArray[n7][0];
            n10 = AESLightEngine.inv_mcol(byArray[n3 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n8 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n11 >> 24 & 0xFF] << 24) ^ nArray[n7][1];
            n8 = AESLightEngine.inv_mcol(byArray[n11 & 0xFF] & 0xFF ^ (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n8 >> 24 & 0xFF] << 24) ^ nArray[n7][2];
            int n16 = AESLightEngine.inv_mcol(Si[n15 & 0xFF] & 0xFF ^ (byArray[n11 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24);
            int n17 = n7;
            n11 = n17 + -1;
            n7 = n16 ^ nArray[n17][3];
            int n18 = n11;
            int n19 = n9;
            int n20 = n8;
            n8 = n10;
            n9 = n20;
            n11 = n7;
            n7 = n19;
            n10 = n18;
        }
        AESLightEngine aESLightEngine3 = object;
        byArray = Si;
        int n21 = n11;
        n4 = AESLightEngine.inv_mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n11 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n8 >> 24 & 0xFF] << 24) ^ nArray[n10][0];
        n3 = AESLightEngine.inv_mcol(byArray[n8 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n11 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n10][1];
        n11 = AESLightEngine.inv_mcol(byArray[n9 & 0xFF] & 0xFF ^ (byArray[n8 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n11 >> 24 & 0xFF] << 24) ^ nArray[n10][2];
        n7 = AESLightEngine.inv_mcol(byArray[n21 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n8 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24) ^ nArray[n10][3];
        AESLightEngine aESLightEngine4 = object;
        AESLightEngine aESLightEngine5 = object;
        AESLightEngine aESLightEngine6 = object;
        int[] nArray3 = nArray[0];
        Object object = nArray3;
        aESLightEngine6.C0 = byArray[n4 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n11 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n3 >> 24 & 0xFF] << 24 ^ nArray3[0];
        aESLightEngine5.C1 = byArray[n3 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n11 >> 24 & 0xFF] << 24 ^ object[1];
        aESLightEngine4.C2 = byArray[n11 & 0xFF] & 0xFF ^ (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24 ^ object[2];
        aESLightEngine3.C3 = Si[n7 & 0xFF] & 0xFF ^ (byArray[n11 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24 ^ object[3];
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.WorkingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey(), bl);
            this.forEncryption = bl;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to AES init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.WorkingKey != null) {
            if (n3 + 16 <= byArray.length) {
                if (n4 + 16 <= byArray2.length) {
                    if (this.forEncryption) {
                        AESLightEngine aESLightEngine = this;
                        aESLightEngine.unpackBlock(byArray, n3);
                        aESLightEngine.encryptBlock(aESLightEngine.WorkingKey);
                        this.packBlock(byArray2, n4);
                    } else {
                        AESLightEngine aESLightEngine = this;
                        aESLightEngine.unpackBlock(byArray, n3);
                        aESLightEngine.decryptBlock(aESLightEngine.WorkingKey);
                        this.packBlock(byArray2, n4);
                    }
                    return 16;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("AES engine not initialised");
    }

    @Override
    public void reset() {
    }
}

