/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.ChaChaEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Salsa20Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class ChaCha7539Engine
extends Salsa20Engine {
    @Override
    public String getAlgorithmName() {
        return "ChaCha7539";
    }

    @Override
    public int getNonceSize() {
        return 12;
    }

    @Override
    public void advanceCounter(long l3) {
        int n3 = (int)l3;
        if ((int)(l3 >>> 32) <= 0) {
            Object object = ((Salsa20Engine)object).engineState;
            int n4 = ((Salsa20Engine)object).engineState[12];
            int n5 = n4 + n3;
            object[12] = n5;
            if (n4 != 0 && n5 < n4) {
                throw new IllegalStateException("attempt to increase counter past 2^32.");
            }
            return;
        }
        throw new IllegalStateException("attempt to increase counter past 2^32.");
    }

    @Override
    public void advanceCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        int n3 = ((Salsa20Engine)object).engineState[12] + 1;
        object[12] = n3;
        if (n3 != 0) {
            return;
        }
        throw new IllegalStateException("attempt to increase counter past 2^32.");
    }

    @Override
    public void retreatCounter(long l3) {
        int n3 = (int)l3;
        if ((int)(l3 >>> 32) == 0) {
            Object object = ((Salsa20Engine)object).engineState;
            int n4 = ((Salsa20Engine)object).engineState[12];
            if (((long)n4 & 0xFFFFFFFFL) >= ((long)n3 & 0xFFFFFFFFL)) {
                object[12] = n4 - n3;
                return;
            }
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        throw new IllegalStateException("attempt to reduce counter past zero.");
    }

    @Override
    public void retreatCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        int n3 = ((Salsa20Engine)object).engineState[12];
        if (n3 != 0) {
            object[12] = n3 - 1;
            return;
        }
        throw new IllegalStateException("attempt to reduce counter past zero.");
    }

    @Override
    public long getCounter() {
        return (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    @Override
    public void resetCounter() {
        this.engineState[12] = 0;
    }

    @Override
    public void setKey(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            if (byArray.length == 32) {
                ChaCha7539Engine chaCha7539Engine = this;
                int n3 = byArray.length;
                chaCha7539Engine.packTauOrSigma(n3, chaCha7539Engine.engineState, 0);
                Pack.littleEndianToInt(byArray, 0, chaCha7539Engine.engineState, 4, 8);
            } else {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 256 bit key");
            }
        }
        Pack.littleEndianToInt(byArray2, 0, this.engineState, 13, 3);
    }

    @Override
    public void generateKeyStream(byte[] byArray) {
        ChaCha7539Engine chaCha7539Engine = object;
        ChaCha7539Engine chaCha7539Engine2 = object;
        Object object = chaCha7539Engine2.engineState;
        ChaChaEngine.chachaCore(chaCha7539Engine.rounds, (int[])object, chaCha7539Engine2.x);
        Pack.intToLittleEndian(chaCha7539Engine.x, byArray, 0);
    }
}

