/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESedeEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DESedeWrapEngine
implements Wrapper {
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private CBCBlockCipher engine;
    private KeyParameter param;
    private ParametersWithIV paramPlusIV;
    private byte[] iv;
    private boolean forWrapping;
    public Digest sha1 = DigestFactory.createSHA1();
    public byte[] digest = new byte[20];

    private byte[] calculateCMSKeyChecksum(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        DESedeWrapEngine dESedeWrapEngine = this;
        dESedeWrapEngine.sha1.update(byArray, 0, byArray.length);
        dESedeWrapEngine.sha1.doFinal(this.digest, 0);
        System.arraycopy(dESedeWrapEngine.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean checkCMSKeyChecksum(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.calculateCMSKeyChecksum(byArray), byArray2);
    }

    private static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray2[n3++] = byArray[byArray.length - n3];
        }
        return byArray2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        Object object2;
        DESedeWrapEngine dESedeWrapEngine = object;
        dESedeWrapEngine.forWrapping = bl;
        dESedeWrapEngine.engine = new CBCBlockCipher(new DESedeEngine());
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = parametersWithRandom.getParameters();
            object2 = parametersWithRandom.getRandom();
        } else {
            object2 = CryptoServicesRegistrar.getSecureRandom();
        }
        if (cipherParameters instanceof KeyParameter) {
            ((DESedeWrapEngine)object).param = (KeyParameter)cipherParameters;
            if (((DESedeWrapEngine)object).forWrapping) {
                ParametersWithIV parametersWithIV;
                DESedeWrapEngine dESedeWrapEngine2 = object;
                SecureRandom secureRandom = object2;
                byte[] byArray = new byte[8];
                object2 = byArray;
                ((DESedeWrapEngine)object).iv = byArray;
                secureRandom.nextBytes((byte[])object2);
                object2 = parametersWithIV;
                DESedeWrapEngine dESedeWrapEngine3 = object;
                object = dESedeWrapEngine3.param;
                parametersWithIV = new ParametersWithIV((CipherParameters)object, dESedeWrapEngine3.iv);
                dESedeWrapEngine2.paramPlusIV = object2;
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            DESedeWrapEngine dESedeWrapEngine4 = object;
            object2 = (ParametersWithIV)cipherParameters;
            dESedeWrapEngine4.paramPlusIV = object2;
            dESedeWrapEngine4.iv = ((ParametersWithIV)object2).getIV();
            dESedeWrapEngine4.param = (KeyParameter)dESedeWrapEngine4.paramPlusIV.getParameters();
            if (dESedeWrapEngine4.forWrapping) {
                object = ((DESedeWrapEngine)object).iv;
                if (((DESedeWrapEngine)object).iv == null || ((Object)object).length != 8) {
                    throw new IllegalArgumentException("IV is not 8 octets");
                }
            } else {
                throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n3, int n4) {
        if (this.forWrapping) {
            byte[] byArray2 = byArray;
            byArray = new byte[n4];
            System.arraycopy(byArray2, n3, byArray, 0, n4);
            byte[] byArray3 = this.calculateCMSKeyChecksum(byArray);
            int n5 = n4 + byArray3.length;
            byte[] byArray4 = byArray;
            byArray = new byte[n5];
            System.arraycopy(byArray4, 0, byArray, 0, n4);
            int n6 = byArray3.length;
            System.arraycopy(byArray3, 0, byArray, n4, n6);
            n6 = this.engine.getBlockSize();
            if (n5 % n6 == 0) {
                ParametersWithIV parametersWithIV;
                this.engine.init(true, this.paramPlusIV);
                Object object = new byte[n5];
                for (int i3 = 0; i3 != n5; i3 += n6) {
                    this.engine.processBlock(byArray, i3, (byte[])object, i3);
                }
                DESedeWrapEngine dESedeWrapEngine = this;
                byArray = dESedeWrapEngine.iv;
                byte[] byArray5 = new byte[dESedeWrapEngine.iv.length + n5];
                int n7 = byArray.length;
                System.arraycopy(byArray, 0, byArray5, 0, n7);
                n7 = this.iv.length;
                System.arraycopy(object, 0, byArray5, n7, n5);
                byte[] byArray6 = DESedeWrapEngine.reverse(byArray5);
                object = parametersWithIV;
                parametersWithIV = new ParametersWithIV(this.param, IV2);
                dESedeWrapEngine.engine.init(true, (CipherParameters)object);
                for (int i4 = 0; i4 != byArray6.length; i4 += n6) {
                    this.engine.processBlock(byArray6, i4, byArray6, i4);
                }
                return byArray6;
            }
            throw new IllegalStateException("Not multiple of block length");
        }
        throw new IllegalStateException("Not initialized for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n3, int n4) {
        if (!this.forWrapping) {
            if (byArray != null) {
                int n5 = this.engine.getBlockSize();
                if (n4 % n5 == 0) {
                    ParametersWithIV parametersWithIV;
                    ParametersWithIV parametersWithIV2;
                    Object object = parametersWithIV2;
                    parametersWithIV2 = new ParametersWithIV(this.param, IV2);
                    this.engine.init(false, (CipherParameters)object);
                    object = new byte[n4];
                    for (int i3 = 0; i3 != n4; i3 += n5) {
                        this.engine.processBlock(byArray, n3 + i3, (byte[])object, i3);
                    }
                    byArray = DESedeWrapEngine.reverse((byte[])object);
                    byte[] byArray2 = new byte[8];
                    this.iv = byArray2;
                    n4 = byArray.length - 8;
                    byte[] byArray3 = byArray;
                    byArray = new byte[n4];
                    System.arraycopy(byArray3, 0, byArray2, 0, 8);
                    int n6 = byArray3.length - 8;
                    System.arraycopy(byArray, 8, byArray, 0, n6);
                    Object object2 = parametersWithIV;
                    DESedeWrapEngine dESedeWrapEngine = this;
                    object = dESedeWrapEngine.param;
                    this.paramPlusIV = new ParametersWithIV((CipherParameters)object, dESedeWrapEngine.iv);
                    this.engine.init(false, (CipherParameters)object2);
                    object2 = new byte[n4];
                    for (int i4 = 0; i4 != n4; i4 += n5) {
                        this.engine.processBlock(byArray, i4, (byte[])object2, i4);
                    }
                    Object object3 = object2;
                    int n7 = n4 - 8;
                    byArray = new byte[n7];
                    object2 = new byte[8];
                    System.arraycopy(object3, 0, byArray, 0, n7);
                    System.arraycopy(object3, n7, object2, 0, 8);
                    if (this.checkCMSKeyChecksum(byArray, (byte[])object2)) {
                        return byArray;
                    }
                    throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
                }
                throw new InvalidCipherTextException(a.a("Ciphertext not multiple of ", n5));
            }
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        throw new IllegalStateException("Not set for unwrapping");
    }
}

