/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class DSTU7624Engine
implements BlockCipher {
    private static final int ROUNDS_128 = 10;
    private static final int ROUNDS_256 = 14;
    private static final int ROUNDS_512 = 18;
    private static final byte[] S0 = new byte[]{-88, 67, 95, 6, 107, 117, 108, 89, 113, -33, -121, -107, 23, -16, -40, 9, 109, -13, 29, -53, -55, 77, 44, -81, 121, -32, -105, -3, 111, 75, 69, 57, 62, -35, -93, 79, -76, -74, -102, 14, 31, -65, 21, -31, 73, -46, -109, -58, -110, 114, -98, 97, -47, 99, -6, -18, -12, 25, -43, -83, 88, -92, -69, -95, -36, -14, -125, 55, 66, -28, 122, 50, -100, -52, -85, 74, -113, 110, 4, 39, 46, -25, -30, 90, -106, 22, 35, 43, -62, 101, 102, 15, -68, -87, 71, 65, 52, 72, -4, -73, 106, -120, -91, 83, -122, -7, 91, -37, 56, 123, -61, 30, 34, 51, 36, 40, 54, -57, -78, 59, -114, 119, -70, -11, 20, -97, 8, 85, -101, 76, -2, 96, 92, -38, 24, 70, -51, 125, 33, -80, 63, 27, -119, -1, -21, -124, 105, 58, -99, -41, -45, 112, 103, 64, -75, -34, 93, 48, -111, -79, 120, 17, 1, -27, 0, 104, -104, -96, -59, 2, -90, 116, 45, 11, -94, 118, -77, -66, -50, -67, -82, -23, -118, 49, 28, -20, -15, -103, -108, -86, -10, 38, 47, -17, -24, -116, 53, 3, -44, 127, -5, 5, -63, 94, -112, 32, 61, -126, -9, -22, 10, 13, 126, -8, 80, 26, -60, 7, 87, -72, 60, 98, -29, -56, -84, 82, 100, 16, -48, -39, 19, 12, 18, 41, 81, -71, -49, -42, 115, -115, -127, 84, -64, -19, 78, 68, -89, 42, -123, 37, -26, -54, 124, -117, 86, -128};
    private static final byte[] S1 = new byte[]{-50, -69, -21, -110, -22, -53, 19, -63, -23, 58, -42, -78, -46, -112, 23, -8, 66, 21, 86, -76, 101, 28, -120, 67, -59, 92, 54, -70, -11, 87, 103, -115, 49, -10, 100, 88, -98, -12, 34, -86, 117, 15, 2, -79, -33, 109, 115, 77, 124, 38, 46, -9, 8, 93, 68, 62, -97, 20, -56, -82, 84, 16, -40, -68, 26, 107, 105, -13, -67, 51, -85, -6, -47, -101, 104, 78, 22, -107, -111, -18, 76, 99, -114, 91, -52, 60, 25, -95, -127, 73, 123, -39, 111, 55, 96, -54, -25, 43, 72, -3, -106, 69, -4, 65, 18, 13, 121, -27, -119, -116, -29, 32, 48, -36, -73, 108, 74, -75, 63, -105, -44, 98, 45, 6, -92, -91, -125, 95, 42, -38, -55, 0, 126, -94, 85, -65, 17, -43, -100, -49, 14, 10, 61, 81, 125, -109, 27, -2, -60, 71, 9, -122, 11, -113, -99, 106, 7, -71, -80, -104, 24, 50, 113, 75, -17, 59, 112, -96, -28, 64, -1, -61, -87, -26, 120, -7, -117, 70, -128, 30, 56, -31, -72, -88, -32, 12, 35, 118, 29, 37, 36, 5, -15, 110, -108, 40, -102, -124, -24, -93, 79, 119, -45, -123, -30, 82, -14, -126, 80, 122, 47, 116, 83, -77, 97, -81, 57, 53, -34, -51, 31, -103, -84, -83, 114, 44, -35, -48, -121, -66, 94, -90, -20, 4, -58, 3, 52, -5, -37, 89, -74, -62, 1, -16, 90, -19, -89, 102, 33, 127, -118, 39, -57, -64, 41, -41};
    private static final byte[] S2 = new byte[]{-109, -39, -102, -75, -104, 34, 69, -4, -70, 106, -33, 2, -97, -36, 81, 89, 74, 23, 43, -62, -108, -12, -69, -93, 98, -28, 113, -44, -51, 112, 22, -31, 73, 60, -64, -40, 92, -101, -83, -123, 83, -95, 122, -56, 45, -32, -47, 114, -90, 44, -60, -29, 118, 120, -73, -76, 9, 59, 14, 65, 76, -34, -78, -112, 37, -91, -41, 3, 17, 0, -61, 46, -110, -17, 78, 18, -99, 125, -53, 53, 16, -43, 79, -98, 77, -87, 85, -58, -48, 123, 24, -105, -45, 54, -26, 72, 86, -127, -113, 119, -52, -100, -71, -30, -84, -72, 47, 21, -92, 124, -38, 56, 30, 11, 5, -42, 20, 110, 108, 126, 102, -3, -79, -27, 96, -81, 94, 51, -121, -55, -16, 93, 109, 63, -120, -115, -57, -9, 29, -23, -20, -19, -128, 41, 39, -49, -103, -88, 80, 15, 55, 36, 40, 48, -107, -46, 62, 91, 64, -125, -77, 105, 87, 31, 7, 28, -118, -68, 32, -21, -50, -114, -85, -18, 49, -94, 115, -7, -54, 58, 26, -5, 13, -63, -2, -6, -14, 111, -67, -106, -35, 67, 82, -74, 8, -13, -82, -66, 25, -119, 50, 38, -80, -22, 75, 100, -124, -126, 107, -11, 121, -65, 1, 95, 117, 99, 27, 35, 61, 104, 42, 101, -24, -111, -10, -1, 19, 88, -15, 71, 10, 127, -59, -89, -25, 97, 90, 6, 70, 68, 66, 4, -96, -37, 57, -122, 84, -86, -116, 52, 33, -117, -8, 12, 116, 103};
    private static final byte[] S3 = new byte[]{104, -115, -54, 77, 115, 75, 78, 42, -44, 82, 38, -77, 84, 30, 25, 31, 34, 3, 70, 61, 45, 74, 83, -125, 19, -118, -73, -43, 37, 121, -11, -67, 88, 47, 13, 2, -19, 81, -98, 17, -14, 62, 85, 94, -47, 22, 60, 102, 112, 93, -13, 69, 64, -52, -24, -108, 86, 8, -50, 26, 58, -46, -31, -33, -75, 56, 110, 14, -27, -12, -7, -122, -23, 79, -42, -123, 35, -49, 50, -103, 49, 20, -82, -18, -56, 72, -45, 48, -95, -110, 65, -79, 24, -60, 44, 113, 114, 68, 21, -3, 55, -66, 95, -86, -101, -120, -40, -85, -119, -100, -6, 96, -22, -68, 98, 12, 36, -90, -88, -20, 103, 32, -37, 124, 40, -35, -84, 91, 52, 126, 16, -15, 123, -113, 99, -96, 5, -102, 67, 119, 33, -65, 39, 9, -61, -97, -74, -41, 41, -62, -21, -64, -92, -117, -116, 29, -5, -1, -63, -78, -105, 46, -8, 101, -10, 117, 7, 4, 73, 51, -28, -39, -71, -48, 66, -57, 108, -112, 0, -114, 111, 80, 1, -59, -38, 71, 63, -51, 105, -94, -30, 122, -89, -58, -109, 15, 10, 6, -26, 43, -106, -93, 28, -81, 106, 18, -124, 57, -25, -80, -126, -9, -2, -99, -121, 92, -127, 53, -34, -76, -91, -4, -128, -17, -53, -69, 107, 118, -70, 90, 125, 120, 11, -107, -29, -83, 116, -104, 59, 54, 100, 109, -36, -16, 89, -87, 76, 23, 127, -111, -72, -55, 87, 27, -32, 97};
    private static final byte[] T0 = new byte[]{-92, -94, -87, -59, 78, -55, 3, -39, 126, 15, -46, -83, -25, -45, 39, 91, -29, -95, -24, -26, 124, 42, 85, 12, -122, 57, -41, -115, -72, 18, 111, 40, -51, -118, 112, 86, 114, -7, -65, 79, 115, -23, -9, 87, 22, -84, 80, -64, -99, -73, 71, 113, 96, -60, 116, 67, 108, 31, -109, 119, -36, -50, 32, -116, -103, 95, 68, 1, -11, 30, -121, 94, 97, 44, 75, 29, -127, 21, -12, 35, -42, -22, -31, 103, -15, 127, -2, -38, 60, 7, 83, 106, -124, -100, -53, 2, -125, 51, -35, 53, -30, 89, 90, -104, -91, -110, 100, 4, 6, 16, 77, 28, -105, 8, 49, -18, -85, 5, -81, 121, -96, 24, 70, 109, -4, -119, -44, -57, -1, -16, -49, 66, -111, -8, 104, 10, 101, -114, -74, -3, -61, -17, 120, 76, -52, -98, 48, 46, -68, 11, 84, 26, -90, -69, 38, -128, 72, -108, 50, 125, -89, 63, -82, 34, 61, 102, -86, -10, 0, 93, -67, 74, -32, 59, -76, 23, -117, -97, 118, -80, 36, -102, 37, 99, -37, -21, 122, 62, 92, -77, -79, 41, -14, -54, 88, 110, -40, -88, 47, 117, -33, 20, -5, 19, 73, -120, -78, -20, -28, 52, 45, -106, -58, 58, -19, -107, 14, -27, -123, 107, 64, 33, -101, 9, 25, 43, 82, -34, 69, -93, -6, 81, -62, -75, -47, -112, -71, -13, 55, -63, 13, -70, 65, 17, 56, 123, -66, -48, -43, 105, 54, -56, 98, 27, -126, -113};
    private static final byte[] T1 = new byte[]{-125, -14, 42, -21, -23, -65, 123, -100, 52, -106, -115, -104, -71, 105, -116, 41, 61, -120, 104, 6, 57, 17, 76, 14, -96, 86, 64, -110, 21, -68, -77, -36, 111, -8, 38, -70, -66, -67, 49, -5, -61, -2, -128, 97, -31, 122, 50, -46, 112, 32, -95, 69, -20, -39, 26, 93, -76, -40, 9, -91, 85, -114, 55, 118, -87, 103, 16, 23, 54, 101, -79, -107, 98, 89, 116, -93, 80, 47, 75, -56, -48, -113, -51, -44, 60, -122, 18, 29, 35, -17, -12, 83, 25, 53, -26, 127, 94, -42, 121, 81, 34, 20, -9, 30, 74, 66, -101, 65, 115, 45, -63, 92, -90, -94, -32, 46, -45, 40, -69, -55, -82, 106, -47, 90, 48, -112, -124, -7, -78, 88, -49, 126, -59, -53, -105, -28, 22, 108, -6, -80, 109, 31, 82, -103, 13, 78, 3, -111, -62, 77, 100, 119, -97, -35, -60, 73, -118, -102, 36, 56, -89, 87, -123, -57, 124, 125, -25, -10, -73, -84, 39, 70, -34, -33, 59, -41, -98, 43, 11, -43, 19, 117, -16, 114, -74, -99, 27, 1, 63, 68, -27, -121, -3, 7, -15, -85, -108, 24, -22, -4, 58, -126, 95, 5, 84, -37, 0, -117, -29, 72, 12, -54, 120, -119, 10, -1, 62, 91, -127, -18, 113, -30, -38, 44, -72, -75, -52, 110, -88, 107, -83, 96, -58, 8, 4, 2, -24, -11, 79, -92, -13, -64, -50, 67, 37, 28, 33, 51, 15, -81, 71, -19, 102, 99, -109, -86};
    private static final byte[] T2 = new byte[]{69, -44, 11, 67, -15, 114, -19, -92, -62, 56, -26, 113, -3, -74, 58, -107, 80, 68, 75, -30, 116, 107, 30, 17, 90, -58, -76, -40, -91, -118, 112, -93, -88, -6, 5, -39, -105, 64, -55, -112, -104, -113, -36, 18, 49, 44, 71, 106, -103, -82, -56, 127, -7, 79, 93, -106, 111, -12, -77, 57, 33, -38, -100, -123, -98, 59, -16, -65, -17, 6, -18, -27, 95, 32, 16, -52, 60, 84, 74, 82, -108, 14, -64, 40, -10, 86, 96, -94, -29, 15, -20, -99, 36, -125, 126, -43, 124, -21, 24, -41, -51, -35, 120, -1, -37, -95, 9, -48, 118, -124, 117, -69, 29, 26, 47, -80, -2, -42, 52, 99, 53, -46, 42, 89, 109, 77, 119, -25, -114, 97, -49, -97, -50, 39, -11, -128, -122, -57, -90, -5, -8, -121, -85, 98, 63, -33, 72, 0, 20, -102, -67, 91, 4, -110, 2, 37, 101, 76, 83, 12, -14, 41, -81, 23, 108, 65, 48, -23, -109, 85, -9, -84, 104, 38, -60, 125, -54, 122, 62, -96, 55, 3, -63, 54, 105, 102, 8, 22, -89, -68, -59, -45, 34, -73, 19, 70, 50, -24, 87, -120, 43, -127, -78, 78, 100, 28, -86, -111, 88, 46, -101, 92, 27, 81, 115, 66, 35, 1, 110, -13, 13, -66, 61, 10, 45, 31, 103, 51, 25, 123, 94, -22, -34, -117, -53, -87, -116, -115, -83, 73, -126, -28, -70, -61, 21, -47, -32, -119, -4, -79, -71, -75, 7, 121, -72, -31};
    private static final byte[] T3 = new byte[]{-78, -74, 35, 17, -89, -120, -59, -90, 57, -113, -60, -24, 115, 34, 67, -61, -126, 39, -51, 24, 81, 98, 45, -9, 92, 14, 59, -3, -54, -101, 13, 15, 121, -116, 16, 76, 116, 28, 10, -114, 124, -108, 7, -57, 94, 20, -95, 33, 87, 80, 78, -87, -128, -39, -17, 100, 65, -49, 60, -18, 46, 19, 41, -70, 52, 90, -82, -118, 97, 51, 18, -71, 85, -88, 21, 5, -10, 3, 6, 73, -75, 37, 9, 22, 12, 42, 56, -4, 32, -12, -27, 127, -41, 49, 43, 102, 111, -1, 114, -122, -16, -93, 47, 120, 0, -68, -52, -30, -80, -15, 66, -76, 48, 95, 96, 4, -20, -91, -29, -117, -25, 29, -65, -124, 123, -26, -127, -8, -34, -40, -46, 23, -50, 75, 71, -42, 105, 108, 25, -103, -102, 1, -77, -123, -79, -7, 89, -62, 55, -23, -56, -96, -19, 79, -119, 104, 109, -43, 38, -111, -121, 88, -67, -55, -104, -36, 117, -64, 118, -11, 103, 107, 126, -21, 82, -53, -47, 91, -97, 11, -37, 64, -110, 26, -6, -84, -28, -31, 113, 31, 101, -115, -105, -98, -107, -112, 93, -73, -63, -81, 84, -5, 2, -32, 53, -69, 58, 77, -83, 44, 61, 86, 8, 27, 74, -109, 106, -85, -72, 122, -14, 125, -38, 63, -2, 62, -66, -22, -86, 68, -58, -48, 54, 72, 112, -106, 119, 36, 83, -33, -13, -125, 40, 50, 69, 30, -92, -45, -94, 70, 110, -100, -35, 99, -44, -99};
    private long[] internalState;
    private long[] workingKey;
    private long[][] roundKeys;
    private int wordsInBlock;
    private int wordsInKey;
    private int roundsAmount;
    private boolean forEncryption;

    public DSTU7624Engine(int n3) {
        int n4;
        if (n3 != 128 && n3 != 256 && n3 != 512) {
            throw new IllegalArgumentException("unsupported block length: only 128/256/512 are allowed");
        }
        DSTU7624Engine dSTU7624Engine = this;
        dSTU7624Engine.wordsInBlock = n4 = n3 >>> 6;
        dSTU7624Engine.internalState = new long[n4];
    }

    private void addRoundKey(int n3) {
        long[] lArray = this.roundKeys[n3];
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            this.internalState[i3] = this.internalState[i3] + lArray[i3];
        }
    }

    private void subRoundKey(int n3) {
        long[] lArray = this.roundKeys[n3];
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            this.internalState[i3] = this.internalState[i3] - lArray[i3];
        }
    }

    private void xorRoundKey(int n3) {
        long[] lArray = this.roundKeys[n3];
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            this.internalState[i3] = this.internalState[i3] ^ lArray[i3];
        }
    }

    private void workingKeyExpandKT(long[] lArray, long[] lArray2) {
        long[] lArray3;
        long l3;
        int n3 = this.wordsInBlock;
        long[] lArray4 = new long[n3];
        long[] lArray5 = new long[n3];
        long[] lArray6 = new long[n3];
        this.internalState = lArray6;
        int n4 = this.wordsInKey;
        lArray6[0] = l3 = lArray6[0] + (long)(n3 + n4 + 1);
        if (n3 == n4) {
            System.arraycopy(lArray, 0, lArray4, 0, n3);
            System.arraycopy(lArray, 0, lArray5, 0, n3);
        } else {
            System.arraycopy(lArray, 0, lArray4, 0, n3);
            int n5 = this.wordsInBlock;
            System.arraycopy(lArray, n5, lArray5, 0, n5);
        }
        int n6 = 0;
        while (true) {
            lArray3 = this.internalState;
            if (n6 >= this.internalState.length) break;
            lArray3[n6] = lArray3[n6] + lArray4[n6];
            ++n6;
        }
        DSTU7624Engine dSTU7624Engine = this;
        dSTU7624Engine.subBytes();
        dSTU7624Engine.shiftRows();
        dSTU7624Engine.mixColumns();
        n6 = 0;
        while (true) {
            lArray3 = this.internalState;
            if (n6 >= this.internalState.length) break;
            lArray3[n6] = lArray3[n6] ^ lArray5[n6];
            ++n6;
        }
        DSTU7624Engine dSTU7624Engine2 = this;
        dSTU7624Engine2.subBytes();
        dSTU7624Engine2.shiftRows();
        dSTU7624Engine2.mixColumns();
        n6 = 0;
        while (true) {
            lArray3 = this.internalState;
            if (n6 >= this.internalState.length) break;
            lArray3[n6] = lArray3[n6] + lArray4[n6];
            ++n6;
        }
        DSTU7624Engine dSTU7624Engine3 = this;
        dSTU7624Engine3.subBytes();
        dSTU7624Engine3.shiftRows();
        dSTU7624Engine3.mixColumns();
        int n7 = this.wordsInBlock;
        System.arraycopy(dSTU7624Engine3.internalState, 0, lArray2, 0, n7);
    }

    private void workingKeyExpandEven(long[] lArray, long[] lArray2) {
        DSTU7624Engine dSTU7624Engine = this;
        int n3 = dSTU7624Engine.wordsInKey;
        long[] lArray3 = new long[n3];
        long[] lArray4 = new long[dSTU7624Engine.wordsInBlock];
        int n4 = 0;
        System.arraycopy(lArray, 0, lArray3, 0, n3);
        long l3 = 0x1000100010001L;
        while (true) {
            block13: {
                block12: {
                    int n5;
                    int n6;
                    for (n6 = 0; n6 < this.wordsInBlock; ++n6) {
                        lArray4[n6] = lArray2[n6] + l3;
                    }
                    for (n6 = 0; n6 < this.wordsInBlock; ++n6) {
                        this.internalState[n6] = lArray3[n6] + lArray4[n6];
                    }
                    DSTU7624Engine dSTU7624Engine2 = this;
                    dSTU7624Engine2.subBytes();
                    dSTU7624Engine2.shiftRows();
                    dSTU7624Engine2.mixColumns();
                    for (n6 = 0; n6 < this.wordsInBlock; ++n6) {
                        this.internalState[n6] = this.internalState[n6] ^ lArray4[n6];
                    }
                    DSTU7624Engine dSTU7624Engine3 = this;
                    dSTU7624Engine3.subBytes();
                    dSTU7624Engine3.shiftRows();
                    dSTU7624Engine3.mixColumns();
                    for (n6 = 0; n6 < (n5 = this.wordsInBlock); ++n6) {
                        this.internalState[n6] = this.internalState[n6] + lArray4[n6];
                    }
                    DSTU7624Engine dSTU7624Engine4 = this;
                    System.arraycopy(dSTU7624Engine4.internalState, 0, this.roundKeys[n4], 0, n5);
                    if (dSTU7624Engine4.roundsAmount == n4) break block12;
                    if (this.wordsInBlock == this.wordsInKey) break block13;
                    n4 += 2;
                    l3 <<= 1;
                    for (n6 = 0; n6 < this.wordsInBlock; ++n6) {
                        lArray4[n6] = lArray2[n6] + l3;
                    }
                    for (n6 = 0; n6 < (n5 = this.wordsInBlock); ++n6) {
                        this.internalState[n6] = lArray3[n5 + n6] + lArray4[n6];
                    }
                    DSTU7624Engine dSTU7624Engine5 = this;
                    dSTU7624Engine5.subBytes();
                    dSTU7624Engine5.shiftRows();
                    dSTU7624Engine5.mixColumns();
                    for (n6 = 0; n6 < this.wordsInBlock; ++n6) {
                        this.internalState[n6] = this.internalState[n6] ^ lArray4[n6];
                    }
                    DSTU7624Engine dSTU7624Engine6 = this;
                    dSTU7624Engine6.subBytes();
                    dSTU7624Engine6.shiftRows();
                    dSTU7624Engine6.mixColumns();
                    for (n6 = 0; n6 < (n5 = this.wordsInBlock); ++n6) {
                        this.internalState[n6] = this.internalState[n6] + lArray4[n6];
                    }
                    DSTU7624Engine dSTU7624Engine7 = this;
                    System.arraycopy(dSTU7624Engine7.internalState, 0, this.roundKeys[n4], 0, n5);
                    if (dSTU7624Engine7.roundsAmount != n4) break block13;
                }
                return;
            }
            n4 += 2;
            l3 <<= 1;
            long l4 = lArray3[0];
            for (int i3 = 1; i3 < n3; ++i3) {
                long l5;
                int n7 = i3 - 1;
                lArray3[n7] = l5 = lArray3[i3];
            }
            lArray3[n3 - 1] = l4;
        }
    }

    private void workingKeyExpandOdd() {
        for (int i3 = 1; i3 < this.roundsAmount; i3 += 2) {
            DSTU7624Engine dSTU7624Engine = this;
            long[] lArray = dSTU7624Engine.roundKeys[i3 - 1];
            dSTU7624Engine.rotateLeft(lArray, dSTU7624Engine.roundKeys[i3]);
        }
    }

    private void decryptBlock_128(byte[] byArray, int n3, byte[] byArray2, int n4) {
        long l3 = Pack.littleEndianToLong(byArray, n3);
        int n5 = ((DSTU7624Engine)object).roundsAmount;
        long[] lArray = ((DSTU7624Engine)object).roundKeys[n5];
        l3 -= lArray[0];
        long l4 = Pack.littleEndianToLong(byArray, n3 + 8) - lArray[1];
        while (true) {
            byte[] byArray3;
            l3 = DSTU7624Engine.mixColumnInv(l3);
            long l5 = DSTU7624Engine.mixColumnInv(l4);
            long l6 = l3;
            int n6 = (int)l6;
            n3 = (int)(l6 >>> 32);
            int n7 = (int)l5;
            int n8 = (int)(l5 >>> 32);
            int n9 = n5;
            byte[] byArray4 = byArray3 = T0;
            byte[] byArray5 = byArray3;
            byte by = byArray3[n6 & 0xFF];
            byArray3 = T1;
            byte by2 = T1[n6 >>> 8 & 0xFF];
            byte[] byArray6 = T2;
            byte by3 = T2[n6 >>> 16 & 0xFF];
            byte[] byArray7 = T3;
            n6 = T3[n6 >>> 24];
            n6 = by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | n6 << 24;
            byte by4 = byArray5[n8 & 0xFF];
            int n10 = n8;
            int n11 = n8;
            n8 = byArray3[n8 >>> 8 & 0xFF];
            by2 = byArray6[n11 >>> 16 & 0xFF];
            by3 = byArray7[n10 >>> 24];
            n8 = by4 & 0xFF | (n8 & 0xFF) << 8 | (by2 & 0xFF) << 16 | by3 << 24;
            long l7 = (long)n6 & 0xFFFFFFFFL | (long)n8 << 32;
            byte by5 = byArray4[n7 & 0xFF];
            int n12 = n7;
            n6 = byArray3[n7 >>> 8 & 0xFF];
            n7 = byArray6[n7 >>> 16 & 0xFF];
            by3 = byArray7[n12 >>> 24];
            n6 = by5 & 0xFF | (n6 & 0xFF) << 8 | (n7 & 0xFF) << 16 | by3 << 24;
            byte by6 = T0[n3 & 0xFF];
            int n13 = n3;
            int n14 = n3;
            n3 = byArray3[n3 >>> 8 & 0xFF];
            n5 = byArray6[n14 >>> 16 & 0xFF];
            n7 = byArray7[n13 >>> 24];
            n3 = by6 & 0xFF | (n3 & 0xFF) << 8 | (n5 & 0xFF) << 16 | n7 << 24;
            long l8 = (long)n6 & 0xFFFFFFFFL | (long)n3 << 32;
            n5 = n9 + -1;
            if (n5 == 0) {
                long[] lArray2 = ((DSTU7624Engine)object).roundKeys[0];
                Object object = lArray2;
                long l9 = l7 - object[0];
                long l10 = l8 - lArray2[1];
                Pack.longToLittleEndian(l9, byArray2, n4);
                Pack.longToLittleEndian(l10, byArray2, n4 + 8);
                return;
            }
            long[] lArray3 = ((DSTU7624Engine)object).roundKeys[n5];
            l3 = l7 ^ lArray3[0];
            l4 = l8 ^ lArray3[1];
        }
    }

    private void encryptBlock_128(byte[] byArray, int n3, byte[] byArray2, int n4) {
        long l3 = Pack.littleEndianToLong(byArray, n3);
        long[] lArray = ((DSTU7624Engine)object).roundKeys[0];
        l3 += lArray[0];
        long l4 = Pack.littleEndianToLong(byArray, n3 + 8) + lArray[1];
        int n5 = 0;
        while (true) {
            byte[] byArray3;
            long l5 = l4;
            long l6 = l3;
            int n6 = (int)l6;
            n3 = (int)(l6 >>> 32);
            int n7 = (int)l5;
            int n8 = (int)(l5 >>> 32);
            byte[] byArray4 = byArray3 = S0;
            byte[] byArray5 = byArray3;
            byte by = byArray3[n6 & 0xFF];
            byArray3 = S1;
            byte by2 = S1[n6 >>> 8 & 0xFF];
            byte[] byArray6 = S2;
            byte by3 = S2[n6 >>> 16 & 0xFF];
            byte[] byArray7 = S3;
            n6 = S3[n6 >>> 24];
            n6 = by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | n6 << 24;
            byte by4 = byArray5[n8 & 0xFF];
            int n9 = n8;
            int n10 = n8;
            n8 = byArray3[n8 >>> 8 & 0xFF];
            by2 = byArray6[n10 >>> 16 & 0xFF];
            by3 = byArray7[n9 >>> 24];
            n8 = by4 & 0xFF | (n8 & 0xFF) << 8 | (by2 & 0xFF) << 16 | by3 << 24;
            long l7 = (long)n6 & 0xFFFFFFFFL | (long)n8 << 32;
            byte by5 = byArray4[n7 & 0xFF];
            int n11 = n7;
            n6 = byArray3[n7 >>> 8 & 0xFF];
            n7 = byArray6[n7 >>> 16 & 0xFF];
            n8 = byArray7[n11 >>> 24];
            n6 = by5 & 0xFF | (n6 & 0xFF) << 8 | (n7 & 0xFF) << 16 | n8 << 24;
            byte by6 = S0[n3 & 0xFF];
            int n12 = n3;
            int n13 = n3;
            n3 = byArray3[n3 >>> 8 & 0xFF];
            n7 = byArray6[n13 >>> 16 & 0xFF];
            n8 = byArray7[n12 >>> 24];
            n3 = by6 & 0xFF | (n3 & 0xFF) << 8 | (n7 & 0xFF) << 16 | n8 << 24;
            l3 = DSTU7624Engine.mixColumn(l7);
            long l8 = DSTU7624Engine.mixColumn((long)n6 & 0xFFFFFFFFL | (long)n3 << 32);
            int n14 = ((DSTU7624Engine)object).roundsAmount;
            if (++n5 == n14) {
                long[] lArray2 = ((DSTU7624Engine)object).roundKeys[n14];
                Object object = lArray2;
                long l9 = l3 + object[0];
                long l10 = l8 + lArray2[1];
                Pack.longToLittleEndian(l9, byArray2, n4);
                Pack.longToLittleEndian(l10, byArray2, n4 + 8);
                return;
            }
            long[] lArray3 = ((DSTU7624Engine)object).roundKeys[n5];
            l3 ^= lArray3[0];
            l4 = l8 ^ lArray3[1];
        }
    }

    private void subBytes() {
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            long l3 = this.internalState[i3];
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            byte by = S0[n3 & 0xFF];
            byte[] byArray = S1;
            byte by2 = S1[n3 >>> 8 & 0xFF];
            byte[] byArray2 = S2;
            byte by3 = S2[n3 >>> 16 & 0xFF];
            byte[] byArray3 = S3;
            n3 = S3[n3 >>> 24];
            n3 = by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | n3 << 24;
            byte by4 = S0[n4 & 0xFF];
            int n5 = n4;
            int n6 = n4;
            n4 = byArray[n4 >>> 8 & 0xFF];
            byte by5 = byArray2[n6 >>> 16 & 0xFF];
            by2 = byArray3[n5 >>> 24];
            n4 = by4 & 0xFF | (n4 & 0xFF) << 8 | (by5 & 0xFF) << 16 | by2 << 24;
            this.internalState[i3] = (long)n3 & 0xFFFFFFFFL | (long)n4 << 32;
        }
    }

    private void invSubBytes() {
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            long l3 = this.internalState[i3];
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            byte by = T0[n3 & 0xFF];
            byte[] byArray = T1;
            byte by2 = T1[n3 >>> 8 & 0xFF];
            byte[] byArray2 = T2;
            byte by3 = T2[n3 >>> 16 & 0xFF];
            byte[] byArray3 = T3;
            n3 = T3[n3 >>> 24];
            n3 = by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | n3 << 24;
            byte by4 = T0[n4 & 0xFF];
            int n5 = n4;
            int n6 = n4;
            n4 = byArray[n4 >>> 8 & 0xFF];
            byte by5 = byArray2[n6 >>> 16 & 0xFF];
            by2 = byArray3[n5 >>> 24];
            n4 = by4 & 0xFF | (n4 & 0xFF) << 8 | (by5 & 0xFF) << 16 | by2 << 24;
            this.internalState[i3] = (long)n3 & 0xFFFFFFFFL | (long)n4 << 32;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shiftRows() {
        int n3 = this.wordsInBlock;
        if (n3 != 2) {
            if (n3 != 4) {
                if (n3 != 8) throw new IllegalStateException("unsupported block length: only 128/256/512 are allowed");
                long[] lArray = this.internalState;
                long[] lArray2 = this.internalState;
                long l3 = lArray[0];
                long l4 = lArray2[1];
                long l5 = lArray[2];
                long l6 = lArray2[3];
                long l7 = lArray[4];
                long l8 = lArray2[5];
                long l9 = lArray[6];
                long l10 = lArray2[7];
                long l11 = l10;
                long l12 = l6;
                long l13 = l5;
                long l14 = l4;
                long l15 = l3;
                l3 = (l15 ^ l7) & 0xFFFFFFFF00000000L;
                l4 = l15 ^ l3;
                l3 = l7 ^ l3;
                l5 = (l14 ^ l8) & 0xFFFFFFFF000000L;
                l6 = l14 ^ l5;
                l5 = l8 ^ l5;
                l7 = (l13 ^ l9) & 0xFFFFFFFF0000L;
                l8 = l13 ^ l7;
                l7 = l9 ^ l7;
                l9 = (l12 ^ l11) & 0xFFFFFFFF00L;
                l11 = l12 ^ l9;
                long l16 = l10 ^ l9;
                l9 = l16;
                long l17 = l5;
                long l18 = l7;
                long l19 = l3;
                long l20 = l6;
                long l21 = l4;
                l3 = (l21 ^ l8) & 0xFFFF0000FFFF0000L;
                l4 = l21 ^ l3;
                l3 = l8 ^ l3;
                l5 = (l20 ^ l11) & 0xFFFF0000FFFF00L;
                l6 = l20 ^ l5;
                l5 = l11 ^ l5;
                l7 = (l19 ^ l7) & 0xFFFF0000FFFF0000L;
                l8 = l19 ^ l7;
                l7 = l18 ^ l7;
                l9 = (l17 ^ l9) & 0xFFFF0000FFFF00L;
                l11 = l17 ^ l9;
                long l22 = l16 ^ l9;
                l9 = l22;
                long l23 = l7;
                long l24 = l8;
                long l25 = l5;
                long l26 = l3;
                long l27 = l4;
                l3 = (l27 ^ l6) & 0xFF00FF00FF00FF00L;
                l4 = l27 ^ l3;
                l3 = l6 ^ l3;
                l5 = (l26 ^ l5) & 0xFF00FF00FF00FF00L;
                l6 = l26 ^ l5;
                l5 = l25 ^ l5;
                l7 = (l24 ^ l11) & 0xFF00FF00FF00FF00L;
                l8 = l24 ^ l7;
                l7 = l11 ^ l7;
                l9 = (l23 ^ l9) & 0xFF00FF00FF00FF00L;
                l11 = l23 ^ l9;
                l9 = l22 ^ l9;
                lArray[0] = l4;
                lArray2[1] = l3;
                lArray[2] = l6;
                lArray2[3] = l5;
                lArray[4] = l8;
                lArray2[5] = l7;
                lArray[6] = l11;
                lArray2[7] = l9;
                return;
            } else {
                long[] lArray = this.internalState;
                long[] lArray3 = this.internalState;
                long l28 = lArray[0];
                long l29 = lArray3[1];
                long l30 = lArray[2];
                long l31 = lArray3[3];
                long l32 = l31;
                long l33 = l29;
                long l34 = l28;
                l28 = (l34 ^ l30) & 0xFFFFFFFF00000000L;
                l29 = l34 ^ l28;
                l28 = l30 ^ l28;
                l30 = (l33 ^ l32) & 0xFFFFFFFF0000L;
                l32 = l33 ^ l30;
                long l35 = l31 ^ l30;
                l30 = l35;
                long l36 = l28;
                long l37 = l29;
                l28 = (l37 ^ l32) & 0xFFFF0000FFFF0000L;
                l29 = l37 ^ l28;
                l28 = l32 ^ l28;
                l30 = (l36 ^ l30) & 0xFFFF0000FFFF0000L;
                l32 = l36 ^ l30;
                l30 = l35 ^ l30;
                lArray[0] = l29;
                lArray3[1] = l28;
                lArray[2] = l32;
                lArray3[3] = l30;
            }
            return;
        } else {
            long[] lArray = this.internalState;
            long[] lArray4 = this.internalState;
            long l38 = lArray[0];
            long l39 = lArray4[1];
            long l40 = l39;
            long l41 = l38;
            l38 = (l41 ^ l40) & 0xFFFFFFFF00000000L;
            l40 = l41 ^ l38;
            l38 = l39 ^ l38;
            lArray[0] = l40;
            lArray4[1] = l38;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invShiftRows() {
        int n3 = this.wordsInBlock;
        if (n3 != 2) {
            if (n3 != 4) {
                if (n3 != 8) throw new IllegalStateException("unsupported block length: only 128/256/512 are allowed");
                long[] lArray = this.internalState;
                long[] lArray2 = this.internalState;
                long l3 = lArray[0];
                long l4 = lArray2[1];
                long l5 = lArray[2];
                long l6 = lArray2[3];
                long l7 = lArray[4];
                long l8 = lArray2[5];
                long l9 = lArray[6];
                long l10 = lArray2[7];
                long l11 = l10;
                long l12 = l9;
                long l13 = l8;
                long l14 = l7;
                long l15 = l6;
                long l16 = l5;
                long l17 = l4;
                long l18 = l3;
                l3 = (l18 ^ l4) & 0xFF00FF00FF00FF00L;
                l4 = l18 ^ l3;
                l3 = l17 ^ l3;
                l5 = (l16 ^ l6) & 0xFF00FF00FF00FF00L;
                l6 = l16 ^ l5;
                l5 = l15 ^ l5;
                l7 = (l14 ^ l8) & 0xFF00FF00FF00FF00L;
                l8 = l14 ^ l7;
                l7 = l13 ^ l7;
                l9 = (l12 ^ l11) & 0xFF00FF00FF00FF00L;
                l11 = l12 ^ l9;
                long l19 = l10 ^ l9;
                l9 = l19;
                long l20 = l7;
                long l21 = l8;
                long l22 = l5;
                long l23 = l3;
                long l24 = l4;
                l3 = (l24 ^ l6) & 0xFFFF0000FFFF0000L;
                l4 = l24 ^ l3;
                l3 = l6 ^ l3;
                l5 = (l23 ^ l5) & 0xFFFF0000FFFF00L;
                l6 = l23 ^ l5;
                l5 = l22 ^ l5;
                l7 = (l21 ^ l11) & 0xFFFF0000FFFF0000L;
                l8 = l21 ^ l7;
                l7 = l11 ^ l7;
                l9 = (l20 ^ l9) & 0xFFFF0000FFFF00L;
                l11 = l20 ^ l9;
                long l25 = l19 ^ l9;
                l9 = l25;
                long l26 = l5;
                long l27 = l7;
                long l28 = l3;
                long l29 = l6;
                long l30 = l4;
                l3 = (l30 ^ l8) & 0xFFFFFFFF00000000L;
                l4 = l30 ^ l3;
                l3 = l8 ^ l3;
                l5 = (l29 ^ l11) & 0xFFFFFFFF000000L;
                l6 = l29 ^ l5;
                l5 = l11 ^ l5;
                l7 = (l28 ^ l7) & 0xFFFFFFFF0000L;
                l8 = l28 ^ l7;
                l7 = l27 ^ l7;
                l9 = (l26 ^ l9) & 0xFFFFFFFF00L;
                l11 = l26 ^ l9;
                l9 = l25 ^ l9;
                lArray[0] = l4;
                lArray2[1] = l6;
                lArray[2] = l8;
                lArray2[3] = l11;
                lArray[4] = l3;
                lArray2[5] = l5;
                lArray[6] = l7;
                lArray2[7] = l9;
                return;
            } else {
                long[] lArray = this.internalState;
                long[] lArray3 = this.internalState;
                long l31 = lArray[0];
                long l32 = lArray3[1];
                long l33 = lArray[2];
                long l34 = lArray3[3];
                long l35 = l34;
                long l36 = l33;
                long l37 = l32;
                long l38 = l31;
                l31 = (l38 ^ l32) & 0xFFFF0000FFFF0000L;
                l32 = l38 ^ l31;
                l31 = l37 ^ l31;
                l33 = (l36 ^ l35) & 0xFFFF0000FFFF0000L;
                l35 = l36 ^ l33;
                long l39 = l34 ^ l33;
                l33 = l39;
                long l40 = l31;
                long l41 = l32;
                l31 = (l41 ^ l35) & 0xFFFFFFFF00000000L;
                l32 = l41 ^ l31;
                l31 = l35 ^ l31;
                l33 = (l40 ^ l33) & 0xFFFFFFFF0000L;
                l35 = l40 ^ l33;
                l33 = l39 ^ l33;
                lArray[0] = l32;
                lArray3[1] = l35;
                lArray[2] = l31;
                lArray3[3] = l33;
            }
            return;
        } else {
            long[] lArray = this.internalState;
            long[] lArray4 = this.internalState;
            long l42 = lArray[0];
            long l43 = lArray4[1];
            long l44 = l43;
            long l45 = l42;
            l42 = (l45 ^ l44) & 0xFFFFFFFF00000000L;
            l44 = l45 ^ l42;
            l42 = l43 ^ l42;
            lArray[0] = l44;
            lArray4[1] = l42;
        }
    }

    private static long mixColumn(long l3) {
        long l4 = DSTU7624Engine.mulX(l3);
        long l5 = DSTU7624Engine.rotate(8, l3) ^ l3;
        long l6 = l5 ^ DSTU7624Engine.rotate(16, l5) ^ DSTU7624Engine.rotate(48, l3);
        l3 = DSTU7624Engine.mulX2(l6 ^ l3 ^ l4);
        return l6 ^ DSTU7624Engine.rotate(32, l3) ^ DSTU7624Engine.rotate(40, l4) ^ DSTU7624Engine.rotate(48, l4);
    }

    private void mixColumns() {
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            this.internalState[i3] = DSTU7624Engine.mixColumn(this.internalState[i3]);
        }
    }

    private static long mixColumnInv(long l3) {
        long l4 = l3 ^ DSTU7624Engine.rotate(8, l3);
        long l5 = l4 ^ DSTU7624Engine.rotate(32, l4) ^ DSTU7624Engine.rotate(48, l3);
        l4 = l5;
        long l6 = l5 ^ l3;
        long l7 = DSTU7624Engine.rotate(48, l3);
        long l8 = DSTU7624Engine.rotate(56, l3);
        long l9 = l6 ^ l8;
        l9 = DSTU7624Engine.rotate(56, l6) ^ DSTU7624Engine.mulX(l9);
        l9 = DSTU7624Engine.mulX(l9) ^ l3;
        l9 = DSTU7624Engine.rotate(16, l6) ^ l3 ^ DSTU7624Engine.rotate(40, l9);
        l9 = l6 ^ l7 ^ DSTU7624Engine.mulX(l9);
        l4 = DSTU7624Engine.rotate(16, l4) ^ DSTU7624Engine.mulX(l9);
        l4 = l6 ^ DSTU7624Engine.rotate(24, l3) ^ l7 ^ l8 ^ DSTU7624Engine.mulX(l4);
        l3 = DSTU7624Engine.rotate(32, l6) ^ l3 ^ l8 ^ DSTU7624Engine.mulX(l4);
        return l5 ^ DSTU7624Engine.mulX(DSTU7624Engine.rotate(40, l3));
    }

    private void mixColumnsInv() {
        for (int i3 = 0; i3 < this.wordsInBlock; ++i3) {
            this.internalState[i3] = DSTU7624Engine.mixColumnInv(this.internalState[i3]);
        }
    }

    private static long mulX(long l3) {
        return (l3 & 0x7F7F7F7F7F7F7F7FL) << 1 ^ ((l3 & 0x8080808080808080L) >>> 7) * 29L;
    }

    private static long mulX2(long l3) {
        return (l3 & 0x3F3F3F3F3F3F3F3FL) << 2 ^ ((l3 & 0x8080808080808080L) >>> 6) * 29L ^ ((l3 & 0x4040404040404040L) >>> 6) * 29L;
    }

    private static long rotate(int n3, long l3) {
        return l3 >>> n3 | l3 << -n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rotateLeft(long[] lArray, long[] lArray2) {
        int n3 = this.wordsInBlock;
        if (n3 != 2) {
            if (n3 != 4) {
                if (n3 != 8) throw new IllegalStateException("unsupported block length: only 128/256/512 are allowed");
                long l3 = lArray[0];
                long l4 = lArray[1];
                long l5 = l3;
                long l6 = lArray[2];
                long l7 = lArray[3];
                long l8 = lArray[4];
                long l9 = lArray[5];
                long l10 = lArray[6];
                long l11 = lArray[7];
                long l12 = l7;
                lArray2[0] = l7 = l6 >>> 24 | l7 << 40;
                lArray2[1] = l7 = l12 >>> 24 | l8 << 40;
                lArray2[2] = l7 = l8 >>> 24 | l9 << 40;
                lArray2[3] = l7 = l9 >>> 24 | l10 << 40;
                lArray2[4] = l7 = l10 >>> 24 | l11 << 40;
                lArray2[5] = l3 = l11 >>> 24 | l3 << 40;
                lArray2[6] = l3 = l5 >>> 24 | l4 << 40;
                lArray2[7] = l6 = l4 >>> 24 | l6 << 40;
                return;
            } else {
                long l13 = lArray[0];
                long l14 = l13;
                long l15 = lArray[1];
                long l16 = lArray[2];
                long l17 = lArray[3];
                long l18 = l16;
                lArray2[0] = l16 = l15 >>> 24 | l16 << 40;
                lArray2[1] = l16 = l18 >>> 24 | l17 << 40;
                lArray2[2] = l14 = l17 >>> 24 | l14 << 40;
                lArray2[3] = l15 = l13 >>> 24 | l15 << 40;
            }
            return;
        } else {
            long l19 = lArray[0];
            long l20 = lArray[1];
            long l21 = l20;
            lArray2[0] = l21 = l19 >>> 56 | l21 << 8;
            lArray2[1] = l19 = l20 >>> 56 | l19 << 8;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            ((DSTU7624Engine)object).forEncryption = bl;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            int n3 = byArray.length << 3;
            int n4 = ((DSTU7624Engine)object).wordsInBlock << 6;
            if (n3 != 128 && n3 != 256 && n3 != 512) {
                throw new IllegalArgumentException("unsupported key length: only 128/256/512 are allowed");
            }
            if (n3 != n4 && n3 != n4 * 2) {
                throw new IllegalArgumentException("Unsupported key length");
            }
            if (n3 != 128) {
                if (n3 != 256) {
                    if (n3 == 512) {
                        ((DSTU7624Engine)object).roundsAmount = 18;
                    }
                } else {
                    ((DSTU7624Engine)object).roundsAmount = 14;
                }
            } else {
                ((DSTU7624Engine)object).roundsAmount = 10;
            }
            ((DSTU7624Engine)object).wordsInKey = n3 >>> 6;
            ((DSTU7624Engine)object).roundKeys = new long[((DSTU7624Engine)object).roundsAmount + 1][];
            n4 = 0;
            while (true) {
                long[][] lArray = ((DSTU7624Engine)object).roundKeys;
                if (n4 >= ((DSTU7624Engine)object).roundKeys.length) break;
                lArray[n4] = new long[((DSTU7624Engine)object).wordsInBlock];
                ++n4;
            }
            long[] lArray = new long[((DSTU7624Engine)object).wordsInKey];
            ((DSTU7624Engine)object).workingKey = lArray;
            if (byArray.length == n3 >>> 3) {
                DSTU7624Engine dSTU7624Engine = object;
                Pack.littleEndianToLong(byArray, 0, lArray);
                Object object = new long[dSTU7624Engine.wordsInBlock];
                dSTU7624Engine.workingKeyExpandKT(dSTU7624Engine.workingKey, (long[])object);
                dSTU7624Engine.workingKeyExpandEven(dSTU7624Engine.workingKey, (long[])object);
                dSTU7624Engine.workingKeyExpandOdd();
                return;
            }
            throw new IllegalArgumentException("Invalid key parameter passed to DSTU7624Engine init");
        }
        throw new IllegalArgumentException("Invalid parameter passed to DSTU7624Engine init");
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624";
    }

    @Override
    public int getBlockSize() {
        return this.wordsInBlock << 3;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.workingKey != null) {
            if (this.getBlockSize() + n3 <= byArray.length) {
                if (this.getBlockSize() + n4 <= byArray2.length) {
                    block11: {
                        if (this.forEncryption) {
                            if (this.wordsInBlock != 2) {
                                Pack.littleEndianToLong(byArray, n3, this.internalState);
                                this.addRoundKey(0);
                                int n5 = 0;
                                while (true) {
                                    DSTU7624Engine dSTU7624Engine = this;
                                    dSTU7624Engine.subBytes();
                                    dSTU7624Engine.shiftRows();
                                    dSTU7624Engine.mixColumns();
                                    n3 = this.roundsAmount;
                                    if (++n5 == n3) {
                                        DSTU7624Engine dSTU7624Engine2 = this;
                                        dSTU7624Engine2.addRoundKey(n3);
                                        Pack.longToLittleEndian(dSTU7624Engine2.internalState, byArray2, n4);
                                        break block11;
                                    }
                                    this.xorRoundKey(n5);
                                }
                            }
                            this.encryptBlock_128(byArray, n3, byArray2, n4);
                        } else {
                            if (this.wordsInBlock != 2) {
                                DSTU7624Engine dSTU7624Engine = this;
                                Pack.littleEndianToLong(byArray, n3, this.internalState);
                                dSTU7624Engine.subRoundKey(dSTU7624Engine.roundsAmount);
                                int n6 = dSTU7624Engine.roundsAmount;
                                while (true) {
                                    DSTU7624Engine dSTU7624Engine3 = this;
                                    dSTU7624Engine3.mixColumnsInv();
                                    dSTU7624Engine3.invShiftRows();
                                    dSTU7624Engine3.invSubBytes();
                                    if ((n6 += -1) == 0) {
                                        DSTU7624Engine dSTU7624Engine4 = this;
                                        dSTU7624Engine4.subRoundKey(0);
                                        Pack.longToLittleEndian(dSTU7624Engine4.internalState, byArray2, n4);
                                        break block11;
                                    }
                                    this.xorRoundKey(n6);
                                }
                            }
                            this.decryptBlock_128(byArray, n3, byArray2, n4);
                        }
                    }
                    return this.getBlockSize();
                }
                throw new OutputLengthException("Output buffer too short");
            }
            throw new DataLengthException("Input buffer too short");
        }
        throw new IllegalStateException("DSTU7624Engine not initialised");
    }

    @Override
    public void reset() {
        Arrays.fill(this.internalState, 0L);
    }
}

