/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DSTU7624Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.ArrayList;

public class DSTU7624WrapEngine
implements Wrapper {
    private static final int BYTES_IN_INTEGER = 4;
    private boolean forWrapping;
    private DSTU7624Engine engine;
    private byte[] B;
    private byte[] intArray;
    private byte[] checkSumArray;
    private byte[] zeroArray;
    private ArrayList<byte[]> Btemp;

    public DSTU7624WrapEngine(int n3) {
        DSTU7624Engine dSTU7624Engine;
        DSTU7624WrapEngine dSTU7624WrapEngine = dSTU7624Engine2;
        DSTU7624Engine dSTU7624Engine2 = dSTU7624Engine;
        dSTU7624WrapEngine.engine = new DSTU7624Engine(n3);
        dSTU7624WrapEngine.B = new byte[dSTU7624Engine2.getBlockSize() / 2];
        dSTU7624WrapEngine.checkSumArray = new byte[dSTU7624WrapEngine.engine.getBlockSize()];
        dSTU7624WrapEngine.zeroArray = new byte[dSTU7624WrapEngine.engine.getBlockSize()];
        dSTU7624WrapEngine.Btemp = new ArrayList();
        dSTU7624WrapEngine.intArray = new byte[4];
    }

    private void intToBytes(int n3, byte[] byArray, int n4) {
        int n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >> 24);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >> 16);
        n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >> 8);
        byArray[n4] = (byte)n3;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        this.forWrapping = bl;
        if (cipherParameters instanceof KeyParameter) {
            this.engine.init(bl, cipherParameters);
            return;
        }
        throw new IllegalArgumentException("invalid parameters passed to DSTU7624WrapEngine");
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624WrapEngine";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n3, int n4) {
        if (this.forWrapping) {
            if (n4 % this.engine.getBlockSize() == 0) {
                if (n3 + n4 <= byArray.length) {
                    int n5;
                    DSTU7624WrapEngine dSTU7624WrapEngine;
                    DSTU7624WrapEngine dSTU7624WrapEngine2 = this;
                    int n6 = (n4 / this.engine.getBlockSize() + 1) * 2;
                    int n7 = n6 - 1;
                    int n8 = n7 * 6;
                    int n9 = dSTU7624WrapEngine2.engine.getBlockSize() + n4;
                    byte[] byArray2 = new byte[n9];
                    DSTU7624WrapEngine dSTU7624WrapEngine3 = this;
                    System.arraycopy(byArray, n3, byArray2, 0, n4);
                    byArray = dSTU7624WrapEngine3.B;
                    n3 = dSTU7624WrapEngine3.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, 0, byArray, 0, n3);
                    this.Btemp.clear();
                    n3 = dSTU7624WrapEngine2.engine.getBlockSize() / 2;
                    for (n5 = n9 - (v730988).engine.getBlockSize() / 2; n5 != 0; n5 -= dSTU7624WrapEngine.engine.getBlockSize() / 2) {
                        dSTU7624WrapEngine = this;
                        DSTU7624WrapEngine dSTU7624WrapEngine4 = this;
                        byte[] byArray3 = new byte[dSTU7624WrapEngine4.engine.getBlockSize() / 2];
                        n4 = dSTU7624WrapEngine4.engine.getBlockSize() / 2;
                        System.arraycopy(byArray2, n3, byArray3, 0, n4);
                        dSTU7624WrapEngine.Btemp.add(byArray3);
                        n3 = this.engine.getBlockSize() / 2 + n3;
                    }
                    n5 = 0;
                    while (n5 < n8) {
                        DSTU7624WrapEngine dSTU7624WrapEngine5 = this;
                        n3 = this.engine.getBlockSize() / 2;
                        System.arraycopy(dSTU7624WrapEngine5.B, 0, byArray2, 0, n3);
                        DSTU7624WrapEngine dSTU7624WrapEngine6 = this;
                        n3 = dSTU7624WrapEngine6.engine.getBlockSize() / 2;
                        n4 = dSTU7624WrapEngine6.engine.getBlockSize() / 2;
                        System.arraycopy(dSTU7624WrapEngine5.Btemp.get(0), 0, byArray2, n3, n4);
                        dSTU7624WrapEngine5.engine.processBlock(byArray2, 0, byArray2, 0);
                        dSTU7624WrapEngine5.intToBytes(++n5, dSTU7624WrapEngine5.intArray, 0);
                        for (n3 = 0; n3 < 4; ++n3) {
                            n4 = this.engine.getBlockSize() / 2 + n3;
                            byArray2[n4] = (byte)(byArray2[n4] ^ this.intArray[n3]);
                        }
                        DSTU7624WrapEngine dSTU7624WrapEngine7 = this;
                        n3 = dSTU7624WrapEngine7.engine.getBlockSize() / 2;
                        byte[] byArray4 = dSTU7624WrapEngine7.B;
                        int n10 = n3;
                        n3 = this.engine.getBlockSize() / 2;
                        System.arraycopy(byArray2, n10, byArray4, 0, n3);
                        for (n3 = 2; n3 < n6; ++n3) {
                            DSTU7624WrapEngine dSTU7624WrapEngine8 = this;
                            byArray4 = dSTU7624WrapEngine8.Btemp.get(n3 - 2);
                            int n11 = dSTU7624WrapEngine8.engine.getBlockSize() / 2;
                            System.arraycopy(this.Btemp.get(n3 - 1), 0, byArray4, 0, n11);
                        }
                        DSTU7624WrapEngine dSTU7624WrapEngine9 = this;
                        byte[] byArray5 = dSTU7624WrapEngine9.Btemp.get(n6 - 2);
                        n4 = dSTU7624WrapEngine9.engine.getBlockSize() / 2;
                        System.arraycopy(byArray2, 0, byArray5, 0, n4);
                    }
                    DSTU7624WrapEngine dSTU7624WrapEngine10 = this;
                    n5 = this.engine.getBlockSize() / 2;
                    System.arraycopy(dSTU7624WrapEngine10.B, 0, byArray2, 0, n5);
                    n5 = dSTU7624WrapEngine10.engine.getBlockSize() / 2;
                    for (n3 = 0; n3 < n7; ++n3) {
                        DSTU7624WrapEngine dSTU7624WrapEngine11 = this;
                        n4 = this.engine.getBlockSize() / 2;
                        System.arraycopy(dSTU7624WrapEngine11.Btemp.get(n3), 0, byArray2, n5, n4);
                        n5 = dSTU7624WrapEngine11.engine.getBlockSize() / 2 + n5;
                    }
                    return byArray2;
                }
                throw new DataLengthException("input buffer too short");
            }
            throw new DataLengthException(b.a("wrap data must be a multiple of ").append(this.engine.getBlockSize()).append(" bytes").toString());
        }
        throw new IllegalStateException("not set for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n3, int n4) {
        if (!this.forWrapping) {
            if (n4 % this.engine.getBlockSize() == 0) {
                int n5;
                DSTU7624WrapEngine dSTU7624WrapEngine;
                int n6 = n4;
                int n7 = n6 * 2 / this.engine.getBlockSize();
                int n8 = n7 - 1;
                int n9 = n8 * 6;
                byte[] byArray2 = new byte[n6];
                DSTU7624WrapEngine dSTU7624WrapEngine2 = this;
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                byArray = new byte[dSTU7624WrapEngine2.engine.getBlockSize() / 2];
                n3 = dSTU7624WrapEngine2.engine.getBlockSize() / 2;
                System.arraycopy(byArray2, 0, byArray, 0, n3);
                this.Btemp.clear();
                int n10 = this.engine.getBlockSize() / 2;
                for (n3 = n4 - (v731274).engine.getBlockSize() / 2; n3 != 0; n3 -= dSTU7624WrapEngine.engine.getBlockSize() / 2) {
                    dSTU7624WrapEngine = this;
                    DSTU7624WrapEngine dSTU7624WrapEngine3 = this;
                    byte[] byArray3 = new byte[dSTU7624WrapEngine3.engine.getBlockSize() / 2];
                    n5 = dSTU7624WrapEngine3.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, n10, byArray3, 0, n5);
                    dSTU7624WrapEngine.Btemp.add(byArray3);
                    n10 = this.engine.getBlockSize() / 2 + n10;
                }
                for (n3 = 0; n3 < n9; ++n3) {
                    DSTU7624WrapEngine dSTU7624WrapEngine4 = this;
                    DSTU7624WrapEngine dSTU7624WrapEngine5 = this;
                    n10 = this.engine.getBlockSize() / 2;
                    System.arraycopy(dSTU7624WrapEngine5.Btemp.get(n7 - 2), 0, byArray2, 0, n10);
                    n10 = dSTU7624WrapEngine5.engine.getBlockSize() / 2;
                    n5 = dSTU7624WrapEngine5.engine.getBlockSize() / 2;
                    System.arraycopy(byArray, 0, byArray2, n10, n5);
                    n10 = n9 - n3;
                    dSTU7624WrapEngine4.intToBytes(n10, dSTU7624WrapEngine4.intArray, 0);
                    for (n10 = 0; n10 < 4; ++n10) {
                        n5 = this.engine.getBlockSize() / 2 + n10;
                        byArray2[n5] = (byte)(byArray2[n5] ^ this.intArray[n10]);
                    }
                    DSTU7624WrapEngine dSTU7624WrapEngine6 = this;
                    dSTU7624WrapEngine6.engine.processBlock(byArray2, 0, byArray2, 0);
                    n10 = dSTU7624WrapEngine6.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, 0, byArray, 0, n10);
                    for (n10 = 2; n10 < n7; ++n10) {
                        int n11 = n7 - n10;
                        DSTU7624WrapEngine dSTU7624WrapEngine7 = this;
                        byte[] byArray4 = dSTU7624WrapEngine7.Btemp.get(n11);
                        int n12 = dSTU7624WrapEngine7.engine.getBlockSize() / 2;
                        System.arraycopy(this.Btemp.get(n11 - 1), 0, byArray4, 0, n12);
                    }
                    DSTU7624WrapEngine dSTU7624WrapEngine8 = this;
                    byte[] byArray5 = dSTU7624WrapEngine8.Btemp.get(0);
                    n5 = dSTU7624WrapEngine8.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, this.engine.getBlockSize() / 2, byArray5, 0, n5);
                }
                int n13 = this.engine.getBlockSize() / 2;
                System.arraycopy(byArray, 0, byArray2, 0, n13);
                n13 = this.engine.getBlockSize() / 2;
                for (n3 = 0; n3 < n8; ++n3) {
                    DSTU7624WrapEngine dSTU7624WrapEngine9 = this;
                    n7 = this.engine.getBlockSize() / 2;
                    System.arraycopy(dSTU7624WrapEngine9.Btemp.get(n3), 0, byArray2, n13, n7);
                    n13 = dSTU7624WrapEngine9.engine.getBlockSize() / 2 + n13;
                }
                n13 = n4 - this.engine.getBlockSize();
                byte[] byArray6 = this.checkSumArray;
                int n14 = n13;
                n13 = this.engine.getBlockSize();
                System.arraycopy(byArray2, n14, byArray6, 0, n13);
                byte[] byArray7 = new byte[n4 - this.engine.getBlockSize()];
                if (Arrays.areEqual(this.checkSumArray, this.zeroArray)) {
                    int n15 = n4 - this.engine.getBlockSize();
                    System.arraycopy(byArray2, 0, byArray7, 0, n15);
                    return byArray7;
                }
                throw new InvalidCipherTextException("checksum failed");
            }
            throw new DataLengthException(b.a("unwrap data must be a multiple of ").append(this.engine.getBlockSize()).append(" bytes").toString());
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

