/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DigestDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.EphemeralKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.IESParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.IESWithCipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ISO18033KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class EthereumIESEngine {
    public BasicAgreement agree;
    public DerivationFunction kdf;
    public Mac mac;
    public BufferedBlockCipher cipher;
    public byte[] macBuf;
    public byte[] commonMac;
    public boolean forEncryption;
    public CipherParameters privParam;
    public CipherParameters pubParam;
    public IESParameters param;
    public byte[] V;
    private EphemeralKeyPairGenerator keyPairGenerator;
    private KeyParser keyParser;
    private byte[] IV;

    public EthereumIESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac, byte[] byArray) {
        EthereumIESEngine ethereumIESEngine = this;
        this.agree = basicAgreement;
        this.kdf = derivationFunction;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        ethereumIESEngine.commonMac = byArray;
        ethereumIESEngine.cipher = null;
    }

    public EthereumIESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac, byte[] byArray, BufferedBlockCipher bufferedBlockCipher) {
        this.agree = basicAgreement;
        this.kdf = derivationFunction;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.commonMac = byArray;
        this.cipher = bufferedBlockCipher;
    }

    private void extractParams(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            EthereumIESEngine ethereumIESEngine = parametersWithIV;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            ethereumIESEngine.IV = parametersWithIV.getIV();
            ethereumIESEngine.param = (IESParameters)parametersWithIV.getParameters();
        } else {
            ((EthereumIESEngine)((Object)parametersWithIV)).IV = null;
            ((EthereumIESEngine)((Object)parametersWithIV)).param = (IESParameters)cipherParameters;
        }
    }

    private byte[] encryptBlock(byte[] byArray, int n3, int n4) {
        SHA256Digest sHA256Digest;
        byte[] byArray2;
        Object object;
        byte[] byArray3;
        Object object2;
        if (this.cipher == null) {
            EthereumIESEngine ethereumIESEngine = this;
            object2 = new byte[n4];
            int n5 = this.param.getMacKeySize() / 8;
            byArray3 = new byte[n5];
            int n6 = n4 + n5;
            object = new byte[n6];
            ethereumIESEngine.kdf.generateBytes((byte[])object, 0, n6);
            if (ethereumIESEngine.V.length != 0) {
                System.arraycopy(object, 0, byArray3, 0, n5);
                System.arraycopy(object, n5, object2, 0, n4);
            } else {
                System.arraycopy(object, 0, object2, 0, n4);
                System.arraycopy(object, n4, byArray3, 0, n5);
            }
            byArray2 = new byte[n4];
            for (n6 = 0; n6 != n4; ++n6) {
                byArray2[n6] = (byte)(byArray[n3 + n6] ^ object2[n6]);
            }
        } else {
            EthereumIESEngine ethereumIESEngine = this;
            int n7 = ((IESWithCipherParameters)ethereumIESEngine.param).getCipherKeySize() / 8;
            byArray2 = new byte[n7];
            int n8 = this.param.getMacKeySize() / 8;
            byte[] byArray4 = new byte[n8];
            int n9 = n7 + n8;
            byte[] byArray5 = new byte[n9];
            this.kdf.generateBytes(byArray5, 0, n9);
            System.arraycopy(byArray5, 0, byArray2, 0, n7);
            System.arraycopy(byArray5, n7, byArray4, 0, n8);
            if (ethereumIESEngine.IV != null) {
                KeyParameter keyParameter;
                ParametersWithIV parametersWithIV;
                object2 = parametersWithIV;
                KeyParameter keyParameter2 = keyParameter;
                keyParameter = new KeyParameter(byArray2);
                parametersWithIV = new ParametersWithIV(keyParameter2, this.IV);
                this.cipher.init(true, (CipherParameters)object2);
            } else {
                KeyParameter keyParameter;
                object2 = keyParameter;
                keyParameter = new KeyParameter(byArray2);
                this.cipher.init(true, (CipherParameters)object2);
            }
            EthereumIESEngine ethereumIESEngine2 = this;
            byArray2 = new byte[ethereumIESEngine2.cipher.getOutputSize(n4)];
            int n10 = ethereumIESEngine2.cipher.processBytes(byArray, n3, n4, byArray2, 0);
            n4 = ethereumIESEngine2.cipher.doFinal(byArray2, n10) + n10;
            byArray3 = byArray4;
        }
        EthereumIESEngine ethereumIESEngine = this;
        byArray = ethereumIESEngine.param.getEncodingV();
        byte[] byArray6 = null;
        if (ethereumIESEngine.V.length != 0) {
            byArray6 = this.getLengthTag(byArray);
        }
        EthereumIESEngine ethereumIESEngine3 = this;
        int n11 = ethereumIESEngine3.mac.getMacSize();
        byte[] byArray7 = new byte[n11];
        Object object3 = object = (Object)sHA256Digest;
        ((SHA256Digest)object3)();
        byArray3 = new byte[object3.getDigestSize()];
        object3.reset();
        sHA256Digest.update(byArray3, 0, byArray3.length);
        sHA256Digest.doFinal(byArray3, 0);
        ethereumIESEngine3.mac.init(new KeyParameter(byArray3));
        ethereumIESEngine3.mac.update(this.IV, 0, this.IV.length);
        ethereumIESEngine3.mac.update(byArray2, 0, byArray2.length);
        if (byArray != null) {
            this.mac.update(byArray, 0, byArray.length);
        }
        if (this.V.length != 0) {
            this.mac.update(byArray6, 0, byArray6.length);
        }
        EthereumIESEngine ethereumIESEngine4 = this;
        ethereumIESEngine4.mac.update(this.commonMac, 0, this.commonMac.length);
        ethereumIESEngine4.mac.doFinal(byArray7, 0);
        byArray = ethereumIESEngine4.V;
        byArray6 = new byte[ethereumIESEngine4.V.length + n4 + n11];
        int n12 = byArray.length;
        System.arraycopy(byArray, 0, byArray6, 0, n12);
        n12 = this.V.length;
        System.arraycopy(byArray2, 0, byArray6, n12, n4);
        n12 = this.V.length + n4;
        System.arraycopy(byArray7, 0, byArray6, n12, n11);
        return byArray6;
    }

    private byte[] decryptBlock(byte[] byArray, int n3, int n4) {
        EthereumIESEngine ethereumIESEngine = bufferedBlockCipher;
        int n5 = 0;
        int n6 = ethereumIESEngine.V.length;
        if (n4 >= ethereumIESEngine.mac.getMacSize() + n6) {
            SHA256Digest sHA256Digest;
            SHA256Digest sHA256Digest2;
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            if (((EthereumIESEngine)((Object)bufferedBlockCipher)).cipher == null) {
                EthereumIESEngine ethereumIESEngine2 = bufferedBlockCipher;
                n6 = n4 - ((EthereumIESEngine)((Object)bufferedBlockCipher)).V.length - ((EthereumIESEngine)((Object)bufferedBlockCipher)).mac.getMacSize();
                byArray4 = new byte[n6];
                int n7 = ((EthereumIESEngine)((Object)bufferedBlockCipher)).param.getMacKeySize() / 8;
                byArray3 = new byte[n7];
                int n8 = n6 + n7;
                byte[] byArray5 = new byte[n8];
                ethereumIESEngine2.kdf.generateBytes(byArray5, 0, n8);
                if (ethereumIESEngine2.V.length != 0) {
                    System.arraycopy(byArray5, 0, byArray3, 0, n7);
                    System.arraycopy(byArray5, n7, byArray4, 0, n6);
                } else {
                    System.arraycopy(byArray5, 0, byArray4, 0, n6);
                    System.arraycopy(byArray5, n6, byArray3, 0, n7);
                }
                byArray2 = new byte[n6];
                for (n8 = 0; n8 != n6; ++n8) {
                    byArray2[n8] = (byte)(byArray[n3 + ((EthereumIESEngine)((Object)bufferedBlockCipher)).V.length + n8] ^ byArray4[n8]);
                }
            } else {
                KeyParameter keyParameter;
                EthereumIESEngine ethereumIESEngine3 = bufferedBlockCipher;
                n5 = ((IESWithCipherParameters)ethereumIESEngine3.param).getCipherKeySize() / 8;
                byte[] byArray6 = new byte[n5];
                int n9 = ((EthereumIESEngine)((Object)bufferedBlockCipher)).param.getMacKeySize() / 8;
                byArray3 = new byte[n9];
                int n10 = n5 + n9;
                byte[] byArray7 = new byte[n10];
                ((EthereumIESEngine)((Object)bufferedBlockCipher)).kdf.generateBytes(byArray7, 0, n10);
                System.arraycopy(byArray7, 0, byArray6, 0, n5);
                System.arraycopy(byArray7, n5, byArray3, 0, n9);
                Object object = keyParameter;
                keyParameter = new KeyParameter(byArray6);
                byArray6 = ethereumIESEngine3.IV;
                if (ethereumIESEngine3.IV != null) {
                    ParametersWithIV parametersWithIV;
                    ParametersWithIV parametersWithIV2 = parametersWithIV;
                    parametersWithIV = new ParametersWithIV((CipherParameters)object, byArray6);
                    object = parametersWithIV2;
                }
                EthereumIESEngine ethereumIESEngine4 = bufferedBlockCipher;
                ethereumIESEngine4.cipher.init(false, (CipherParameters)object);
                byArray2 = new byte[ethereumIESEngine4.cipher.getOutputSize(n4 - ((EthereumIESEngine)((Object)bufferedBlockCipher)).V.length - ((EthereumIESEngine)((Object)bufferedBlockCipher)).mac.getMacSize())];
                object = ((EthereumIESEngine)((Object)bufferedBlockCipher)).V;
                n6 = n3 + ((EthereumIESEngine)((Object)bufferedBlockCipher)).V.length;
                n5 = ethereumIESEngine4.cipher.processBytes(byArray, n6, n4 - ((Object)object).length - ((EthereumIESEngine)((Object)bufferedBlockCipher)).mac.getMacSize(), byArray2, 0);
            }
            EthereumIESEngine ethereumIESEngine5 = bufferedBlockCipher;
            byte[] byArray8 = ethereumIESEngine5.param.getEncodingV();
            byArray4 = null;
            if (ethereumIESEngine5.V.length != 0) {
                byArray4 = ((EthereumIESEngine)((Object)bufferedBlockCipher)).getLengthTag(byArray8);
            }
            EthereumIESEngine ethereumIESEngine6 = bufferedBlockCipher;
            int n11 = n3 + n4;
            byte[] byArray9 = Arrays.copyOfRange(byArray, n11 - ((EthereumIESEngine)((Object)bufferedBlockCipher)).mac.getMacSize(), n11);
            int n12 = byArray9.length;
            byte[] byArray10 = new byte[n12];
            SHA256Digest sHA256Digest3 = sHA256Digest2 = sHA256Digest;
            sHA256Digest3();
            byArray3 = new byte[sHA256Digest3.getDigestSize()];
            sHA256Digest3.reset();
            sHA256Digest.update(byArray3, 0, byArray3.length);
            sHA256Digest.doFinal(byArray3, 0);
            ethereumIESEngine6.mac.init(new KeyParameter(byArray3));
            ethereumIESEngine6.mac.update(((EthereumIESEngine)((Object)bufferedBlockCipher)).IV, 0, ((EthereumIESEngine)((Object)bufferedBlockCipher)).IV.length);
            byte[] byArray11 = byArray;
            byArray = ((EthereumIESEngine)((Object)bufferedBlockCipher)).V;
            ethereumIESEngine6.mac.update(byArray11, n3 += ((EthereumIESEngine)((Object)bufferedBlockCipher)).V.length, n4 - byArray.length - n12);
            if (byArray8 != null) {
                ((EthereumIESEngine)((Object)bufferedBlockCipher)).mac.update(byArray8, 0, byArray8.length);
            }
            if (((EthereumIESEngine)((Object)bufferedBlockCipher)).V.length != 0) {
                ((EthereumIESEngine)((Object)bufferedBlockCipher)).mac.update(byArray4, 0, byArray4.length);
            }
            EthereumIESEngine ethereumIESEngine7 = bufferedBlockCipher;
            ethereumIESEngine7.mac.update(((EthereumIESEngine)((Object)bufferedBlockCipher)).commonMac, 0, ((EthereumIESEngine)((Object)bufferedBlockCipher)).commonMac.length);
            ethereumIESEngine7.mac.doFinal(byArray10, 0);
            if (Arrays.constantTimeAreEqual(byArray9, byArray10)) {
                BufferedBlockCipher bufferedBlockCipher = ((EthereumIESEngine)((Object)bufferedBlockCipher)).cipher;
                if (bufferedBlockCipher == null) {
                    return byArray2;
                }
                return Arrays.copyOfRange(byArray2, 0, bufferedBlockCipher.doFinal(byArray2, n5) + n5);
            }
            throw new InvalidCipherTextException("invalid MAC");
        }
        throw new InvalidCipherTextException("length of input must be greater than the MAC and V combined");
    }

    public void init(boolean bl, CipherParameters cipherParameters, CipherParameters cipherParameters2, CipherParameters cipherParameters3) {
        EthereumIESEngine ethereumIESEngine = this;
        this.forEncryption = bl;
        this.privParam = cipherParameters;
        ethereumIESEngine.pubParam = cipherParameters2;
        ethereumIESEngine.V = new byte[0];
        this.extractParams(cipherParameters3);
    }

    public void init(AsymmetricKeyParameter asymmetricKeyParameter, CipherParameters cipherParameters, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.forEncryption = true;
        this.pubParam = asymmetricKeyParameter;
        this.keyPairGenerator = ephemeralKeyPairGenerator;
        this.extractParams(cipherParameters);
    }

    public void init(AsymmetricKeyParameter asymmetricKeyParameter, CipherParameters cipherParameters, KeyParser keyParser) {
        this.forEncryption = false;
        this.privParam = asymmetricKeyParameter;
        this.keyParser = keyParser;
        this.extractParams(cipherParameters);
    }

    public BufferedBlockCipher getCipher() {
        return this.cipher;
    }

    public Mac getMac() {
        return this.mac;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] processBlock(byte[] byArray, int n3, int n4) {
        KDFParameters kDFParameters;
        EthereumIESEngine ethereumIESEngine;
        EthereumIESEngine ethereumIESEngine2;
        Object object;
        if (((EthereumIESEngine)object3).forEncryption) {
            object = ((EthereumIESEngine)object3).keyPairGenerator;
            if (object != null) {
                EthereumIESEngine ethereumIESEngine3 = object3;
                object = ((EphemeralKeyPairGenerator)object).generate();
                ethereumIESEngine3.privParam = ((EphemeralKeyPair)object).getKeyPair().getPrivate();
                ethereumIESEngine3.V = ((EphemeralKeyPair)object).getEncodedPublicKey();
            }
        } else if (((EthereumIESEngine)object3).keyParser != null) {
            ByteArrayInputStream byteArrayInputStream;
            object = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(byArray, n3, n4);
            try {
                ((EthereumIESEngine)object3).pubParam = ((EthereumIESEngine)object3).keyParser.readKey((InputStream)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidCipherTextException(b.b.a("unable to recover ephemeral public key: ").append(illegalArgumentException.getMessage()).toString(), illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new InvalidCipherTextException(b.a(iOException, b.b.a("unable to recover ephemeral public key: ")), iOException);
            }
            ((EthereumIESEngine)object3).V = Arrays.copyOfRange(byArray, n3, n4 - ((ByteArrayInputStream)object).available() + n3);
        }
        EthereumIESEngine ethereumIESEngine4 = object3;
        ethereumIESEngine4.agree.init(((EthereumIESEngine)object3).privParam);
        object = ethereumIESEngine4.agree.calculateAgreement(((EthereumIESEngine)object3).pubParam);
        object = BigIntegers.asUnsignedByteArray(ethereumIESEngine4.agree.getFieldSize(), (BigInteger)object);
        byte[] byArray2 = ethereumIESEngine4.V;
        if (ethereumIESEngine4.V.length != 0) {
            Object object2 = object;
            object = Arrays.concatenate(byArray2, (byte[])object);
            Arrays.fill((byte[])object2, (byte)0);
        }
        try {
            EthereumIESEngine ethereumIESEngine5 = object3;
            ethereumIESEngine2 = ethereumIESEngine5;
            ethereumIESEngine = ethereumIESEngine5;
        }
        catch (Throwable throwable) {
            Arrays.fill((byte[])object, (byte)0);
            throw throwable;
        }
        KDFParameters kDFParameters2 = kDFParameters;
        {
            kDFParameters = new KDFParameters((byte[])object, ((EthereumIESEngine)object3).param.getDerivationV());
            ethereumIESEngine2.kdf.init(kDFParameters2);
            Object object3 = ethereumIESEngine.forEncryption ? ((EthereumIESEngine)object3).encryptBlock(byArray, n3, n4) : ((EthereumIESEngine)object3).decryptBlock(byArray, n3, n4);
        }
        Arrays.fill((byte[])object, (byte)0);
        return object3;
    }

    public byte[] getLengthTag(byte[] byArray) {
        Object object = new byte[8];
        if (byArray != null) {
            Pack.longToBigEndian((long)byArray.length * 8L, (byte[])object, 0);
        }
        return object;
    }

    public static class HandshakeKDFFunction
    implements DigestDerivationFunction {
        private int counterStart;
        private Digest digest;
        private byte[] shared;
        private byte[] iv;

        public HandshakeKDFFunction(int n3, Digest digest) {
            this.counterStart = n3;
            this.digest = digest;
        }

        @Override
        public void init(DerivationParameters derivationParameters) {
            block4: {
                block3: {
                    block2: {
                        if (!(derivationParameters instanceof KDFParameters)) break block2;
                        HandshakeKDFFunction handshakeKDFFunction = kDFParameters;
                        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
                        handshakeKDFFunction.shared = kDFParameters.getSharedSecret();
                        handshakeKDFFunction.iv = kDFParameters.getIV();
                        break block3;
                    }
                    if (!(derivationParameters instanceof ISO18033KDFParameters)) break block4;
                    HandshakeKDFFunction handshakeKDFFunction = kDFParameters;
                    handshakeKDFFunction.shared = ((ISO18033KDFParameters)derivationParameters).getSeed();
                    handshakeKDFFunction.iv = null;
                }
                return;
            }
            throw new IllegalArgumentException("KDF parameters required for generator");
        }

        @Override
        public Digest getDigest() {
            return this.digest;
        }

        @Override
        public int generateBytes(byte[] byArray, int n3, int n4) {
            if (byArray.length - n4 >= n3) {
                long l3 = n4;
                int n5 = this.digest.getDigestSize();
                if (l3 <= 0x1FFFFFFFFL) {
                    HandshakeKDFFunction handshakeKDFFunction = this;
                    long l4 = n5;
                    int n6 = (int)((l3 + l4 - 1L) / l4);
                    byte[] byArray2 = new byte[handshakeKDFFunction.digest.getDigestSize()];
                    int n7 = 4;
                    byte[] byArray3 = new byte[4];
                    Pack.intToBigEndian(handshakeKDFFunction.counterStart, byArray3, 0);
                    int n8 = handshakeKDFFunction.counterStart & 0xFFFFFF00;
                    for (int i3 = 0; i3 < n6; ++i3) {
                        byte by;
                        HandshakeKDFFunction handshakeKDFFunction2 = this;
                        handshakeKDFFunction2.digest.update(byArray3, 0, n7);
                        handshakeKDFFunction2.digest.update(this.shared, 0, this.shared.length);
                        byte[] byArray4 = handshakeKDFFunction2.iv;
                        if (handshakeKDFFunction2.iv != null) {
                            this.digest.update(byArray4, 0, byArray4.length);
                        }
                        this.digest.doFinal(byArray2, 0);
                        if (n4 > n5) {
                            System.arraycopy(byArray2, 0, byArray, n3, n5);
                            n3 += n5;
                            n4 -= n5;
                        } else {
                            System.arraycopy(byArray2, 0, byArray, n3, n4);
                        }
                        byArray3[3] = by = (byte)(byArray3[3] + 1);
                        if (by != 0) continue;
                        Pack.intToBigEndian(n8 += 256, byArray3, 0);
                    }
                    this.digest.reset();
                    return (int)l3;
                }
                throw new IllegalArgumentException("output length too large");
            }
            throw new OutputLengthException("output buffer too small");
        }
    }
}

