/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class Grain128Engine
implements StreamCipher {
    private static final int STATE_SIZE = 4;
    private byte[] workingKey;
    private byte[] workingIV;
    private byte[] out;
    private int[] lfsr;
    private int[] nfsr;
    private int output;
    private int index = 4;
    private boolean initialised = false;

    private void initGrain() {
        for (int i3 = 0; i3 < 8; ++i3) {
            Grain128Engine grain128Engine = this;
            grain128Engine.output = grain128Engine.getOutput();
            grain128Engine.nfsr = grain128Engine.shift(grain128Engine.nfsr, this.getOutputNFSR() ^ this.lfsr[0] ^ this.output);
            grain128Engine.lfsr = grain128Engine.shift(grain128Engine.lfsr, this.getOutputLFSR() ^ this.output);
        }
        this.initialised = true;
    }

    private int getOutputNFSR() {
        Object object = ((Grain128Engine)object).nfsr;
        int n3 = ((Grain128Engine)object).nfsr[0];
        int n4 = n3;
        Object object2 = object;
        int n5 = n4 >>> 3;
        Object object3 = object2[1];
        int n6 = n4;
        n4 = n5 | object3 << 29;
        n5 = n6 >>> 11 | object3 << 21;
        int n7 = n6 >>> 13 | object3 << 19;
        int n8 = n6 >>> 17 | object3 << 15;
        int n9 = n6 >>> 18 | object3 << 14;
        int n10 = n6 >>> 26 | object3 << 6;
        int n11 = n6 >>> 27 | object3 << 5;
        Object object4 = object3 >>> 8;
        Object object5 = object2[2];
        int n12 = n10;
        Object object6 = object5;
        Object object7 = object3;
        object3 = object4 | object5 << 24;
        n10 = object7 >>> 16 | object5 << 16;
        object4 = object7 >>> 24 | object5 << 8;
        int n13 = object7 >>> 27 | object5 << 5;
        object5 = object7 >>> 29 | object5 << 3;
        Object object8 = object[3];
        int n14 = object6 >>> 1 | object8 << 31;
        int n15 = object6 >>> 3 | object8 << 29;
        int n16 = object6 >>> 4 | object8 << 28;
        int n17 = object6 >>> 20 | object8 << 12;
        int n18 = object6 >>> 27 | object8 << 5;
        return n3 ^ n12 ^ object4 ^ n18 ^ object8 ^ n4 & n15 ^ n5 & n7 ^ n8 & n9 ^ n11 & n13 ^ object3 & n10 ^ object5 & n14 ^ n16 & n17;
    }

    private int getOutputLFSR() {
        Object object = ((Grain128Engine)object).lfsr;
        int n3 = ((Grain128Engine)object).lfsr[0];
        int n4 = n3;
        Object object2 = object;
        n4 >>>= 7;
        Object object3 = object2[1];
        Object object4 = object3 >>> 6;
        Object object5 = object2[2];
        int n5 = n4 |= object3 << 25;
        Object object6 = object5;
        n4 = object4 | object5 << 26;
        Object object7 = object[3];
        object4 = object6 >>> 6 | object7 << 26;
        object5 = object6 >>> 17 | object7 << 15;
        return n3 ^ n5 ^ n4 ^ object4 ^ object5 ^ object7;
    }

    private int getOutput() {
        int[] nArray = this.nfsr;
        int n3 = this.nfsr[0];
        int n4 = nArray[1];
        int n5 = n3 >>> 2 | n4 << 30;
        int n6 = n3 >>> 12 | n4 << 20;
        int n7 = n3 >>> 15 | n4 << 17;
        n3 = n4 >>> 4;
        int n8 = nArray[2];
        n3 |= n8 << 28;
        n4 = n4 >>> 13 | n8 << 19;
        int n9 = nArray[3];
        int n10 = n8 >>> 9 | n9 << 23;
        int n11 = n8 >>> 25 | n9 << 7;
        n9 = n8 >>> 31 | n9 << 1;
        int[] nArray2 = this.lfsr;
        int n12 = this.lfsr[0];
        int n13 = n12 >>> 8;
        int n14 = nArray2[1];
        int n15 = n12;
        n12 = n13 | n14 << 24;
        n13 = n15 >>> 13 | n14 << 19;
        int n16 = n15 >>> 20 | n14 << 12;
        int n17 = n14 >>> 10;
        int n18 = this.lfsr[2];
        int n19 = n12;
        int n20 = n18;
        n12 = n17 | n18 << 22;
        n14 = n14 >>> 28 | n18 << 4;
        int n21 = nArray2[3];
        n17 = n20 >>> 15 | n21 << 17;
        n18 = n20 >>> 29 | n21 << 3;
        n21 = n20 >>> 31 | n21 << 1;
        return n6 & n19 ^ n13 & n16 ^ n9 & n12 ^ n14 & n17 ^ n6 & n9 & n21 ^ n18 ^ n5 ^ n7 ^ n3 ^ n4 ^ n8 ^ n10 ^ n11;
    }

    private int[] shift(int[] nArray, int n3) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray3[0] = nArray2[1];
        nArray3[1] = nArray2[2];
        nArray3[2] = nArray2[3];
        nArray2[3] = n3;
        return nArray3;
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        Grain128Engine grain128Engine = this;
        byte[] byArray3 = byArray2;
        byte[] byArray4 = byArray2;
        byArray3[12] = -1;
        byArray4[13] = -1;
        byArray3[14] = -1;
        byArray4[15] = -1;
        grain128Engine.workingKey = byArray;
        grain128Engine.workingIV = byArray2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            Object[] objectArray = this.nfsr;
            if (n4 >= this.nfsr.length) break;
            int[] nArray = objectArray;
            objectArray = this.workingKey;
            int n5 = n3 + 3;
            int n6 = n3 + 2;
            int n7 = n3 + 1;
            nArray[n4] = this.workingKey[n5] << 24 | objectArray[n6] << 16 & 0xFF0000 | objectArray[n7] << 8 & 0xFF00 | objectArray[n3] & 0xFF;
            objectArray = this.workingIV;
            this.lfsr[n4] = this.workingIV[n5] << 24 | objectArray[n6] << 16 & 0xFF0000 | objectArray[n7] << 8 & 0xFF00 | objectArray[n3] & 0xFF;
            n3 += 4;
            ++n4;
        }
    }

    private void oneRound() {
        int n3;
        Grain128Engine grain128Engine = object;
        grain128Engine.output = n3 = grain128Engine.getOutput();
        byte[] byArray = grain128Engine.out;
        byArray[0] = (byte)n3;
        byArray[1] = (byte)(n3 >> 8);
        byArray[2] = (byte)(n3 >> 16);
        grain128Engine.out[3] = (byte)(n3 >> 24);
        grain128Engine.nfsr = grain128Engine.shift(grain128Engine.nfsr, ((Grain128Engine)object).getOutputNFSR() ^ ((Grain128Engine)object).lfsr[0]);
        Object object = grain128Engine.lfsr;
        grain128Engine.lfsr = grain128Engine.shift((int[])object, grain128Engine.getOutputLFSR());
    }

    private byte getKeyStream() {
        if (this.index > 3) {
            this.oneRound();
            this.index = 0;
        }
        int n3 = this.index;
        this.index = n3 + 1;
        return this.out[n3];
    }

    @Override
    public String getAlgorithmName() {
        return "Grain-128";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            CipherParameters cipherParameters = (ParametersWithIV)object;
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            object = byArray;
            if (byArray != null && ((Object)object).length == 12) {
                if (((ParametersWithIV)cipherParameters).getParameters() instanceof KeyParameter) {
                    Grain128Engine grain128Engine = object3;
                    Object object2 = object;
                    cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    ((Grain128Engine)object3).workingIV = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grain128Engine)object3).workingKey = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grain128Engine)object3).lfsr = new int[4];
                    ((Grain128Engine)object3).nfsr = new int[4];
                    ((Grain128Engine)object3).out = new byte[4];
                    object = ((Grain128Engine)object3).workingIV;
                    int n3 = ((Object)object2).length;
                    System.arraycopy(object2, 0, object, 0, n3);
                    Object object3 = ((Grain128Engine)object3).workingKey;
                    int n4 = ((KeyParameter)cipherParameters).getKey().length;
                    System.arraycopy(((KeyParameter)cipherParameters).getKey(), 0, object3, 0, n4);
                    grain128Engine.reset();
                    return;
                }
                throw new IllegalArgumentException("Grain-128 Init parameters must include a key");
            }
            throw new IllegalArgumentException("Grain-128  requires exactly 12 bytes of IV");
        }
        throw new IllegalArgumentException("Grain-128 Init parameters must include an IV");
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.initialised) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n6 = n5 + i3;
                        byArray2[n6] = (byte)(byArray[n3 + i3] ^ this.getKeyStream());
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        Grain128Engine grain128Engine = object;
        grain128Engine.index = 4;
        Object object = grain128Engine.workingKey;
        grain128Engine.setKey((byte[])object, grain128Engine.workingIV);
        grain128Engine.initGrain();
    }

    @Override
    public byte returnByte(byte by) {
        if (this.initialised) {
            return (byte)(by ^ this.getKeyStream());
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }
}

