/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class Grainv1Engine
implements StreamCipher {
    private static final int STATE_SIZE = 5;
    private byte[] workingKey;
    private byte[] workingIV;
    private byte[] out;
    private int[] lfsr;
    private int[] nfsr;
    private int output;
    private int index = 2;
    private boolean initialised = false;

    private void initGrain() {
        for (int i3 = 0; i3 < 10; ++i3) {
            Grainv1Engine grainv1Engine = this;
            grainv1Engine.output = grainv1Engine.getOutput();
            grainv1Engine.nfsr = grainv1Engine.shift(grainv1Engine.nfsr, this.getOutputNFSR() ^ this.lfsr[0] ^ this.output);
            grainv1Engine.lfsr = grainv1Engine.shift(grainv1Engine.lfsr, this.getOutputLFSR() ^ this.output);
        }
        this.initialised = true;
    }

    private int getOutputNFSR() {
        Object object = ((Grainv1Engine)object).nfsr;
        int n3 = ((Grainv1Engine)object).nfsr[0];
        int n4 = n3 >>> 9;
        int n5 = ((Grainv1Engine)object).nfsr[1];
        int n6 = n3;
        n4 |= n5 << 7;
        int n7 = n6 >>> 14 | n5 << 2;
        int n8 = n6 >>> 15 | n5 << 1;
        int n9 = n5 >>> 5;
        int n10 = ((Grainv1Engine)object).nfsr[2];
        int n11 = n5;
        n5 = n9 | n10 << 11;
        n9 = n11 >>> 12 | n10 << 4;
        int n12 = n10 >>> 1;
        int n13 = ((Grainv1Engine)object).nfsr[3];
        int n14 = n10;
        n10 = n12 | n13 << 15;
        n12 = n14 >>> 5 | n13 << 11;
        int n15 = n14 >>> 13 | n13 << 3;
        Object object2 = object[4];
        int n16 = n13 >>> 4 | object2 << 12;
        int n17 = n13 >>> 12 | object2 << 4;
        int n18 = n13 >>> 14 | object2 << 2;
        object2 = n13 >>> 15 | object2 << 1;
        int n19 = n18 ^ n17 ^ n16 ^ n15 ^ n12 ^ n10 ^ n9 ^ n5 ^ n7 ^ n4 ^ n3;
        n3 = object2 & n17;
        n7 = n17 & n16;
        n13 = n10 & n9 & n5;
        return (n19 ^ n3 ^ n12 & n10 ^ n8 & n4 ^ n7 & n15 ^ n13 ^ object2 & n15 & n9 & n4 ^ n7 & n12 & n10 ^ n3 & n5 & n8 ^ n3 & n16 & n15 & n12 ^ n13 & n8 & n4 ^ n16 & n15 & n12 & n10 & n9 & n5) & 0xFFFF;
    }

    private int getOutputLFSR() {
        Object object = ((Grainv1Engine)object).lfsr;
        int n3 = ((Grainv1Engine)object).lfsr[0];
        int n4 = n3;
        Object object2 = object;
        n4 >>>= 13;
        Object object3 = object2[1];
        n4 |= object3 << 3;
        Object object4 = object3 >>> 7;
        Object object5 = object2[2];
        object4 = object4 | object5 << 9;
        Object object6 = object5 >>> 6;
        Object object7 = object2[3];
        int n5 = n4;
        Object object8 = object7;
        n4 = object6 | object7 << 10;
        Object object9 = object[4];
        object6 = object8 >>> 3 | object9 << 13;
        object9 = object8 >>> 14 | object9 << 2;
        return (n3 ^ n5 ^ object4 ^ n4 ^ object6 ^ object9) & 0xFFFF;
    }

    private int getOutput() {
        Grainv1Engine grainv1Engine = object;
        Object object = grainv1Engine.nfsr;
        int n3 = grainv1Engine.nfsr[0];
        int n4 = n3 >>> 1;
        int n5 = grainv1Engine.nfsr[1];
        int n6 = n5;
        int n7 = n3;
        n3 = n4 | n6 << 15;
        n4 = n7 >>> 2 | n6 << 14;
        int n8 = n7 >>> 4 | n6 << 12;
        n6 = n7 >>> 10 | n6 << 6;
        int n9 = n5 >>> 15;
        int n10 = grainv1Engine.nfsr[2];
        n9 |= n10 << 1;
        int n11 = n10 >>> 11;
        int n12 = grainv1Engine.nfsr[3];
        n11 |= n12 << 5;
        Object object2 = object[4];
        int n13 = n12 >>> 8 | object2 << 8;
        object2 = n12 >>> 15 | object2 << 1;
        int[] nArray = grainv1Engine.lfsr;
        int n14 = nArray[0] >>> 3;
        int n15 = grainv1Engine.lfsr[1];
        n14 |= n15 << 13;
        int n16 = nArray[2];
        int n17 = n15 >>> 9 | n16 << 7;
        int n18 = n16 >>> 14 | nArray[3] << 2;
        n16 = nArray[4];
        int n19 = n18 & n16;
        return (n17 ^ object2 ^ n14 & n16 ^ n19 ^ n16 & object2 ^ n14 & n17 & n18 ^ (n14 &= n18) & n16 ^ n14 & object2 ^ n17 & n18 & object2 ^ n19 & object2 ^ n3 ^ n4 ^ n8 ^ n6 ^ n9 ^ n11 ^ n13) & 0xFFFF;
    }

    private int[] shift(int[] nArray, int n3) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray3[0] = nArray2[1];
        nArray3[1] = nArray2[2];
        nArray3[2] = nArray2[3];
        nArray3[3] = nArray2[4];
        nArray2[4] = n3;
        return nArray3;
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        Grainv1Engine grainv1Engine = this;
        byArray2[8] = -1;
        byArray2[9] = -1;
        grainv1Engine.workingKey = byArray;
        grainv1Engine.workingIV = byArray2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            Object[] objectArray = this.nfsr;
            if (n4 >= this.nfsr.length) break;
            int[] nArray = objectArray;
            objectArray = this.workingKey;
            int n5 = n3 + 1;
            nArray[n4] = (this.workingKey[n5] << 8 | objectArray[n3] & 0xFF) & 0xFFFF;
            objectArray = this.workingIV;
            this.lfsr[n4] = (this.workingIV[n5] << 8 | objectArray[n3] & 0xFF) & 0xFFFF;
            n3 += 2;
            ++n4;
        }
    }

    private void oneRound() {
        int n3;
        Grainv1Engine grainv1Engine = object;
        grainv1Engine.output = n3 = grainv1Engine.getOutput();
        grainv1Engine.out[0] = (byte)n3;
        grainv1Engine.out[1] = (byte)(n3 >> 8);
        grainv1Engine.nfsr = grainv1Engine.shift(grainv1Engine.nfsr, ((Grainv1Engine)object).getOutputNFSR() ^ ((Grainv1Engine)object).lfsr[0]);
        Object object = grainv1Engine.lfsr;
        grainv1Engine.lfsr = grainv1Engine.shift((int[])object, grainv1Engine.getOutputLFSR());
    }

    private byte getKeyStream() {
        if (this.index > 1) {
            this.oneRound();
            this.index = 0;
        }
        int n3 = this.index;
        this.index = n3 + 1;
        return this.out[n3];
    }

    @Override
    public String getAlgorithmName() {
        return "Grain v1";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            CipherParameters cipherParameters = (ParametersWithIV)object;
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            object = byArray;
            if (byArray != null && ((Object)object).length == 8) {
                if (((ParametersWithIV)cipherParameters).getParameters() instanceof KeyParameter) {
                    Grainv1Engine grainv1Engine = object3;
                    Object object2 = object;
                    cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    ((Grainv1Engine)object3).workingIV = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grainv1Engine)object3).workingKey = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grainv1Engine)object3).lfsr = new int[5];
                    ((Grainv1Engine)object3).nfsr = new int[5];
                    ((Grainv1Engine)object3).out = new byte[2];
                    object = ((Grainv1Engine)object3).workingIV;
                    int n3 = ((Object)object2).length;
                    System.arraycopy(object2, 0, object, 0, n3);
                    Object object3 = ((Grainv1Engine)object3).workingKey;
                    int n4 = ((KeyParameter)cipherParameters).getKey().length;
                    System.arraycopy(((KeyParameter)cipherParameters).getKey(), 0, object3, 0, n4);
                    grainv1Engine.reset();
                    return;
                }
                throw new IllegalArgumentException("Grain v1 Init parameters must include a key");
            }
            throw new IllegalArgumentException("Grain v1 requires exactly 8 bytes of IV");
        }
        throw new IllegalArgumentException("Grain v1 Init parameters must include an IV");
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.initialised) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n6 = n5 + i3;
                        byArray2[n6] = (byte)(byArray[n3 + i3] ^ this.getKeyStream());
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        Grainv1Engine grainv1Engine = object;
        grainv1Engine.index = 2;
        Object object = grainv1Engine.workingKey;
        grainv1Engine.setKey((byte[])object, grainv1Engine.workingIV);
        grainv1Engine.initGrain();
    }

    @Override
    public byte returnByte(byte by) {
        if (this.initialised) {
            return (byte)(by ^ this.getKeyStream());
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }
}

