/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class HC128Engine
implements StreamCipher {
    private int[] p = new int[512];
    private int[] q = new int[512];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private static int f1(int n3) {
        return HC128Engine.rotateRight(n3, 7) ^ HC128Engine.rotateRight(n3, 18) ^ n3 >>> 3;
    }

    private static int f2(int n3) {
        return HC128Engine.rotateRight(n3, 17) ^ HC128Engine.rotateRight(n3, 19) ^ n3 >>> 10;
    }

    private int g1(int n3, int n4, int n5) {
        return (HC128Engine.rotateRight(n3, 10) ^ HC128Engine.rotateRight(n5, 23)) + HC128Engine.rotateRight(n4, 8);
    }

    private int g2(int n3, int n4, int n5) {
        return (HC128Engine.rotateLeft(n3, 10) ^ HC128Engine.rotateLeft(n5, 23)) + HC128Engine.rotateLeft(n4, 8);
    }

    private static int rotateLeft(int n3, int n4) {
        return n3 << n4 | n3 >>> -n4;
    }

    private static int rotateRight(int n3, int n4) {
        return n3 >>> n4 | n3 << -n4;
    }

    private int h1(int n3) {
        Object object = ((HC128Engine)object).q;
        return ((HC128Engine)object).q[n3 & 0xFF] + object[(n3 >> 16 & 0xFF) + 256];
    }

    private int h2(int n3) {
        Object object = ((HC128Engine)object).p;
        return ((HC128Engine)object).p[n3 & 0xFF] + object[(n3 >> 16 & 0xFF) + 256];
    }

    private static int mod1024(int n3) {
        return n3 & 0x3FF;
    }

    private static int mod512(int n3) {
        return n3 & 0x1FF;
    }

    private static int dim(int n3, int n4) {
        return HC128Engine.mod512(n3 - n4);
    }

    private int step() {
        int n3;
        HC128Engine hC128Engine = this;
        int n4 = HC128Engine.mod512(hC128Engine.cnt);
        if (hC128Engine.cnt < 512) {
            HC128Engine hC128Engine2 = this;
            int[] nArray = hC128Engine2.p;
            HC128Engine hC128Engine3 = this;
            int n5 = hC128Engine3.p[HC128Engine.dim(n4, 10)];
            hC128Engine2.p[n4] = nArray[n4] + this.g1(nArray[HC128Engine.dim(n4, 3)], n5, hC128Engine3.p[HC128Engine.dim(n4, 511)]);
            n3 = hC128Engine2.h1(hC128Engine2.p[HC128Engine.dim(n4, 12)]) ^ this.p[n4];
        } else {
            HC128Engine hC128Engine4 = this;
            int[] nArray = hC128Engine4.q;
            HC128Engine hC128Engine5 = this;
            int n6 = hC128Engine5.q[HC128Engine.dim(n4, 10)];
            hC128Engine4.q[n4] = nArray[n4] + this.g2(nArray[HC128Engine.dim(n4, 3)], n6, hC128Engine5.q[HC128Engine.dim(n4, 511)]);
            n3 = hC128Engine4.h2(hC128Engine4.q[HC128Engine.dim(n4, 12)]) ^ this.q[n4];
        }
        this.cnt = HC128Engine.mod1024(this.cnt + 1);
        return n3;
    }

    private void init() {
        if (this.key.length == 16) {
            int n3;
            int n4;
            HC128Engine hC128Engine = this;
            hC128Engine.idx = 0;
            hC128Engine.cnt = 0;
            int[] nArray = new int[1280];
            for (n4 = 0; n4 < 16; ++n4) {
                int n5 = n4 >> 2;
                nArray[n5] = nArray[n5] | (this.key[n4] & 0xFF) << (n4 & 3) * 8;
            }
            System.arraycopy(nArray, 0, nArray, 4, 4);
            n4 = 0;
            while (true) {
                byte[] byArray = this.iv;
                if (n4 >= this.iv.length || n4 >= 16) break;
                int n6 = (n4 >> 2) + 8;
                nArray[n6] = nArray[n6] | (byArray[n4] & 0xFF) << (n4 & 3) * 8;
                ++n4;
            }
            System.arraycopy(nArray, 8, nArray, 12, 4);
            for (n4 = 16; n4 < 1280; ++n4) {
                nArray[n4] = HC128Engine.f2(nArray[n4 - 2]) + nArray[n4 - 7] + HC128Engine.f1(nArray[n4 - 15]) + nArray[n4 - 16] + n4;
            }
            System.arraycopy(nArray, 256, this.p, 0, 512);
            System.arraycopy(nArray, 768, this.q, 0, 512);
            for (n3 = 0; n3 < 512; ++n3) {
                this.p[n3] = this.step();
            }
            for (n3 = 0; n3 < 512; ++n3) {
                this.q[n3] = this.step();
            }
            this.cnt = 0;
            return;
        }
        throw new IllegalArgumentException("The key must be 128 bits long");
    }

    private byte getByte() {
        int n3;
        if (this.idx == 0) {
            HC128Engine hC128Engine = this;
            n3 = hC128Engine.step();
            byte[] byArray = hC128Engine.buf;
            byArray[0] = (byte)(n3 & 0xFF);
            int n4 = n3 >> 8;
            byArray[1] = (byte)(n4 & 0xFF);
            int n5 = n4 >> 8;
            byArray[2] = (byte)(n5 & 0xFF);
            hC128Engine.buf[3] = (byte)(n5 >> 8 & 0xFF);
        }
        n3 = this.idx;
        this.idx = n3 + 1 & 3;
        return this.buf[n3];
    }

    @Override
    public String getAlgorithmName() {
        return "HC-128";
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.iv = parametersWithIV.getIV();
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            this.iv = new byte[0];
            cipherParameters2 = cipherParameters;
        }
        if (cipherParameters2 instanceof KeyParameter) {
            this.key = ((KeyParameter)cipherParameters2).getKey();
            this.init();
            this.initialised = true;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("Invalid parameter passed to HC128 init - ")));
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.initialised) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n6 = n5 + i3;
                        byArray2[n6] = (byte)(byArray[n3 + i3] ^ this.getByte());
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        this.init();
    }

    @Override
    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }
}

