/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private int step() {
        int n3;
        int n4 = this.cnt;
        int n5 = n4 & 0x3FF;
        if (n4 < 1024) {
            HC256Engine hC256Engine = this;
            int[] nArray = hC256Engine.p;
            int n6 = nArray[n5 - 3 & 0x3FF];
            int n7 = nArray[n5 - 1023 & 0x3FF];
            int n8 = nArray[n5];
            int n9 = hC256Engine.p[n5 - 10 & 0x3FF] + (HC256Engine.rotateRight(n6, 10) ^ HC256Engine.rotateRight(n7, 23));
            int[] nArray2 = hC256Engine.q;
            nArray[n5] = n9 + nArray2[(n6 ^ n7) & 0x3FF] + n8;
            nArray = this.p;
            n6 = this.p[n5 - 12 & 0x3FF];
            n3 = hC256Engine.q[n6 & 0xFF] + nArray2[(n6 >> 8 & 0xFF) + 256] + nArray2[(n6 >> 16 & 0xFF) + 512] + nArray2[(n6 >> 24 & 0xFF) + 768] ^ nArray[n5];
        } else {
            HC256Engine hC256Engine = this;
            int[] nArray = hC256Engine.q;
            int n10 = nArray[n5 - 3 & 0x3FF];
            int n11 = nArray[n5 - 1023 & 0x3FF];
            int n12 = nArray[n5];
            int n13 = hC256Engine.q[n5 - 10 & 0x3FF] + (HC256Engine.rotateRight(n10, 10) ^ HC256Engine.rotateRight(n11, 23));
            int[] nArray3 = hC256Engine.p;
            nArray[n5] = n13 + nArray3[(n10 ^ n11) & 0x3FF] + n12;
            nArray = this.q;
            n10 = this.q[n5 - 12 & 0x3FF];
            n3 = hC256Engine.p[n10 & 0xFF] + nArray3[(n10 >> 8 & 0xFF) + 256] + nArray3[(n10 >> 16 & 0xFF) + 512] + nArray3[(n10 >> 24 & 0xFF) + 768] ^ nArray[n5];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return n3;
    }

    private void init() {
        Object[] objectArray = this.key;
        if (this.key.length != 32 && objectArray.length != 16) {
            throw new IllegalArgumentException("The key must be 128/256 bits long");
        }
        if (this.iv.length >= 16) {
            int n3;
            int n4;
            if (objectArray.length != 32) {
                HC256Engine hC256Engine = this;
                objectArray = new byte[32];
                n4 = objectArray.length;
                System.arraycopy(objectArray, 0, objectArray, 0, n4);
                n4 = hC256Engine.key.length;
                System.arraycopy(hC256Engine.key, 0, objectArray, 16, n4);
                hC256Engine.key = objectArray;
            }
            objectArray = this.iv;
            if (this.iv.length < 32) {
                HC256Engine hC256Engine = this;
                objectArray = new byte[32];
                n4 = objectArray.length;
                System.arraycopy(objectArray, 0, objectArray, 0, n4);
                n4 = hC256Engine.iv.length;
                n3 = 32 - hC256Engine.iv.length;
                System.arraycopy(hC256Engine.iv, 0, objectArray, n4, n3);
                hC256Engine.iv = objectArray;
            }
            HC256Engine hC256Engine = this;
            hC256Engine.idx = 0;
            hC256Engine.cnt = 0;
            objectArray = new int[2560];
            for (n4 = 0; n4 < 32; ++n4) {
                n3 = n4 >> 2;
                objectArray[n3] = objectArray[n3] | (this.key[n4] & 0xFF) << (n4 & 3) * 8;
            }
            for (n4 = 0; n4 < 32; ++n4) {
                n3 = (n4 >> 2) + 8;
                objectArray[n3] = objectArray[n3] | (this.iv[n4] & 0xFF) << (n4 & 3) * 8;
            }
            for (n4 = 16; n4 < 2560; ++n4) {
                n3 = objectArray[n4 - 2];
                byte by = objectArray[n4 - 15];
                objectArray[n4] = (HC256Engine.rotateRight(n3, 17) ^ HC256Engine.rotateRight(n3, 19) ^ n3 >>> 10) + objectArray[n4 - 7] + (HC256Engine.rotateRight(by, 7) ^ HC256Engine.rotateRight(by, 18) ^ by >>> 3) + objectArray[n4 - 16] + n4;
            }
            System.arraycopy(objectArray, 512, this.p, 0, 1024);
            System.arraycopy(objectArray, 1536, this.q, 0, 1024);
            for (int i3 = 0; i3 < 4096; ++i3) {
                this.step();
            }
            this.cnt = 0;
            return;
        }
        throw new IllegalArgumentException("The IV must be at least 128 bits long");
    }

    private byte getByte() {
        int n3;
        if (this.idx == 0) {
            HC256Engine hC256Engine = this;
            n3 = hC256Engine.step();
            byte[] byArray = hC256Engine.buf;
            byArray[0] = (byte)(n3 & 0xFF);
            int n4 = n3 >> 8;
            byArray[1] = (byte)(n4 & 0xFF);
            int n5 = n4 >> 8;
            byArray[2] = (byte)(n5 & 0xFF);
            hC256Engine.buf[3] = (byte)(n5 >> 8 & 0xFF);
        }
        n3 = this.idx;
        this.idx = n3 + 1 & 3;
        return this.buf[n3];
    }

    private static int rotateRight(int n3, int n4) {
        return n3 >>> n4 | n3 << -n4;
    }

    @Override
    public String getAlgorithmName() {
        return "HC-256";
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.iv = parametersWithIV.getIV();
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            this.iv = new byte[0];
            cipherParameters2 = cipherParameters;
        }
        if (cipherParameters2 instanceof KeyParameter) {
            this.key = ((KeyParameter)cipherParameters2).getKey();
            this.init();
            this.initialised = true;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("Invalid parameter passed to HC256 init - ")));
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.initialised) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n6 = n5 + i3;
                        byArray2[n6] = (byte)(byArray[n3 + i3] ^ this.getByte());
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        this.init();
    }

    @Override
    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }
}

