/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class IDEAEngine
implements BlockCipher {
    public static final int BLOCK_SIZE = 8;
    private static final int MASK = 65535;
    private static final int BASE = 65537;
    private int[] workingKey = null;

    private int bytesToWord(byte[] byArray, int n3) {
        return (byArray[n3] << 8 & 0xFF00) + (byArray[n3 + 1] & 0xFF);
    }

    private void wordToBytes(int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)(n3 >>> 8);
        int n5 = n4 + 1;
        byArray[n5] = (byte)n3;
    }

    private int mul(int n3, int n4) {
        int n5;
        if (n3 == 0) {
            n5 = 65537 - n4;
        } else if (n4 == 0) {
            n5 = 65537 - n3;
        } else {
            int n6 = n3 * n4;
            int n7 = n6 & 0xFFFF;
            n3 = n7 - (n6 >>>= 16);
            n6 = n7 < n6 ? 1 : 0;
            n5 = n3 + n6;
        }
        return n5 & 0xFFFF;
    }

    private void ideaFunc(int[] nArray, byte[] byArray, int n3, byte[] byArray2, int n4) {
        IDEAEngine iDEAEngine = this;
        int n5 = 0;
        int n6 = iDEAEngine.bytesToWord(byArray, n3);
        int n7 = iDEAEngine.bytesToWord(byArray, n3 + 2);
        int n8 = iDEAEngine.bytesToWord(byArray, n3 + 4);
        int n9 = iDEAEngine.bytesToWord(byArray, n3 + 6);
        for (n3 = 0; n3 < 8; ++n3) {
            n6 = this.mul(n6, nArray[n5++]);
            n7 = n7 + nArray[n5++] & 0xFFFF;
            n8 = n8 + nArray[n5++] & 0xFFFF;
            int n10 = n9;
            int n11 = n5;
            n9 = n11 + 1;
            n5 = this.mul(n10, nArray[n11]);
            int n12 = n8 ^ n6;
            int n13 = n7 ^ n5;
            int n14 = this.mul(n12, nArray[n9++]);
            n12 = n14;
            n12 = n13 + n12 & 0xFFFF;
            n12 = this.mul(n12, nArray[n9++]);
            n13 = n14 + n12 & 0xFFFF;
            int n15 = n7;
            n6 ^= n12;
            n7 = n12 ^ n8;
            n8 = n13 ^ n15;
            int n16 = n9;
            n9 = n5 ^= n13;
            n5 = n16;
        }
        IDEAEngine iDEAEngine2 = this;
        IDEAEngine iDEAEngine3 = this;
        int n17 = n5;
        int n18 = n17 + 1;
        iDEAEngine3.wordToBytes(iDEAEngine3.mul(n6, nArray[n17]), byArray2, n4);
        this.wordToBytes(n8 + nArray[n18++], byArray2, n4 + 2);
        this.wordToBytes(n7 + nArray[n18++], byArray2, n4 + 4);
        iDEAEngine2.wordToBytes(iDEAEngine2.mul(n9, nArray[n18]), byArray2, n4 + 6);
    }

    private int[] expandKey(byte[] byArray) {
        int n3;
        int[] nArray = new int[52];
        if (byArray.length < 16) {
            byte[] byArray2 = byArray;
            byArray = new byte[16];
            n3 = 16 - byArray2.length;
            int n4 = byArray2.length;
            System.arraycopy(byArray, 0, byArray, n3, n4);
        }
        for (n3 = 0; n3 < 8; ++n3) {
            nArray[n3] = this.bytesToWord(byArray, n3 * 2);
        }
        for (int i3 = 8; i3 < 52; ++i3) {
            int n5 = i3 & 7;
            nArray[i3] = n5 < 6 ? ((nArray[i3 - 7] & 0x7F) << 9 | nArray[i3 - 6] >> 7) & 0xFFFF : (n5 == 6 ? ((nArray[i3 - 7] & 0x7F) << 9 | nArray[i3 - 14] >> 7) & 0xFFFF : ((nArray[i3 - 15] & 0x7F) << 9 | nArray[i3 - 14] >> 7) & 0xFFFF);
        }
        return nArray;
    }

    private int mulInv(int n3) {
        int n4;
        if (n3 < 2) {
            return n3;
        }
        int n5 = 1;
        int n6 = 65537 / n3;
        for (int i3 = 65537 % n3; i3 != 1; i3 %= n4) {
            int n7 = n3;
            n4 = n7 % i3;
            n5 = n6 * (n3 /= i3) + n5 & 0xFFFF;
            if (n4 == 1) {
                return n5;
            }
            n3 = i3 / n4;
            n6 = n5 * n3 + n6 & 0xFFFF;
            n3 = n4;
        }
        return 1 - n6 & 0xFFFF;
    }

    private int[] invertKey(int[] nArray) {
        int[] nArray2 = new int[52];
        int[] nArray3 = nArray2;
        int n3 = this.mulInv(nArray[0]);
        int n4 = this.addInv(nArray[1]);
        int n5 = this.addInv(nArray[2]);
        int n6 = 4;
        nArray2[51] = this.mulInv(nArray[3]);
        nArray2[50] = n5;
        nArray2[49] = n4;
        n4 = 48;
        nArray2[48] = n3;
        for (n3 = 1; n3 < 8; ++n3) {
            int[] nArray4 = nArray3;
            int[] nArray5 = nArray3;
            int n7 = n6;
            n5 = n7 + 1;
            n6 = nArray[n7];
            int n8 = nArray[n5++];
            nArray3[n4 += -1] = n8;
            nArray3[n4 += -1] = n6;
            n6 = this.mulInv(nArray[n5++]);
            n8 = this.addInv(nArray[n5++]);
            int n9 = this.addInv(nArray[n5++]);
            int n10 = this.mulInv(nArray[n5++]);
            nArray4[n4 += -1] = n10;
            nArray5[n4 += -1] = n8;
            nArray4[n4 += -1] = n9;
            nArray5[n4 += -1] = n6;
            n6 = n5;
        }
        int[] nArray6 = nArray3;
        int[] nArray7 = nArray3;
        int n11 = n6;
        int n12 = n11 + 1;
        int n13 = nArray[n11];
        n3 = nArray[n12++];
        nArray3[n4 += -1] = n3;
        n3 = n4 + -1;
        nArray3[n3] = n13;
        n13 = this.mulInv(nArray[n12++]);
        n4 = this.addInv(nArray[n12++]);
        n5 = this.addInv(nArray[n12++]);
        n12 = this.mulInv(nArray[n12]);
        nArray6[n3 += -1] = n12;
        n12 = n3 + -1;
        nArray7[n12] = n5;
        int n14 = n12 + -1;
        nArray3[n14] = n4;
        nArray6[n14 + -1] = n13;
        return nArray7;
    }

    private int[] generateWorkingKey(boolean bl, byte[] byArray) {
        if (bl) {
            return this.expandKey(byArray);
        }
        IDEAEngine iDEAEngine = this;
        return iDEAEngine.invertKey(iDEAEngine.expandKey(byArray));
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(bl, ((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to IDEA init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "IDEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int[] nArray = this.workingKey;
        if (this.workingKey != null) {
            if (n3 + 8 <= byArray.length) {
                if (n4 + 8 <= byArray2.length) {
                    this.ideaFunc(nArray, byArray, n3, byArray2, n4);
                    return 8;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("IDEA engine not initialised");
    }

    @Override
    public void reset() {
    }

    public int addInv(int n3) {
        return 0 - n3 & 0xFFFF;
    }
}

