/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class ISAACEngine
implements StreamCipher {
    private final int sizeL;
    private final int stateArraySize;
    private int[] engineState = null;
    private int[] results = null;
    private int a = 0;
    private int b = 0;
    private int c = 0;
    private int index = 0;
    private byte[] keyStream = new byte[1024];
    private byte[] workingKey = null;
    private boolean initialised = false;

    public ISAACEngine() {
        this.sizeL = 8;
        this.stateArraySize = 256;
    }

    private void setKey(byte[] byArray) {
        int n3;
        int n4;
        this.workingKey = byArray;
        if (this.engineState == null) {
            this.engineState = new int[256];
        }
        if (this.results == null) {
            this.results = new int[256];
        }
        for (int i3 = 0; i3 < 256; ++i3) {
            this.results[i3] = 0;
            this.engineState[i3] = 0;
        }
        ISAACEngine iSAACEngine = this;
        iSAACEngine.c = 0;
        iSAACEngine.b = 0;
        iSAACEngine.a = 0;
        iSAACEngine.index = 0;
        int n5 = byArray.length + (byArray.length & 3);
        byte[] byArray2 = new byte[n5];
        int n6 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n6);
        for (n6 = 0; n6 < n5; n6 += 4) {
            int n7 = n6;
            n4 = n7 >>> 2;
            this.results[n4] = Pack.littleEndianToInt(byArray2, n7);
        }
        int[] nArray = new int[8];
        for (n3 = 0; n3 < 8; ++n3) {
            nArray[n3] = -1640531527;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            this.mix(nArray);
        }
        for (n3 = 0; n3 < 2; ++n3) {
            for (n6 = 0; n6 < 256; n6 += 8) {
                int n8;
                for (n4 = 0; n4 < 8; ++n4) {
                    n8 = nArray[n4];
                    int n9 = n3 < 1 ? this.results[n6 + n4] : this.engineState[n6 + n4];
                    nArray[n4] = n8 + n9;
                }
                this.mix(nArray);
                for (n4 = 0; n4 < 8; ++n4) {
                    n8 = n6 + n4;
                    this.engineState[n8] = nArray[n4];
                }
            }
        }
        this.isaac();
        this.initialised = true;
    }

    private void isaac() {
        int n3;
        this.c = n3 = this.c + 1;
        this.b += n3;
        for (n3 = 0; n3 < 256; ++n3) {
            int n4;
            int n5;
            int[] nArray = this.engineState;
            int n6 = this.engineState[n3];
            switch (n3 & 3) {
                default: {
                    break;
                }
                case 3: {
                    int n7 = this.a;
                    this.a = n7 ^ n7 >>> 16;
                    break;
                }
                case 2: {
                    int n8 = this.a;
                    this.a = n8 ^ n8 << 2;
                    break;
                }
                case 1: {
                    int n9 = this.a;
                    this.a = n9 ^ n9 >>> 6;
                    break;
                }
                case 0: {
                    int n10 = this.a;
                    this.a = n10 ^ n10 << 13;
                }
            }
            this.a = n5 = this.a + nArray[n3 + 128 & 0xFF];
            nArray[n3] = n5 = nArray[n6 >>> 2 & 0xFF] + n5 + this.b;
            this.b = n4 = nArray[n5 >>> 10 & 0xFF] + n6;
            this.results[n3] = n4;
        }
    }

    private void mix(int[] nArray) {
        int n3;
        int n4;
        int n5 = nArray[1];
        int n6 = nArray[0] ^ n5 << 11;
        int n7 = n6;
        int[] nArray2 = nArray;
        nArray2[0] = n7;
        nArray2[3] = n7 = nArray2[3] + n7;
        int n8 = nArray2[2];
        int n9 = n8;
        int[] nArray3 = nArray;
        nArray[1] = n5 += n9;
        nArray3[1] = n5 ^= n9 >>> 2;
        nArray[4] = n9 = nArray3[4] + n5;
        nArray[2] = n4 = n8 + n7;
        nArray2[2] = n4 ^= n7 << 8;
        int n10 = nArray2[5] + n4;
        int[] nArray4 = nArray;
        int[] nArray5 = nArray;
        nArray[5] = n10;
        nArray[3] = n7 += n9;
        nArray5[3] = n7 ^= n9 >>> 16;
        nArray[6] = n7 = nArray5[6] + n7;
        nArray[4] = n9 += n10;
        nArray4[4] = n9 ^= n10 << 10;
        nArray[7] = n9 = nArray4[7] + n9;
        nArray[5] = n10 += n7;
        nArray[5] = n10 ^= n7 >>> 4;
        n10 = n6 + n10;
        int n11 = n5;
        nArray[0] = n10;
        nArray[6] = n5 = n7 + n9;
        nArray[6] = n5 ^= n9 << 8;
        nArray[1] = n5 = n11 + n5;
        nArray[7] = n7 = n9 + n10;
        nArray[7] = n3 = n7 ^ n10 >>> 9;
        nArray[2] = n4 + n3;
        nArray[0] = n10 + n5;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a.a(cipherParameters, b.b.a("invalid parameter passed to ISAAC init - ")));
    }

    @Override
    public byte returnByte(byte by) {
        if (this.index == 0) {
            ISAACEngine iSAACEngine = this;
            iSAACEngine.isaac();
            iSAACEngine.keyStream = Pack.intToBigEndian(iSAACEngine.results);
        }
        int n3 = this.index;
        this.index = n3 + 1 & 0x3FF;
        return (byte)(this.keyStream[n3] ^ by);
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.initialised) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (this.index == 0) {
                            ISAACEngine iSAACEngine = this;
                            iSAACEngine.isaac();
                            iSAACEngine.keyStream = Pack.intToBigEndian(iSAACEngine.results);
                        }
                        ISAACEngine iSAACEngine = this;
                        int n6 = i3 + n5;
                        byte[] byArray3 = iSAACEngine.keyStream;
                        int n7 = iSAACEngine.index;
                        byArray2[n6] = (byte)(byArray3[n7] ^ byArray[i3 + n3]);
                        iSAACEngine.index = n7 + 1 & 0x3FF;
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public String getAlgorithmName() {
        return "ISAAC";
    }

    @Override
    public void reset() {
        ISAACEngine iSAACEngine = this;
        iSAACEngine.setKey(iSAACEngine.workingKey);
    }
}

