/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;

public class NaccacheSternEngine
implements AsymmetricBlockCipher {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private boolean forEncryption;
    private NaccacheSternKeyParameters key;
    private Vector[] lookup = null;
    private boolean debug = false;

    private static BigInteger chineseRemainder(Vector vector, Vector vector2) {
        int n3;
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = ONE;
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            bigInteger2 = bigInteger2.multiply((BigInteger)vector2.elementAt(n3));
        }
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            BigInteger bigInteger3 = bigInteger;
            bigInteger = (BigInteger)vector2.elementAt(n3);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger);
            bigInteger = bigInteger3.add(bigInteger4.multiply(bigInteger4.modInverse(bigInteger)).multiply((BigInteger)vector.elementAt(n3)));
        }
        return bigInteger.mod(bigInteger2);
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.forEncryption = bl;
        if (object instanceof ParametersWithRandom) {
            object = ((ParametersWithRandom)object).getParameters();
        }
        this.key = (NaccacheSternKeyParameters)object;
        if (!this.forEncryption) {
            if (this.debug) {
                System.out.println("Constructing lookup Array");
            }
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
            object = naccacheSternPrivateKeyParameters.getSmallPrimes();
            this.lookup = new Vector[((Vector)object).size()];
            for (int i3 = 0; i3 < ((Vector)object).size(); ++i3) {
                Vector vector;
                NaccacheSternEngine naccacheSternEngine = this;
                BigInteger bigInteger = (BigInteger)((Vector)object).elementAt(i3);
                int n3 = bigInteger.intValue();
                Serializable serializable = vector;
                vector = new Vector();
                naccacheSternEngine.lookup[i3] = serializable;
                naccacheSternEngine.lookup[i3].addElement(ONE);
                if (naccacheSternEngine.debug) {
                    System.out.println("Constructing lookup ArrayList for " + n3);
                }
                serializable = ZERO;
                for (int i4 = 1; i4 < n3; ++i4) {
                    serializable = ((BigInteger)serializable).add(naccacheSternPrivateKeyParameters.getPhi_n());
                    BigInteger bigInteger2 = ((BigInteger)serializable).divide(bigInteger);
                    this.lookup[i3].addElement(naccacheSternPrivateKeyParameters.getG().modPow(bigInteger2, naccacheSternPrivateKeyParameters.getModulus()));
                }
            }
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public int getInputBlockSize() {
        if (this.forEncryption) {
            return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
        }
        return this.key.getModulus().toByteArray().length;
    }

    @Override
    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.key.getModulus().toByteArray().length;
        }
        return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
    }

    @Override
    public byte[] processBlock(byte[] object, int n3, int n4) {
        if (this.key != null) {
            if (n4 <= this.getInputBlockSize() + 1) {
                byte[] byArray;
                BigInteger bigInteger;
                if (!this.forEncryption && n4 < this.getInputBlockSize()) {
                    throw new InvalidCipherTextException("BlockLength does not match modulus for Naccache-Stern cipher.\n");
                }
                if (n3 != 0 || n4 != ((byte[])object).length) {
                    byte[] byArray2 = object;
                    object = new byte[n4];
                    System.arraycopy(byArray2, n3, object, 0, n4);
                }
                BigInteger bigInteger2 = bigInteger;
                bigInteger = new BigInteger(1, (byte[])object);
                if (this.debug) {
                    System.out.println("input as BigInteger: " + bigInteger2);
                }
                if (this.forEncryption) {
                    byArray = this.encrypt(bigInteger2);
                } else {
                    Vector vector;
                    object = vector;
                    vector = new Vector();
                    NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
                    Vector vector2 = naccacheSternPrivateKeyParameters.getSmallPrimes();
                    for (int i3 = 0; i3 < vector2.size(); ++i3) {
                        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters2 = naccacheSternPrivateKeyParameters;
                        BigInteger bigInteger3 = naccacheSternPrivateKeyParameters2.getPhi_n().divide((BigInteger)vector2.elementAt(i3));
                        bigInteger3 = bigInteger2.modPow(bigInteger3, naccacheSternPrivateKeyParameters2.getModulus());
                        Vector vector3 = this.lookup[i3];
                        if (vector3.size() != ((BigInteger)vector2.elementAt(i3)).intValue()) {
                            if (this.debug) {
                                System.out.println(b.a("Prime is ").append(vector2.elementAt(i3)).append(", lookup table has size ").append(vector3.size()).toString());
                            }
                            throw new InvalidCipherTextException(b.a("Error in lookup Array for ").append(((BigInteger)vector2.elementAt(i3)).intValue()).append(": Size mismatch. Expected ArrayList with length ").append(((BigInteger)vector2.elementAt(i3)).intValue()).append(" but found ArrayList of length ").append(this.lookup[i3].size()).toString());
                        }
                        int n5 = vector3.indexOf(bigInteger3);
                        if (n5 == -1) {
                            if (this.debug) {
                                System.out.println(b.a("Actual prime is ").append(vector2.elementAt(i3)).toString());
                                System.out.println("Decrypted value is " + bigInteger3);
                                System.out.println(b.a("LookupList for ").append(vector2.elementAt(i3)).append(" with size ").append(this.lookup[i3].size()).append(" is: ").toString());
                                for (int i4 = 0; i4 < this.lookup[i3].size(); ++i4) {
                                    System.out.println(this.lookup[i3].elementAt(i4));
                                }
                            }
                            throw new InvalidCipherTextException("Lookup failed");
                        }
                        ((Vector)object).addElement(BigInteger.valueOf(n5));
                    }
                    byArray = NaccacheSternEngine.chineseRemainder((Vector)object, vector2).toByteArray();
                }
                return byArray;
            }
            throw new DataLengthException("input too large for Naccache-Stern cipher.\n");
        }
        throw new IllegalStateException("NaccacheStern engine not initialised");
    }

    public byte[] encrypt(BigInteger bigInteger) {
        NaccacheSternEngine naccacheSternEngine = this;
        byte[] byArray = naccacheSternEngine.key.getModulus().toByteArray();
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = naccacheSternEngine.key.getG().modPow(bigInteger, this.key.getModulus()).toByteArray();
        int n3 = byArray.length - byArray2.length;
        int n4 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n3, n4);
        if (naccacheSternEngine.debug) {
            System.out.println(b.a("Encrypted value is:  ").append(new BigInteger(byArray)).toString());
        }
        return byArray;
    }

    public byte[] addCryptedBlocks(byte[] object, byte[] object2) {
        block8: {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            block7: {
                block6: {
                    if (!((NaccacheSternEngine)object3).forEncryption) break block6;
                    if (((byte[])object).length > ((NaccacheSternEngine)object3).getOutputBlockSize() || ((byte[])object2).length > ((NaccacheSternEngine)object3).getOutputBlockSize()) {
                        throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
                    }
                    break block7;
                }
                if (((byte[])object).length > ((NaccacheSternEngine)object3).getInputBlockSize() || ((byte[])object2).length > ((NaccacheSternEngine)object3).getInputBlockSize()) break block8;
            }
            BigInteger bigInteger3 = bigInteger2;
            bigInteger2 = new BigInteger(1, (byte[])object);
            object = bigInteger;
            bigInteger = new BigInteger(1, (byte[])object2);
            object2 = bigInteger2.multiply(bigInteger).mod(((NaccacheSternEngine)object3).key.getModulus());
            if (((NaccacheSternEngine)object3).debug) {
                System.out.println("c(m1) as BigInteger:....... " + bigInteger3);
                System.out.println("c(m2) as BigInteger:....... " + object);
                System.out.println("c(m1)*c(m2)%n = c(m1+m2)%n: " + object2);
            }
            byte[] byArray = ((NaccacheSternEngine)object3).key.getModulus().toByteArray();
            Object object3 = byArray;
            Arrays.fill((byte[])object3, (byte)0);
            int n3 = ((Object)object3).length - ((BigInteger)object2).toByteArray().length;
            int n4 = ((BigInteger)object2).toByteArray().length;
            System.arraycopy(((BigInteger)object2).toByteArray(), 0, object3, n3, n4);
            return byArray;
        }
        throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
    }

    public byte[] processData(byte[] byArray) {
        if (((NaccacheSternEngine)object).debug) {
            System.out.println();
        }
        if (byArray.length > ((NaccacheSternEngine)object).getInputBlockSize()) {
            NaccacheSternEngine naccacheSternEngine = object;
            int n3 = naccacheSternEngine.getInputBlockSize();
            int n4 = naccacheSternEngine.getOutputBlockSize();
            if (naccacheSternEngine.debug) {
                System.out.println("Input blocksize is:  " + n3 + " bytes");
                System.out.println("Output blocksize is: " + n4 + " bytes");
                System.out.println(b.a("Data has length:.... ").append(byArray.length).append(" bytes").toString());
            }
            int n5 = 0;
            int n6 = 0;
            byte[] byArray2 = new byte[(byArray.length / n3 + 1) * n4];
            while (n5 < byArray.length) {
                byte[] byArray3;
                int n7 = n5 + n3;
                if (n7 < byArray.length) {
                    byte[] byArray4;
                    byArray3 = byArray4 = ((NaccacheSternEngine)object).processBlock(byArray, n5, n3);
                    n5 = n7;
                } else {
                    byArray3 = ((NaccacheSternEngine)object).processBlock(byArray, n5, byArray.length - n5);
                    n5 = byArray.length - n5 + n5;
                }
                if (((NaccacheSternEngine)object).debug) {
                    System.out.println("new datapos is " + n5);
                }
                if (byArray3 != null) {
                    n7 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray2, n6, n7);
                    n6 += byArray3.length;
                    continue;
                }
                if (((NaccacheSternEngine)object).debug) {
                    System.out.println("cipher returned null");
                }
                throw new InvalidCipherTextException("cipher returned null");
            }
            NaccacheSternEngine naccacheSternEngine2 = object;
            Object object = new byte[n6];
            System.arraycopy(byArray2, 0, object, 0, n6);
            if (naccacheSternEngine2.debug) {
                System.out.println("returning " + n6 + " bytes");
            }
            return object;
        }
        if (((NaccacheSternEngine)object).debug) {
            System.out.println("data size is less then input block size, processing directly");
        }
        return ((NaccacheSternEngine)object).processBlock(byArray, 0, byArray.length);
    }
}

