/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class NoekeonEngine
implements BlockCipher {
    private static final int SIZE = 16;
    private static final byte[] roundConstants = new byte[]{-128, 27, 54, 108, -40, -85, 77, -102, 47, 94, -68, 99, -58, -105, 53, 106, -44};
    private final int[] k = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        int n6 = Pack.bigEndianToInt(byArray, n3);
        int n7 = Pack.bigEndianToInt(byArray, n3 + 4);
        n3 = Pack.bigEndianToInt(byArray, n3 + 8);
        int n8 = Pack.bigEndianToInt(byArray, n5 + 12);
        int n9 = this.k[0];
        int n10 = this.k[1];
        int n11 = this.k[2];
        int n12 = this.k[3];
        int n13 = 0;
        while (true) {
            int n14 = n3;
            int n15 = n7;
            n7 = (n6 ^= roundConstants[n13] & 0xFF) ^ n3;
            int n16 = n7 ^ (Integers.rotateLeft(n7, 8) ^ Integers.rotateLeft(n7, 24));
            n7 = n16;
            int n17 = n6;
            n6 = n8 ^ n7;
            n7 = n17 ^ n9;
            n3 = n15 ^ n16 ^ n10;
            int n18 = n7;
            n7 = n3 ^ (n6 ^= n12);
            n7 ^= Integers.rotateLeft(n7, 8) ^ Integers.rotateLeft(n7, 24);
            n8 = n18 ^ n7;
            n7 = n14 ^ n11 ^ n7;
            if (++n13 > 16) {
                Pack.intToBigEndian(n8, byArray2, n4);
                Pack.intToBigEndian(n3, byArray2, n4 + 4);
                Pack.intToBigEndian(n7, byArray2, n4 + 8);
                Pack.intToBigEndian(n6, byArray2, n4 + 12);
                return 16;
            }
            int n19 = n7;
            n7 = Integers.rotateLeft(n3, 1);
            n3 = Integers.rotateLeft(n19, 5);
            n6 = Integers.rotateLeft(n6, 2);
            n8 ^= n3 & (n7 ^= ~n6 & ~n3);
            n3 ^= n6 ^ n7 ^ n8;
            n6 ^= n3 & (n7 ^= ~n8 & ~n3);
            n7 = Integers.rotateLeft(n7, 31);
            n3 = Integers.rotateLeft(n3, 27);
            n8 = Integers.rotateLeft(n8, 30);
        }
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        int n6 = Pack.bigEndianToInt(byArray, n3);
        int n7 = Pack.bigEndianToInt(byArray, n3 + 4);
        n3 = Pack.bigEndianToInt(byArray, n3 + 8);
        int n8 = Pack.bigEndianToInt(byArray, n5 + 12);
        int n9 = this.k[0];
        int n10 = this.k[1];
        int n11 = this.k[2];
        int n12 = this.k[3];
        int n13 = 16;
        while (true) {
            int n14 = n6;
            n6 ^= n3;
            n6 ^= Integers.rotateLeft(n6, 8) ^ Integers.rotateLeft(n6, 24);
            n7 ^= n6;
            n6 = n8 ^ n6;
            int n15 = n6;
            n6 = n3 ^ n11;
            n3 = n15 ^ n12;
            n8 = (n7 ^= n10) ^ n3;
            n8 ^= Integers.rotateLeft(n8, 8) ^ Integers.rotateLeft(n8, 24);
            n6 ^= n8;
            n8 = n14 ^ n9 ^ n8 ^ roundConstants[n13] & 0xFF;
            if ((n13 += -1) < 0) {
                Pack.intToBigEndian(n8, byArray2, n4);
                Pack.intToBigEndian(n7, byArray2, n4 + 4);
                Pack.intToBigEndian(n6, byArray2, n4 + 8);
                Pack.intToBigEndian(n3, byArray2, n4 + 12);
                return 16;
            }
            int n16 = n6;
            n6 = Integers.rotateLeft(n7, 1);
            n7 = Integers.rotateLeft(n16, 5);
            int n17 = n6;
            n6 = Integers.rotateLeft(n3, 2);
            n3 = n17 ^ ~n6 & ~n7;
            int n18 = n7 ^ (n6 ^ n3 ^ (n8 ^= n7 & n3));
            n7 = n18;
            n6 ^= n7 & (n3 ^= ~n8 & ~n7);
            n7 = Integers.rotateLeft(n3, 31);
            n3 = Integers.rotateLeft(n18, 27);
            n8 = Integers.rotateLeft(n8, 30);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "Noekeon";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        void var2_9;
        if (var2_9 instanceof KeyParameter) {
            Object object;
            NoekeonEngine noekeonEngine = object;
            noekeonEngine._forEncryption = bl;
            noekeonEngine._initialised = true;
            Pack.bigEndianToInt(((KeyParameter)var2_9).getKey(), 0, ((NoekeonEngine)object).k, 0, 4);
            if (!bl) {
                NoekeonEngine noekeonEngine2 = object;
                object = noekeonEngine2.k;
                int n3 = noekeonEngine2.k[0];
                int n4 = noekeonEngine2.k[1];
                int n5 = noekeonEngine2.k[2];
                int n6 = n5;
                Object object2 = object[3];
                int n8 = n3 ^ n6;
                n8 = n8 ^ (Integers.rotateLeft(n8, 8) ^ Integers.rotateLeft(n8, 24));
                int n9 = object2 ^ n8;
                object2 = n9;
                int n11 = (n4 ^= n8) ^ n9;
                n11 = n11 ^ (Integers.rotateLeft(n11, 8) ^ Integers.rotateLeft(n11, 24));
                n6 = n3 ^ n11;
                int n12 = n5 ^ n11;
                int[] nArray2 = noekeonEngine2.k;
                nArray2 = noekeonEngine2.k;
                nArray[0] = n6;
                nArray2[1] = n4;
                nArray[2] = n12;
                nArray2[3] = (int)object2;
            }
            return;
        }
        throw new IllegalArgumentException(a.a((CipherParameters)var2_9, b.a("invalid parameter passed to Noekeon init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this._initialised) {
            if (n3 <= byArray.length - 16) {
                if (n4 <= byArray2.length - 16) {
                    return this._forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }
}

