/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;

public class NullEngine
implements BlockCipher {
    public static final int DEFAULT_BLOCK_SIZE = 1;
    private boolean initialised;
    private final int blockSize;

    public NullEngine() {
        this(1);
    }

    public NullEngine(int n3) {
        this.blockSize = n3;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.initialised = true;
    }

    @Override
    public String getAlgorithmName() {
        return "Null";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.initialised) {
            int n5 = this.blockSize;
            if (n3 + n5 <= byArray.length) {
                if (n4 + n5 <= byArray2.length) {
                    int n6;
                    for (n5 = 0; n5 < (n6 = this.blockSize); ++n5) {
                        n6 = n4 + n5;
                        byArray2[n6] = byArray[n3 + n5];
                    }
                    return n6;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Null engine not initialised");
    }

    @Override
    public void reset() {
    }
}

