/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC2Parameters;

public class RC2Engine
implements BlockCipher {
    private static byte[] piTable = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    private static final int BLOCK_SIZE = 8;
    private int[] workingKey;
    private boolean encrypting;

    private int[] generateWorkingKey(byte[] byArray, int n3) {
        int n4;
        Object object;
        int n5;
        Object object2 = new int[128];
        for (n5 = 0; n5 != byArray.length; ++n5) {
            object2[n5] = byArray[n5] & 0xFF;
        }
        int n6 = byArray.length;
        if (n6 < 128) {
            n5 = 0;
            object = object2[n6 - 1];
            while (true) {
                object = piTable[object + object2[n5++] & 0xFF] & 0xFF;
                int n7 = n6 + 1;
                object2[n6] = object;
                if (n7 >= 128) break;
                n6 = n7;
            }
        }
        n6 = n3 + 7 >> 3;
        byte[] byArray2 = piTable;
        object = 128 - n6;
        n3 = byArray2[object2[object] & 255 >> (-n3 & 7)] & 0xFF;
        object2[object] = n3;
        for (n4 = (v748327) - 1; n4 >= 0; --n4) {
            n3 = piTable[n3 ^ object2[n4 + n6]] & 0xFF;
            object2[n4] = n3;
        }
        n6 = 64;
        int[] nArray = new int[64];
        for (n4 = 0; n4 != n6; ++n4) {
            int n8 = n4 * 2;
            object = n8;
            nArray[n4] = (int)(object2[n8] + (object2[object + true] << 8));
        }
        return nArray;
    }

    private int rotateWordLeft(int n3, int n4) {
        int n5 = n3 & 0xFFFF;
        return n5 << n4 | n5 >> 16 - n4;
    }

    private void encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = ((byArray[n3 + 7] & 0xFF) << 8) + (byArray[n3 + 6] & 0xFF);
        int n6 = ((byArray[n3 + 5] & 0xFF) << 8) + (byArray[n3 + 4] & 0xFF);
        int n7 = ((byArray[n3 + 3] & 0xFF) << 8) + (byArray[n3 + 2] & 0xFF);
        int n8 = ((byArray[n3 + 1] & 0xFF) << 8) + (byArray[n3 + 0] & 0xFF);
        for (n3 = 0; n3 <= 16; n3 += 4) {
            n8 = this.rotateWordLeft(n8 + (n7 & ~n5) + (n6 & n5) + this.workingKey[n3], 1);
            n7 = this.rotateWordLeft(n7 + (n6 & ~n8) + (n5 & n8) + this.workingKey[n3 + 1], 2);
            n6 = this.rotateWordLeft(n6 + (n5 & ~n7) + (n8 & n7) + this.workingKey[n3 + 2], 3);
            n5 = this.rotateWordLeft(n5 + (n8 & ~n6) + (n7 & n6) + this.workingKey[n3 + 3], 5);
        }
        int n9 = n5;
        int[] nArray = this.workingKey;
        int n10 = n7 + nArray[(n8 += nArray[n5 & 0x3F]) & 0x3F];
        n5 = n6 + nArray[n10 & 0x3F];
        n6 = n9 + this.workingKey[n5 & 0x3F];
        for (n7 = 20; n7 <= 40; n7 += 4) {
            n8 = this.rotateWordLeft(n8 + (n10 & ~n6) + (n5 & n6) + this.workingKey[n7], 1);
            n10 = this.rotateWordLeft(n10 + (n5 & ~n8) + (n6 & n8) + this.workingKey[n7 + 1], 2);
            n5 = this.rotateWordLeft(n5 + (n6 & ~n10) + (n8 & n10) + this.workingKey[n7 + 2], 3);
            n6 = this.rotateWordLeft(n6 + (n8 & ~n5) + (n10 & n5) + this.workingKey[n7 + 3], 5);
        }
        int[] nArray2 = this.workingKey;
        n5 += nArray2[(n10 += nArray2[(n8 += nArray2[n6 & 0x3F]) & 0x3F]) & 0x3F];
        n6 += this.workingKey[n5 & 0x3F];
        for (int i3 = 44; i3 < 64; i3 += 4) {
            n8 = this.rotateWordLeft(n8 + (n10 & ~n6) + (n5 & n6) + this.workingKey[i3], 1);
            n10 = this.rotateWordLeft(n10 + (n5 & ~n8) + (n6 & n8) + this.workingKey[i3 + 1], 2);
            n5 = this.rotateWordLeft(n5 + (n6 & ~n10) + (n8 & n10) + this.workingKey[i3 + 2], 3);
            n6 = this.rotateWordLeft(n6 + (n8 & ~n5) + (n10 & n5) + this.workingKey[i3 + 3], 5);
        }
        int n11 = n4 + 0;
        byArray2[n11] = (byte)n8;
        n11 = n4 + 1;
        byArray2[n11] = (byte)(n8 >> 8);
        n11 = n4 + 2;
        byArray2[n11] = (byte)n10;
        n11 = n4 + 3;
        byArray2[n11] = (byte)(n10 >> 8);
        n11 = n4 + 4;
        byArray2[n11] = (byte)n5;
        n11 = n4 + 5;
        byArray2[n11] = (byte)(n5 >> 8);
        n11 = n4 + 6;
        byArray2[n11] = (byte)n6;
        n11 = n4 + 7;
        byArray2[n11] = (byte)(n6 >> 8);
    }

    private void decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = ((byArray[n3 + 7] & 0xFF) << 8) + (byArray[n3 + 6] & 0xFF);
        int n6 = ((byArray[n3 + 5] & 0xFF) << 8) + (byArray[n3 + 4] & 0xFF);
        int n7 = ((byArray[n3 + 3] & 0xFF) << 8) + (byArray[n3 + 2] & 0xFF);
        int n8 = ((byArray[n3 + 1] & 0xFF) << 8) + (byArray[n3 + 0] & 0xFF);
        for (n3 = 60; n3 >= 44; n3 -= 4) {
            n5 = this.rotateWordLeft(n5, 11) - ((n8 & ~n6) + (n7 & n6) + this.workingKey[n3 + 3]);
            n6 = this.rotateWordLeft(n6, 13) - ((n5 & ~n7) + (n8 & n7) + this.workingKey[n3 + 2]);
            n7 = this.rotateWordLeft(n7, 14) - ((n6 & ~n8) + (n5 & n8) + this.workingKey[n3 + 1]);
            n8 = this.rotateWordLeft(n8, 15) - ((n7 & ~n5) + (n6 & n5) + this.workingKey[n3]);
        }
        int n9 = n8;
        int[] nArray = this.workingKey;
        n5 -= nArray[n6 & 0x3F];
        int n10 = n8;
        n8 = n6 - nArray[n7 & 0x3F];
        int n11 = n7 - nArray[n10 & 0x3F];
        n6 = n9 - this.workingKey[n5 & 0x3F];
        for (n7 = 40; n7 >= 20; n7 -= 4) {
            n5 = this.rotateWordLeft(n5, 11) - ((n6 & ~n8) + (n11 & n8) + this.workingKey[n7 + 3]);
            n8 = this.rotateWordLeft(n8, 13) - ((n5 & ~n11) + (n6 & n11) + this.workingKey[n7 + 2]);
            n11 = this.rotateWordLeft(n11, 14) - ((n8 & ~n6) + (n5 & n6) + this.workingKey[n7 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n11 & ~n5) + (n8 & n5) + this.workingKey[n7]);
        }
        int[] nArray2 = this.workingKey;
        n5 -= nArray2[n8 & 0x3F];
        n8 -= nArray2[n11 & 0x3F];
        n11 -= nArray2[n6 & 0x3F];
        n6 -= this.workingKey[n5 & 0x3F];
        for (int i3 = 16; i3 >= 0; i3 -= 4) {
            n5 = this.rotateWordLeft(n5, 11) - ((n6 & ~n8) + (n11 & n8) + this.workingKey[i3 + 3]);
            n8 = this.rotateWordLeft(n8, 13) - ((n5 & ~n11) + (n6 & n11) + this.workingKey[i3 + 2]);
            n11 = this.rotateWordLeft(n11, 14) - ((n8 & ~n6) + (n5 & n6) + this.workingKey[i3 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n11 & ~n5) + (n8 & n5) + this.workingKey[i3]);
        }
        int n12 = n4 + 0;
        byArray2[n12] = (byte)n6;
        n12 = n4 + 1;
        byArray2[n12] = (byte)(n6 >> 8);
        n12 = n4 + 2;
        byArray2[n12] = (byte)n11;
        n12 = n4 + 3;
        byArray2[n12] = (byte)(n11 >> 8);
        n12 = n4 + 4;
        byArray2[n12] = (byte)n8;
        n12 = n4 + 5;
        byArray2[n12] = (byte)(n8 >> 8);
        n12 = n4 + 6;
        byArray2[n12] = (byte)n5;
        n12 = n4 + 7;
        byArray2[n12] = (byte)(n5 >> 8);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block4: {
            block3: {
                block2: {
                    ((RC2Engine)object).encrypting = bl;
                    if (!(cipherParameters instanceof RC2Parameters)) break block2;
                    RC2Engine rC2Engine = object;
                    RC2Parameters rC2Parameters = (RC2Parameters)cipherParameters;
                    Object object = rC2Parameters.getKey();
                    rC2Engine.workingKey = rC2Engine.generateWorkingKey((byte[])object, rC2Parameters.getEffectiveKeyBits());
                    break block3;
                }
                if (!(cipherParameters instanceof KeyParameter)) break block4;
                byte[] byArray = ((KeyParameter)cipherParameters).getKey();
                ((RC2Engine)object).workingKey = ((RC2Engine)object).generateWorkingKey(byArray, byArray.length * 8);
            }
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC2 init - ")));
    }

    @Override
    public void reset() {
    }

    @Override
    public String getAlgorithmName() {
        return "RC2";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public final int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.workingKey != null) {
            if (n3 + 8 <= byArray.length) {
                if (n4 + 8 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n3, byArray2, n4);
                    } else {
                        this.decryptBlock(byArray, n3, byArray2, n4);
                    }
                    return 8;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("RC2 engine not initialised");
    }
}

