/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RC2Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class RC2WrapEngine
implements Wrapper {
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private CBCBlockCipher engine;
    private CipherParameters param;
    private ParametersWithIV paramPlusIV;
    private byte[] iv;
    private boolean forWrapping;
    private SecureRandom sr;
    public Digest sha1 = DigestFactory.createSHA1();
    public byte[] digest = new byte[20];

    private byte[] calculateCMSKeyChecksum(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        RC2WrapEngine rC2WrapEngine = this;
        rC2WrapEngine.sha1.update(byArray, 0, byArray.length);
        rC2WrapEngine.sha1.doFinal(this.digest, 0);
        System.arraycopy(rC2WrapEngine.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean checkCMSKeyChecksum(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.calculateCMSKeyChecksum(byArray), byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        RC2WrapEngine rC2WrapEngine = object;
        rC2WrapEngine.forWrapping = bl;
        rC2WrapEngine.engine = new CBCBlockCipher(new RC2Engine());
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            ((RC2WrapEngine)object).sr = parametersWithRandom.getRandom();
            cipherParameters = parametersWithRandom.getParameters();
        } else {
            ((RC2WrapEngine)object).sr = CryptoServicesRegistrar.getSecureRandom();
        }
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV;
            RC2WrapEngine rC2WrapEngine2 = object;
            rC2WrapEngine2.paramPlusIV = parametersWithIV = (ParametersWithIV)cipherParameters;
            rC2WrapEngine2.iv = parametersWithIV.getIV();
            rC2WrapEngine2.param = rC2WrapEngine2.paramPlusIV.getParameters();
            if (!rC2WrapEngine2.forWrapping) throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            object = ((RC2WrapEngine)object).iv;
            if (((RC2WrapEngine)object).iv != null && ((Object)object).length == 8) return;
            throw new IllegalArgumentException("IV is not 8 octets");
        }
        ((RC2WrapEngine)object).param = cipherParameters;
        if (!((RC2WrapEngine)object).forWrapping) return;
        byte[] byArray = new byte[8];
        ((RC2WrapEngine)object).iv = byArray;
        ((RC2WrapEngine)object).sr.nextBytes(byArray);
        RC2WrapEngine rC2WrapEngine3 = object;
        object = rC2WrapEngine3.param;
        v4.paramPlusIV = new ParametersWithIV((CipherParameters)object, rC2WrapEngine3.iv);
    }

    @Override
    public String getAlgorithmName() {
        return "RC2";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n3, int n4) {
        if (this.forWrapping) {
            int n5 = n4 + 1;
            int n6 = n5 % 8;
            n6 = n6 != 0 ? 8 - n6 + n5 : n5;
            byte[] byArray2 = byArray;
            byte[] byArray3 = new byte[n6];
            byArray = byArray3;
            byArray3[0] = (byte)n4;
            System.arraycopy(byArray2, n3, byArray, 1, n4);
            n3 = n6 - n4 - 1;
            byte[] byArray4 = new byte[n3];
            if (n3 > 0) {
                this.sr.nextBytes(byArray4);
                System.arraycopy(byArray4, 0, byArray, n5, n3);
            }
            byte[] byArray5 = this.calculateCMSKeyChecksum(byArray);
            int n7 = n6 + byArray5.length;
            byte[] byArray6 = new byte[n7];
            System.arraycopy(byArray, 0, byArray6, 0, n6);
            int n8 = byArray5.length;
            System.arraycopy(byArray5, 0, byArray6, n6, n8);
            Object object = new byte[n7];
            System.arraycopy(byArray6, 0, object, 0, n7);
            int n9 = n7 / this.engine.getBlockSize();
            if (n7 % this.engine.getBlockSize() == 0) {
                ParametersWithIV parametersWithIV;
                this.engine.init(true, this.paramPlusIV);
                for (int i3 = 0; i3 < n9; ++i3) {
                    RC2WrapEngine rC2WrapEngine = this;
                    n6 = rC2WrapEngine.engine.getBlockSize() * i3;
                    rC2WrapEngine.engine.processBlock((byte[])object, n6, (byte[])object, n6);
                }
                byte[] byArray7 = this.iv;
                n6 = this.iv.length + n7;
                byte[] byArray8 = object;
                object = new byte[n6];
                int n10 = byArray7.length;
                System.arraycopy(byArray7, 0, object, 0, n10);
                n10 = this.iv.length;
                System.arraycopy(byArray8, 0, object, n10, n7);
                byte[] byArray9 = new byte[n6];
                n10 = 0;
                while (n10 < n6) {
                    byArray9[n10++] = object[n6 - n10];
                }
                object = parametersWithIV;
                parametersWithIV = new ParametersWithIV(this.param, IV2);
                this.engine.init(true, (CipherParameters)object);
                for (int i4 = 0; i4 < n9 + 1; ++i4) {
                    RC2WrapEngine rC2WrapEngine = this;
                    n10 = rC2WrapEngine.engine.getBlockSize() * i4;
                    rC2WrapEngine.engine.processBlock(byArray9, n10, byArray9, n10);
                }
                return byArray9;
            }
            throw new IllegalStateException("Not multiple of block length");
        }
        throw new IllegalStateException("Not initialized for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] object, int n3, int n4) {
        if (!this.forWrapping) {
            if (object != null) {
                if (n4 % this.engine.getBlockSize() == 0) {
                    ParametersWithIV parametersWithIV;
                    int n5;
                    ParametersWithIV parametersWithIV2;
                    byte[] byArray = object;
                    object = parametersWithIV2;
                    parametersWithIV2 = new ParametersWithIV(this.param, IV2);
                    this.engine.init(false, (CipherParameters)object);
                    object = new byte[n4];
                    System.arraycopy(byArray, n3, object, 0, n4);
                    for (n3 = 0; n3 < n4 / this.engine.getBlockSize(); ++n3) {
                        RC2WrapEngine rC2WrapEngine = this;
                        n5 = rC2WrapEngine.engine.getBlockSize() * n3;
                        rC2WrapEngine.engine.processBlock((byte[])object, n5, (byte[])object, n5);
                    }
                    Object object2 = new byte[n4];
                    n5 = 0;
                    while (n5 < n4) {
                        object2[n5++] = object[n4 - n5];
                    }
                    object = new byte[8];
                    this.iv = object;
                    byte[] byArray2 = new byte[n4 -= 8];
                    System.arraycopy(object2, 0, object, 0, 8);
                    System.arraycopy(object2, 8, byArray2, 0, n4);
                    object = parametersWithIV;
                    RC2WrapEngine rC2WrapEngine = this;
                    object2 = rC2WrapEngine.param;
                    parametersWithIV = new ParametersWithIV((CipherParameters)object2, rC2WrapEngine.iv);
                    this.paramPlusIV = parametersWithIV;
                    this.engine.init(false, (CipherParameters)object);
                    object = new byte[n4];
                    System.arraycopy(byArray2, 0, object, 0, n4);
                    for (int i3 = 0; i3 < n4 / this.engine.getBlockSize(); ++i3) {
                        RC2WrapEngine rC2WrapEngine2 = this;
                        int n6 = rC2WrapEngine2.engine.getBlockSize() * i3;
                        rC2WrapEngine2.engine.processBlock((byte[])object, n6, (byte[])object, n6);
                    }
                    int n7 = n4 - 8;
                    object = new byte[n7];
                    byte[] byArray3 = new byte[8];
                    System.arraycopy(object, 0, object, 0, n7);
                    System.arraycopy(object, n7, byArray3, 0, 8);
                    if (this.checkCMSKeyChecksum((byte[])object, byArray3)) {
                        byte by = object[0];
                        if (n7 - ((by & 0xFF) + 1) <= 7) {
                            byte[] byArray4 = new byte[by];
                            System.arraycopy(object, 1, byArray4, 0, by);
                            return byArray4;
                        }
                        throw new InvalidCipherTextException(b.a("too many pad bytes (").append(n7 - ((object[0] & 0xFF) + 1)).append(")").toString());
                    }
                    throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
                }
                throw new InvalidCipherTextException(b.a("Ciphertext not multiple of ").append(this.engine.getBlockSize()).toString());
            }
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        throw new IllegalStateException("Not set for unwrapping");
    }
}

