/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class RC4Engine
implements StreamCipher {
    private static final int STATE_LENGTH = 256;
    private byte[] engineState = null;
    private int x = 0;
    private int y = 0;
    private byte[] workingKey = null;

    private void setKey(byte[] byArray) {
        this.workingKey = byArray;
        this.x = 0;
        this.y = 0;
        if (this.engineState == null) {
            this.engineState = new byte[256];
        }
        int n3 = 0;
        while (n3 < 256) {
            int n4 = n3++;
            this.engineState[n4] = (byte)n4;
        }
        n3 = 0;
        int n5 = 0;
        for (int i3 = 0; i3 < 256; ++i3) {
            int n6 = n3;
            n3 = byArray[n3] & 0xFF;
            byte[] byArray2 = this.engineState;
            byte[] byArray3 = byArray2;
            int n7 = n3;
            n3 = byArray3[i3];
            n5 = n7 + n3 + n5 & 0xFF;
            byArray2[i3] = byArray3[n5];
            this.engineState[n5] = n3;
            n3 = (n6 + 1) % byArray.length;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            RC4Engine rC4Engine = object;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            Object object = byArray;
            rC4Engine.workingKey = byArray;
            rC4Engine.setKey((byte[])object);
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC4 init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "RC4";
    }

    @Override
    public byte returnByte(byte by) {
        int n3;
        byte by2 = by;
        RC4Engine rC4Engine = this;
        int n4 = rC4Engine.x + 1 & 0xFF;
        by = (byte)n4;
        rC4Engine.x = n4;
        byte[] byArray = rC4Engine.engineState;
        byte by3 = by;
        byte by4 = by;
        by = byArray[by];
        this.y = n3 = by + this.y & 0xFF;
        byArray[by4] = byArray[n3];
        byArray[n3] = by;
        return (byte)(by2 ^ rC4Engine.engineState[byArray[by3] + by & 0xFF]);
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (n3 + n4 <= byArray.length) {
            if (n5 + n4 <= byArray2.length) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n6;
                    int n7;
                    RC4Engine rC4Engine = this;
                    rC4Engine.x = n7 = rC4Engine.x + 1 & 0xFF;
                    byte[] byArray3 = rC4Engine.engineState;
                    byte[] byArray4 = byArray3;
                    byte by = byArray4[n7];
                    this.y = n6 = by + this.y & 0xFF;
                    byArray3[n7] = byArray4[n6];
                    rC4Engine.engineState[n6] = by;
                    n6 = i3 + n5;
                    byArray2[n6] = (byte)(byArray[i3 + n3] ^ byArray4[byArray4[n7] + by & 0xFF]);
                }
                return n4;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public void reset() {
        RC4Engine rC4Engine = this;
        rC4Engine.setKey(rC4Engine.workingKey);
    }
}

