/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC5Parameters;

public class RC532Engine
implements BlockCipher {
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private int _noRounds = 12;
    private int[] _S = null;
    private boolean forEncryption;

    private void setKey(byte[] byArray) {
        int[] nArray;
        int n3;
        int n4 = (byArray.length + 3) / 4;
        int[] nArray2 = new int[n4];
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            n3 = i3 / 4;
            nArray2[n3] = nArray2[n3] + ((byArray[i3] & 0xFF) << i3 % 4 * 8);
        }
        int[] nArray3 = new int[(this._noRounds + 1) * 2];
        this._S = nArray3;
        nArray3[0] = -1209970333;
        int n5 = 1;
        while (true) {
            nArray = this._S;
            if (n5 >= this._S.length) break;
            nArray[n5] = nArray[n5 - 1] + -1640531527;
            ++n5;
        }
        n5 = n4 > nArray.length ? n4 * 3 : nArray.length * 3;
        int n6 = 0;
        n3 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i4 = 0; i4 < n5; ++i4) {
            RC532Engine rC532Engine = this;
            int[] nArray4 = rC532Engine._S;
            n6 = rC532Engine.rotateLeft(rC532Engine._S[n7] + n6 + n3, 3);
            int n9 = n3;
            nArray4[n7] = n6;
            n3 = nArray2[n8] + n6 + n3;
            nArray2[n8] = n3 = rC532Engine.rotateLeft(n3, n6 + n9);
            n7 = (n7 + 1) % this._S.length;
            n8 = (n8 + 1) % n4;
        }
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.bytesToWord(byArray, n3) + this._S[0];
        n3 = this.bytesToWord(byArray, n3 + 4) + this._S[1];
        for (int i3 = 1; i3 <= this._noRounds; ++i3) {
            int n6 = n3;
            int n7 = this.rotateLeft(n5 ^ n3, n3);
            n5 = i3 * 2;
            n3 = n7 + this._S[n5];
            n5 = this.rotateLeft(n6 ^ n3, n3) + this._S[n5 + 1];
            int n8 = n3;
            n3 = n5;
            n5 = n8;
        }
        RC532Engine rC532Engine = this;
        rC532Engine.wordToBytes(n5, byArray2, n4);
        int n9 = n4 + 4;
        rC532Engine.wordToBytes(n3, byArray2, n9);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        RC532Engine rC532Engine = this;
        int n5 = rC532Engine.bytesToWord(byArray, n3);
        int n6 = rC532Engine.bytesToWord(byArray, n3 + 4);
        for (n3 = (v751687)._noRounds; n3 >= 1; --n3) {
            int n7 = n5;
            RC532Engine rC532Engine2 = this;
            int n8 = n6;
            n6 = n3 * 2;
            n5 = rC532Engine2.rotateRight(n8 - this._S[n6 + 1], n5) ^ n5;
            n6 = this.rotateRight(n7 - rC532Engine2._S[n6], n5) ^ n5;
            int n9 = n6;
            n6 = n5;
            n5 = n9;
        }
        RC532Engine rC532Engine3 = this;
        rC532Engine3.wordToBytes(n5 - this._S[0], byArray2, n4);
        this.wordToBytes(n6 - rC532Engine3._S[1], byArray2, n4 + 4);
        return 8;
    }

    private int rotateLeft(int n3, int n4) {
        int n5 = n4 & 0x1F;
        return n3 << n5 | n3 >>> 32 - n5;
    }

    private int rotateRight(int n3, int n4) {
        int n5 = n4 & 0x1F;
        return n3 >>> n5 | n3 << 32 - n5;
    }

    private int bytesToWord(byte[] byArray, int n3) {
        return byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 3] & 0xFF) << 24;
    }

    private void wordToBytes(int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)n3;
        int n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >> 8);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >> 16);
        n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >> 24);
    }

    @Override
    public String getAlgorithmName() {
        return "RC5-32";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block4: {
            block3: {
                block2: {
                    if (!(cipherParameters instanceof RC5Parameters)) break block2;
                    cipherParameters = (RC5Parameters)cipherParameters;
                    this._noRounds = ((RC5Parameters)cipherParameters).getRounds();
                    this.setKey(((RC5Parameters)cipherParameters).getKey());
                    break block3;
                }
                if (!(cipherParameters instanceof KeyParameter)) break block4;
                this.setKey(((KeyParameter)cipherParameters).getKey());
            }
            this.forEncryption = bl;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC532 init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        return this.forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
    }

    @Override
    public void reset() {
    }
}

