/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC5Parameters;

public class RC564Engine
implements BlockCipher {
    private static final int wordSize = 64;
    private static final int bytesPerWord = 8;
    private static final long P64 = -5196783011329398165L;
    private static final long Q64 = -7046029254386353131L;
    private int _noRounds = 12;
    private long[] _S = null;
    private boolean forEncryption;

    private void setKey(byte[] byArray) {
        long[] lArray;
        long l3;
        int n3 = (byArray.length + 7) / 8;
        long[] lArray2 = new long[n3];
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            int n4 = i3 / 8;
            lArray2[n4] = l3 = lArray2[n4] + ((long)(byArray[i3] & 0xFF) << i3 % 8 * 8);
        }
        long[] lArray3 = new long[(this._noRounds + 1) * 2];
        this._S = lArray3;
        lArray3[0] = -5196783011329398165L;
        int n5 = 1;
        while (true) {
            lArray = this._S;
            if (n5 >= this._S.length) break;
            lArray[n5] = lArray[n5 - 1] + -7046029254386353131L;
            ++n5;
        }
        n5 = n3 > lArray.length ? n3 * 3 : lArray.length * 3;
        long l4 = 0L;
        l3 = 0L;
        int n6 = 0;
        int n7 = 0;
        for (int i4 = 0; i4 < n5; ++i4) {
            RC564Engine rC564Engine = this;
            long[] lArray4 = rC564Engine._S;
            l4 = rC564Engine.rotateLeft(rC564Engine._S[n6] + l4 + l3, 3L);
            long l5 = l3;
            lArray4[n6] = l4;
            l3 = lArray2[n7] + l4 + l3;
            long l6 = l4 + l5;
            lArray2[n7] = l3 = rC564Engine.rotateLeft(l3, l6);
            n6 = (n6 + 1) % this._S.length;
            n7 = (n7 + 1) % n3;
        }
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        long l3 = this.bytesToWord(byArray, n3) + this._S[0];
        long l4 = this.bytesToWord(byArray, n3 + 8) + this._S[1];
        for (int i3 = 1; i3 <= this._noRounds; ++i3) {
            long l5 = l4;
            int n5 = i3 * 2;
            l4 = this.rotateLeft(l3 ^ l4, l4) + this._S[n5];
            l3 = this.rotateLeft(l5 ^ l4, l4) + this._S[n5 + 1];
            long l6 = l4;
            l4 = l3;
            l3 = l6;
        }
        RC564Engine rC564Engine = this;
        rC564Engine.wordToBytes(l3, byArray2, n4);
        int n6 = n4 + 8;
        rC564Engine.wordToBytes(l4, byArray2, n6);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        RC564Engine rC564Engine = this;
        long l3 = rC564Engine.bytesToWord(byArray, n3);
        long l4 = rC564Engine.bytesToWord(byArray, n3 + 8);
        for (int i3 = (v752115)._noRounds; i3 >= 1; --i3) {
            long l5 = l3;
            RC564Engine rC564Engine2 = this;
            int n5 = i3 * 2;
            l3 = rC564Engine2.rotateRight(l4 - this._S[n5 + 1], l3) ^ l3;
            l4 = this.rotateRight(l5 - rC564Engine2._S[n5], l3) ^ l3;
            long l6 = l4;
            l4 = l3;
            l3 = l6;
        }
        RC564Engine rC564Engine3 = this;
        rC564Engine3.wordToBytes(l3 - this._S[0], byArray2, n4);
        this.wordToBytes(l4 - rC564Engine3._S[1], byArray2, n4 + 8);
        return 16;
    }

    private long rotateLeft(long l3, long l4) {
        return l3 << (int)(l4 &= 0x3FL) | l3 >>> (int)(64L - l4);
    }

    private long rotateRight(long l3, long l4) {
        return l3 >>> (int)(l4 &= 0x3FL) | l3 << (int)(64L - l4);
    }

    private long bytesToWord(byte[] byArray, int n3) {
        long l3 = 0L;
        for (int i3 = 7; i3 >= 0; --i3) {
            l3 = (l3 << 8) + (long)(byArray[i3 + n3] & 0xFF);
        }
        return l3;
    }

    private void wordToBytes(long l3, byte[] byArray, int n3) {
        for (int i3 = 0; i3 < 8; ++i3) {
            byArray[i3 + n3] = (byte)l3;
            l3 >>>= 8;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "RC5-64";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof RC5Parameters) {
            RC564Engine rC564Engine = rC5Parameters;
            RC5Parameters rC5Parameters = (RC5Parameters)cipherParameters;
            rC564Engine.forEncryption = bl;
            rC564Engine._noRounds = rC5Parameters.getRounds();
            rC564Engine.setKey(rC5Parameters.getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC564 init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        return this.forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
    }

    @Override
    public void reset() {
    }
}

