/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class RC6Engine
implements BlockCipher {
    private static final int wordSize = 32;
    private static final int bytesPerWord = 4;
    private static final int _noRounds = 20;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private static final int LGW = 5;
    private int[] _S = null;
    private boolean forEncryption;

    private void setKey(byte[] byArray) {
        int[] nArray;
        int n3;
        int cfr_ignored_0 = (byArray.length + 3) / 4;
        int n4 = (byArray.length + 4 - 1) / 4;
        int[] nArray2 = new int[n4];
        for (int i3 = byArray.length - 1; i3 >= 0; --i3) {
            n3 = i3 / 4;
            nArray2[n3] = (nArray2[n3] << 8) + (byArray[i3] & 0xFF);
        }
        int[] nArray3 = new int[44];
        this._S = nArray3;
        nArray3[0] = -1209970333;
        int n5 = 1;
        while (true) {
            nArray = this._S;
            if (n5 >= this._S.length) break;
            nArray[n5] = nArray[n5 - 1] + -1640531527;
            ++n5;
        }
        n5 = n4 > nArray.length ? n4 * 3 : nArray.length * 3;
        int n6 = 0;
        n3 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i4 = 0; i4 < n5; ++i4) {
            RC6Engine rC6Engine = this;
            int[] nArray4 = rC6Engine._S;
            n6 = rC6Engine.rotateLeft(rC6Engine._S[n7] + n6 + n3, 3);
            int n9 = n3;
            nArray4[n7] = n6;
            n3 = nArray2[n8] + n6 + n3;
            nArray2[n8] = n3 = rC6Engine.rotateLeft(n3, n6 + n9);
            n7 = (n7 + 1) % this._S.length;
            n8 = (n8 + 1) % n4;
        }
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = this.bytesToWord(byArray, n3);
        n3 = this.bytesToWord(byArray, n3 + 4);
        int n8 = this.bytesToWord(byArray, n6 + 8);
        n3 += this._S[0];
        int n9 = this.bytesToWord(byArray, n5 + 12) + this._S[1];
        for (int i3 = 1; i3 <= 20; ++i3) {
            int n10 = n8;
            int n11 = n7;
            n7 = this.rotateLeft((n3 * 2 + 1) * n3, 5);
            n8 = this.rotateLeft((n9 * 2 + 1) * n9, 5);
            int n12 = i3 * 2;
            int n13 = this.rotateLeft(n11 ^ n7, n8) + this._S[n12];
            n7 = this.rotateLeft(n10 ^ n8, n7) + this._S[n12 + 1];
            int n14 = n3;
            int n15 = n9;
            n9 = n13;
            n3 = n7;
            n8 = n15;
            n7 = n14;
        }
        RC6Engine rC6Engine = this;
        int n16 = n7 + this._S[42];
        n7 = n8 + this._S[43];
        this.wordToBytes(n16, byArray2, n4);
        rC6Engine.wordToBytes(n3, byArray2, n4 + 4);
        rC6Engine.wordToBytes(n7, byArray2, n4 + 8);
        this.wordToBytes(n9, byArray2, n4 + 12);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.bytesToWord(byArray, n3);
        RC6Engine rC6Engine = this;
        int n6 = n3;
        int n7 = this.bytesToWord(byArray, n3 + 4);
        n3 = this.bytesToWord(byArray, n3 + 8);
        int n8 = rC6Engine.bytesToWord(byArray, n6 + 12);
        int n9 = n5 - rC6Engine._S[42];
        int n10 = n9;
        n9 = n3 -= rC6Engine._S[43];
        n3 = n10;
        for (int i3 = 20; i3 >= 1; --i3) {
            int n11 = n8;
            RC6Engine rC6Engine2 = this;
            int n12 = n7;
            RC6Engine rC6Engine3 = this;
            n7 = this.rotateLeft((n3 * 2 + 1) * n3, 5);
            n8 = rC6Engine3.rotateLeft((n9 * 2 + 1) * n9, 5);
            int n13 = i3 * 2;
            int n14 = rC6Engine2.rotateRight(n12 - rC6Engine3._S[n13 + 1], n7) ^ n8;
            n7 = this.rotateRight(n11 - rC6Engine2._S[n13], n8) ^ n7;
            int n15 = n9;
            int n16 = n3;
            n9 = n14;
            n3 = n7;
            n7 = n16;
            n8 = n15;
        }
        RC6Engine rC6Engine4 = this;
        RC6Engine rC6Engine5 = this;
        int n17 = n8 - this._S[1];
        rC6Engine5.wordToBytes(n3, byArray2, n4);
        rC6Engine5.wordToBytes(n7 -= this._S[0], byArray2, n4 + 4);
        rC6Engine4.wordToBytes(n9, byArray2, n4 + 8);
        rC6Engine4.wordToBytes(n17, byArray2, n4 + 12);
        return 16;
    }

    private int rotateLeft(int n3, int n4) {
        return n3 << n4 | n3 >>> -n4;
    }

    private int rotateRight(int n3, int n4) {
        return n3 >>> n4 | n3 << -n4;
    }

    private int bytesToWord(byte[] byArray, int n3) {
        int n4 = 0;
        for (int i3 = 3; i3 >= 0; --i3) {
            n4 = (n4 << 8) + (byArray[i3 + n3] & 0xFF);
        }
        return n4;
    }

    private void wordToBytes(int n3, byte[] byArray, int n4) {
        for (int i3 = 0; i3 < 4; ++i3) {
            int n5 = n3;
            int n6 = n3;
            n3 = i3 + n4;
            byArray[n3] = (byte)n6;
            n3 = n5 >>> 8;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "RC6";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            RC6Engine rC6Engine = keyParameter;
            KeyParameter keyParameter = (KeyParameter)cipherParameters;
            rC6Engine.forEncryption = bl;
            rC6Engine.setKey(keyParameter.getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC6 init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        RC6Engine rC6Engine = this;
        int n5 = rC6Engine.getBlockSize();
        if (rC6Engine._S != null) {
            if (n3 + n5 <= byArray.length) {
                if (n4 + n5 <= byArray2.length) {
                    return this.forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("RC6 engine not initialised");
    }

    @Override
    public void reset() {
    }
}

