/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher blockCipher) {
        CBCBlockCipher cBCBlockCipher;
        CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
        cBCBlockCipher = new CBCBlockCipher(blockCipher);
        v1.engine = cBCBlockCipher2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block7: {
            block6: {
                block4: {
                    block5: {
                        this.forWrapping = bl;
                        if (!(cipherParameters instanceof ParametersWithRandom)) break block4;
                        ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                        this.rand = parametersWithRandom.getRandom();
                        if (!(parametersWithRandom.getParameters() instanceof ParametersWithIV)) break block5;
                        this.param = (ParametersWithIV)parametersWithRandom.getParameters();
                        break block6;
                    }
                    throw new IllegalArgumentException("RFC3211Wrap requires an IV");
                }
                if (bl) {
                    this.rand = CryptoServicesRegistrar.getSecureRandom();
                }
                if (!(cipherParameters instanceof ParametersWithIV)) break block7;
                this.param = (ParametersWithIV)cipherParameters;
            }
            return;
        }
        throw new IllegalArgumentException("RFC3211Wrap requires an IV");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte[] wrap(byte[] byArray, int n3, int n4) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        if (n4 <= 255 && n4 >= 0) {
            RFC3211WrapEngine rFC3211WrapEngine = this;
            rFC3211WrapEngine.engine.init(true, this.param);
            int n5 = rFC3211WrapEngine.engine.getBlockSize();
            int n6 = n4 + 4;
            int n7 = n5 * 2;
            if (n6 >= n7) {
                n7 = n6 % n5 == 0 ? n6 : (n6 / n5 + 1) * n5;
            }
            byte[] byArray2 = new byte[n7];
            byte[] byArray3 = byArray2;
            byArray2[0] = (byte)n4;
            System.arraycopy(byArray, n3, byArray2, 4, n4);
            int n8 = byArray3.length - n6;
            byte[] byArray4 = new byte[n8];
            this.rand.nextBytes(byArray4);
            System.arraycopy(byArray4, 0, byArray2, n6, n8);
            byArray3[1] = ~byArray3[4];
            byArray3[2] = ~byArray3[5];
            byArray2[3] = ~byArray3[6];
            for (n8 = 0; n8 < byArray2.length; n8 += n5) {
                this.engine.processBlock(byArray2, n8, byArray2, n8);
            }
            n8 = 0;
            while (true) {
                if (n8 >= byArray2.length) {
                    return byArray2;
                }
                this.engine.processBlock(byArray2, n8, byArray2, n8);
                n8 += n5;
            }
        }
        throw new IllegalArgumentException("input must be from 0 to 255 bytes");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n3, int n4) {
        if (!this.forWrapping) {
            int n5 = this.engine.getBlockSize();
            if (n4 >= n5 * 2) {
                int n6;
                ParametersWithIV parametersWithIV;
                ParametersWithIV parametersWithIV2;
                byte[] byArray2 = byArray;
                byte[] byArray3 = byArray;
                byArray = new byte[n4];
                byte[] byArray4 = new byte[n5];
                System.arraycopy(byArray3, n3, byArray, 0, n4);
                System.arraycopy(byArray2, n3, byArray4, 0, n5);
                ParametersWithIV parametersWithIV3 = parametersWithIV2;
                parametersWithIV2 = new ParametersWithIV(this.param.getParameters(), byArray4);
                this.engine.init(false, parametersWithIV3);
                for (int i3 = n5; i3 < n4; i3 += n5) {
                    this.engine.processBlock(byArray, i3, byArray, i3);
                }
                RFC3211WrapEngine rFC3211WrapEngine = this;
                System.arraycopy(byArray, n4 - n5, byArray4, 0, n5);
                ParametersWithIV parametersWithIV4 = parametersWithIV;
                parametersWithIV = new ParametersWithIV(this.param.getParameters(), byArray4);
                rFC3211WrapEngine.engine.init(false, parametersWithIV4);
                rFC3211WrapEngine.engine.processBlock(byArray, 0, byArray, 0);
                rFC3211WrapEngine.engine.init(false, this.param);
                for (n6 = 0; n6 < n4; n6 += n5) {
                    this.engine.processBlock(byArray, n6, byArray, n6);
                }
                byte by = byArray[0];
                n6 = n4 - 4;
                n4 = (by & 0xFF) > n6 ? 1 : 0;
                byte[] byArray5 = n4 != 0 ? new byte[n6] : new byte[by & 0xFF];
                n6 = byArray5.length;
                System.arraycopy(byArray, 4, byArray5, 0, n6);
                n6 = 0;
                n5 = 0;
                while (n5 != 3) {
                    int n7 = n6;
                    n6 = n5 + 1;
                    n5 = n7 | (byte)(~byArray[n6]) ^ byArray[n5 + 4];
                    int n8 = n6;
                    n6 = n5;
                    n5 = n8;
                }
                Arrays.clear(byArray);
                if (((n6 != 0 ? 1 : 0) | n4) == 0) {
                    return byArray5;
                }
                throw new InvalidCipherTextException("wrapped key corrupted");
            }
            throw new InvalidCipherTextException("input too short");
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

