/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private boolean wrapCipherMode;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher blockCipher) {
        this(blockCipher, false);
    }

    public RFC3394WrapEngine(BlockCipher blockCipher, boolean bl) {
        this.engine = blockCipher;
        this.wrapCipherMode = bl ^ true;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        ((RFC3394WrapEngine)((Object)parametersWithIV)).forWrapping = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            ((RFC3394WrapEngine)((Object)parametersWithIV)).param = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            RFC3394WrapEngine rFC3394WrapEngine = parametersWithIV;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            rFC3394WrapEngine.iv = parametersWithIV.getIV();
            rFC3394WrapEngine.param = (KeyParameter)parametersWithIV.getParameters();
            if (rFC3394WrapEngine.iv.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] byArray, int n3, int n4) {
        if (this.forWrapping) {
            int n5 = n4 / 8;
            if (n5 * 8 == n4) {
                byte[] byArray2 = byArray;
                RFC3394WrapEngine rFC3394WrapEngine = this;
                byArray = new byte[n4 + rFC3394WrapEngine.iv.length];
                byte[] byArray3 = new byte[rFC3394WrapEngine.iv.length + 8];
                int n6 = rFC3394WrapEngine.iv.length;
                System.arraycopy(rFC3394WrapEngine.iv, 0, byArray, 0, n6);
                System.arraycopy(byArray2, n3, byArray, rFC3394WrapEngine.iv.length, n4);
                RFC3394WrapEngine rFC3394WrapEngine2 = this;
                n4 = rFC3394WrapEngine2.wrapCipherMode ? 1 : 0;
                this.engine.init(n4 != 0, rFC3394WrapEngine2.param);
                for (n4 = 0; n4 != 6; ++n4) {
                    for (n6 = 1; n6 <= n5; ++n6) {
                        int n7 = this.iv.length;
                        System.arraycopy(byArray, 0, byArray3, 0, n7);
                        n7 = n6 * 8;
                        System.arraycopy(byArray, n7, byArray3, this.iv.length, 8);
                        this.engine.processBlock(byArray3, 0, byArray3, 0);
                        int n8 = n5 * n4 + n6;
                        int n9 = 1;
                        while (n8 != 0) {
                            int n10 = n8;
                            n8 = (byte)n8;
                            int n11 = this.iv.length - n9;
                            byArray3[n11] = (byte)(byArray3[n11] ^ n8);
                            n8 = n10 >>> 8;
                            ++n9;
                        }
                        System.arraycopy(byArray3, 0, byArray, 0, 8);
                        System.arraycopy(byArray3, 8, byArray, n7, 8);
                    }
                }
                return byArray;
            }
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        throw new IllegalStateException("not set for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n3, int n4) {
        if (!this.forWrapping) {
            int n5 = n4 / 8;
            if (n5 * 8 == n4) {
                int n6 = n5;
                byte[] byArray2 = byArray;
                byte[] byArray3 = byArray;
                byArray = new byte[n4 - this.iv.length];
                byte[] byArray4 = new byte[this.iv.length];
                byte[] byArray5 = new byte[this.iv.length + 8];
                n5 = this.iv.length;
                System.arraycopy(byArray3, n3, byArray4, 0, n5);
                byte[] byArray6 = this.iv;
                int n7 = n3 + this.iv.length;
                int n8 = n4 - byArray6.length;
                System.arraycopy(byArray2, n7, byArray, 0, n8);
                RFC3394WrapEngine rFC3394WrapEngine = this;
                n8 = rFC3394WrapEngine.wrapCipherMode ^ 1;
                this.engine.init(n8 != 0, rFC3394WrapEngine.param);
                n8 = n6 - 1;
                for (n7 = 5; n7 >= 0; --n7) {
                    for (int i3 = n8; i3 >= 1; --i3) {
                        int n9 = this.iv.length;
                        System.arraycopy(byArray4, 0, byArray5, 0, n9);
                        n9 = (i3 - 1) * 8;
                        System.arraycopy(byArray, n9, byArray5, this.iv.length, 8);
                        int n10 = n8 * n7 + i3;
                        int n11 = 1;
                        while (n10 != 0) {
                            int n12 = n10;
                            n10 = (byte)n10;
                            int n13 = this.iv.length - n11;
                            byArray5[n13] = (byte)(byArray5[n13] ^ n10);
                            n10 = n12 >>> 8;
                            ++n11;
                        }
                        this.engine.processBlock(byArray5, 0, byArray5, 0);
                        System.arraycopy(byArray5, 0, byArray4, 0, 8);
                        System.arraycopy(byArray5, 8, byArray, n9, 8);
                    }
                }
                if (Arrays.constantTimeAreEqual(byArray4, this.iv)) {
                    return byArray;
                }
                throw new InvalidCipherTextException("checksum failed");
            }
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

