/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RFC3394WrapEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class RFC5649WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] highOrderIV;
    private byte[] preIV;
    private byte[] extractedAIV;

    public RFC5649WrapEngine(BlockCipher blockCipher) {
        byte[] byArray = new byte[4];
        Object object = byArray;
        byArray[0] = -90;
        byArray[1] = 89;
        byArray[2] = 89;
        byArray[3] = -90;
        v1.highOrderIV = (byte[])object;
        v1.preIV = (byte[])object;
        v1.extractedAIV = null;
        v1.engine = blockCipher;
    }

    private byte[] padPlaintext(byte[] byArray) {
        int n3 = byArray.length;
        int n4 = (8 - n3 % 8) % 8;
        byte[] byArray2 = byArray;
        byArray = new byte[n3 + n4];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        if (n4 != 0) {
            System.arraycopy(new byte[n4], 0, byArray, n3, n4);
        }
        return byArray;
    }

    private byte[] rfc3394UnwrapNoIvCheck(byte[] byArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = 8;
        n3 = n4 - n7;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, n6, byArray3, 0, n7);
        System.arraycopy(byArray, n5 + n7, byArray2, 0, n3);
        this.engine.init(false, this.param);
        n3 = n4 / 8 - 1;
        for (int i3 = 5; i3 >= 0; --i3) {
            for (int i4 = n3; i4 >= 1; --i4) {
                System.arraycopy(byArray3, 0, byArray4, 0, n7);
                int n8 = (i4 - 1) * 8;
                System.arraycopy(byArray2, n8, byArray4, n7, 8);
                int n9 = n3 * i3 + i4;
                int n10 = 1;
                while (n9 != 0) {
                    int n11 = n9;
                    n9 = (byte)n9;
                    int n12 = n7 - n10;
                    byArray4[n12] = (byte)(byArray4[n12] ^ n9);
                    n9 = n11 >>> 8;
                    ++n10;
                }
                this.engine.processBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, 8);
                System.arraycopy(byArray4, 8, byArray2, n8, 8);
            }
        }
        this.extractedAIV = byArray3;
        return byArray2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        ((RFC5649WrapEngine)((Object)parametersWithIV)).forWrapping = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            ((RFC5649WrapEngine)((Object)parametersWithIV)).param = (KeyParameter)cipherParameters;
            ((RFC5649WrapEngine)((Object)parametersWithIV)).preIV = ((RFC5649WrapEngine)((Object)parametersWithIV)).highOrderIV;
        } else if (cipherParameters instanceof ParametersWithIV) {
            RFC5649WrapEngine rFC5649WrapEngine = parametersWithIV;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            rFC5649WrapEngine.preIV = parametersWithIV.getIV();
            rFC5649WrapEngine.param = (KeyParameter)parametersWithIV.getParameters();
            if (rFC5649WrapEngine.preIV.length != 4) {
                throw new IllegalArgumentException("IV length not equal to 4");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] byArray, int n3, int n4) {
        if (this.forWrapping) {
            ParametersWithIV parametersWithIV;
            RFC3394WrapEngine rFC3394WrapEngine;
            int n5 = n4;
            int n6 = 8;
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = Pack.intToBigEndian(n5);
            RFC5649WrapEngine rFC5649WrapEngine = this;
            int n7 = rFC5649WrapEngine.preIV.length;
            System.arraycopy(rFC5649WrapEngine.preIV, 0, byArray2, 0, n7);
            n7 = rFC5649WrapEngine.preIV.length;
            int n8 = byArray3.length;
            System.arraycopy(byArray3, 0, byArray2, n7, n8);
            byte[] byArray4 = new byte[n5];
            System.arraycopy(byArray, n3, byArray4, 0, n4);
            byte[] byArray5 = this.padPlaintext(byArray4);
            if (byArray5.length == 8) {
                int n9 = byArray5.length + n6;
                byArray5 = new byte[n9];
                System.arraycopy(byArray2, 0, byArray5, 0, n6);
                int n10 = byArray5.length;
                System.arraycopy(byArray5, 0, byArray5, n6, n10);
                this.engine.init(true, this.param);
                n6 = 0;
                while (n6 < n9) {
                    RFC5649WrapEngine rFC5649WrapEngine2 = this;
                    rFC5649WrapEngine2.engine.processBlock(byArray5, n6, byArray5, n6);
                    n6 = rFC5649WrapEngine2.engine.getBlockSize() + n6;
                }
                return byArray5;
            }
            Object object = rFC3394WrapEngine;
            RFC3394WrapEngine rFC3394WrapEngine2 = object;
            rFC3394WrapEngine2(this.engine);
            object = parametersWithIV;
            parametersWithIV = new ParametersWithIV(this.param, byArray2);
            rFC3394WrapEngine2.init(true, (CipherParameters)object);
            return rFC3394WrapEngine.wrap(byArray5, 0, byArray5.length);
        }
        throw new IllegalStateException("not set for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n3, int n4) {
        if (!this.forWrapping) {
            int n5 = n4 / 8;
            if (n5 * 8 == n4) {
                if (n5 > 1) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, n3, byArray2, 0, n4);
                    byte[] byArray3 = new byte[n4];
                    if (n5 == 2) {
                        this.engine.init(false, this.param);
                        int n6 = 0;
                        while (n6 < n4) {
                            RFC5649WrapEngine rFC5649WrapEngine = this;
                            rFC5649WrapEngine.engine.processBlock(byArray2, n6, byArray3, n6);
                            n6 = rFC5649WrapEngine.engine.getBlockSize() + n6;
                        }
                        byArray = new byte[8];
                        this.extractedAIV = byArray;
                        n3 = byArray.length;
                        System.arraycopy(byArray3, 0, byArray, 0, n3);
                        byArray = this.extractedAIV;
                        n3 = n4 - this.extractedAIV.length;
                        byte[] byArray4 = byArray;
                        byArray = new byte[n3];
                        System.arraycopy(byArray3, byArray4.length, byArray, 0, n3);
                    } else {
                        byArray = this.rfc3394UnwrapNoIvCheck(byArray, n3, n4);
                    }
                    byte[] byArray5 = new byte[4];
                    byte[] byArray6 = new byte[4];
                    RFC5649WrapEngine rFC5649WrapEngine = this;
                    System.arraycopy(rFC5649WrapEngine.extractedAIV, 0, byArray5, 0, 4);
                    System.arraycopy(rFC5649WrapEngine.extractedAIV, 4, byArray6, 0, 4);
                    int n7 = Pack.bigEndianToInt(byArray6, 0);
                    boolean bl = Arrays.constantTimeAreEqual(byArray5, this.preIV);
                    int n8 = byArray.length;
                    if (n7 <= n8 - 8) {
                        bl = false;
                    }
                    if (n7 > n8) {
                        bl = false;
                    }
                    if ((n8 -= n7) >= 8 || n8 < 0) {
                        bl = false;
                        n8 = 4;
                    }
                    int n9 = n8;
                    byArray2 = new byte[n9];
                    byArray3 = new byte[n9];
                    System.arraycopy(byArray, byArray.length - n8, byArray3, 0, n8);
                    if (!Arrays.constantTimeAreEqual(byArray3, byArray2)) {
                        bl = false;
                    }
                    if (bl) {
                        byte[] byArray7 = new byte[n7];
                        System.arraycopy(byArray, 0, byArray7, 0, n7);
                        return byArray7;
                    }
                    throw new InvalidCipherTextException("checksum failed");
                }
                throw new InvalidCipherTextException("unwrap data must be at least 16 bytes");
            }
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

