/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class RijndaelEngine
implements BlockCipher {
    private static final int MAXROUNDS = 14;
    private static final int MAXKC = 64;
    private static final byte[] logtable = new byte[]{0, 0, 25, 1, 50, 2, 26, -58, 75, -57, 27, 104, 51, -18, -33, 3, 100, 4, -32, 14, 52, -115, -127, -17, 76, 113, 8, -56, -8, 105, 28, -63, 125, -62, 29, -75, -7, -71, 39, 106, 77, -28, -90, 114, -102, -55, 9, 120, 101, 47, -118, 5, 33, 15, -31, 36, 18, -16, -126, 69, 53, -109, -38, -114, -106, -113, -37, -67, 54, -48, -50, -108, 19, 92, -46, -15, 64, 70, -125, 56, 102, -35, -3, 48, -65, 6, -117, 98, -77, 37, -30, -104, 34, -120, -111, 16, 126, 110, 72, -61, -93, -74, 30, 66, 58, 107, 40, 84, -6, -123, 61, -70, 43, 121, 10, 21, -101, -97, 94, -54, 78, -44, -84, -27, -13, 115, -89, 87, -81, 88, -88, 80, -12, -22, -42, 116, 79, -82, -23, -43, -25, -26, -83, -24, 44, -41, 117, 122, -21, 22, 11, -11, 89, -53, 95, -80, -100, -87, 81, -96, 127, 12, -10, 111, 23, -60, 73, -20, -40, 67, 31, 45, -92, 118, 123, -73, -52, -69, 62, 90, -5, 96, -79, -122, 59, 82, -95, 108, -86, 85, 41, -99, -105, -78, -121, -112, 97, -66, -36, -4, -68, -107, -49, -51, 55, 63, 91, -47, 83, 57, -124, 60, 65, -94, 109, 71, 20, 42, -98, 93, 86, -14, -45, -85, 68, 17, -110, -39, 35, 32, 46, -119, -76, 124, -72, 38, 119, -103, -29, -91, 103, 74, -19, -34, -59, 49, -2, 24, 13, 99, -116, -128, -64, -9, 112, 7};
    private static final byte[] aLogtable = new byte[]{0, 3, 5, 15, 17, 51, 85, -1, 26, 46, 114, -106, -95, -8, 19, 53, 95, -31, 56, 72, -40, 115, -107, -92, -9, 2, 6, 10, 30, 34, 102, -86, -27, 52, 92, -28, 55, 89, -21, 38, 106, -66, -39, 112, -112, -85, -26, 49, 83, -11, 4, 12, 20, 60, 68, -52, 79, -47, 104, -72, -45, 110, -78, -51, 76, -44, 103, -87, -32, 59, 77, -41, 98, -90, -15, 8, 24, 40, 120, -120, -125, -98, -71, -48, 107, -67, -36, 127, -127, -104, -77, -50, 73, -37, 118, -102, -75, -60, 87, -7, 16, 48, 80, -16, 11, 29, 39, 105, -69, -42, 97, -93, -2, 25, 43, 125, -121, -110, -83, -20, 47, 113, -109, -82, -23, 32, 96, -96, -5, 22, 58, 78, -46, 109, -73, -62, 93, -25, 50, 86, -6, 21, 63, 65, -61, 94, -30, 61, 71, -55, 64, -64, 91, -19, 44, 116, -100, -65, -38, 117, -97, -70, -43, 100, -84, -17, 42, 126, -126, -99, -68, -33, 122, -114, -119, -128, -101, -74, -63, 88, -24, 35, 101, -81, -22, 37, 111, -79, -56, 67, -59, 84, -4, 31, 33, 99, -91, -12, 7, 9, 27, 45, 119, -103, -80, -53, 70, -54, 69, -49, 74, -34, 121, -117, -122, -111, -88, -29, 62, 66, -58, 81, -13, 14, 18, 54, 90, -18, 41, 123, -115, -116, -113, -118, -123, -108, -89, -14, 13, 23, 57, 75, -35, 124, -124, -105, -94, -3, 28, 36, 108, -76, -57, 82, -10, 1, 3, 5, 15, 17, 51, 85, -1, 26, 46, 114, -106, -95, -8, 19, 53, 95, -31, 56, 72, -40, 115, -107, -92, -9, 2, 6, 10, 30, 34, 102, -86, -27, 52, 92, -28, 55, 89, -21, 38, 106, -66, -39, 112, -112, -85, -26, 49, 83, -11, 4, 12, 20, 60, 68, -52, 79, -47, 104, -72, -45, 110, -78, -51, 76, -44, 103, -87, -32, 59, 77, -41, 98, -90, -15, 8, 24, 40, 120, -120, -125, -98, -71, -48, 107, -67, -36, 127, -127, -104, -77, -50, 73, -37, 118, -102, -75, -60, 87, -7, 16, 48, 80, -16, 11, 29, 39, 105, -69, -42, 97, -93, -2, 25, 43, 125, -121, -110, -83, -20, 47, 113, -109, -82, -23, 32, 96, -96, -5, 22, 58, 78, -46, 109, -73, -62, 93, -25, 50, 86, -6, 21, 63, 65, -61, 94, -30, 61, 71, -55, 64, -64, 91, -19, 44, 116, -100, -65, -38, 117, -97, -70, -43, 100, -84, -17, 42, 126, -126, -99, -68, -33, 122, -114, -119, -128, -101, -74, -63, 88, -24, 35, 101, -81, -22, 37, 111, -79, -56, 67, -59, 84, -4, 31, 33, 99, -91, -12, 7, 9, 27, 45, 119, -103, -80, -53, 70, -54, 69, -49, 74, -34, 121, -117, -122, -111, -88, -29, 62, 66, -58, 81, -13, 14, 18, 54, 90, -18, 41, 123, -115, -116, -113, -118, -123, -108, -89, -14, 13, 23, 57, 75, -35, 124, -124, -105, -94, -3, 28, 36, 108, -76, -57, 82, -10, 1};
    private static final byte[] S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final int[] rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    public static byte[][] shifts0;
    public static byte[][] shifts1;
    private int BC;
    private long BC_MASK;
    private int ROUNDS;
    private int blockBits;
    private long[][] workingKey;
    private long A0;
    private long A1;
    private long A2;
    private long A3;
    private boolean forEncryption;
    private byte[] shifts0SC;
    private byte[] shifts1SC;

    private byte mul0x2(int n3) {
        if (n3 != 0) {
            return aLogtable[(logtable[n3] & 0xFF) + 25];
        }
        return 0;
    }

    private byte mul0x3(int n3) {
        if (n3 != 0) {
            return aLogtable[(logtable[n3] & 0xFF) + 1];
        }
        return 0;
    }

    private byte mul0x9(int n3) {
        if (n3 >= 0) {
            return aLogtable[n3 + 199];
        }
        return 0;
    }

    private byte mul0xb(int n3) {
        if (n3 >= 0) {
            return aLogtable[n3 + 104];
        }
        return 0;
    }

    private byte mul0xd(int n3) {
        if (n3 >= 0) {
            return aLogtable[n3 + 238];
        }
        return 0;
    }

    private byte mul0xe(int n3) {
        if (n3 >= 0) {
            return aLogtable[n3 + 223];
        }
        return 0;
    }

    private void KeyAddition(long[] lArray) {
        RijndaelEngine rijndaelEngine = this;
        rijndaelEngine.A0 ^= lArray[0];
        rijndaelEngine.A1 ^= lArray[1];
        rijndaelEngine.A2 ^= lArray[2];
        rijndaelEngine.A3 ^= lArray[3];
    }

    private long shift(long l3, int n3) {
        return (l3 >>> n3 | l3 << this.BC - n3) & this.BC_MASK;
    }

    private void ShiftRow(byte[] byArray) {
        RijndaelEngine rijndaelEngine = this;
        RijndaelEngine rijndaelEngine2 = this;
        long l3 = this.A1;
        byte by = byArray[1];
        rijndaelEngine2.A1 = rijndaelEngine2.shift(l3, by);
        l3 = rijndaelEngine2.A2;
        by = byArray[2];
        rijndaelEngine.A2 = rijndaelEngine.shift(l3, by);
        l3 = rijndaelEngine.A3;
        by = byArray[3];
        this.A3 = this.shift(l3, by);
    }

    private long applyS(long l3, byte[] byArray) {
        long l4 = 0L;
        for (int i3 = 0; i3 < this.BC; i3 += 8) {
            l4 |= (long)(byArray[(int)(l3 >> i3 & 0xFFL)] & 0xFF) << i3;
        }
        return l4;
    }

    private void Substitution(byte[] byArray) {
        RijndaelEngine rijndaelEngine = this;
        rijndaelEngine.A0 = rijndaelEngine.applyS(rijndaelEngine.A0, byArray);
        rijndaelEngine.A1 = rijndaelEngine.applyS(rijndaelEngine.A1, byArray);
        rijndaelEngine.A2 = rijndaelEngine.applyS(rijndaelEngine.A2, byArray);
        rijndaelEngine.A3 = rijndaelEngine.applyS(rijndaelEngine.A3, byArray);
    }

    private void MixColumn() {
        long l3 = 0L;
        int n3 = 0;
        long l4 = l3;
        long l5 = l3;
        long l6 = l3;
        int n4 = n3;
        while (n4 < this.BC) {
            long l7 = l4;
            long l8 = l5;
            RijndaelEngine rijndaelEngine = this;
            int n5 = (int)(rijndaelEngine.A0 >> n4 & 0xFFL);
            RijndaelEngine rijndaelEngine2 = this;
            int n6 = (int)(rijndaelEngine2.A1 >> n4 & 0xFFL);
            int n7 = (int)(rijndaelEngine2.A2 >> n4 & 0xFFL);
            int n8 = (int)(rijndaelEngine2.A3 >> n4 & 0xFFL);
            l5 = l3 | (long)((rijndaelEngine.mul0x2(n5) ^ this.mul0x3(n6) ^ n7 ^ n8) & 0xFF) << n4;
            l4 = l6 | (long)((this.mul0x2(n6) ^ this.mul0x3(n7) ^ n8 ^ n5) & 0xFF) << n4;
            long l9 = l8 | (long)((this.mul0x2(n7) ^ this.mul0x3(n8) ^ n5 ^ n6) & 0xFF) << n4;
            l3 = l7 | (long)((this.mul0x2(n8) ^ this.mul0x3(n5) ^ n6 ^ n7) & 0xFF) << n4;
            n7 = n4 + 8;
            long l10 = l5;
            long l11 = l4;
            l4 = l3;
            l5 = l9;
            l6 = l11;
            l3 = l10;
            n4 = n7;
        }
        RijndaelEngine rijndaelEngine = this;
        rijndaelEngine.A0 = l3;
        rijndaelEngine.A1 = l6;
        rijndaelEngine.A2 = l5;
        rijndaelEngine.A3 = l4;
    }

    private void InvMixColumn() {
        long l3 = 0L;
        int n3 = 0;
        long l4 = l3;
        long l5 = l3;
        long l6 = l3;
        for (int i3 = n3; i3 < this.BC; i3 += 8) {
            int n4 = (int)(this.A0 >> i3 & 0xFFL);
            RijndaelEngine rijndaelEngine = this;
            int n5 = (int)(rijndaelEngine.A1 >> i3 & 0xFFL);
            int n6 = (int)(rijndaelEngine.A2 >> i3 & 0xFFL);
            int n7 = (int)(rijndaelEngine.A3 >> i3 & 0xFFL);
            n4 = n4 != 0 ? logtable[n4 & 0xFF] & 0xFF : -1;
            n5 = n5 != 0 ? logtable[n5 & 0xFF] & 0xFF : -1;
            n6 = n6 != 0 ? logtable[n6 & 0xFF] & 0xFF : -1;
            n7 = n7 != 0 ? logtable[n7 & 0xFF] & 0xFF : -1;
            l3 |= (long)((this.mul0xe(n4) ^ this.mul0xb(n5) ^ this.mul0xd(n6) ^ this.mul0x9(n7)) & 0xFF) << i3;
            l6 |= (long)((this.mul0xe(n5) ^ this.mul0xb(n6) ^ this.mul0xd(n7) ^ this.mul0x9(n4)) & 0xFF) << i3;
            l5 |= (long)((this.mul0xe(n6) ^ this.mul0xb(n7) ^ this.mul0xd(n4) ^ this.mul0x9(n5)) & 0xFF) << i3;
            l4 |= (long)((this.mul0xe(n7) ^ this.mul0xb(n4) ^ this.mul0xd(n5) ^ this.mul0x9(n6)) & 0xFF) << i3;
        }
        RijndaelEngine rijndaelEngine = this;
        rijndaelEngine.A0 = l3;
        rijndaelEngine.A1 = l6;
        rijndaelEngine.A2 = l5;
        rijndaelEngine.A3 = l4;
    }

    /*
     * Unable to fully structure code
     */
    private long[][] generateWorkingKey(byte[] var1_1) {
        var2_3 = 0;
        var3_4 = var1_1.length * 8;
        var4_5 = new byte[4][64];
        var5_6 = new long[15][4];
        switch (var3_4) {
            default: {
                throw new IllegalArgumentException("Key length not 128/160/192/224/256 bits.");
            }
            case 256: {
                var6_7 = 8;
                break;
            }
            case 224: {
                var6_7 = 7;
                break;
            }
            case 192: {
                var6_7 = 6;
                break;
            }
            case 160: {
                var6_7 = 5;
                break;
            }
            case 128: {
                var6_7 = 4;
            }
        }
        this.ROUNDS = var3_4 >= this.blockBits ? var6_7 + 6 : this.BC / 8 + 6;
        var3_4 = 0;
        for (var7_8 = 0; var7_8 < var1_1.length; ++var7_8) {
            var8_10 = var7_8 / 4;
            var4_5[var7_8 % 4][var8_10] = var1_1[var3_4++];
        }
        var1_2 = 0;
        var3_4 = 0;
        while (var3_4 < var6_7) {
            v0 = this;
            var7_8 = v0.ROUNDS + 1;
            if (var1_2 >= v0.BC / 8 * var7_8) break;
            for (var7_8 = 0; var7_8 < 4; ++var7_8) {
                var8_10 = this.BC;
                v1 = var5_6[var1_2 / (var8_10 / 8)];
                v1[var7_8] = v1[var7_8] | (long)(var4_5[var7_8][var3_4] & 255) << var1_2 * 8 % var8_10;
            }
            ++var3_4;
            ++var1_2;
        }
        block10: while (true) {
            v2 = this;
            var3_4 = v2.ROUNDS + 1;
            if (var1_2 >= v2.BC / 8 * var3_4) break;
            var3_4 = 0;
            while (var3_4 < 4) {
                v3 = var4_5[var3_4];
                v3[0] = (byte)(v3[0] ^ RijndaelEngine.S[var4_5[++var3_4 % 4][var6_7 - 1] & 255]);
            }
            v4 = var4_5[0];
            v4[0] = (byte)(v4[0] ^ RijndaelEngine.rcon[var2_3++]);
            if (var6_7 <= 6) {
                for (var3_4 = 1; var3_4 < var6_7; ++var3_4) {
                    for (var7_8 = 0; var7_8 < 4; ++var7_8) {
                        v5 = var4_5[var7_8];
                        var8_11 = v5;
                        v5[var3_4] = (byte)(var8_11[var3_4] ^ var8_11[var3_4 - 1]);
                    }
                }
            } else {
                for (var3_4 = 1; var3_4 < 4; ++var3_4) {
                    for (var7_8 = 0; var7_8 < 4; ++var7_8) {
                        v6 = var4_5[var7_8];
                        var8_12 = v6;
                        v6[var3_4] = (byte)(var8_12[var3_4] ^ var8_12[var3_4 - 1]);
                    }
                }
                for (var3_4 = 0; var3_4 < 4; ++var3_4) {
                    v7 = var4_5[var3_4];
                    var7_9 = v7;
                    v7[4] = (byte)(v7[4] ^ RijndaelEngine.S[var7_9[3] & 255]);
                }
                for (var3_4 = 5; var3_4 < var6_7; ++var3_4) {
                    for (var7_8 = 0; var7_8 < 4; ++var7_8) {
                        v8 = var4_5[var7_8];
                        var8_13 = v8;
                        v8[var3_4] = (byte)(var8_13[var3_4] ^ var8_13[var3_4 - 1]);
                    }
                }
            }
            var3_4 = 0;
            while (true) {
                if (var3_4 >= var6_7) continue block10;
                v9 = this;
                var7_8 = v9.ROUNDS + 1;
                if (var1_2 < v9.BC / 8 * var7_8) ** break;
                continue block10;
                for (var7_8 = 0; var7_8 < 4; ++var7_8) {
                    var8_14 = this.BC;
                    v10 = var5_6[var1_2 / (var8_14 / 8)];
                    v10[var7_8] = v10[var7_8] | (long)(var4_5[var7_8][var3_4] & 255) << var1_2 * 8 % var8_14;
                }
                ++var3_4;
                ++var1_2;
            }
            break;
        }
        return var5_6;
    }

    public RijndaelEngine() {
        this(128);
    }

    public RijndaelEngine(int n3) {
        switch (n3) {
            default: {
                throw new IllegalArgumentException("unknown blocksize to Rijndael");
            }
            case 256: {
                RijndaelEngine rijndaelEngine = this;
                rijndaelEngine.BC = 64;
                rijndaelEngine.BC_MASK = -1L;
                rijndaelEngine.shifts0SC = shifts0[4];
                rijndaelEngine.shifts1SC = shifts1[4];
                break;
            }
            case 224: {
                RijndaelEngine rijndaelEngine = this;
                rijndaelEngine.BC = 56;
                rijndaelEngine.BC_MASK = 0xFFFFFFFFFFFFFFL;
                rijndaelEngine.shifts0SC = shifts0[3];
                rijndaelEngine.shifts1SC = shifts1[3];
                break;
            }
            case 192: {
                RijndaelEngine rijndaelEngine = this;
                rijndaelEngine.BC = 48;
                rijndaelEngine.BC_MASK = 0xFFFFFFFFFFFFL;
                rijndaelEngine.shifts0SC = shifts0[2];
                rijndaelEngine.shifts1SC = shifts1[2];
                break;
            }
            case 160: {
                RijndaelEngine rijndaelEngine = this;
                rijndaelEngine.BC = 40;
                rijndaelEngine.BC_MASK = 0xFFFFFFFFFFL;
                rijndaelEngine.shifts0SC = shifts0[1];
                rijndaelEngine.shifts1SC = shifts1[1];
                break;
            }
            case 128: {
                RijndaelEngine rijndaelEngine = this;
                rijndaelEngine.BC = 32;
                rijndaelEngine.BC_MASK = 0xFFFFFFFFL;
                rijndaelEngine.shifts0SC = shifts0[0];
                rijndaelEngine.shifts1SC = shifts1[0];
            }
        }
        this.blockBits = n3;
    }

    private void unpackBlock(byte[] byArray, int n3) {
        this.A0 = byArray[n3++] & 0xFF;
        this.A1 = byArray[n3++] & 0xFF;
        this.A2 = byArray[n3++] & 0xFF;
        this.A3 = byArray[n3++] & 0xFF;
        for (int i3 = 8; i3 != this.BC; i3 += 8) {
            RijndaelEngine rijndaelEngine = this;
            rijndaelEngine.A0 |= (long)(byArray[n3++] & 0xFF) << i3;
            rijndaelEngine.A1 |= (long)(byArray[n3++] & 0xFF) << i3;
            rijndaelEngine.A2 |= (long)(byArray[n3++] & 0xFF) << i3;
            rijndaelEngine.A3 |= (long)(byArray[n3++] & 0xFF) << i3;
        }
    }

    private void packBlock(byte[] byArray, int n3) {
        for (int i3 = 0; i3 != this.BC; i3 += 8) {
            byte[] byArray2 = byArray;
            byte[] byArray3 = byArray;
            byArray2[n3++] = (byte)(this.A0 >> i3);
            byArray3[n3++] = (byte)(this.A1 >> i3);
            byArray2[n3++] = (byte)(this.A2 >> i3);
            byArray3[n3++] = (byte)(this.A3 >> i3);
        }
    }

    private void encryptBlock(long[][] lArray) {
        this.KeyAddition(lArray[0]);
        for (int i3 = 1; i3 < this.ROUNDS; ++i3) {
            RijndaelEngine rijndaelEngine = this;
            rijndaelEngine.Substitution(S);
            rijndaelEngine.ShiftRow(rijndaelEngine.shifts0SC);
            rijndaelEngine.MixColumn();
            this.KeyAddition(lArray[i3]);
        }
        RijndaelEngine rijndaelEngine = this;
        rijndaelEngine.Substitution(S);
        rijndaelEngine.ShiftRow(rijndaelEngine.shifts0SC);
        this.KeyAddition(lArray[rijndaelEngine.ROUNDS]);
    }

    private void decryptBlock(long[][] lArray) {
        RijndaelEngine rijndaelEngine = this;
        rijndaelEngine.KeyAddition(lArray[this.ROUNDS]);
        rijndaelEngine.Substitution(Si);
        rijndaelEngine.ShiftRow(rijndaelEngine.shifts1SC);
        for (int i3 = (v759269).ROUNDS - 1; i3 > 0; --i3) {
            RijndaelEngine rijndaelEngine2 = this;
            rijndaelEngine2.KeyAddition(lArray[i3]);
            rijndaelEngine2.InvMixColumn();
            rijndaelEngine2.Substitution(Si);
            rijndaelEngine2.ShiftRow(rijndaelEngine2.shifts1SC);
        }
        this.KeyAddition(lArray[0]);
    }

    static {
        byte[][] byArrayArray = new byte[5][];
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray[1] = 8;
        byArray[2] = 16;
        byArray[3] = 24;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[4];
        byArray2 = byArray3;
        byArray3[0] = 0;
        byArray3[1] = 8;
        byArray3[2] = 16;
        byArray3[3] = 24;
        byArrayArray[1] = byArray2;
        byte[] byArray4 = new byte[4];
        byArray2 = byArray4;
        byArray4[0] = 0;
        byArray4[1] = 8;
        byArray4[2] = 16;
        byArray4[3] = 24;
        byArrayArray[2] = byArray2;
        byte[] byArray5 = new byte[4];
        byArray2 = byArray5;
        byArray5[0] = 0;
        byArray5[1] = 8;
        byArray5[2] = 16;
        byArray5[3] = 32;
        byArrayArray[3] = byArray2;
        byte[] byArray6 = new byte[4];
        byArray2 = byArray6;
        byArray6[0] = 0;
        byArray6[1] = 8;
        byArray6[2] = 24;
        byArray6[3] = 32;
        byArrayArray[4] = byArray2;
        shifts0 = byArrayArray;
        byte[][] byArrayArray2 = new byte[5][];
        byte[] byArray7 = new byte[4];
        byArray2 = byArray7;
        byArray7[0] = 0;
        byArray7[1] = 24;
        byArray7[2] = 16;
        byArray7[3] = 8;
        byArrayArray2[0] = byArray2;
        byte[] byArray8 = new byte[4];
        byArray2 = byArray8;
        byArray8[0] = 0;
        byArray8[1] = 32;
        byArray8[2] = 24;
        byArray8[3] = 16;
        byArrayArray2[1] = byArray2;
        byte[] byArray9 = new byte[4];
        byArray2 = byArray9;
        byArray9[0] = 0;
        byArray9[1] = 40;
        byArray9[2] = 32;
        byArray9[3] = 24;
        byArrayArray2[2] = byArray2;
        byte[] byArray10 = new byte[4];
        byArray2 = byArray10;
        byArray10[0] = 0;
        byArray10[1] = 48;
        byArray10[2] = 40;
        byArray10[3] = 24;
        byArrayArray2[3] = byArray2;
        byte[] byArray11 = new byte[4];
        byArray2 = byArray11;
        byArray11[0] = 0;
        byArray11[1] = 56;
        byArray11[2] = 40;
        byArray11[3] = 32;
        byArrayArray2[4] = byArray2;
        shifts1 = byArrayArray2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey());
            this.forEncryption = bl;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to Rijndael init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "Rijndael";
    }

    @Override
    public int getBlockSize() {
        return this.BC / 2;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.workingKey != null) {
            int n5 = this.BC;
            if (n5 / 2 + n3 <= byArray.length) {
                if (n5 / 2 + n4 <= byArray2.length) {
                    if (this.forEncryption) {
                        RijndaelEngine rijndaelEngine = this;
                        rijndaelEngine.unpackBlock(byArray, n3);
                        rijndaelEngine.encryptBlock(rijndaelEngine.workingKey);
                        this.packBlock(byArray2, n4);
                    } else {
                        RijndaelEngine rijndaelEngine = this;
                        rijndaelEngine.unpackBlock(byArray, n3);
                        rijndaelEngine.decryptBlock(rijndaelEngine.workingKey);
                        this.packBlock(byArray2, n4);
                    }
                    return this.BC / 2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Rijndael engine not initialised");
    }

    @Override
    public void reset() {
    }
}

