/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.MaxBytesExceededException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SkippingStreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class Salsa20Engine
implements SkippingStreamCipher {
    public static final int DEFAULT_ROUNDS = 20;
    private static final int STATE_SIZE = 16;
    private static final int[] TAU_SIGMA = Pack.littleEndianToInt(Strings.toByteArray("expand 16-byte kexpand 32-byte k"), 0, 8);
    public static final byte[] sigma = Strings.toByteArray("expand 32-byte k");
    public static final byte[] tau = Strings.toByteArray("expand 16-byte k");
    public int rounds;
    private int index = 0;
    public int[] engineState = new int[16];
    public int[] x = new int[16];
    private byte[] keyStream = new byte[64];
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    public Salsa20Engine() {
        this(20);
    }

    public Salsa20Engine(int n3) {
        if (n3 > 0 && (n3 & 1) == 0) {
            this.rounds = n3;
            return;
        }
        throw new IllegalArgumentException("'rounds' must be a positive, even number");
    }

    public static void salsaCore(int n3, int[] nArray, int[] nArray2) {
        if (nArray.length == 16) {
            if (nArray2.length == 16) {
                if (n3 % 2 == 0) {
                    int n4 = nArray[0];
                    int n5 = nArray[1];
                    int n6 = nArray[2];
                    int n7 = nArray[3];
                    int n8 = nArray[4];
                    int n9 = nArray[5];
                    int n10 = nArray[6];
                    int n11 = nArray[7];
                    int n12 = nArray[8];
                    int n13 = nArray[9];
                    int n14 = nArray[10];
                    int n15 = nArray[11];
                    int n16 = nArray[12];
                    int n17 = nArray[13];
                    int n18 = nArray[14];
                    int n19 = nArray[15];
                    while (n3 > 0) {
                        int n20 = n15;
                        int n21 = n11;
                        int n22 = n7;
                        int n23 = n15;
                        int n24 = n14;
                        int n25 = n10;
                        int n26 = n6;
                        int n27 = n10;
                        int n28 = n9;
                        int n29 = n5;
                        int n30 = n5;
                        int n31 = n4;
                        n5 = n8 ^ Integers.rotateLeft(n4 + n16, 7);
                        n4 = n12 ^ Integers.rotateLeft(n5 + n4, 9);
                        n6 = n16 ^ Integers.rotateLeft(n4 + n5, 13);
                        n7 = n31 ^ Integers.rotateLeft(n6 + n4, 18);
                        n8 = n13 ^ Integers.rotateLeft(n9 + n30, 7);
                        n9 = n17 ^ Integers.rotateLeft(n8 + n9, 9);
                        n10 = n29 ^ Integers.rotateLeft(n9 + n8, 13);
                        n11 = n28 ^ Integers.rotateLeft(n10 + n9, 18);
                        n12 = n18 ^ Integers.rotateLeft(n14 + n27, 7);
                        n13 = n26 ^ Integers.rotateLeft(n12 + n14, 9);
                        n14 = n25 ^ Integers.rotateLeft(n13 + n12, 13);
                        n15 = n24 ^ Integers.rotateLeft(n14 + n13, 18);
                        n16 = n22 ^ Integers.rotateLeft(n19 + n23, 7);
                        n17 = n21 ^ Integers.rotateLeft(n16 + n19, 9);
                        n18 = n20 ^ Integers.rotateLeft(n17 + n16, 13);
                        n19 ^= Integers.rotateLeft(n18 + n17, 18);
                        int n32 = n12;
                        int n33 = n9;
                        int n34 = n6;
                        int n35 = n12;
                        int n36 = n8;
                        int n37 = n4;
                        int n38 = n8;
                        int n39 = n11;
                        int n40 = n5;
                        int n41 = n5;
                        int n42 = n7;
                        n5 = n10 ^ Integers.rotateLeft(n7 + n16, 7);
                        n6 = n13 ^ Integers.rotateLeft(n5 + n7, 9);
                        n7 = n16 ^ Integers.rotateLeft(n6 + n5, 13);
                        n4 = n42 ^ Integers.rotateLeft(n7 + n6, 18);
                        n10 = n14 ^ Integers.rotateLeft(n11 + n41, 7);
                        n11 = n17 ^ Integers.rotateLeft(n10 + n11, 9);
                        n8 = n40 ^ Integers.rotateLeft(n11 + n10, 13);
                        n9 = n39 ^ Integers.rotateLeft(n8 + n11, 18);
                        n12 = n18 ^ Integers.rotateLeft(n15 + n38, 7);
                        n13 = n37 ^ Integers.rotateLeft(n12 + n15, 9);
                        n14 = n36 ^ Integers.rotateLeft(n13 + n12, 13);
                        n15 ^= Integers.rotateLeft(n14 + n13, 18);
                        n16 = n34 ^ Integers.rotateLeft(n19 + n35, 7);
                        n17 = n33 ^ Integers.rotateLeft(n16 + n19, 9);
                        n18 = n32 ^ Integers.rotateLeft(n17 + n16, 13);
                        n19 ^= Integers.rotateLeft(n18 + n17, 18);
                        n3 -= 2;
                        int n43 = n13;
                        int n44 = n14;
                        int n45 = n15;
                        n15 = n12;
                        n14 = n45;
                        n13 = n44;
                        n12 = n43;
                    }
                    nArray2[0] = n4 + nArray[0];
                    nArray2[1] = n5 + nArray[1];
                    nArray2[2] = n6 + nArray[2];
                    nArray2[3] = n7 + nArray[3];
                    nArray2[4] = n8 + nArray[4];
                    nArray2[5] = n9 + nArray[5];
                    nArray2[6] = n10 + nArray[6];
                    nArray2[7] = n11 + nArray[7];
                    nArray2[8] = n12 + nArray[8];
                    nArray2[9] = n13 + nArray[9];
                    nArray2[10] = n14 + nArray[10];
                    nArray2[11] = n15 + nArray[11];
                    nArray2[12] = n16 + nArray[12];
                    nArray2[13] = n17 + nArray[13];
                    nArray2[14] = n18 + nArray[14];
                    nArray2[15] = n19 + nArray[15];
                    return;
                }
                throw new IllegalArgumentException("Number of rounds must be even");
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private void resetLimitCounter() {
        Salsa20Engine salsa20Engine = this;
        salsa20Engine.cW0 = 0;
        salsa20Engine.cW1 = 0;
        salsa20Engine.cW2 = 0;
    }

    private boolean limitExceeded() {
        if (++this.cW0 == 0 && ++this.cW1 == 0) {
            return (++this.cW2 & 0x20) != 0;
        }
        return false;
    }

    private boolean limitExceeded(int n3) {
        int n4;
        this.cW0 = n4 = this.cW0 + n3;
        if (n4 < n3 && n4 >= 0 && ++this.cW1 == 0) {
            return (++this.cW2 & 0x20) != 0;
        }
        return false;
    }

    public void packTauOrSigma(int n3, int[] nArray, int n4) {
        int n5 = (n3 - 16) / 4;
        int[] nArray2 = TAU_SIGMA;
        int n6 = n5;
        int n7 = n5;
        int n8 = n5;
        nArray[n4] = nArray2[n5];
        n5 = n4 + 1;
        nArray[n5] = nArray2[n8 + 1];
        n5 = n4 + 2;
        nArray[n5] = nArray2[n7 + 2];
        n5 = n4 + 3;
        nArray[n5] = TAU_SIGMA[n6 + 3];
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block2: {
            block3: {
                block7: {
                    block6: {
                        CipherParameters cipherParameters;
                        block4: {
                            block5: {
                                if (!(object instanceof ParametersWithIV)) break block2;
                                cipherParameters = (ParametersWithIV)object;
                                byte[] byArray = cipherParameters.getIV();
                                object = byArray;
                                if (byArray == null || ((Object)object).length != this.getNonceSize()) break block3;
                                if ((cipherParameters = cipherParameters.getParameters()) != null) break block4;
                                if (!this.initialised) break block5;
                                this.setKey(null, (byte[])object);
                                break block6;
                            }
                            throw new IllegalStateException(this.getAlgorithmName() + " KeyParameter can not be null for first initialisation");
                        }
                        if (!(cipherParameters instanceof KeyParameter)) break block7;
                        this.setKey(((KeyParameter)cipherParameters).getKey(), (byte[])object);
                    }
                    this.reset();
                    this.initialised = true;
                    return;
                }
                throw new IllegalArgumentException(this.getAlgorithmName() + " Init parameters must contain a KeyParameter (or null for re-init)");
            }
            throw new IllegalArgumentException(this.getAlgorithmName() + " requires exactly " + this.getNonceSize() + " bytes of IV");
        }
        throw new IllegalArgumentException(this.getAlgorithmName() + " Init parameters must include an IV");
    }

    public int getNonceSize() {
        return 8;
    }

    @Override
    public String getAlgorithmName() {
        String string2 = "Salsa20";
        if (this.rounds != 20) {
            string2 = e.a(string2, "/").append(this.rounds).toString();
        }
        return string2;
    }

    @Override
    public byte returnByte(byte by) {
        if (!this.limitExceeded()) {
            Salsa20Engine salsa20Engine = this;
            byte[] byArray = salsa20Engine.keyStream;
            int n3 = salsa20Engine.index;
            by = (byte)(byArray[n3] ^ by);
            this.index = n3 + 1 & 0x3F;
            if (this.index == 0) {
                Salsa20Engine salsa20Engine2 = this;
                salsa20Engine2.advanceCounter();
                salsa20Engine2.generateKeyStream(salsa20Engine2.keyStream);
            }
            return by;
        }
        throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
    }

    public void advanceCounter(long l3) {
        int n3 = (int)(l3 >>> 32);
        int n4 = (int)l3;
        if (n3 > 0) {
            ((Salsa20Engine)object).engineState[9] = ((Salsa20Engine)object).engineState[9] + n3;
        }
        Object object = ((Salsa20Engine)object).engineState;
        int n5 = ((Salsa20Engine)object).engineState[8];
        n4 = n5 + n4;
        object[8] = n4;
        if (n5 != 0 && n4 < n5) {
            Object object2 = object;
            object2[9] = object2[9] + true;
        }
    }

    public void advanceCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        int n3 = ((Salsa20Engine)object).engineState[8] + 1;
        object[8] = n3;
        if (n3 == 0) {
            Object object2 = object;
            object2[9] = object2[9] + true;
        }
    }

    public void retreatCounter(long l3) {
        block8: {
            block7: {
                int n3;
                int n4;
                Object object;
                block6: {
                    object = (int)(l3 >>> 32);
                    n4 = (int)l3;
                    if (object != 0) {
                        int[] nArray = ((Salsa20Engine)object2).engineState;
                        int n5 = ((Salsa20Engine)object2).engineState[9];
                        if (((long)n5 & 0xFFFFFFFFL) >= ((long)object & 0xFFFFFFFFL)) {
                            nArray[9] = n5 - object;
                        } else {
                            throw new IllegalStateException("attempt to reduce counter past zero.");
                        }
                    }
                    Object object2 = ((Salsa20Engine)object2).engineState;
                    n3 = ((Salsa20Engine)object2).engineState[8];
                    if (((long)n3 & 0xFFFFFFFFL) < ((long)n4 & 0xFFFFFFFFL)) break block6;
                    object2[8] = n3 - n4;
                    break block7;
                }
                Object object3 = object2[9];
                object = object3;
                if (object3 == false) break block8;
                object2[9] = object - 1;
                object2[8] = n3 - n4;
            }
            return;
        }
        throw new IllegalStateException("attempt to reduce counter past zero.");
    }

    public void retreatCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        int n3 = ((Salsa20Engine)object).engineState[8];
        if (n3 == 0 && object[9] == false) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        object[8] = --n3;
        if (n3 == -1) {
            Object object2 = object;
            object2[9] = object2[9] - true;
        }
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.initialised) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    if (!this.limitExceeded(n4)) {
                        for (int i3 = 0; i3 < n4; ++i3) {
                            Salsa20Engine salsa20Engine = this;
                            int n6 = i3 + n5;
                            byte[] byArray3 = salsa20Engine.keyStream;
                            int n7 = salsa20Engine.index;
                            byArray2[n6] = (byte)(byArray3[n7] ^ byArray[i3 + n3]);
                            this.index = n7 + 1 & 0x3F;
                            if (this.index != 0) continue;
                            Salsa20Engine salsa20Engine2 = this;
                            salsa20Engine2.advanceCounter();
                            salsa20Engine2.generateKeyStream(salsa20Engine2.keyStream);
                        }
                        return n4;
                    }
                    throw new MaxBytesExceededException("2^70 byte limit per IV would be exceeded; Change IV");
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public long skip(long l3) {
        if (l3 >= 0L) {
            int n3;
            long l4;
            if (l3 >= 64L) {
                long l5 = l3;
                l4 = l5 / 64L;
                this.advanceCounter(l4);
                l4 = l5 - l4 * 64L;
            } else {
                l4 = l3;
            }
            int n4 = this.index;
            this.index = n3 = n4 + (int)l4 & 0x3F;
            if (n3 < n4) {
                this.advanceCounter();
            }
        } else {
            long l6 = -l3;
            if (l6 >= 64L) {
                long l7 = l6;
                l6 = l7 / 64L;
                this.retreatCounter(l6);
                l6 = l7 - l6 * 64L;
            }
            for (long i3 = 0L; i3 < l6; ++i3) {
                if (this.index == 0) {
                    this.retreatCounter();
                }
                this.index = this.index - 1 & 0x3F;
            }
        }
        Salsa20Engine salsa20Engine = this;
        salsa20Engine.generateKeyStream(salsa20Engine.keyStream);
        return l3;
    }

    @Override
    public long seekTo(long l3) {
        this.reset();
        return this.skip(l3);
    }

    @Override
    public long getPosition() {
        return this.getCounter() * 64L + (long)this.index;
    }

    @Override
    public void reset() {
        Salsa20Engine salsa20Engine = this;
        salsa20Engine.index = 0;
        salsa20Engine.resetLimitCounter();
        salsa20Engine.resetCounter();
        salsa20Engine.generateKeyStream(salsa20Engine.keyStream);
    }

    public long getCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        return (long)((Salsa20Engine)object).engineState[9] << 32 | (long)object[8] & 0xFFFFFFFFL;
    }

    public void resetCounter() {
        this.engineState[9] = 0;
        this.engineState[8] = 0;
    }

    public void setKey(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            if (byArray.length != 16 && byArray.length != 32) {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 128 bit or 256 bit key");
            }
            int n3 = (byArray.length - 16) / 4;
            int[] nArray = this.engineState;
            int[] nArray2 = TAU_SIGMA;
            nArray[0] = nArray2[n3];
            nArray[5] = nArray2[n3 + 1];
            nArray[10] = nArray2[n3 + 2];
            this.engineState[15] = TAU_SIGMA[n3 + 3];
            Pack.littleEndianToInt(byArray, 0, nArray, 1, 4);
            n3 = byArray.length - 16;
            Pack.littleEndianToInt(byArray, n3, this.engineState, 11, 4);
        }
        Pack.littleEndianToInt(byArray2, 0, this.engineState, 6, 2);
    }

    public void generateKeyStream(byte[] byArray) {
        Salsa20Engine salsa20Engine = object;
        Salsa20Engine salsa20Engine2 = object;
        Object object = salsa20Engine2.engineState;
        Salsa20Engine.salsaCore(salsa20Engine.rounds, (int[])object, salsa20Engine2.x);
        Pack.intToLittleEndian(salsa20Engine.x, byArray, 0);
    }
}

