/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public abstract class SerpentEngineBase
implements BlockCipher {
    public static final int BLOCK_SIZE = 16;
    public static final int ROUNDS = 32;
    public static final int PHI = -1640531527;
    public boolean encrypting;
    public int[] wKey;
    public int X0;
    public int X1;
    public int X2;
    public int X3;

    public static int rotateLeft(int n3, int n4) {
        return n3 << n4 | n3 >>> -n4;
    }

    public static int rotateRight(int n3, int n4) {
        return n3 >>> n4 | n3 << -n4;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.encrypting = bl;
            this.wKey = this.makeWorkingKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to ").append(this.getAlgorithmName()).append(" init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "Serpent";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public final int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.wKey != null) {
            if (n3 + 16 <= byArray.length) {
                if (n4 + 16 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n3, byArray2, n4);
                    } else {
                        this.decryptBlock(byArray, n3, byArray2, n4);
                    }
                    return 16;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }

    public final void sb0(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n6;
        n6 = n3 ^ n6;
        int n9 = n5 ^ n6;
        int n10 = n4 ^ n9;
        this.X3 = n7 = n3 & n8 ^ n10;
        this.X2 = n10 ^ (n5 | (n3 ^= n4 & n6));
        n4 = n7 & (n9 ^ n3);
        this.X1 = ~n9 ^ n4;
        this.X0 = n4 ^ ~n3;
    }

    public final void ib0(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n3;
        int n9 = ~n3;
        n3 ^= n4;
        n4 = n6 ^ (n9 | n3);
        this.X2 = n7 = n3 ^ (n5 ^= n4);
        n3 = n9 ^ n6 & n3;
        this.X1 = n6 = n4 ^ n7 & n3;
        this.X3 = n4 = n8 & n4 ^ (n5 | n6);
        this.X0 = n4 ^ (n5 ^ n3);
    }

    public final void sb1(int n3, int n4, int n5, int n6) {
        int n7 = n3;
        n3 = n4 ^ ~n3;
        n5 ^= n7 | n3;
        int n8 = n3;
        int n9 = n3;
        this.X2 = n3 = n6 ^ n5;
        int n10 = n8 ^ n3;
        this.X3 = n3 = n10 ^ n5 & (n4 ^= n6 | n9);
        int n11 = n5 ^ n4;
        this.X1 = n3 ^ n11;
        this.X0 = n5 ^ n10 & n11;
    }

    public final void ib1(int n3, int n4, int n5, int n6) {
        n6 = n4 ^ n6;
        int n7 = n6 ^ (n3 ^= n4 & n6);
        int n8 = n3;
        this.X3 = n5 ^= n7;
        n3 = n4 ^ n6 & n3;
        this.X1 = n8 ^ (n5 | n3);
        int n9 = ~this.X1;
        int n10 = n5 ^ n3;
        this.X0 = n9 ^ n10;
        this.X2 = n7 ^ (n9 | n10);
    }

    public final void sb2(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = ~n3;
        int n9 = n4 ^ n6;
        int n10 = n3;
        this.X0 = n7 = n9 ^ n5 & n8;
        n3 = n5 ^ n8;
        n4 &= n5 ^ n7;
        this.X3 = n5 = n3 ^ n4;
        this.X2 = n7 = n10 ^ (n6 | n4) & (n7 | n3);
        this.X1 = n9 ^ n5 ^ (n7 ^ (n6 | n8));
    }

    public final void ib2(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n5;
        int n9 = n5;
        n5 = n4 ^ n6;
        int n10 = ~n5;
        int n11 = n3 ^ n9;
        int n12 = n8 ^ n5;
        this.X0 = n7 = n11 ^ n4 & n12;
        this.X3 = n3 = n5 ^ (n11 | n6 ^ (n3 | n10));
        n4 = ~n12;
        this.X1 = n4 ^ (n7 |= n3);
        this.X2 = n6 & n4 ^ (n11 ^ n7);
    }

    public final void sb3(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n4;
        int n9 = n6;
        int n10 = n3 ^ n4;
        int n11 = n3 & n5;
        n3 |= n6;
        n5 ^= n6;
        n6 = n11 | n10 & n3;
        int n12 = n3;
        this.X2 = n3 = n5 ^ n6;
        n4 = n6 ^ (n4 ^ n12);
        this.X0 = n7 = n10 ^ n5 & n4;
        n7 = n3 & n7;
        this.X1 = n4 ^ n7;
        this.X3 = (n8 | n9) ^ (n5 ^ n7);
    }

    public final void ib3(int n3, int n4, int n5, int n6) {
        int n7 = n3;
        int n8 = n4;
        n3 |= n4;
        n4 = n8 ^ n5;
        int n9 = n7 ^ n8 & n4;
        int n10 = n9;
        n5 ^= n10;
        n10 = n6 | n10;
        int n11 = n4 ^ n10;
        int n12 = n3;
        this.X0 = n11;
        n3 = n6 ^ (n4 | n10);
        this.X2 = n5 ^ n3;
        n3 = n12 ^ n3;
        this.X3 = n4 = n9 ^ n11 & n3;
        this.X1 = n4 ^ (n11 ^ n3);
    }

    public final void sb4(int n3, int n4, int n5, int n6) {
        int n7 = n3;
        int n8 = n3;
        int n9 = n4 | (n5 ^= n6 & (n3 ^= n6));
        this.X3 = n3 ^ n9;
        this.X0 = n6 = n5 ^ (n3 | (n4 ^= 0xFFFFFFFF));
        int n10 = n9;
        n9 = n3 ^ n4;
        this.X2 = n3 = n8 & n6 ^ n10 & n9;
        this.X1 = n7 ^ n5 ^ n9 & n3;
    }

    public final void ib4(int n3, int n4, int n5, int n6) {
        int n7 = n4 ^ n3 & (n5 | n6);
        int n8 = n4 = n7;
        int n9 = n5 ^ n3 & n4;
        n4 = n9;
        int n10 = n3;
        this.X1 = n3 = n6 ^ n4;
        n4 = ~n10;
        this.X3 = n5 = n8 ^ n9 & n3;
        int n11 = n6 ^ (n3 | n4);
        this.X0 = n5 ^ n11;
        this.X2 = n7 & n11 ^ (n3 ^ n4);
    }

    public final void sb5(int n3, int n4, int n5, int n6) {
        int n7 = n4;
        int n8 = n4;
        n4 = ~n3;
        int n9 = n3 ^ n8;
        int n10 = n4;
        int n11 = n3 ^ n6;
        this.X0 = n3 = n5 ^ n4 ^ (n9 | n11);
        n4 = n6 & n3;
        this.X1 = n5 = n4 ^ (n9 ^ n3);
        n3 = n10 | n3;
        this.X2 = (n9 | n4) ^ (n11 ^= n3);
        this.X3 = n7 ^ n4 ^ n5 & n11;
    }

    public final void ib5(int n3, int n4, int n5, int n6) {
        int n7 = n4;
        int n8 = n6;
        int n9 = n6;
        n6 = ~n5;
        int n10 = n9 ^ n4 & n6;
        int n11 = n4;
        int n12 = n3 & n10;
        this.X3 = n4 = n12 ^ (n4 ^ n6);
        n4 = n11 | n4;
        this.X1 = n10 ^ n3 & n4;
        n10 = n3 | n8;
        this.X0 = n10 ^ (n6 ^ n4);
        this.X2 = n7 & n10 ^ (n12 | n3 ^ n5);
    }

    public final void sb6(int n3, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = ~n3;
        n5 = n4 ^ (n3 ^= n6);
        int n9 = n7 ^ (n8 | n3);
        int n10 = n3;
        this.X1 = n3 = n4 ^ n9;
        n3 = n6 ^ (n10 | n3);
        this.X2 = n4 = n5 ^ n9 & n3;
        int n11 = n9 ^ n3;
        this.X0 = n4 ^ n11;
        this.X3 = ~n9 ^ n5 & n11;
    }

    public final void ib6(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n6;
        int n9 = n3;
        int n10 = n9 ^ n4;
        int n11 = n5 ^ n10;
        n5 = n6 ^ (n5 | (n3 ^= 0xFFFFFFFF));
        this.X1 = n11 ^ n5;
        n6 = n10 ^ n11 & n5;
        this.X3 = n7 = n5 ^ (n4 | n6);
        n7 = n4 | n7;
        this.X0 = n6 ^ n7;
        this.X2 = n8 & n3 ^ (n11 ^ n7);
    }

    public final void sb7(int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n5;
        n5 = n4 ^ n5;
        int n9 = n6 ^ n8 & n5;
        int n10 = n3 ^ n9;
        int n11 = n3;
        this.X1 = n3 = n4 ^ n10 & (n6 | n5);
        n3 = n9 | n3;
        this.X3 = n4 = n5 ^ n11 & n10;
        n3 = n10 ^ n3;
        this.X2 = n7 = n9 ^ n4 & n3;
        this.X0 = ~n3 ^ n4 & n7;
    }

    public final void ib7(int n3, int n4, int n5, int n6) {
        int n7 = n5 | n3 & n4;
        int n8 = n5;
        int n9 = n4;
        int n10 = n6 & (n3 | n4);
        this.X3 = n4 = n7 ^ n10;
        n5 = ~n6;
        n10 = n9 ^ n10;
        this.X1 = n5 = n3 ^ (n10 | n4 ^ n5);
        this.X0 = n10 = n8 ^ n10 ^ (n6 | n5);
        this.X2 = n7 ^ n5 ^ (n10 ^ n3 & n4);
    }

    public final void LT() {
        SerpentEngineBase serpentEngineBase = this;
        int n3 = SerpentEngineBase.rotateLeft(serpentEngineBase.X0, 13);
        int n4 = SerpentEngineBase.rotateLeft(serpentEngineBase.X2, 3);
        int n5 = n3;
        SerpentEngineBase serpentEngineBase2 = this;
        int n6 = serpentEngineBase2.X1 ^ n3 ^ n4;
        this.X1 = SerpentEngineBase.rotateLeft(n6, 1);
        serpentEngineBase2.X3 = n3 = SerpentEngineBase.rotateLeft(serpentEngineBase2.X3 ^ n4 ^ n3 << 3, 7);
        this.X0 = SerpentEngineBase.rotateLeft(n5 ^ serpentEngineBase2.X1 ^ n3, 5);
        serpentEngineBase.X2 = SerpentEngineBase.rotateLeft(n4 ^ this.X3 ^ this.X1 << 7, 22);
    }

    public final void inverseLT() {
        SerpentEngineBase serpentEngineBase = this;
        int n3 = SerpentEngineBase.rotateRight(serpentEngineBase.X2, 22) ^ this.X3 ^ this.X1 << 7;
        int n4 = this.X3;
        int n5 = SerpentEngineBase.rotateRight(serpentEngineBase.X0, 5) ^ this.X1 ^ n4;
        n4 = SerpentEngineBase.rotateRight(n4, 7);
        this.X3 = n4 ^ n3 ^ n5 << 3;
        this.X1 = SerpentEngineBase.rotateRight(this.X1, 1) ^ n5 ^ n3;
        this.X2 = SerpentEngineBase.rotateRight(n3, 3);
        serpentEngineBase.X0 = SerpentEngineBase.rotateRight(n5, 13);
    }

    public abstract int[] makeWorkingKey(byte[] var1);

    public abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    public abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);
}

