/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class SkipjackEngine
implements BlockCipher {
    public static final int BLOCK_SIZE = 8;
    public static short[] ftable = new short[]{163, 215, 9, 131, 248, 72, 246, 244, 179, 33, 21, 120, 153, 177, 175, 249, 231, 45, 77, 138, 206, 76, 202, 46, 82, 149, 217, 30, 78, 56, 68, 40, 10, 223, 2, 160, 23, 241, 96, 104, 18, 183, 122, 195, 233, 250, 61, 83, 150, 132, 107, 186, 242, 99, 154, 25, 124, 174, 229, 245, 247, 22, 106, 162, 57, 182, 123, 15, 193, 147, 129, 27, 238, 180, 26, 234, 208, 145, 47, 184, 85, 185, 218, 133, 63, 65, 191, 224, 90, 88, 128, 95, 102, 11, 216, 144, 53, 213, 192, 167, 51, 6, 101, 105, 69, 0, 148, 86, 109, 152, 155, 118, 151, 252, 178, 194, 176, 254, 219, 32, 225, 235, 214, 228, 221, 71, 74, 29, 66, 237, 158, 110, 73, 60, 205, 67, 39, 210, 7, 212, 222, 199, 103, 24, 137, 203, 48, 31, 141, 198, 143, 170, 200, 116, 220, 201, 93, 92, 49, 164, 112, 136, 97, 44, 159, 13, 43, 135, 80, 130, 84, 100, 38, 125, 3, 64, 52, 75, 28, 115, 209, 196, 253, 59, 204, 251, 127, 171, 230, 62, 91, 165, 173, 4, 35, 156, 20, 81, 34, 240, 41, 121, 113, 126, 255, 140, 14, 226, 12, 239, 188, 114, 117, 111, 55, 161, 236, 211, 142, 98, 139, 134, 16, 232, 8, 119, 17, 190, 146, 79, 36, 197, 50, 54, 157, 207, 243, 166, 187, 172, 94, 108, 169, 19, 87, 37, 181, 227, 189, 168, 58, 1, 5, 89, 42, 70};
    private int[] key0;
    private int[] key1;
    private int[] key2;
    private int[] key3;
    private boolean encrypting;

    private int g(int n3, int n4) {
        int n5 = n4;
        n4 = n5 >> 8 & 0xFF;
        int n6 = n5 & 0xFF;
        short[] sArray = ftable;
        n4 = ftable[n6 ^ this.key0[n3]] ^ n4;
        n6 = sArray[n4 ^ this.key1[n3]] ^ n6;
        int n7 = ftable[n6 ^ this.key2[n3]] ^ n4;
        int n8 = sArray[n7 ^ this.key3[n3]] ^ n6;
        return (n7 << 8) + n8;
    }

    private int h(int n3, int n4) {
        int n5 = n4;
        n4 = n5 & 0xFF;
        int n6 = n5 >> 8 & 0xFF;
        n4 = ftable[n6 ^ this.key3[n3]] ^ n4;
        n6 = ftable[n4 ^ this.key2[n3]] ^ n6;
        n4 = ftable[n6 ^ this.key1[n3]] ^ n4;
        return ((ftable[n4 ^ this.key0[n3]] ^ n6) << 8) + n4;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            SkipjackEngine skipjackEngine = this;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            skipjackEngine.encrypting = bl;
            skipjackEngine.key0 = new int[32];
            skipjackEngine.key1 = new int[32];
            skipjackEngine.key2 = new int[32];
            skipjackEngine.key3 = new int[32];
            for (int i3 = 0; i3 < 32; ++i3) {
                SkipjackEngine skipjackEngine2 = this;
                int n3 = i3 * 4;
                skipjackEngine2.key0[i3] = byArray[n3 % 10] & 0xFF;
                skipjackEngine2.key1[i3] = byArray[(n3 + 1) % 10] & 0xFF;
                skipjackEngine2.key2[i3] = byArray[(n3 + 2) % 10] & 0xFF;
                skipjackEngine2.key3[i3] = byArray[(n3 + 3) % 10] & 0xFF;
            }
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to SKIPJACK init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "SKIPJACK";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.key1 != null) {
            if (n3 + 8 <= byArray.length) {
                if (n4 + 8 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n3, byArray2, n4);
                    } else {
                        this.decryptBlock(byArray, n3, byArray2, n4);
                    }
                    return 8;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("SKIPJACK engine not initialised");
    }

    @Override
    public void reset() {
    }

    public int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = (byArray[n3 + 0] << 8) + (byArray[n3 + 1] & 0xFF);
        int n6 = (byArray[n3 + 2] << 8) + (byArray[n3 + 3] & 0xFF);
        int n7 = (byArray[n3 + 4] << 8) + (byArray[n3 + 5] & 0xFF);
        int n8 = (byArray[n3 + 6] << 8) + (byArray[n3 + 7] & 0xFF);
        n3 = 0;
        for (int i3 = 0; i3 < 2; ++i3) {
            int n9;
            int n10 = n7;
            int n11 = n6;
            n6 = n5;
            n5 = n3;
            n7 = n11;
            n3 = n10;
            for (n9 = 0; n9 < 8; ++n9) {
                n6 = this.g(n5, n6);
                int n12 = n6 ^ n8;
                n8 = n5 + 1;
                n5 = n12 ^ n8;
                int n13 = n3;
                int n14 = n7;
                int n15 = n6;
                n6 = n5;
                n5 = n8;
                n7 = n15;
                n3 = n14;
                n8 = n13;
            }
            int n16 = n6;
            int n17 = n7;
            int n18 = n3;
            n3 = n5;
            n7 = n18;
            n6 = n17;
            n5 = n16;
            for (n9 = 0; n9 < 8; ++n9) {
                int n19 = n3++;
                n6 = n5 ^ n6 ^ n3;
                n5 = this.g(n19, n5);
                int n20 = n8;
                n8 = n7;
                n7 = n6;
                n6 = n5;
                n5 = n20;
            }
        }
        int n21 = n4 + 0;
        byArray2[n21] = (byte)(n5 >> 8);
        n21 = n4 + 1;
        byArray2[n21] = (byte)n5;
        n21 = n4 + 2;
        byArray2[n21] = (byte)(n6 >> 8);
        n21 = n4 + 3;
        byArray2[n21] = (byte)n6;
        n21 = n4 + 4;
        byArray2[n21] = (byte)(n7 >> 8);
        n21 = n4 + 5;
        byArray2[n21] = (byte)n7;
        n21 = n4 + 6;
        byArray2[n21] = (byte)(n8 >> 8);
        n21 = n4 + 7;
        byArray2[n21] = (byte)n8;
        return 8;
    }

    public int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = (byArray[n3 + 0] << 8) + (byArray[n3 + 1] & 0xFF);
        int n6 = (byArray[n3 + 2] << 8) + (byArray[n3 + 3] & 0xFF);
        int n7 = (byArray[n3 + 4] << 8) + (byArray[n3 + 5] & 0xFF);
        int n8 = (byArray[n3 + 6] << 8) + (byArray[n3 + 7] & 0xFF);
        n3 = 31;
        for (int i3 = 0; i3 < 2; ++i3) {
            int n9;
            int n10 = n8;
            n8 = n5;
            n5 = n10;
            for (n9 = 0; n9 < 8; ++n9) {
                n6 = this.h(n3, n6);
                n7 = n6 ^ n7 ^ n3 + 1;
                --n3;
                int n11 = n5;
                int n12 = n8;
                int n13 = n6;
                n6 = n7;
                n8 = n13;
                n5 = n12;
                n7 = n11;
            }
            int n14 = n8;
            n8 = n5;
            n5 = n14;
            for (n9 = 0; n9 < 8; ++n9) {
                n5 = n6 ^ n5 ^ n3 + 1;
                n6 = this.h(n3, n6);
                --n3;
                int n15 = n6;
                int n16 = n7;
                int n17 = n8;
                n8 = n5;
                n7 = n17;
                n6 = n16;
                n5 = n15;
            }
        }
        int n18 = n4 + 0;
        byArray2[n18] = (byte)(n5 >> 8);
        n18 = n4 + 1;
        byArray2[n18] = (byte)n5;
        n18 = n4 + 2;
        byArray2[n18] = (byte)(n6 >> 8);
        n18 = n4 + 3;
        byArray2[n18] = (byte)n6;
        n18 = n4 + 4;
        byArray2[n18] = (byte)(n7 >> 8);
        n18 = n4 + 5;
        byArray2[n18] = (byte)n7;
        n18 = n4 + 6;
        byArray2[n18] = (byte)(n8 >> 8);
        n18 = n4 + 7;
        byArray2[n18] = (byte)n8;
        return 8;
    }
}

