/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class TEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private static final int d_sum = -957401312;
    private int _a;
    private int _b;
    private int _c;
    private int _d;
    private boolean _initialised = false;
    private boolean _forEncryption;

    private void setKey(byte[] byArray) {
        if (byArray.length == 16) {
            this._a = this.bytesToInt(byArray, 0);
            this._b = this.bytesToInt(byArray, 4);
            this._c = this.bytesToInt(byArray, 8);
            this._d = this.bytesToInt(byArray, 12);
            return;
        }
        throw new IllegalArgumentException("Key size must be 128 bits.");
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        TEAEngine tEAEngine = this;
        int n5 = tEAEngine.bytesToInt(byArray, n3);
        int n6 = tEAEngine.bytesToInt(byArray, n3 + 4);
        n3 = 0;
        for (int i3 = 0; i3 != 32; ++i3) {
            n6 += ((n5 += (n6 << 4) + this._a ^ n6 + (n3 -= 1640531527) ^ (n6 >>> 5) + this._b) << 4) + this._c ^ n5 + n3 ^ (n5 >>> 5) + this._d;
        }
        TEAEngine tEAEngine2 = this;
        tEAEngine2.unpackInt(n5, byArray2, n4);
        int n7 = n4 + 4;
        tEAEngine2.unpackInt(n6, byArray2, n7);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        TEAEngine tEAEngine = this;
        int n5 = tEAEngine.bytesToInt(byArray, n3);
        int n6 = tEAEngine.bytesToInt(byArray, n3 + 4);
        n3 = -957401312;
        for (int i3 = 0; i3 != 32; ++i3) {
            n5 -= ((n6 -= (n5 << 4) + this._c ^ n5 + n3 ^ (n5 >>> 5) + this._d) << 4) + this._a ^ n6 + n3 ^ (n6 >>> 5) + this._b;
            n3 += 1640531527;
        }
        TEAEngine tEAEngine2 = this;
        tEAEngine2.unpackInt(n5, byArray2, n4);
        int n7 = n4 + 4;
        tEAEngine2.unpackInt(n6, byArray2, n7);
        return 8;
    }

    private int bytesToInt(byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n4 + 1;
        return byArray[n4] << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5] & 0xFF;
    }

    private void unpackInt(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = n4 + 1;
        byArray[n4] = (byte)(n3 >>> 24);
        n3 = n8 + 1;
        byArray[n8] = (byte)(n7 >>> 16);
        n8 = n3 + 1;
        byArray[n3] = (byte)(n6 >>> 8);
        byArray[n8] = (byte)n5;
    }

    @Override
    public String getAlgorithmName() {
        return "TEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            TEAEngine tEAEngine = this;
            tEAEngine._forEncryption = bl;
            tEAEngine._initialised = true;
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to TEA init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this._initialised) {
            if (n3 + 8 <= byArray.length) {
                if (n4 + 8 <= byArray2.length) {
                    return this._forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }
}

