/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.TweakableBlockCipherParameters;

public class ThreefishEngine
implements BlockCipher {
    public static final int BLOCKSIZE_256 = 256;
    public static final int BLOCKSIZE_512 = 512;
    public static final int BLOCKSIZE_1024 = 1024;
    private static final int TWEAK_SIZE_BYTES = 16;
    private static final int TWEAK_SIZE_WORDS = 2;
    private static final int ROUNDS_256 = 72;
    private static final int ROUNDS_512 = 72;
    private static final int ROUNDS_1024 = 80;
    private static final int MAX_ROUNDS = 80;
    private static final long C_240 = 2004413935125273122L;
    private static int[] MOD9 = new int[80];
    private static int[] MOD17 = new int[MOD9.length];
    private static int[] MOD5 = new int[MOD9.length];
    private static int[] MOD3 = new int[MOD9.length];
    private int blocksizeBytes;
    private int blocksizeWords;
    private long[] currentBlock;
    private long[] t;
    private long[] kw;
    private ThreefishCipher cipher;
    private boolean forEncryption;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ThreefishEngine(int n3) {
        Object object;
        int n4;
        long[] lArray = new long[5];
        ((ThreefishEngine)object).t = lArray;
        ((ThreefishEngine)object).blocksizeBytes = n3 / 8;
        ((ThreefishEngine)object).blocksizeWords = n4 = ((ThreefishEngine)object).blocksizeBytes / 8;
        ((ThreefishEngine)object).currentBlock = new long[n4];
        long[] lArray2 = new long[n4 * 2 + 1];
        ((ThreefishEngine)object).kw = lArray2;
        if (n3 != 256) {
            if (n3 != 512) {
                Threefish1024Cipher threefish1024Cipher;
                if (n3 != 1024) throw new IllegalArgumentException("Invalid blocksize - Threefish is defined with block size of 256, 512, or 1024 bits");
                Object object2 = object;
                object = threefish1024Cipher;
                threefish1024Cipher = new Threefish1024Cipher(lArray2, lArray);
                ((ThreefishEngine)object2).cipher = object;
                return;
            } else {
                Threefish512Cipher threefish512Cipher;
                ThreefishEngine threefishEngine = object;
                object = threefish512Cipher;
                threefish512Cipher = new Threefish512Cipher(lArray2, lArray);
                threefishEngine.cipher = object;
            }
            return;
        } else {
            Threefish256Cipher threefish256Cipher;
            ThreefishEngine threefishEngine = object;
            object = threefish256Cipher;
            threefish256Cipher = new Threefish256Cipher(lArray2, lArray);
            threefishEngine.cipher = object;
        }
    }

    private void setKey(long[] lArray) {
        if (lArray.length == ((ThreefishEngine)object).blocksizeWords) {
            int n3;
            long l3 = 2004413935125273122L;
            for (int i3 = 0; i3 < (n3 = ((ThreefishEngine)object).blocksizeWords); ++i3) {
                long l4 = l3;
                ((ThreefishEngine)object).kw[i3] = l3 = lArray[i3];
                l3 = l4 ^ l3;
            }
            long[] lArray2 = ((ThreefishEngine)object).kw;
            Object object = lArray2;
            lArray2[n3] = l3;
            int n4 = n3 + 1;
            System.arraycopy(((ThreefishEngine)object).kw, 0, object, n4, n3);
            return;
        }
        throw new IllegalArgumentException(b.a(b.b.a("Threefish key must be same size as block ("), ((ThreefishEngine)object).blocksizeWords, " words)"));
    }

    private void setTweak(long[] lArray) {
        if (lArray.length == 2) {
            long l3;
            long[] lArray2 = ((ThreefishEngine)object).t;
            long[] lArray3 = ((ThreefishEngine)object).t;
            Object object = lArray2;
            long l4 = lArray[0];
            object[0] = l4;
            long l5 = lArray[1];
            object[1] = l5;
            lArray3[2] = l3 = l4 ^ l5;
            lArray2[3] = l4;
            lArray3[4] = l5;
            return;
        }
        throw new IllegalArgumentException("Tweak must be 2 words.");
    }

    public static long bytesToWord(byte[] byArray, int n3) {
        if (n3 + 8 <= byArray.length) {
            return (long)byArray[n3++] & 0xFFL | ((long)byArray[n3++] & 0xFFL) << 8 | ((long)byArray[n3++] & 0xFFL) << 16 | ((long)byArray[n3++] & 0xFFL) << 24 | ((long)byArray[n3++] & 0xFFL) << 32 | ((long)byArray[n3++] & 0xFFL) << 40 | ((long)byArray[n3++] & 0xFFL) << 48 | ((long)byArray[n3] & 0xFFL) << 56;
        }
        throw new IllegalArgumentException();
    }

    public static void wordToBytes(long l3, byte[] byArray, int n3) {
        if (n3 + 8 <= byArray.length) {
            int n4 = n3 + 1;
            byArray[n3] = (byte)l3;
            int n5 = n4 + 1;
            byArray[n4] = (byte)(l3 >> 8);
            n4 = n5 + 1;
            byArray[n5] = (byte)(l3 >> 16);
            n5 = n4 + 1;
            byArray[n4] = (byte)(l3 >> 24);
            n4 = n5 + 1;
            byArray[n5] = (byte)(l3 >> 32);
            n5 = n4 + 1;
            byArray[n4] = (byte)(l3 >> 40);
            n4 = n5 + 1;
            byArray[n5] = (byte)(l3 >> 48);
            byArray[n4] = (byte)(l3 >> 56);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static long rotlXor(long l3, int n3, long l4) {
        return (l3 << n3 | l3 >>> -n3) ^ l4;
    }

    public static long xorRotr(long l3, int n3, long l4) {
        return (l3 ^= l4) >>> n3 | l3 << -n3;
    }

    static {
        int n3 = 0;
        while (true) {
            int[] nArray = MOD9;
            if (n3 >= MOD9.length) break;
            int n4 = n3;
            int n5 = n3;
            ThreefishEngine.MOD17[n5] = n5 % 17;
            nArray[n4] = n4 % 9;
            int n6 = n3;
            ThreefishEngine.MOD5[n6] = n6 % 5;
            int n7 = n3++;
            ThreefishEngine.MOD3[n7] = n7 % 3;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block12: {
            byte[] byArray;
            block11: {
                block10: {
                    if (!(object instanceof TweakableBlockCipherParameters)) break block10;
                    TweakableBlockCipherParameters tweakableBlockCipherParameters = (TweakableBlockCipherParameters)object;
                    object = tweakableBlockCipherParameters.getKey().getKey();
                    byArray = tweakableBlockCipherParameters.getTweak();
                    break block11;
                }
                if (!(object instanceof KeyParameter)) break block12;
                object = ((KeyParameter)object).getKey();
                byArray = null;
            }
            long[] lArray = null;
            long[] lArray2 = null;
            if (object != null) {
                if (((Object)object).length == this.blocksizeBytes) {
                    int n3 = this.blocksizeWords;
                    long[] lArray3 = new long[n3];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        lArray3[i3] = ThreefishEngine.bytesToWord((byte[])object, i3 * 8);
                    }
                    lArray = lArray3;
                } else {
                    throw new IllegalArgumentException(b.a(b.b.a("Threefish key must be same size as block ("), this.blocksizeBytes, " bytes)"));
                }
            }
            if (byArray != null) {
                if (byArray.length == 16) {
                    long l3;
                    long[] lArray4 = new long[2];
                    lArray2 = lArray4;
                    lArray2[0] = l3 = ThreefishEngine.bytesToWord(byArray, 0);
                    lArray4[1] = l3 = ThreefishEngine.bytesToWord(byArray, 8);
                } else {
                    throw new IllegalArgumentException("Threefish tweak must be 16 bytes");
                }
            }
            this.init(bl, lArray, lArray2);
            return;
        }
        throw new IllegalArgumentException(a.a((CipherParameters)object, b.b.a("Invalid parameter passed to Threefish init - ")));
    }

    public void init(boolean bl, long[] lArray, long[] lArray2) {
        this.forEncryption = bl;
        if (lArray != null) {
            this.setKey(lArray);
        }
        if (lArray2 != null) {
            this.setTweak(lArray2);
        }
    }

    @Override
    public String getAlgorithmName() {
        return b.b.a("Threefish-").append(this.blocksizeBytes * 8).toString();
    }

    @Override
    public int getBlockSize() {
        return this.blocksizeBytes;
    }

    @Override
    public void reset() {
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = this.blocksizeBytes;
        if (n3 + n5 <= byArray.length) {
            if (n4 + n5 <= byArray2.length) {
                for (n5 = 0; n5 < this.blocksizeBytes; n5 += 8) {
                    long l3;
                    int n6 = n5;
                    int n7 = n6 >> 3;
                    this.currentBlock[n7] = l3 = ThreefishEngine.bytesToWord(byArray, n3 + n6);
                }
                ThreefishEngine threefishEngine = this;
                threefishEngine.processBlock(threefishEngine.currentBlock, threefishEngine.currentBlock);
                for (int i3 = 0; i3 < (n3 = this.blocksizeBytes); i3 += 8) {
                    ThreefishEngine.wordToBytes(this.currentBlock[i3 >> 3], byArray2, n4 + i3);
                }
                return n3;
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new DataLengthException("Input buffer too short");
    }

    public int processBlock(long[] lArray, long[] lArray2) {
        int n3 = this.blocksizeWords;
        if (this.kw[n3] != 0L) {
            if (lArray.length == n3) {
                if (lArray2.length == n3) {
                    if (this.forEncryption) {
                        this.cipher.encryptBlock(lArray, lArray2);
                    } else {
                        this.cipher.decryptBlock(lArray, lArray2);
                    }
                    return this.blocksizeWords;
                }
                throw new OutputLengthException("Output buffer too short");
            }
            throw new DataLengthException("Input buffer too short");
        }
        throw new IllegalStateException("Threefish engine not initialised");
    }

    public static final class Threefish1024Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 24;
        private static final int ROTATION_0_1 = 13;
        private static final int ROTATION_0_2 = 8;
        private static final int ROTATION_0_3 = 47;
        private static final int ROTATION_0_4 = 8;
        private static final int ROTATION_0_5 = 17;
        private static final int ROTATION_0_6 = 22;
        private static final int ROTATION_0_7 = 37;
        private static final int ROTATION_1_0 = 38;
        private static final int ROTATION_1_1 = 19;
        private static final int ROTATION_1_2 = 10;
        private static final int ROTATION_1_3 = 55;
        private static final int ROTATION_1_4 = 49;
        private static final int ROTATION_1_5 = 18;
        private static final int ROTATION_1_6 = 23;
        private static final int ROTATION_1_7 = 52;
        private static final int ROTATION_2_0 = 33;
        private static final int ROTATION_2_1 = 4;
        private static final int ROTATION_2_2 = 51;
        private static final int ROTATION_2_3 = 13;
        private static final int ROTATION_2_4 = 34;
        private static final int ROTATION_2_5 = 41;
        private static final int ROTATION_2_6 = 59;
        private static final int ROTATION_2_7 = 17;
        private static final int ROTATION_3_0 = 5;
        private static final int ROTATION_3_1 = 20;
        private static final int ROTATION_3_2 = 48;
        private static final int ROTATION_3_3 = 41;
        private static final int ROTATION_3_4 = 47;
        private static final int ROTATION_3_5 = 28;
        private static final int ROTATION_3_6 = 16;
        private static final int ROTATION_3_7 = 25;
        private static final int ROTATION_4_0 = 41;
        private static final int ROTATION_4_1 = 9;
        private static final int ROTATION_4_2 = 37;
        private static final int ROTATION_4_3 = 31;
        private static final int ROTATION_4_4 = 12;
        private static final int ROTATION_4_5 = 47;
        private static final int ROTATION_4_6 = 44;
        private static final int ROTATION_4_7 = 30;
        private static final int ROTATION_5_0 = 16;
        private static final int ROTATION_5_1 = 34;
        private static final int ROTATION_5_2 = 56;
        private static final int ROTATION_5_3 = 51;
        private static final int ROTATION_5_4 = 4;
        private static final int ROTATION_5_5 = 53;
        private static final int ROTATION_5_6 = 42;
        private static final int ROTATION_5_7 = 41;
        private static final int ROTATION_6_0 = 31;
        private static final int ROTATION_6_1 = 44;
        private static final int ROTATION_6_2 = 47;
        private static final int ROTATION_6_3 = 46;
        private static final int ROTATION_6_4 = 19;
        private static final int ROTATION_6_5 = 42;
        private static final int ROTATION_6_6 = 44;
        private static final int ROTATION_6_7 = 25;
        private static final int ROTATION_7_0 = 9;
        private static final int ROTATION_7_1 = 48;
        private static final int ROTATION_7_2 = 35;
        private static final int ROTATION_7_3 = 52;
        private static final int ROTATION_7_4 = 23;
        private static final int ROTATION_7_5 = 31;
        private static final int ROTATION_7_6 = 37;
        private static final int ROTATION_7_7 = 20;

        public Threefish1024Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void encryptBlock(long[] lArray, long[] lArray2) {
            Threefish1024Cipher threefish1024Cipher = object;
            Object object = threefish1024Cipher.kw;
            long[] lArray3 = threefish1024Cipher.t;
            int[] nArray = MOD17;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 33) {
                if (lArray3.length == 5) {
                    long l3 = lArray[0];
                    long l4 = lArray[1];
                    long l5 = lArray[2];
                    long l6 = lArray[3];
                    long l7 = lArray[4];
                    long l8 = lArray[5];
                    long l9 = lArray[6];
                    long l10 = lArray[7];
                    long l11 = lArray[8];
                    long l12 = lArray[9];
                    long l13 = lArray[10];
                    long l14 = lArray[11];
                    long l15 = lArray[12];
                    Object object2 = lArray[13];
                    Object object3 = lArray[14];
                    Object object4 = object;
                    l3 += object[0];
                    l4 += object[1];
                    l5 += object[2];
                    l6 += object[3];
                    l7 += object[4];
                    l8 += object[5];
                    l9 += object[6];
                    l10 += object[7];
                    l11 += object[8];
                    l12 += object[9];
                    l13 += object[10];
                    l14 += object[11];
                    l15 += object[12];
                    object2 = object4[13] + lArray3[0] + object2;
                    object3 = object4[14] + lArray3[1] + object3;
                    Object object5 = lArray[15] + object4[15];
                    for (int i3 = 1; i3 < 20; i3 += 2) {
                        int n3 = nArray[i3];
                        Object object6 = object;
                        int n4 = nArray2[i3];
                        long l16 = l3 + l4;
                        long l17 = ThreefishEngine.rotlXor(l4, 24, l16);
                        long l18 = l5 + l6;
                        long l19 = ThreefishEngine.rotlXor(l6, 13, l18);
                        Object object7 = l7 + l8;
                        long l20 = ThreefishEngine.rotlXor(l8, 8, object7);
                        Object object8 = l9 + l10;
                        long l21 = ThreefishEngine.rotlXor(l10, 47, object8);
                        long l22 = l11 + l12;
                        long l23 = ThreefishEngine.rotlXor(l12, 8, l22);
                        long l24 = l13 + l14;
                        long l25 = ThreefishEngine.rotlXor(l14, 17, l24);
                        long l26 = l15 + object2;
                        long l27 = l21;
                        long l28 = l24;
                        long l29 = l21;
                        l21 = ThreefishEngine.rotlXor(object2, 22, l26);
                        l24 = object3 + object5;
                        Object object9 = ThreefishEngine.rotlXor(object5, 37, l24);
                        long l30 = object7;
                        long l31 = object8;
                        long l32 = l18;
                        l18 = ThreefishEngine.rotlXor(l23, 38, l16 += l23);
                        object7 = l32 + l21;
                        object8 = ThreefishEngine.rotlXor(l21, 19, object7);
                        l21 = l31 + l25;
                        l23 = ThreefishEngine.rotlXor(l25, 10, l21);
                        l25 = l30 + object9;
                        object9 = ThreefishEngine.rotlXor(object9, 55, l25);
                        long l33 = l28 + l29;
                        long l34 = ThreefishEngine.rotlXor(l27, 49, l33);
                        long l35 = l17;
                        long l36 = l17;
                        l17 = ThreefishEngine.rotlXor(l19, 18, l26 += l19);
                        l19 = l24 + l20;
                        l20 = ThreefishEngine.rotlXor(l20, 23, l19);
                        long l37 = ThreefishEngine.rotlXor(l35, 52, l22 += l36);
                        l24 = l37;
                        long l38 = l21;
                        long l39 = l24;
                        long l40 = l17;
                        long l41 = l17;
                        l17 = ThreefishEngine.rotlXor(l34, 33, l16 += l34);
                        object7 += l20;
                        l20 = ThreefishEngine.rotlXor(l20, 4, object7);
                        l21 = l25 + l41;
                        l24 = ThreefishEngine.rotlXor(l40, 51, l21);
                        l25 = l38 + l39;
                        l34 = ThreefishEngine.rotlXor(l37, 13, l25);
                        l26 += object9;
                        long l42 = l24;
                        long l43 = l23;
                        long l44 = l22;
                        long l45 = object8;
                        long l46 = l19;
                        l19 = ThreefishEngine.rotlXor(object9, 34, l26);
                        object8 = l46 + object8;
                        l22 = ThreefishEngine.rotlXor(l45, 41, object8);
                        l23 = l44 + l23;
                        object9 = ThreefishEngine.rotlXor(l43, 59, l23);
                        l33 += l18;
                        long l47 = l24;
                        long l48 = l20;
                        long l49 = l23;
                        long l50 = l20;
                        long l51 = object8;
                        long l52 = ThreefishEngine.rotlXor(l18, 17, l33);
                        long l53 = l18 = l52;
                        l18 = ThreefishEngine.rotlXor(l19, 5, l16 += l19);
                        l19 = object7 + object9;
                        object7 = ThreefishEngine.rotlXor(object9, 20, l19);
                        l20 = l25 + l22;
                        object8 = ThreefishEngine.rotlXor(l22, 48, l20);
                        l22 = ThreefishEngine.rotlXor(l52, 41, l21 += l53);
                        l23 = l51 + l34;
                        l24 = ThreefishEngine.rotlXor(l34, 47, l23);
                        l25 = l49 + l50;
                        object9 = ThreefishEngine.rotlXor(l48, 28, l25);
                        l34 = ThreefishEngine.rotlXor(l42, 16, l33 += l47);
                        long l54 = l26 + l17;
                        l26 = l54;
                        long l55 = object7;
                        long l56 = l22;
                        long l57 = l21;
                        long l58 = l19;
                        l16 += object[n3];
                        int n5 = n3 + 1;
                        l19 = l24 + object[n5];
                        int n6 = n3 + 2;
                        object7 = l58 + object[n6];
                        int n7 = n3 + 3;
                        l21 = l34 + object[n7];
                        int n8 = n3 + 4;
                        l22 = l57 + object[n8];
                        int n9 = n3 + 5;
                        l14 = object9 + object[n9];
                        int n10 = n3 + 6;
                        object9 = l20 + object[n10];
                        int n11 = n3 + 7;
                        object3 = ThreefishEngine.rotlXor(l17, 25, l26) + object[n11];
                        int n12 = n3 + 8;
                        l26 = l25 + object[n12];
                        int n13 = n3 + 9;
                        long l59 = l56 + object[n13];
                        int n14 = n3 + 10;
                        long l60 = l33 + object[n14];
                        int n15 = n3 + 11;
                        long l61 = l55 + object[n15];
                        int n16 = n3 + 12;
                        long l62 = l61;
                        long l63 = l60;
                        long l64 = l61;
                        Object object10 = object3;
                        long l65 = object9;
                        Object object11 = object3;
                        long l66 = l14;
                        long l67 = l22;
                        long l68 = l14;
                        long l69 = l21;
                        long l70 = l21;
                        long l71 = l19;
                        long l72 = l19;
                        Object object12 = object;
                        int n17 = n3 + 13;
                        l19 = (long)(object12[n17] + lArray3[n4] + object8);
                        int n18 = n3 + 14;
                        int n19 = n4 + 1;
                        object8 = object12[n18] + lArray3[n19] + l23;
                        int n20 = n3 + 15;
                        l21 = i3;
                        l18 = (long)(object12[n20] + l21 + l18);
                        l22 = l16 + l72;
                        l23 = ThreefishEngine.rotlXor(l71, 41, l22);
                        l14 = object7 + l70;
                        object9 = ThreefishEngine.rotlXor(l69, 9, l14);
                        object3 = l67 + l68;
                        long l73 = ThreefishEngine.rotlXor(l66, 37, object3);
                        long l74 = l65 + object11;
                        l60 = ThreefishEngine.rotlXor(object10, 31, l74);
                        l61 = l26 + l59;
                        long l75 = ThreefishEngine.rotlXor(l59, 12, l61);
                        long l76 = l63 + l64;
                        long l77 = ThreefishEngine.rotlXor(l62, 47, l76);
                        long l78 = l54 + object[n16] + l19;
                        long l79 = l60;
                        long l80 = l60;
                        Object object13 = l18;
                        Object object14 = l18;
                        l18 = ThreefishEngine.rotlXor(l19, 44, l78);
                        l19 = object8 + object14;
                        long l81 = ThreefishEngine.rotlXor(object13, 30, l19);
                        object8 = l81;
                        Object object15 = object3;
                        long l82 = object8;
                        long l83 = l18;
                        long l84 = l18;
                        l18 = l22 + l75;
                        object8 = ThreefishEngine.rotlXor(l75, 16, l18);
                        l22 = l14 + l84;
                        l14 = ThreefishEngine.rotlXor(l83, 34, l22);
                        object3 = l74 + l77;
                        l74 = ThreefishEngine.rotlXor(l77, 56, object3);
                        l60 = object15 + l82;
                        l75 = ThreefishEngine.rotlXor(l81, 51, l60);
                        l77 = ThreefishEngine.rotlXor(l79, 4, l76 += l80);
                        long l85 = l23;
                        long l86 = l23;
                        long l87 = l19;
                        l19 = ThreefishEngine.rotlXor(object9, 53, l78 += object9);
                        l23 = l87 + l73;
                        object9 = ThreefishEngine.rotlXor(l73, 42, l23);
                        l73 = l61 + l86;
                        long l88 = ThreefishEngine.rotlXor(l85, 41, l73);
                        l61 = l88;
                        Object object16 = object3;
                        long l89 = l19;
                        long l90 = l19;
                        l19 = ThreefishEngine.rotlXor(l77, 31, l18 += l77);
                        l22 += object9;
                        object9 = ThreefishEngine.rotlXor(object9, 44, l22);
                        object3 = l60 + l90;
                        l60 = ThreefishEngine.rotlXor(l89, 47, object3);
                        l61 = object16 + l61;
                        l77 = ThreefishEngine.rotlXor(l88, 46, l61);
                        l78 += l75;
                        long l91 = l60;
                        long l92 = l74;
                        long l93 = l73;
                        long l94 = l14;
                        long l95 = l23;
                        l23 = ThreefishEngine.rotlXor(l75, 19, l78);
                        l14 = l95 + l14;
                        l73 = ThreefishEngine.rotlXor(l94, 42, l14);
                        l74 = l93 + l74;
                        l75 = ThreefishEngine.rotlXor(l92, 44, l74);
                        l76 += object8;
                        long l96 = l60;
                        long l97 = object9;
                        long l98 = l74;
                        long l99 = object9;
                        long l100 = l14;
                        long l101 = ThreefishEngine.rotlXor(object8, 25, l76);
                        Object object17 = object8 = l101;
                        object8 = ThreefishEngine.rotlXor(l23, 9, l18 += l23);
                        l23 = ThreefishEngine.rotlXor(l75, 48, l22 += l75);
                        l14 = l61 + l73;
                        object9 = ThreefishEngine.rotlXor(l73, 35, l14);
                        l73 = ThreefishEngine.rotlXor(l101, 52, object3 += object17);
                        l74 = l100 + l77;
                        l60 = ThreefishEngine.rotlXor(l77, 23, l74);
                        l61 = l98 + l99;
                        l75 = ThreefishEngine.rotlXor(l97, 31, l61);
                        l77 = ThreefishEngine.rotlXor(l91, 37, l76 += l96);
                        long l102 = l23;
                        long l103 = ThreefishEngine.rotlXor(l19, 20, l78 += l19);
                        l16 = l18 + object[n5];
                        l17 = l60 + object[n6];
                        l18 = l22 + object[n7];
                        l19 = l77 + object[n8];
                        l20 = object3 + object[n9];
                        l22 = l75 + object[n10];
                        l23 = l14 + object[n11];
                        l24 = l103 + object[n12];
                        l25 = l61 + object[n13];
                        l33 = l73 + object[n14];
                        l34 = l76 + object[n15];
                        long l104 = l102 + object[n16];
                        long l105 = l78 + object[n17];
                        object9 = object6[n18] + lArray3[n19] + object9;
                        object7 = object6[n20] + lArray3[n4 + 2] + l74;
                        object8 = object[n3 + 16] + l21 + 1L + object8;
                        object5 = object8;
                        object3 = object7;
                        object2 = object9;
                        l15 = l105;
                        l14 = l104;
                        l13 = l34;
                        l12 = l33;
                        l11 = l25;
                        l10 = l24;
                        l9 = l23;
                        l8 = l22;
                        l7 = l20;
                        l6 = l19;
                        l5 = l18;
                        l4 = l17;
                        l3 = l16;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    lArray4[0] = l3;
                    lArray5[1] = l4;
                    lArray4[2] = l5;
                    lArray5[3] = l6;
                    lArray4[4] = l7;
                    lArray5[5] = l8;
                    lArray4[6] = l9;
                    lArray5[7] = l10;
                    lArray4[8] = l11;
                    lArray5[9] = l12;
                    lArray4[10] = l13;
                    lArray5[11] = l14;
                    lArray4[12] = l15;
                    lArray5[13] = object2;
                    lArray4[14] = object3;
                    lArray5[15] = object5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void decryptBlock(long[] lArray, long[] lArray2) {
            Threefish1024Cipher threefish1024Cipher = object;
            Object object = threefish1024Cipher.kw;
            long[] lArray3 = threefish1024Cipher.t;
            int[] nArray = MOD17;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 33) {
                if (lArray3.length == 5) {
                    long l3 = lArray[0];
                    long l4 = lArray[1];
                    long l5 = lArray[2];
                    long l6 = lArray[3];
                    long l7 = lArray[4];
                    long l8 = lArray[5];
                    long l9 = lArray[6];
                    long l10 = lArray[7];
                    long l11 = lArray[8];
                    long l12 = lArray[9];
                    long l13 = lArray[10];
                    long l14 = lArray[11];
                    long l15 = lArray[12];
                    long l16 = lArray[13];
                    long l17 = lArray[14];
                    long l18 = lArray[15];
                    for (int i3 = 19; i3 >= 1; i3 -= 2) {
                        long l19 = l15;
                        long l20 = l12;
                        long l21 = l9;
                        long l22 = l6;
                        int n3 = nArray[i3];
                        int n4 = nArray2[i3];
                        int n5 = n3 + 1;
                        long l23 = l3 - object[n5];
                        int n6 = n3 + 2;
                        l6 = l4 - object[n6];
                        int n7 = n3 + 3;
                        long l24 = l5 - object[n7];
                        int n8 = n3 + 4;
                        l9 = l22 - object[n8];
                        int n9 = n3 + 5;
                        long l25 = l7 - object[n9];
                        int n10 = n3 + 6;
                        l12 = l8 - object[n10];
                        int n11 = n3 + 7;
                        long l26 = l21 - object[n11];
                        int n12 = n3 + 8;
                        l15 = l10 - object[n12];
                        int n13 = n3 + 9;
                        long l27 = l11 - object[n13];
                        int n14 = n3 + 10;
                        long l28 = l20 - object[n14];
                        int n15 = n3 + 11;
                        long l29 = l13 - object[n15];
                        int n16 = n3 + 12;
                        long l30 = l14 - object[n16];
                        int n17 = n3 + 13;
                        long l31 = l19 - object[n17];
                        int n18 = n3 + 14;
                        int n19 = n4 + 1;
                        long l32 = l16 - (object[n18] + lArray3[n19]);
                        int n20 = n3 + 15;
                        long l33 = l17 - (object[n20] + lArray3[n4 + 2]);
                        long l34 = l33;
                        long l35 = l6;
                        long l36 = l25;
                        long l37 = l28;
                        long l38 = l26;
                        long l39 = l24;
                        long l40 = l23;
                        l6 = i3;
                        l23 = ThreefishEngine.xorRotr(l18 - (object[n3 + 16] + l6 + 1L), 9, l23);
                        l18 = l40 - l23;
                        l24 = ThreefishEngine.xorRotr(l30, 48, l24);
                        l28 = l39 - l24;
                        l26 = ThreefishEngine.xorRotr(l32, 35, l26);
                        l30 = l38 - l26;
                        l25 = ThreefishEngine.xorRotr(l37, 52, l25);
                        l32 = l36 - l25;
                        l34 = ThreefishEngine.xorRotr(l35, 23, l34);
                        long l41 = l33 - l34;
                        long l42 = l26;
                        long l43 = l15;
                        long l44 = l9;
                        l9 = ThreefishEngine.xorRotr(l12, 31, l27);
                        l12 = l27 - l9;
                        l26 = ThreefishEngine.xorRotr(l44, 37, l29);
                        l15 = l29 - l26;
                        l27 = ThreefishEngine.xorRotr(l43, 20, l31);
                        long l45 = l31 - l27;
                        l29 = l45;
                        long l46 = l23;
                        long l47 = l30;
                        long l48 = l26;
                        long l49 = l9;
                        l23 = ThreefishEngine.xorRotr(l27, 31, l18);
                        l9 = l18 - l23;
                        l26 = ThreefishEngine.xorRotr(l49, 44, l28);
                        l27 = l28 - l26;
                        l18 = ThreefishEngine.xorRotr(l48, 47, l32);
                        l28 = l32 - l18;
                        l30 = ThreefishEngine.xorRotr(l34, 46, l30);
                        l31 = l47 - l30;
                        l29 = ThreefishEngine.xorRotr(l46, 19, l29);
                        l32 = l45 - l29;
                        l34 = ThreefishEngine.xorRotr(l42, 42, l41);
                        l41 -= l34;
                        long l50 = l26;
                        long l51 = l18;
                        long l52 = l25;
                        l24 = ThreefishEngine.xorRotr(l24, 44, l12);
                        l25 = l12 - l24;
                        l12 = ThreefishEngine.xorRotr(l52, 25, l15);
                        long l53 = l15 - l12;
                        l26 = l53;
                        long l54 = l23;
                        long l55 = l24;
                        l23 = ThreefishEngine.xorRotr(l12, 16, l9);
                        l24 = l9 - l23;
                        l9 = ThreefishEngine.xorRotr(l34, 34, l27);
                        l12 = l27 - l9;
                        l15 = ThreefishEngine.xorRotr(l55, 56, l31);
                        l27 = l31 - l15;
                        l18 = ThreefishEngine.xorRotr(l29, 51, l28);
                        l28 -= l18;
                        l26 = ThreefishEngine.xorRotr(l54, 4, l26);
                        l29 = l53 - l26;
                        l31 = ThreefishEngine.xorRotr(l51, 53, l32);
                        l32 -= l31;
                        l34 = ThreefishEngine.xorRotr(l50, 42, l41);
                        l41 -= l34;
                        long l56 = l18;
                        long l57 = l9;
                        long l58 = l29;
                        long l59 = l15;
                        l9 = ThreefishEngine.xorRotr(l30, 41, l25);
                        long l60 = l25 - l9;
                        l25 = l60;
                        long l61 = l23;
                        long l62 = l27;
                        long l63 = l26;
                        l23 = ThreefishEngine.xorRotr(l9, 41, l24);
                        l24 -= l23;
                        l9 = ThreefishEngine.xorRotr(l31, 9, l12);
                        l12 -= l9;
                        l26 = ThreefishEngine.xorRotr(l34, 37, l28);
                        l15 = l28 - l26;
                        l27 = ThreefishEngine.xorRotr(l63, 31, l27);
                        l18 = l62 - l27;
                        l25 = ThreefishEngine.xorRotr(l61, 12, l25);
                        l28 = l60 - l25;
                        l29 = ThreefishEngine.xorRotr(l59, 47, l29);
                        l30 = l58 - l29;
                        l31 = ThreefishEngine.xorRotr(l57, 44, l32);
                        l32 -= l31;
                        l34 = ThreefishEngine.xorRotr(l56, 30, l41);
                        l4 = l24 - object[n3];
                        l5 = l23 - object[n5];
                        l7 = l12 - object[n6];
                        l8 = l9 - object[n7];
                        l9 = l15 - object[n8];
                        l10 = l26 - object[n9];
                        l11 = l18 - object[n10];
                        l12 = l27 - object[n11];
                        l13 = l28 - object[n12];
                        l14 = l25 - object[n13];
                        l15 = l30 - object[n14];
                        l16 = l29 - object[n15];
                        l17 = l32 - object[n16];
                        l3 = l31 - (object[n17] + lArray3[n4]);
                        l18 = l41 - l34 - (object[n18] + lArray3[n19]);
                        long l64 = l5;
                        long l65 = l9;
                        long l66 = l3;
                        l3 = ThreefishEngine.xorRotr(l34 - (object[n20] + l6), 5, l4);
                        l4 -= l3;
                        l5 = ThreefishEngine.xorRotr(l16, 20, l7);
                        l6 = l7 - l5;
                        l7 = ThreefishEngine.xorRotr(l66, 48, l11);
                        l11 -= l7;
                        l9 = ThreefishEngine.xorRotr(l14, 41, l9);
                        l14 = l65 - l9;
                        l16 = ThreefishEngine.xorRotr(l64, 47, l18);
                        l18 -= l16;
                        long l67 = l7;
                        long l68 = l12;
                        long l69 = l8;
                        l7 = ThreefishEngine.xorRotr(l10, 28, l13);
                        l8 = l13 - l7;
                        l10 = ThreefishEngine.xorRotr(l69, 16, l15);
                        l12 = l15 - l10;
                        l13 = ThreefishEngine.xorRotr(l68, 25, l17);
                        long l70 = l17 - l13;
                        l15 = l70;
                        long l71 = l3;
                        long l72 = l11;
                        long l73 = l6;
                        l3 = ThreefishEngine.xorRotr(l13, 33, l4);
                        l4 -= l3;
                        l6 = ThreefishEngine.xorRotr(l7, 4, l6);
                        l7 = l73 - l6;
                        l10 = ThreefishEngine.xorRotr(l10, 51, l14);
                        l13 = l14 - l10;
                        l11 = ThreefishEngine.xorRotr(l16, 13, l11);
                        l14 = l72 - l11;
                        l15 = ThreefishEngine.xorRotr(l71, 34, l15);
                        l16 = l70 - l15;
                        l17 = ThreefishEngine.xorRotr(l67, 41, l18);
                        l18 -= l17;
                        long l74 = l6;
                        long l75 = l10;
                        l5 = ThreefishEngine.xorRotr(l5, 59, l8);
                        l6 = l8 - l5;
                        l8 = ThreefishEngine.xorRotr(l9, 17, l12);
                        long l76 = l12 - l8;
                        l9 = l76;
                        long l77 = l3;
                        long l78 = l5;
                        l3 = ThreefishEngine.xorRotr(l8, 38, l4);
                        l4 -= l3;
                        l5 = ThreefishEngine.xorRotr(l17, 19, l7);
                        l7 -= l5;
                        l8 = ThreefishEngine.xorRotr(l78, 10, l14);
                        l10 = l14 - l8;
                        l12 = ThreefishEngine.xorRotr(l15, 55, l13);
                        l13 -= l12;
                        l9 = ThreefishEngine.xorRotr(l77, 49, l9);
                        l14 = l76 - l9;
                        l15 = ThreefishEngine.xorRotr(l75, 18, l16);
                        l17 = ThreefishEngine.xorRotr(l74, 23, l18);
                        long l79 = l18 - l17;
                        l18 = l79;
                        long l80 = l12;
                        long l81 = l16 -= l15;
                        long l82 = l5;
                        long l83 = l14;
                        long l84 = l8;
                        l5 = ThreefishEngine.xorRotr(l11, 52, l6);
                        l6 -= l5;
                        long l85 = l3;
                        long l86 = l10;
                        long l87 = l9;
                        long l88 = l4;
                        l4 = ThreefishEngine.xorRotr(l5, 24, l4);
                        l3 = l88 - l4;
                        l5 = ThreefishEngine.xorRotr(l15, 13, l7);
                        l7 -= l5;
                        l8 = ThreefishEngine.xorRotr(l17, 8, l13);
                        l9 = l13 - l8;
                        l10 = ThreefishEngine.xorRotr(l87, 47, l10);
                        l11 = l86 - l10;
                        l12 = ThreefishEngine.xorRotr(l85, 8, l6);
                        l6 -= l12;
                        l14 = ThreefishEngine.xorRotr(l84, 17, l14);
                        l13 = l83 - l14;
                        l16 = ThreefishEngine.xorRotr(l82, 22, l16);
                        l15 = l81 - l16;
                        l18 = ThreefishEngine.xorRotr(l80, 37, l18);
                        l17 = l79 - l18;
                        long l89 = l7;
                        long l90 = l9;
                        long l91 = l11;
                        l11 = l6;
                        l9 = l91;
                        l7 = l90;
                        l6 = l5;
                        l5 = l89;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    long l92 = l3 - object[0];
                    long l93 = l4 - object[1];
                    l3 = l5 - object[2];
                    l4 = l6 - object[3];
                    l5 = l7 - object[4];
                    l6 = l8 - object[5];
                    l7 = l9 - object[6];
                    l8 = l10 - object[7];
                    l9 = l11 - object[8];
                    l10 = l12 - object[9];
                    l11 = l13 - object[10];
                    l12 = l14 - object[11];
                    l13 = l15 - object[12];
                    l14 = l16 - (object[13] + lArray3[0]);
                    l15 = l17 - (object[14] + lArray3[1]);
                    l16 = l18 - object[15];
                    lArray4[0] = l92;
                    lArray5[1] = l93;
                    lArray4[2] = l3;
                    lArray5[3] = l4;
                    lArray4[4] = l5;
                    lArray5[5] = l6;
                    lArray4[6] = l7;
                    lArray5[7] = l8;
                    lArray4[8] = l9;
                    lArray5[9] = l10;
                    lArray4[10] = l11;
                    lArray5[11] = l12;
                    lArray4[12] = l13;
                    lArray5[13] = l14;
                    lArray4[14] = l15;
                    lArray5[15] = l16;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class Threefish512Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 46;
        private static final int ROTATION_0_1 = 36;
        private static final int ROTATION_0_2 = 19;
        private static final int ROTATION_0_3 = 37;
        private static final int ROTATION_1_0 = 33;
        private static final int ROTATION_1_1 = 27;
        private static final int ROTATION_1_2 = 14;
        private static final int ROTATION_1_3 = 42;
        private static final int ROTATION_2_0 = 17;
        private static final int ROTATION_2_1 = 49;
        private static final int ROTATION_2_2 = 36;
        private static final int ROTATION_2_3 = 39;
        private static final int ROTATION_3_0 = 44;
        private static final int ROTATION_3_1 = 9;
        private static final int ROTATION_3_2 = 54;
        private static final int ROTATION_3_3 = 56;
        private static final int ROTATION_4_0 = 39;
        private static final int ROTATION_4_1 = 30;
        private static final int ROTATION_4_2 = 34;
        private static final int ROTATION_4_3 = 24;
        private static final int ROTATION_5_0 = 13;
        private static final int ROTATION_5_1 = 50;
        private static final int ROTATION_5_2 = 10;
        private static final int ROTATION_5_3 = 17;
        private static final int ROTATION_6_0 = 25;
        private static final int ROTATION_6_1 = 29;
        private static final int ROTATION_6_2 = 39;
        private static final int ROTATION_6_3 = 43;
        private static final int ROTATION_7_0 = 8;
        private static final int ROTATION_7_1 = 35;
        private static final int ROTATION_7_2 = 56;
        private static final int ROTATION_7_3 = 22;

        public Threefish512Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void encryptBlock(long[] lArray, long[] lArray2) {
            Threefish512Cipher threefish512Cipher = object;
            Object object = threefish512Cipher.kw;
            long[] lArray3 = threefish512Cipher.t;
            int[] nArray = MOD9;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 17) {
                if (lArray3.length == 5) {
                    long l3 = lArray[0];
                    long l4 = lArray[1];
                    long l5 = lArray[2];
                    long l6 = lArray[3];
                    long l7 = lArray[4];
                    Object object2 = lArray[5];
                    Object object3 = lArray[6];
                    Object object4 = object;
                    l3 += object[0];
                    l4 += object[1];
                    l5 += object[2];
                    l6 += object[3];
                    l7 += object[4];
                    object2 = object4[5] + lArray3[0] + object2;
                    object3 = object4[6] + lArray3[1] + object3;
                    Object object5 = lArray[7] + object4[7];
                    for (int i3 = 1; i3 < 18; i3 += 2) {
                        int n3 = nArray[i3];
                        Object object6 = object;
                        int n4 = nArray2[i3];
                        long l8 = l3 + l4;
                        long l9 = ThreefishEngine.rotlXor(l4, 46, l8);
                        long l10 = l5 + l6;
                        long l11 = ThreefishEngine.rotlXor(l6, 36, l10);
                        Object object7 = l7 + object2;
                        long l12 = l9;
                        long l13 = l10;
                        long l14 = l9;
                        l9 = ThreefishEngine.rotlXor(object2, 19, object7);
                        l10 = object3 + object5;
                        long l15 = ThreefishEngine.rotlXor(object5, 37, l10);
                        Object object8 = l13 + l14;
                        long l16 = ThreefishEngine.rotlXor(l12, 33, object8);
                        long l17 = l11;
                        long l18 = l8;
                        long l19 = l9;
                        l8 = ThreefishEngine.rotlXor(l15, 27, object7 += l15);
                        l9 = l10 + l9;
                        l10 = ThreefishEngine.rotlXor(l19, 14, l9);
                        l11 = l18 + l11;
                        l15 = ThreefishEngine.rotlXor(l17, 42, l11);
                        long l20 = l10;
                        long l21 = l11;
                        long l22 = l10;
                        long l23 = l9;
                        l9 = ThreefishEngine.rotlXor(l16, 17, object7 += l16);
                        l10 = l23 + l15;
                        l11 = ThreefishEngine.rotlXor(l15, 49, l10);
                        l15 = l21 + l22;
                        l16 = ThreefishEngine.rotlXor(l20, 36, l15);
                        long l24 = ThreefishEngine.rotlXor(l8, 39, object8 += l8);
                        long l25 = l8 = l24;
                        l8 = l10 + l9;
                        l9 = ThreefishEngine.rotlXor(l9, 44, l8);
                        l10 = l15 + l25;
                        l15 = ThreefishEngine.rotlXor(l24, 9, l10);
                        object8 += l16;
                        l16 = ThreefishEngine.rotlXor(l16, 54, object8);
                        long l26 = object7 + l11;
                        object7 = l26;
                        long l27 = l9;
                        l9 = l10 + object[n3];
                        int n5 = n3 + 1;
                        l6 = l27 + object[n5];
                        int n6 = n3 + 2;
                        object8 += object[n6];
                        int n7 = n3 + 3;
                        object7 = ThreefishEngine.rotlXor(l11, 56, object7) + object[n7];
                        int n8 = n3 + 4;
                        long l28 = l6;
                        long l29 = l6;
                        Object object9 = object;
                        int n9 = n3 + 5;
                        l6 = (long)(object9[n9] + lArray3[n4] + l16);
                        int n10 = n3 + 6;
                        int n11 = n4 + 1;
                        l8 = (long)(object9[n10] + lArray3[n11] + l8);
                        int n12 = n3 + 7;
                        l16 = i3;
                        l15 = (long)(object9[n12] + l16 + l15);
                        long l30 = l9 + l29;
                        long l31 = ThreefishEngine.rotlXor(l28, 39, l30);
                        long l32 = object8 + object7;
                        long l33 = ThreefishEngine.rotlXor(object7, 30, l32);
                        long l34 = l26 + object[n8] + l6;
                        long l35 = l31;
                        Object object10 = l8;
                        l8 = ThreefishEngine.rotlXor(l6, 34, l34);
                        l6 = object10 + l15;
                        l15 = ThreefishEngine.rotlXor(l15, 24, l6);
                        l31 = l32 + l31;
                        l32 = ThreefishEngine.rotlXor(l35, 13, l31);
                        long l36 = l8;
                        long l37 = l8;
                        l8 = ThreefishEngine.rotlXor(l15, 50, l34 += l15);
                        l15 = ThreefishEngine.rotlXor(l36, 10, l6 += l37);
                        l30 += l33;
                        l33 = ThreefishEngine.rotlXor(l33, 17, l30);
                        long l38 = l15;
                        long l39 = l30;
                        long l40 = l15;
                        long l41 = l6;
                        l6 = ThreefishEngine.rotlXor(l32, 25, l34 += l32);
                        l15 = l41 + l33;
                        l30 = ThreefishEngine.rotlXor(l33, 29, l15);
                        l32 = l39 + l40;
                        l33 = ThreefishEngine.rotlXor(l38, 39, l32);
                        long l42 = l31 + l8;
                        l31 = l42;
                        long l43 = ThreefishEngine.rotlXor(l8, 43, l31);
                        long l44 = l8 = l43;
                        l8 = l15 + l6;
                        l6 = ThreefishEngine.rotlXor(l6, 8, l8);
                        l15 = l32 + l44;
                        l31 = ThreefishEngine.rotlXor(l43, 35, l15);
                        l32 = l42 + l33;
                        l33 = ThreefishEngine.rotlXor(l33, 56, l32);
                        l9 = l15 + object[n5];
                        l10 = l6 + object[n6];
                        l11 = l32 + object[n7];
                        l15 = ThreefishEngine.rotlXor(l30, 22, l34 += l30) + object[n8];
                        long l45 = l34 + object[n9];
                        object7 = object6[n10] + lArray3[n11] + l33;
                        l3 = (long)(object6[n12] + lArray3[n4 + 2] + l8);
                        object8 = object[n3 + 8] + l16 + 1L + l31;
                        object5 = object8;
                        object3 = l3;
                        object2 = object7;
                        l7 = l45;
                        l6 = l15;
                        l5 = l11;
                        l4 = l10;
                        l3 = l9;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    lArray4[0] = l3;
                    lArray5[1] = l4;
                    lArray4[2] = l5;
                    lArray5[3] = l6;
                    lArray4[4] = l7;
                    lArray5[5] = object2;
                    lArray4[6] = object3;
                    lArray5[7] = object5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void decryptBlock(long[] lArray, long[] lArray2) {
            Threefish512Cipher threefish512Cipher = object;
            Object object = threefish512Cipher.kw;
            long[] lArray3 = threefish512Cipher.t;
            int[] nArray = MOD9;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 17) {
                if (lArray3.length == 5) {
                    long l3 = lArray[0];
                    long l4 = lArray[1];
                    long l5 = lArray[2];
                    long l6 = lArray[3];
                    long l7 = lArray[4];
                    long l8 = lArray[5];
                    long l9 = lArray[6];
                    long l10 = lArray[7];
                    for (int i3 = 17; i3 >= 1; i3 -= 2) {
                        long l11 = l9;
                        long l12 = l6;
                        int n3 = nArray[i3];
                        int n4 = nArray2[i3];
                        int n5 = n3 + 1;
                        long l13 = l3 - object[n5];
                        int n6 = n3 + 2;
                        l6 = l4 - object[n6];
                        int n7 = n3 + 3;
                        long l14 = l5 - object[n7];
                        int n8 = n3 + 4;
                        l9 = l12 - object[n8];
                        int n9 = n3 + 5;
                        long l15 = l7 - object[n9];
                        int n10 = n3 + 6;
                        int n11 = n4 + 1;
                        long l16 = l8 - (object[n10] + lArray3[n11]);
                        int n12 = n3 + 7;
                        long l17 = l11 - (object[n12] + lArray3[n4 + 2]);
                        long l18 = l17;
                        long l19 = l6;
                        l6 = i3;
                        l10 -= object[n3 + 8] + l6 + 1L;
                        l18 = ThreefishEngine.xorRotr(l19, 8, l18);
                        long l20 = l17 - l18;
                        long l21 = l9;
                        long l22 = l14;
                        long l23 = l13;
                        l13 = ThreefishEngine.xorRotr(l10, 35, l13);
                        l9 = l23 - l13;
                        l14 = ThreefishEngine.xorRotr(l16, 56, l14);
                        l10 = l22 - l14;
                        long l24 = ThreefishEngine.xorRotr(l21, 22, l15);
                        l16 = l24;
                        long l25 = l15 - l16;
                        l15 = l25;
                        l15 = ThreefishEngine.xorRotr(l18, 25, l15);
                        l16 = l25 - l15;
                        l18 = ThreefishEngine.xorRotr(l24, 29, l20);
                        l20 -= l18;
                        long l26 = ThreefishEngine.xorRotr(l14, 39, l9);
                        l14 = l26;
                        long l27 = l13;
                        l13 = l9 - l14;
                        long l28 = ThreefishEngine.xorRotr(l27, 43, l10);
                        l14 = l28;
                        long l29 = l10 - l14;
                        l14 = l29;
                        l14 = ThreefishEngine.xorRotr(l15, 13, l14);
                        l9 = l29 - l14;
                        l10 = ThreefishEngine.xorRotr(l28, 50, l16);
                        l15 = l16 - l10;
                        l16 = ThreefishEngine.xorRotr(l26, 10, l20);
                        l20 -= l16;
                        long l30 = l10;
                        long l31 = l15;
                        long l32 = l9;
                        l10 = ThreefishEngine.xorRotr(l18, 17, l13);
                        long l33 = l13 - l10;
                        l13 = l33;
                        l13 = ThreefishEngine.xorRotr(l14, 39, l13);
                        l14 = l33 - l13;
                        l9 = ThreefishEngine.xorRotr(l10, 30, l9);
                        l10 = l32 - l9;
                        l15 = ThreefishEngine.xorRotr(l16, 34, l15);
                        l16 = l31 - l15;
                        l18 = ThreefishEngine.xorRotr(l30, 24, l20);
                        l4 = l14 - object[n3];
                        l5 = l13 - object[n5];
                        l7 = l10 - object[n6];
                        l8 = l9 - object[n7];
                        l9 = l16 - object[n8];
                        l3 = l15 - (object[n9] + lArray3[n4]);
                        l10 = l20 - l18 - (object[n10] + lArray3[n11]);
                        long l34 = l5;
                        l5 = l18 - (object[n12] + l6);
                        l6 = ThreefishEngine.xorRotr(l34, 44, l10);
                        l10 -= l6;
                        long l35 = l3;
                        l3 = ThreefishEngine.xorRotr(l5, 9, l4);
                        l4 -= l3;
                        l5 = ThreefishEngine.xorRotr(l35, 54, l7);
                        l7 -= l5;
                        long l36 = ThreefishEngine.xorRotr(l8, 56, l9);
                        l8 = l36;
                        l8 = l9 - l8;
                        l6 = ThreefishEngine.xorRotr(l6, 17, l8);
                        l8 -= l6;
                        l9 = ThreefishEngine.xorRotr(l36, 49, l10);
                        l10 -= l9;
                        long l37 = ThreefishEngine.xorRotr(l5, 36, l4);
                        l5 = l37;
                        long l38 = l3;
                        l3 = l4 - l5;
                        long l39 = ThreefishEngine.xorRotr(l38, 39, l7);
                        l4 = l39;
                        long l40 = l7 - l4;
                        l4 = l40;
                        l4 = ThreefishEngine.xorRotr(l6, 33, l4);
                        l5 = l40 - l4;
                        l6 = ThreefishEngine.xorRotr(l39, 27, l8);
                        l7 = l8 - l6;
                        l8 = ThreefishEngine.xorRotr(l37, 14, l10);
                        long l41 = l10 - l8;
                        l10 = l41;
                        long l42 = l6;
                        l6 = ThreefishEngine.xorRotr(l9, 42, l3);
                        l4 = ThreefishEngine.xorRotr(l4, 46, l3 -= l6);
                        l3 -= l4;
                        l6 = ThreefishEngine.xorRotr(l6, 36, l5);
                        l5 -= l6;
                        l8 = ThreefishEngine.xorRotr(l8, 19, l7);
                        l7 -= l8;
                        l10 = ThreefishEngine.xorRotr(l42, 37, l10);
                        l9 = l41 - l10;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    long l43 = l3 - object[0];
                    long l44 = l4 - object[1];
                    l3 = l5 - object[2];
                    l4 = l6 - object[3];
                    l5 = l7 - object[4];
                    l6 = l8 - (object[5] + lArray3[0]);
                    l7 = l9 - (object[6] + lArray3[1]);
                    l8 = l10 - object[7];
                    lArray4[0] = l43;
                    lArray5[1] = l44;
                    lArray4[2] = l3;
                    lArray5[3] = l4;
                    lArray4[4] = l5;
                    lArray5[5] = l6;
                    lArray4[6] = l7;
                    lArray5[7] = l8;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class Threefish256Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 14;
        private static final int ROTATION_0_1 = 16;
        private static final int ROTATION_1_0 = 52;
        private static final int ROTATION_1_1 = 57;
        private static final int ROTATION_2_0 = 23;
        private static final int ROTATION_2_1 = 40;
        private static final int ROTATION_3_0 = 5;
        private static final int ROTATION_3_1 = 37;
        private static final int ROTATION_4_0 = 25;
        private static final int ROTATION_4_1 = 33;
        private static final int ROTATION_5_0 = 46;
        private static final int ROTATION_5_1 = 12;
        private static final int ROTATION_6_0 = 58;
        private static final int ROTATION_6_1 = 22;
        private static final int ROTATION_7_0 = 32;
        private static final int ROTATION_7_1 = 32;

        public Threefish256Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void encryptBlock(long[] lArray, long[] lArray2) {
            Threefish256Cipher threefish256Cipher = object;
            Object object = threefish256Cipher.kw;
            long[] lArray3 = threefish256Cipher.t;
            int[] nArray = MOD5;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 9) {
                if (lArray3.length == 5) {
                    long l3 = lArray[0];
                    Object object2 = lArray[1];
                    Object object3 = lArray[2];
                    Object object4 = object;
                    l3 += object[0];
                    object2 = object4[1] + lArray3[0] + object2;
                    object3 = object4[2] + lArray3[1] + object3;
                    Object object5 = lArray[3] + object4[3];
                    for (int i3 = 1; i3 < 18; i3 += 2) {
                        int n3 = nArray[i3];
                        int n4 = n3;
                        Object object6 = object;
                        int n5 = nArray2[i3];
                        long l4 = l3 + object2;
                        long l5 = ThreefishEngine.rotlXor(object2, 14, l4);
                        Object object7 = object3 + object5;
                        Object object8 = ThreefishEngine.rotlXor(object5, 16, object7);
                        long l6 = l5;
                        long l7 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 52, l4 += object8);
                        object8 = ThreefishEngine.rotlXor(l6, 57, object7 += l7);
                        long l8 = l5;
                        long l9 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 23, l4 += object8);
                        object8 = ThreefishEngine.rotlXor(l8, 40, object7 += l9);
                        long l10 = l5;
                        long l11 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 5, l4 += object8);
                        object8 = ThreefishEngine.rotlXor(l10, 37, object7 += l11);
                        long l12 = l4 + object[n4];
                        Object object9 = object;
                        int n6 = n4 + 1;
                        object8 = object9[n6] + lArray3[n5] + object8;
                        int n7 = n4 + 2;
                        int n8 = n5 + 1;
                        object7 = object9[n7] + lArray3[n8] + object7;
                        long l13 = i3;
                        l5 = (long)(object9[n4 += 3] + l13 + l5);
                        long l14 = l12 + object8;
                        Object object10 = l5;
                        Object object11 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 25, l14);
                        object8 = ThreefishEngine.rotlXor(object10, 33, object7 += object11);
                        long l15 = l5;
                        long l16 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 46, l14 += object8);
                        object8 = ThreefishEngine.rotlXor(l15, 12, object7 += l16);
                        long l17 = l5;
                        long l18 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 58, l14 += object8);
                        object8 = ThreefishEngine.rotlXor(l17, 22, object7 += l18);
                        long l19 = l5;
                        long l20 = l5;
                        l5 = ThreefishEngine.rotlXor(object8, 32, l14 += object8);
                        object8 = ThreefishEngine.rotlXor(l19, 32, object7 += l20);
                        l14 += object[n6];
                        object8 = object6[n7] + lArray3[n8] + object8;
                        object7 = object6[n4] + lArray3[n5 + 2] + object7;
                        l3 = (long)(object[n3 + 4] + l13 + 1L + l5);
                        object5 = l3;
                        object3 = object7;
                        object2 = object8;
                        l3 = l14;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    lArray4[0] = l3;
                    lArray5[1] = object2;
                    lArray4[2] = object3;
                    lArray5[3] = object5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void decryptBlock(long[] lArray, long[] lArray2) {
            Threefish256Cipher threefish256Cipher = object;
            Object object = threefish256Cipher.kw;
            long[] lArray3 = threefish256Cipher.t;
            int[] nArray = MOD5;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 9) {
                if (lArray3.length == 5) {
                    long l3 = lArray[0];
                    long l4 = lArray[1];
                    long l5 = lArray[2];
                    long l6 = lArray[3];
                    for (int i3 = 17; i3 >= 1; i3 -= 2) {
                        int n3 = nArray[i3];
                        int n4 = nArray2[i3];
                        int n5 = n3 + 1;
                        long l7 = l3 - object[n5];
                        int n6 = n3 + 2;
                        int n7 = n4 + 1;
                        long l8 = l4 - (object[n6] + lArray3[n7]);
                        int n8 = n3 + 3;
                        long l9 = l5 - (object[n8] + lArray3[n4 + 2]);
                        long l10 = l9;
                        long l11 = l8;
                        long l12 = l7;
                        long l13 = l6;
                        l6 = i3;
                        l7 = ThreefishEngine.xorRotr(l13 - (object[n3 + 4] + l6 + 1L), 32, l7);
                        l8 = l12 - l7;
                        l10 = ThreefishEngine.xorRotr(l11, 32, l10);
                        long l14 = l9 - l10;
                        long l15 = l7;
                        l7 = ThreefishEngine.xorRotr(l10, 58, l8);
                        l8 -= l7;
                        l10 = ThreefishEngine.xorRotr(l15, 22, l14);
                        l14 -= l10;
                        long l16 = l7;
                        l7 = ThreefishEngine.xorRotr(l10, 46, l8);
                        l8 -= l7;
                        l10 = ThreefishEngine.xorRotr(l16, 12, l14);
                        l14 -= l10;
                        long l17 = l7;
                        l7 = ThreefishEngine.xorRotr(l10, 25, l8);
                        l10 = ThreefishEngine.xorRotr(l17, 33, l14);
                        l4 = (l8 -= l7) - object[n3];
                        l3 = l7 - (object[n5] + lArray3[n4]);
                        long l18 = l14 - l10 - (object[n6] + lArray3[n7]);
                        l5 = l18;
                        long l19 = l3;
                        l3 = ThreefishEngine.xorRotr(l10 - (object[n8] + l6), 5, l4);
                        l4 -= l3;
                        l5 = ThreefishEngine.xorRotr(l19, 37, l5);
                        l6 = l18 - l5;
                        long l20 = l3;
                        l3 = ThreefishEngine.xorRotr(l5, 23, l4);
                        l4 -= l3;
                        l5 = ThreefishEngine.xorRotr(l20, 40, l6);
                        l6 -= l5;
                        long l21 = l3;
                        l3 = ThreefishEngine.xorRotr(l5, 52, l4);
                        l5 = ThreefishEngine.xorRotr(l21, 57, l6);
                        long l22 = l6 - l5;
                        l6 = l22;
                        long l23 = l3;
                        long l24 = l4 -= l3;
                        l4 = ThreefishEngine.xorRotr(l5, 14, l4);
                        l3 = l24 - l4;
                        l6 = ThreefishEngine.xorRotr(l23, 16, l6);
                        l5 = l22 - l6;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    long l25 = l3 - object[0];
                    long l26 = l4 - (object[1] + lArray3[0]);
                    l3 = l5 - (object[2] + lArray3[1]);
                    l4 = l6 - object[3];
                    lArray4[0] = l25;
                    lArray5[1] = l26;
                    lArray4[2] = l3;
                    lArray5[3] = l4;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static abstract class ThreefishCipher {
        public final long[] t;
        public final long[] kw;

        public ThreefishCipher(long[] lArray, long[] lArray2) {
            this.kw = lArray;
            this.t = lArray2;
        }

        public abstract void encryptBlock(long[] var1, long[] var2);

        public abstract void decryptBlock(long[] var1, long[] var2);
    }
}

