/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public final class TwofishEngine
implements BlockCipher {
    private static final byte[][] P;
    private static final int P_00 = 1;
    private static final int P_01 = 0;
    private static final int P_02 = 0;
    private static final int P_03 = 1;
    private static final int P_04 = 1;
    private static final int P_10 = 0;
    private static final int P_11 = 0;
    private static final int P_12 = 1;
    private static final int P_13 = 1;
    private static final int P_14 = 0;
    private static final int P_20 = 1;
    private static final int P_21 = 1;
    private static final int P_22 = 0;
    private static final int P_23 = 0;
    private static final int P_24 = 0;
    private static final int P_30 = 0;
    private static final int P_31 = 1;
    private static final int P_32 = 1;
    private static final int P_33 = 0;
    private static final int P_34 = 1;
    private static final int GF256_FDBK = 361;
    private static final int GF256_FDBK_2 = 180;
    private static final int GF256_FDBK_4 = 90;
    private static final int RS_GF_FDBK = 333;
    private static final int ROUNDS = 16;
    private static final int MAX_ROUNDS = 16;
    private static final int BLOCK_SIZE = 16;
    private static final int MAX_KEY_BITS = 256;
    private static final int INPUT_WHITEN = 0;
    private static final int OUTPUT_WHITEN = 4;
    private static final int ROUND_SUBKEYS = 8;
    private static final int TOTAL_SUBKEYS = 40;
    private static final int SK_STEP = 0x2020202;
    private static final int SK_BUMP = 0x1010101;
    private static final int SK_ROTL = 9;
    private boolean encrypting = false;
    private int[] gMDS0 = new int[256];
    private int[] gMDS1 = new int[256];
    private int[] gMDS2 = new int[256];
    private int[] gMDS3 = new int[256];
    private int[] gSubKeys;
    private int[] gSBox;
    private int k64Cnt = 0;
    private byte[] workingKey = null;

    public TwofishEngine() {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        for (int i3 = 0; i3 < 256; ++i3) {
            int n3;
            TwofishEngine twofishEngine = this;
            byte[][] byArray = P;
            nArray[0] = n3 = byArray[0][i3] & 0xFF;
            nArray2[0] = this.Mx_X(n3) & 0xFF;
            nArray3[0] = this.Mx_Y(n3) & 0xFF;
            nArray[1] = n3 = P[1][i3] & 0xFF;
            nArray2[1] = this.Mx_X(n3) & 0xFF;
            nArray3[1] = n3 = this.Mx_Y(n3) & 0xFF;
            twofishEngine.gMDS0[i3] = nArray[1] | nArray2[1] << 8 | n3 << 16 | n3 << 24;
            int n4 = nArray3[0];
            twofishEngine.gMDS1[i3] = n4 | n4 << 8 | nArray2[0] << 16 | nArray[0] << 24;
            n3 = nArray3[1];
            twofishEngine.gMDS2[i3] = nArray2[1] | n3 << 8 | nArray[1] << 16 | n3 << 24;
            n3 = nArray2[0];
            twofishEngine.gMDS3[i3] = n3 | nArray[0] << 8 | nArray3[0] << 16 | n3 << 24;
        }
    }

    private void setKey(byte[] byArray) {
        block9: {
            block10: {
                int n3;
                int n4;
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                int[] nArray3 = new int[4];
                this.gSubKeys = new int[40];
                int n5 = this.k64Cnt;
                if (n5 < 1) break block9;
                if (n5 > 4) break block10;
                for (n5 = 0; n5 < this.k64Cnt; ++n5) {
                    n4 = n5 * 8;
                    nArray[n5] = this.BytesTo32Bits(byArray, n4);
                    nArray2[n5] = n4 = this.BytesTo32Bits(byArray, n4 + 4);
                    int n6 = this.k64Cnt - 1 - n5;
                    nArray3[n6] = this.RS_MDS_Encode(nArray[n5], n4);
                }
                for (n3 = 0; n3 < 20; ++n3) {
                    TwofishEngine twofishEngine = this;
                    int n7 = n3 * 0x2020202;
                    n5 = n7;
                    n5 = this.F32(n5 + 0x1010101, nArray2);
                    n5 = n5 << 8 | n5 >>> 24;
                    n4 = twofishEngine.F32(n7, nArray) + n5;
                    int[] nArray4 = twofishEngine.gSubKeys;
                    int n8 = n5;
                    n5 = n3 * 2;
                    nArray4[n5] = n4;
                    twofishEngine.gSubKeys[++n5] = (n4 += n8) << 9 | n4 >>> 23;
                }
                n3 = nArray3[0];
                int n9 = nArray3[1];
                int n10 = nArray3[2];
                int n11 = nArray3[3];
                this.gSBox = new int[1024];
                block8: for (n5 = 0; n5 < 256; ++n5) {
                    int n12;
                    int n13;
                    int n14;
                    block11: {
                        switch (this.k64Cnt & 3) {
                            default: {
                                continue block8;
                            }
                            case 3: {
                                n14 = n5;
                                n13 = n5;
                                n12 = n5;
                                n4 = n5;
                                break;
                            }
                            case 2: {
                                n14 = n5;
                                n13 = n5;
                                n12 = n5;
                                n4 = n5;
                                break block11;
                            }
                            case 1: {
                                TwofishEngine twofishEngine = this;
                                n4 = n5 * 2;
                                byte[][] byArray2 = P;
                                twofishEngine.gSBox[n4] = this.gMDS0[P[0][n5] & 0xFF ^ this.b0(n3)];
                                twofishEngine.gSBox[n4 + 1] = this.gMDS1[byArray2[0][n5] & 0xFF ^ this.b1(n3)];
                                twofishEngine.gSBox[n4 + 512] = this.gMDS2[byArray2[1][n5] & 0xFF ^ this.b2(n3)];
                                twofishEngine.gSBox[n4 + 513] = this.gMDS3[byArray2[1][n5] & 0xFF ^ this.b3(n3)];
                                continue block8;
                            }
                            case 0: {
                                n4 = P[1][n5] & 0xFF ^ this.b0(n11);
                                n12 = P[0][n5] & 0xFF ^ this.b1(n11);
                                n13 = P[0][n5] & 0xFF ^ this.b2(n11);
                                n14 = P[1][n5] & 0xFF ^ this.b3(n11);
                            }
                        }
                        n4 = P[1][n4] & 0xFF ^ this.b0(n10);
                        n12 = P[1][n12] & 0xFF ^ this.b1(n10);
                        n13 = P[0][n13] & 0xFF ^ this.b2(n10);
                        n14 = P[0][n14] & 0xFF ^ this.b3(n10);
                    }
                    TwofishEngine twofishEngine = this;
                    int n15 = n5 * 2;
                    byte[][] byArray3 = P;
                    byte[] byArray4 = P[0];
                    twofishEngine.gSBox[n15] = this.gMDS0[byArray4[byArray4[n4] & 0xFF ^ this.b0(n9)] & 0xFF ^ this.b0(n3)];
                    twofishEngine.gSBox[n15 + 1] = this.gMDS1[byArray3[0][byArray3[1][n12] & 0xFF ^ this.b1(n9)] & 0xFF ^ this.b1(n3)];
                    twofishEngine.gSBox[n15 + 512] = this.gMDS2[byArray3[1][byArray3[0][n13] & 0xFF ^ this.b2(n9)] & 0xFF ^ this.b2(n3)];
                    byte[] byArray5 = byArray3[1];
                    twofishEngine.gSBox[n15 + 513] = this.gMDS3[byArray5[byArray5[n14] & 0xFF ^ this.b3(n9)] & 0xFF ^ this.b3(n3)];
                }
                return;
            }
            throw new IllegalArgumentException("Key size larger than 256 bits");
        }
        throw new IllegalArgumentException("Key size less than 64 bits");
    }

    private void encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = this.BytesTo32Bits(byArray, n3) ^ this.gSubKeys[0];
        n3 = this.BytesTo32Bits(byArray, n3 + 4) ^ this.gSubKeys[1];
        int n8 = this.BytesTo32Bits(byArray, n6 + 8) ^ this.gSubKeys[2];
        int n9 = this.BytesTo32Bits(byArray, n5 + 12) ^ this.gSubKeys[3];
        int n10 = 8;
        for (int i3 = 0; i3 < 16; i3 += 2) {
            int n11 = n7;
            int n12 = n8;
            n7 = this.Fe32_0(n7);
            n8 = this.Fe32_3(n3);
            int[] nArray = this.gSubKeys;
            int n13 = n12 ^ n7 + n8 + this.gSubKeys[n10++];
            n13 = n13 >>> 1 | n13 << 31;
            int n14 = n8 * 2 + n7;
            int n15 = n10;
            n7 = n15 + 1;
            n9 = (n9 << 1 | n9 >>> 31) ^ n14 + nArray[n15];
            n8 = this.Fe32_0(n13);
            n10 = this.Fe32_3(n9);
            nArray = this.gSubKeys;
            int n16 = n11 ^ n8 + n10 + this.gSubKeys[n7++];
            n16 = n16 >>> 1 | n16 << 31;
            int n17 = n10 * 2 + n8;
            int n18 = n7;
            n10 = n18 + 1;
            n3 = (n3 << 1 | n3 >>> 31) ^ n17 + nArray[n18];
            n7 = n16;
            n8 = n13;
        }
        TwofishEngine twofishEngine = this;
        TwofishEngine twofishEngine2 = this;
        TwofishEngine twofishEngine3 = this;
        twofishEngine3.Bits32ToBytes(n8 ^ this.gSubKeys[4], byArray2, n4);
        twofishEngine2.Bits32ToBytes(n9 ^ twofishEngine3.gSubKeys[5], byArray2, n4 + 4);
        twofishEngine.Bits32ToBytes(n7 ^ twofishEngine2.gSubKeys[6], byArray2, n4 + 8);
        this.Bits32ToBytes(n3 ^ twofishEngine.gSubKeys[7], byArray2, n4 + 12);
    }

    private void decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = this.BytesTo32Bits(byArray, n3) ^ this.gSubKeys[4];
        n3 = this.BytesTo32Bits(byArray, n3 + 4) ^ this.gSubKeys[5];
        int n8 = this.BytesTo32Bits(byArray, n6 + 8) ^ this.gSubKeys[6];
        int n9 = this.BytesTo32Bits(byArray, n5 + 12) ^ this.gSubKeys[7];
        int n10 = 39;
        for (int i3 = 0; i3 < 16; i3 += 2) {
            int n11 = n3;
            TwofishEngine twofishEngine = this;
            int n12 = n9;
            int n13 = n3;
            n3 = this.Fe32_0(n7);
            n9 = this.Fe32_3(n13);
            int[] nArray = this.gSubKeys;
            int n14 = n10;
            n10 = n14 + -1;
            int n15 = n12 ^ n9 * 2 + n3 + this.gSubKeys[n14];
            int n16 = n3 + n9;
            int n17 = n10;
            n3 = n17 + -1;
            n8 = (n8 << 1 | n8 >>> 31) ^ n16 + nArray[n17];
            n9 = n15 >>> 1 | n15 << 31;
            n10 = twofishEngine.Fe32_0(n8);
            int n18 = twofishEngine.Fe32_3(n9);
            int[] nArray2 = this.gSubKeys;
            int n19 = n3;
            n3 = n19 + -1;
            int n20 = n11 ^ n18 * 2 + n10 + this.gSubKeys[n19];
            int n21 = n10 + n18;
            int n22 = n3;
            n10 = n22 + -1;
            n7 = (n7 << 1 | n7 >>> 31) ^ n21 + nArray2[n22];
            n3 = n20 >>> 1 | n20 << 31;
        }
        TwofishEngine twofishEngine = this;
        TwofishEngine twofishEngine2 = this;
        TwofishEngine twofishEngine3 = this;
        twofishEngine3.Bits32ToBytes(n8 ^ this.gSubKeys[0], byArray2, n4);
        twofishEngine2.Bits32ToBytes(n9 ^ twofishEngine3.gSubKeys[1], byArray2, n4 + 4);
        twofishEngine.Bits32ToBytes(n7 ^ twofishEngine2.gSubKeys[2], byArray2, n4 + 8);
        this.Bits32ToBytes(n3 ^ twofishEngine.gSubKeys[3], byArray2, n4 + 12);
    }

    private int F32(int n3, int[] nArray) {
        int n4 = n3;
        int n5 = n3;
        int n6 = n3;
        n3 = this.b0(n3);
        int n7 = this.b1(n6);
        int n8 = this.b2(n5);
        int n9 = this.b3(n4);
        int n10 = nArray[0];
        int n11 = nArray[1];
        int n12 = nArray[2];
        int n13 = nArray[3];
        int n14 = 0;
        switch (this.k64Cnt & 3) {
            default: {
                break;
            }
            case 1: {
                byte[][] byArray = P;
                n14 = this.gMDS0[P[0][n3] & 0xFF ^ this.b0(n10)] ^ this.gMDS1[byArray[0][n7] & 0xFF ^ this.b1(n10)] ^ this.gMDS2[byArray[1][n8] & 0xFF ^ this.b2(n10)] ^ this.gMDS3[byArray[1][n9] & 0xFF ^ this.b3(n10)];
                break;
            }
            case 0: {
                n3 = P[1][n3] & 0xFF ^ this.b0(n13);
                n7 = P[0][n7] & 0xFF ^ this.b1(n13);
                n8 = P[0][n8] & 0xFF ^ this.b2(n13);
                n9 = P[1][n9] & 0xFF ^ this.b3(n13);
            }
            case 3: {
                n3 = P[1][n3] & 0xFF ^ this.b0(n12);
                n7 = P[1][n7] & 0xFF ^ this.b1(n12);
                n8 = P[0][n8] & 0xFF ^ this.b2(n12);
                n9 = P[0][n9] & 0xFF ^ this.b3(n12);
            }
            case 2: {
                byte[][] byArray = P;
                byte[] byArray2 = P[0];
                byte[] byArray3 = byArray[1];
                n14 = this.gMDS0[byArray2[byArray2[n3] & 0xFF ^ this.b0(n11)] & 0xFF ^ this.b0(n10)] ^ this.gMDS1[byArray[0][byArray[1][n7] & 0xFF ^ this.b1(n11)] & 0xFF ^ this.b1(n10)] ^ this.gMDS2[byArray[1][byArray[0][n8] & 0xFF ^ this.b2(n11)] & 0xFF ^ this.b2(n10)] ^ this.gMDS3[byArray3[byArray3[n9] & 0xFF ^ this.b3(n11)] & 0xFF ^ this.b3(n10)];
            }
        }
        return n14;
    }

    private int RS_MDS_Encode(int n3, int n4) {
        for (int i3 = 0; i3 < 4; ++i3) {
            n4 = this.RS_rem(n4);
        }
        n3 = n4 ^ n3;
        for (n4 = 0; n4 < 4; ++n4) {
            n3 = this.RS_rem(n3);
        }
        return n3;
    }

    private int RS_rem(int n3) {
        int n4 = n3 >>> 24 & 0xFF;
        int n5 = n4 << 1;
        int n6 = (n4 & 0x80) != 0 ? 333 : 0;
        int n7 = n4;
        n5 = (n5 ^ n6) & 0xFF;
        n6 = n7 >>> 1;
        int n8 = (n7 & 1) != 0 ? 166 : 0;
        int n9 = n3;
        n3 = n6 ^ n8 ^ n5;
        return n9 << 8 ^ n3 << 24 ^ n5 << 16 ^ n3 << 8 ^ n4;
    }

    private int LFSR1(int n3) {
        int n4 = n3;
        int n5 = n4 >> 1;
        n3 = (n4 & 1) != 0 ? 180 : 0;
        return n5 ^ n3;
    }

    private int LFSR2(int n3) {
        int n4 = n3;
        int n5 = n4 >> 2;
        int n6 = (n4 & 2) != 0 ? 180 : 0;
        n3 = (n3 & 1) != 0 ? 90 : 0;
        return (n5 ^= n6) ^ n3;
    }

    private int Mx_X(int n3) {
        return n3 ^ this.LFSR2(n3);
    }

    private int Mx_Y(int n3) {
        return n3 ^ this.LFSR1(n3) ^ this.LFSR2(n3);
    }

    private int b0(int n3) {
        return n3 & 0xFF;
    }

    private int b1(int n3) {
        return n3 >>> 8 & 0xFF;
    }

    private int b2(int n3) {
        return n3 >>> 16 & 0xFF;
    }

    private int b3(int n3) {
        return n3 >>> 24 & 0xFF;
    }

    private int Fe32_0(int n3) {
        Object object = ((TwofishEngine)object).gSBox;
        return ((TwofishEngine)object).gSBox[(n3 & 0xFF) * 2 + 0] ^ object[(n3 >>> 8 & 0xFF) * 2 + 1] ^ object[(n3 >>> 16 & 0xFF) * 2 + 512] ^ object[(n3 >>> 24 & 0xFF) * 2 + 513];
    }

    private int Fe32_3(int n3) {
        Object object = ((TwofishEngine)object).gSBox;
        return ((TwofishEngine)object).gSBox[(n3 >>> 24 & 0xFF) * 2 + 0] ^ object[(n3 & 0xFF) * 2 + 1] ^ object[(n3 >>> 8 & 0xFF) * 2 + 512] ^ object[(n3 >>> 16 & 0xFF) * 2 + 513];
    }

    private int BytesTo32Bits(byte[] byArray, int n3) {
        return byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 3] & 0xFF) << 24;
    }

    private void Bits32ToBytes(int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)n3;
        int n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >> 8);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >> 16);
        n5 = n4 + 3;
        byArray[n5] = (byte)(n3 >> 24);
    }

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[256];
        byte[] byArray2 = byArray;
        byArray[0] = -87;
        byArray[1] = 103;
        byArray[2] = -77;
        byArray[3] = -24;
        byArray[4] = 4;
        byArray[5] = -3;
        byArray[6] = -93;
        byArray[7] = 118;
        byArray[8] = -102;
        byArray[9] = -110;
        byArray[10] = -128;
        byArray[11] = 120;
        byArray[12] = -28;
        byArray[13] = -35;
        byArray[14] = -47;
        byArray[15] = 56;
        byArray[16] = 13;
        byArray[17] = -58;
        byArray[18] = 53;
        byArray[19] = -104;
        byArray[20] = 24;
        byArray[21] = -9;
        byArray[22] = -20;
        byArray[23] = 108;
        byArray[24] = 67;
        byArray[25] = 117;
        byArray[26] = 55;
        byArray[27] = 38;
        byArray[28] = -6;
        byArray[29] = 19;
        byArray[30] = -108;
        byArray[31] = 72;
        byArray[32] = -14;
        byArray[33] = -48;
        byArray[34] = -117;
        byArray[35] = 48;
        byArray[36] = -124;
        byArray[37] = 84;
        byArray[38] = -33;
        byArray[39] = 35;
        byArray[40] = 25;
        byArray[41] = 91;
        byArray[42] = 61;
        byArray[43] = 89;
        byArray[44] = -13;
        byArray[45] = -82;
        byArray[46] = -94;
        byArray[47] = -126;
        byArray[48] = 99;
        byArray[49] = 1;
        byArray[50] = -125;
        byArray[51] = 46;
        byArray[52] = -39;
        byArray[53] = 81;
        byArray[54] = -101;
        byArray[55] = 124;
        byArray[56] = -90;
        byArray[57] = -21;
        byArray[58] = -91;
        byArray[59] = -66;
        byArray[60] = 22;
        byArray[61] = 12;
        byArray[62] = -29;
        byArray[63] = 97;
        byArray[64] = -64;
        byArray[65] = -116;
        byArray[66] = 58;
        byArray[67] = -11;
        byArray[68] = 115;
        byArray[69] = 44;
        byArray[70] = 37;
        byArray[71] = 11;
        byArray[72] = -69;
        byArray[73] = 78;
        byArray[74] = -119;
        byArray[75] = 107;
        byArray[76] = 83;
        byArray[77] = 106;
        byArray[78] = -76;
        byArray[79] = -15;
        byArray[80] = -31;
        byArray[81] = -26;
        byArray[82] = -67;
        byArray[83] = 69;
        byArray[84] = -30;
        byArray[85] = -12;
        byArray[86] = -74;
        byArray[87] = 102;
        byArray[88] = -52;
        byArray[89] = -107;
        byArray[90] = 3;
        byArray[91] = 86;
        byArray[92] = -44;
        byArray[93] = 28;
        byArray[94] = 30;
        byArray[95] = -41;
        byArray[96] = -5;
        byArray[97] = -61;
        byArray[98] = -114;
        byArray[99] = -75;
        byArray[100] = -23;
        byArray[101] = -49;
        byArray[102] = -65;
        byArray[103] = -70;
        byArray[104] = -22;
        byArray[105] = 119;
        byArray[106] = 57;
        byArray[107] = -81;
        byArray[108] = 51;
        byArray[109] = -55;
        byArray[110] = 98;
        byArray[111] = 113;
        byArray[112] = -127;
        byArray[113] = 121;
        byArray[114] = 9;
        byArray[115] = -83;
        byArray[116] = 36;
        byArray[117] = -51;
        byArray[118] = -7;
        byArray[119] = -40;
        byArray[120] = -27;
        byArray[121] = -59;
        byArray[122] = -71;
        byArray[123] = 77;
        byArray[124] = 68;
        byArray[125] = 8;
        byArray[126] = -122;
        byArray[127] = -25;
        byArray[128] = -95;
        byArray[129] = 29;
        byArray[130] = -86;
        byArray[131] = -19;
        byArray[132] = 6;
        byArray[133] = 112;
        byArray[134] = -78;
        byArray[135] = -46;
        byArray[136] = 65;
        byArray[137] = 123;
        byArray[138] = -96;
        byArray[139] = 17;
        byArray[140] = 49;
        byArray[141] = -62;
        byArray[142] = 39;
        byArray[143] = -112;
        byArray[144] = 32;
        byArray[145] = -10;
        byArray[146] = 96;
        byArray[147] = -1;
        byArray[148] = -106;
        byArray[149] = 92;
        byArray[150] = -79;
        byArray[151] = -85;
        byArray[152] = -98;
        byArray[153] = -100;
        byArray[154] = 82;
        byArray[155] = 27;
        byArray[156] = 95;
        byArray[157] = -109;
        byArray[158] = 10;
        byArray[159] = -17;
        byArray[160] = -111;
        byArray[161] = -123;
        byArray[162] = 73;
        byArray[163] = -18;
        byArray[164] = 45;
        byArray[165] = 79;
        byArray[166] = -113;
        byArray[167] = 59;
        byArray[168] = 71;
        byArray[169] = -121;
        byArray[170] = 109;
        byArray[171] = 70;
        byArray[172] = -42;
        byArray[173] = 62;
        byArray[174] = 105;
        byArray[175] = 100;
        byArray[176] = 42;
        byArray[177] = -50;
        byArray[178] = -53;
        byArray[179] = 47;
        byArray[180] = -4;
        byArray[181] = -105;
        byArray[182] = 5;
        byArray[183] = 122;
        byArray[184] = -84;
        byArray[185] = 127;
        byArray[186] = -43;
        byArray[187] = 26;
        byArray[188] = 75;
        byArray[189] = 14;
        byArray[190] = -89;
        byArray[191] = 90;
        byArray[192] = 40;
        byArray[193] = 20;
        byArray[194] = 63;
        byArray[195] = 41;
        byArray[196] = -120;
        byArray[197] = 60;
        byArray[198] = 76;
        byArray[199] = 2;
        byArray[200] = -72;
        byArray[201] = -38;
        byArray[202] = -80;
        byArray[203] = 23;
        byArray[204] = 85;
        byArray[205] = 31;
        byArray[206] = -118;
        byArray[207] = 125;
        byArray[208] = 87;
        byArray[209] = -57;
        byArray[210] = -115;
        byArray[211] = 116;
        byArray[212] = -73;
        byArray[213] = -60;
        byArray[214] = -97;
        byArray[215] = 114;
        byArray[216] = 126;
        byArray[217] = 21;
        byArray[218] = 34;
        byArray[219] = 18;
        byArray[220] = 88;
        byArray[221] = 7;
        byArray[222] = -103;
        byArray[223] = 52;
        byArray[224] = 110;
        byArray[225] = 80;
        byArray[226] = -34;
        byArray[227] = 104;
        byArray[228] = 101;
        byArray[229] = -68;
        byArray[230] = -37;
        byArray[231] = -8;
        byArray[232] = -56;
        byArray[233] = -88;
        byArray[234] = 43;
        byArray[235] = 64;
        byArray[236] = -36;
        byArray[237] = -2;
        byArray[238] = 50;
        byArray[239] = -92;
        byArray[240] = -54;
        byArray[241] = 16;
        byArray[242] = 33;
        byArray[243] = -16;
        byArray[244] = -45;
        byArray[245] = 93;
        byArray[246] = 15;
        byArray[247] = 0;
        byArray[248] = 111;
        byArray[249] = -99;
        byArray[250] = 54;
        byArray[251] = 66;
        byArray[252] = 74;
        byArray[253] = 94;
        byArray[254] = -63;
        byArray[255] = -32;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[256];
        byArray2 = byArray3;
        byArray3[0] = 117;
        byArray3[1] = -13;
        byArray3[2] = -58;
        byArray3[3] = -12;
        byArray3[4] = -37;
        byArray3[5] = 123;
        byArray3[6] = -5;
        byArray3[7] = -56;
        byArray3[8] = 74;
        byArray3[9] = -45;
        byArray3[10] = -26;
        byArray3[11] = 107;
        byArray3[12] = 69;
        byArray3[13] = 125;
        byArray3[14] = -24;
        byArray3[15] = 75;
        byArray3[16] = -42;
        byArray3[17] = 50;
        byArray3[18] = -40;
        byArray3[19] = -3;
        byArray3[20] = 55;
        byArray3[21] = 113;
        byArray3[22] = -15;
        byArray3[23] = -31;
        byArray3[24] = 48;
        byArray3[25] = 15;
        byArray3[26] = -8;
        byArray3[27] = 27;
        byArray3[28] = -121;
        byArray3[29] = -6;
        byArray3[30] = 6;
        byArray3[31] = 63;
        byArray3[32] = 94;
        byArray3[33] = -70;
        byArray3[34] = -82;
        byArray3[35] = 91;
        byArray3[36] = -118;
        byArray3[37] = 0;
        byArray3[38] = -68;
        byArray3[39] = -99;
        byArray3[40] = 109;
        byArray3[41] = -63;
        byArray3[42] = -79;
        byArray3[43] = 14;
        byArray3[44] = -128;
        byArray3[45] = 93;
        byArray3[46] = -46;
        byArray3[47] = -43;
        byArray3[48] = -96;
        byArray3[49] = -124;
        byArray3[50] = 7;
        byArray3[51] = 20;
        byArray3[52] = -75;
        byArray3[53] = -112;
        byArray3[54] = 44;
        byArray3[55] = -93;
        byArray3[56] = -78;
        byArray3[57] = 115;
        byArray3[58] = 76;
        byArray3[59] = 84;
        byArray3[60] = -110;
        byArray3[61] = 116;
        byArray3[62] = 54;
        byArray3[63] = 81;
        byArray3[64] = 56;
        byArray3[65] = -80;
        byArray3[66] = -67;
        byArray3[67] = 90;
        byArray3[68] = -4;
        byArray3[69] = 96;
        byArray3[70] = 98;
        byArray3[71] = -106;
        byArray3[72] = 108;
        byArray3[73] = 66;
        byArray3[74] = -9;
        byArray3[75] = 16;
        byArray3[76] = 124;
        byArray3[77] = 40;
        byArray3[78] = 39;
        byArray3[79] = -116;
        byArray3[80] = 19;
        byArray3[81] = -107;
        byArray3[82] = -100;
        byArray3[83] = -57;
        byArray3[84] = 36;
        byArray3[85] = 70;
        byArray3[86] = 59;
        byArray3[87] = 112;
        byArray3[88] = -54;
        byArray3[89] = -29;
        byArray3[90] = -123;
        byArray3[91] = -53;
        byArray3[92] = 17;
        byArray3[93] = -48;
        byArray3[94] = -109;
        byArray3[95] = -72;
        byArray3[96] = -90;
        byArray3[97] = -125;
        byArray3[98] = 32;
        byArray3[99] = -1;
        byArray3[100] = -97;
        byArray3[101] = 119;
        byArray3[102] = -61;
        byArray3[103] = -52;
        byArray3[104] = 3;
        byArray3[105] = 111;
        byArray3[106] = 8;
        byArray3[107] = -65;
        byArray3[108] = 64;
        byArray3[109] = -25;
        byArray3[110] = 43;
        byArray3[111] = -30;
        byArray3[112] = 121;
        byArray3[113] = 12;
        byArray3[114] = -86;
        byArray3[115] = -126;
        byArray3[116] = 65;
        byArray3[117] = 58;
        byArray3[118] = -22;
        byArray3[119] = -71;
        byArray3[120] = -28;
        byArray3[121] = -102;
        byArray3[122] = -92;
        byArray3[123] = -105;
        byArray3[124] = 126;
        byArray3[125] = -38;
        byArray3[126] = 122;
        byArray3[127] = 23;
        byArray3[128] = 102;
        byArray3[129] = -108;
        byArray3[130] = -95;
        byArray3[131] = 29;
        byArray3[132] = 61;
        byArray3[133] = -16;
        byArray3[134] = -34;
        byArray3[135] = -77;
        byArray3[136] = 11;
        byArray3[137] = 114;
        byArray3[138] = -89;
        byArray3[139] = 28;
        byArray3[140] = -17;
        byArray3[141] = -47;
        byArray3[142] = 83;
        byArray3[143] = 62;
        byArray3[144] = -113;
        byArray3[145] = 51;
        byArray3[146] = 38;
        byArray3[147] = 95;
        byArray3[148] = -20;
        byArray3[149] = 118;
        byArray3[150] = 42;
        byArray3[151] = 73;
        byArray3[152] = -127;
        byArray3[153] = -120;
        byArray3[154] = -18;
        byArray3[155] = 33;
        byArray3[156] = -60;
        byArray3[157] = 26;
        byArray3[158] = -21;
        byArray3[159] = -39;
        byArray3[160] = -59;
        byArray3[161] = 57;
        byArray3[162] = -103;
        byArray3[163] = -51;
        byArray3[164] = -83;
        byArray3[165] = 49;
        byArray3[166] = -117;
        byArray3[167] = 1;
        byArray3[168] = 24;
        byArray3[169] = 35;
        byArray3[170] = -35;
        byArray3[171] = 31;
        byArray3[172] = 78;
        byArray3[173] = 45;
        byArray3[174] = -7;
        byArray3[175] = 72;
        byArray3[176] = 79;
        byArray3[177] = -14;
        byArray3[178] = 101;
        byArray3[179] = -114;
        byArray3[180] = 120;
        byArray3[181] = 92;
        byArray3[182] = 88;
        byArray3[183] = 25;
        byArray3[184] = -115;
        byArray3[185] = -27;
        byArray3[186] = -104;
        byArray3[187] = 87;
        byArray3[188] = 103;
        byArray3[189] = 127;
        byArray3[190] = 5;
        byArray3[191] = 100;
        byArray3[192] = -81;
        byArray3[193] = 99;
        byArray3[194] = -74;
        byArray3[195] = -2;
        byArray3[196] = -11;
        byArray3[197] = -73;
        byArray3[198] = 60;
        byArray3[199] = -91;
        byArray3[200] = -50;
        byArray3[201] = -23;
        byArray3[202] = 104;
        byArray3[203] = 68;
        byArray3[204] = -32;
        byArray3[205] = 77;
        byArray3[206] = 67;
        byArray3[207] = 105;
        byArray3[208] = 41;
        byArray3[209] = 46;
        byArray3[210] = -84;
        byArray3[211] = 21;
        byArray3[212] = 89;
        byArray3[213] = -88;
        byArray3[214] = 10;
        byArray3[215] = -98;
        byArray3[216] = 110;
        byArray3[217] = 71;
        byArray3[218] = -33;
        byArray3[219] = 52;
        byArray3[220] = 53;
        byArray3[221] = 106;
        byArray3[222] = -49;
        byArray3[223] = -36;
        byArray3[224] = 34;
        byArray3[225] = -55;
        byArray3[226] = -64;
        byArray3[227] = -101;
        byArray3[228] = -119;
        byArray3[229] = -44;
        byArray3[230] = -19;
        byArray3[231] = -85;
        byArray3[232] = 18;
        byArray3[233] = -94;
        byArray3[234] = 13;
        byArray3[235] = 82;
        byArray3[236] = -69;
        byArray3[237] = 2;
        byArray3[238] = 47;
        byArray3[239] = -87;
        byArray3[240] = -41;
        byArray3[241] = 97;
        byArray3[242] = 30;
        byArray3[243] = -76;
        byArray3[244] = 80;
        byArray3[245] = 4;
        byArray3[246] = -10;
        byArray3[247] = -62;
        byArray3[248] = 22;
        byArray3[249] = 37;
        byArray3[250] = -122;
        byArray3[251] = 86;
        byArray3[252] = 85;
        byArray3[253] = 9;
        byArray3[254] = -66;
        byArray3[255] = -111;
        byArrayArray[1] = byArray2;
        P = byArrayArray;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            TwofishEngine twofishEngine = object;
            ((TwofishEngine)object).encrypting = bl;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            Object object = byArray;
            twofishEngine.workingKey = byArray;
            twofishEngine.k64Cnt = ((Object)object).length / 8;
            twofishEngine.setKey((byte[])object);
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to Twofish init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "Twofish";
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this.workingKey != null) {
            if (n3 + 16 <= byArray.length) {
                if (n4 + 16 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n3, byArray2, n4);
                    } else {
                        this.decryptBlock(byArray, n3, byArray2, n4);
                    }
                    return 16;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Twofish not initialised");
    }

    @Override
    public void reset() {
        byte[] byArray = this.workingKey;
        if (this.workingKey != null) {
            this.setKey(byArray);
        }
    }

    @Override
    public int getBlockSize() {
        return 16;
    }
}

