/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class VMPCEngine
implements StreamCipher {
    public byte n = 0;
    public byte[] P = null;
    public byte s = 0;
    public byte[] workingIV;
    public byte[] workingKey;

    @Override
    public String getAlgorithmName() {
        return "VMPC";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            CipherParameters cipherParameters = (ParametersWithIV)object;
            if (((ParametersWithIV)cipherParameters).getParameters() instanceof KeyParameter) {
                ParametersWithIV parametersWithIV = cipherParameters;
                cipherParameters = (KeyParameter)parametersWithIV.getParameters();
                byte[] byArray = parametersWithIV.getIV();
                object = byArray;
                ((VMPCEngine)object2).workingIV = (byte[])object;
                if (byArray != null && ((Object)object).length >= 1 && ((Object)object).length <= 768) {
                    VMPCEngine vMPCEngine = object2;
                    byte[] byArray2 = ((KeyParameter)cipherParameters).getKey();
                    Object object2 = byArray2;
                    vMPCEngine.workingKey = byArray2;
                    vMPCEngine.initKey((byte[])object2, vMPCEngine.workingIV);
                    return;
                }
                throw new IllegalArgumentException("VMPC requires 1 to 768 bytes of IV");
            }
            throw new IllegalArgumentException("VMPC init parameters must include a key");
        }
        throw new IllegalArgumentException("VMPC init parameters must include an IV");
    }

    public void initKey(byte[] byArray, byte[] byArray2) {
        byte by;
        int n3;
        VMPCEngine vMPCEngine = this;
        vMPCEngine.s = 0;
        vMPCEngine.P = new byte[256];
        int n4 = 0;
        while (n4 < 256) {
            int n5 = n4++;
            this.P[n5] = (byte)n5;
        }
        for (n4 = 0; n4 < 768; ++n4) {
            byte by2;
            byte[] byArray3 = this.P;
            n3 = n4 & 0xFF;
            by = byArray3[n3];
            this.s = by2 = byArray3[this.s + by + byArray[n4 % byArray.length] & 0xFF];
            byArray3[n3] = byArray3[by2 & 0xFF];
            this.P[by2 & 0xFF] = by;
        }
        for (int i3 = 0; i3 < 768; ++i3) {
            byte[] byArray4 = this.P;
            int n6 = i3 & 0xFF;
            n3 = byArray4[n6];
            this.s = by = byArray4[this.s + n3 + byArray2[i3 % byArray2.length] & 0xFF];
            byArray4[n6] = byArray4[by & 0xFF];
            this.P[by & 0xFF] = n3;
        }
        this.n = 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (n3 + n4 <= byArray.length) {
            if (n5 + n4 <= byArray2.length) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    VMPCEngine vMPCEngine = this;
                    byte[] byArray3 = vMPCEngine.P;
                    int n6 = vMPCEngine.s;
                    int n7 = vMPCEngine.n;
                    int n8 = n7;
                    int n9 = byArray3[n6 + byArray3[n8 & 0xFF] & 0xFF];
                    int n10 = this.s = (n6 = n9);
                    byte by = byArray3[byArray3[byArray3[n6 & 0xFF] & 0xFF] + 1 & 0xFF];
                    n6 = byArray3[n8 & 0xFF];
                    byArray3[n8 &= 0xFF] = byArray3[n10 & 0xFF];
                    byArray3[n9 & 0xFF] = n6;
                    vMPCEngine.n = (byte)(n7 + 1 & 0xFF);
                    n6 = i3 + n5;
                    byArray2[n6] = (byte)(byArray[i3 + n3] ^ by);
                }
                return n4;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public void reset() {
        VMPCEngine vMPCEngine = object;
        Object object = vMPCEngine.workingKey;
        vMPCEngine.initKey((byte[])object, vMPCEngine.workingIV);
    }

    @Override
    public byte returnByte(byte by) {
        VMPCEngine vMPCEngine = this;
        byte[] byArray = vMPCEngine.P;
        int n3 = vMPCEngine.s;
        byte by2 = vMPCEngine.n;
        int n4 = byArray[n3 + byArray[by2 & 0xFF] & 0xFF];
        int n5 = this.s = (n3 = n4);
        byte by3 = byArray[byArray[byArray[n3 & 0xFF] & 0xFF] + 1 & 0xFF];
        byte by4 = byArray[by2 & 0xFF];
        n3 = by2 & 0xFF;
        byArray[n3] = byArray[n5 & 0xFF];
        byArray[n4 & 0xFF] = by4;
        vMPCEngine.n = (byte)(by2 + 1 & 0xFF);
        return (byte)(by ^ by3);
    }
}

