/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private int[] _S = new int[4];
    private int[] _sum0 = new int[32];
    private int[] _sum1 = new int[32];
    private boolean _initialised = false;
    private boolean _forEncryption;

    private void setKey(byte[] byArray) {
        if (byArray.length == 16) {
            int n3;
            int n4;
            int n5 = n4 = 0;
            while (n4 < 4) {
                this._S[n4] = this.bytesToInt(byArray, n5);
                ++n4;
                n5 += 4;
            }
            n4 = n3 = 0;
            while (n3 < 32) {
                int[] nArray = this._S;
                this._sum0[n3] = n4 + this._S[n4 & 3];
                this._sum1[n3] = (n4 -= 1640531527) + nArray[n4 >>> 11 & 3];
                ++n3;
            }
            return;
        }
        throw new IllegalArgumentException("Key size must be 128 bits.");
    }

    private int encryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        XTEAEngine xTEAEngine = this;
        int n5 = xTEAEngine.bytesToInt(byArray, n3);
        int n6 = xTEAEngine.bytesToInt(byArray, n3 + 4);
        for (n3 = 0; n3 < 32; ++n3) {
            n6 += ((n5 += (n6 << 4 ^ n6 >>> 5) + n6 ^ this._sum0[n3]) << 4 ^ n5 >>> 5) + n5 ^ this._sum1[n3];
        }
        XTEAEngine xTEAEngine2 = this;
        xTEAEngine2.unpackInt(n5, byArray2, n4);
        int n7 = n4 + 4;
        xTEAEngine2.unpackInt(n6, byArray2, n7);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        XTEAEngine xTEAEngine = this;
        int n5 = xTEAEngine.bytesToInt(byArray, n3);
        int n6 = xTEAEngine.bytesToInt(byArray, n3 + 4);
        for (n3 = 31; n3 >= 0; --n3) {
            n5 -= ((n6 -= (n5 << 4 ^ n5 >>> 5) + n5 ^ this._sum1[n3]) << 4 ^ n6 >>> 5) + n6 ^ this._sum0[n3];
        }
        XTEAEngine xTEAEngine2 = this;
        xTEAEngine2.unpackInt(n5, byArray2, n4);
        int n7 = n4 + 4;
        xTEAEngine2.unpackInt(n6, byArray2, n7);
        return 8;
    }

    private int bytesToInt(byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n4 + 1;
        return byArray[n4] << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5] & 0xFF;
    }

    private void unpackInt(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = n4 + 1;
        byArray[n4] = (byte)(n3 >>> 24);
        n3 = n8 + 1;
        byArray[n8] = (byte)(n7 >>> 16);
        n8 = n3 + 1;
        byArray[n3] = (byte)(n6 >>> 8);
        byArray[n8] = (byte)n5;
    }

    @Override
    public String getAlgorithmName() {
        return "XTEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            XTEAEngine xTEAEngine = this;
            xTEAEngine._forEncryption = bl;
            xTEAEngine._initialised = true;
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to TEA init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        if (this._initialised) {
            if (n3 + 8 <= byArray.length) {
                if (n4 + 8 <= byArray2.length) {
                    return this._forEncryption ? this.encryptBlock(byArray, n3, byArray2, n4) : this.decryptBlock(byArray, n3, byArray2, n4);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }
}

