/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public class Zuc128CoreEngine
implements StreamCipher,
Memoable {
    private static final byte[] S0 = new byte[]{62, 114, 91, 71, -54, -32, 0, 51, 4, -47, 84, -104, 9, -71, 109, -53, 123, 27, -7, 50, -81, -99, 106, -91, -72, 45, -4, 29, 8, 83, 3, -112, 77, 78, -124, -103, -28, -50, -39, -111, -35, -74, -123, 72, -117, 41, 110, -84, -51, -63, -8, 30, 115, 67, 105, -58, -75, -67, -3, 57, 99, 32, -44, 56, 118, 125, -78, -89, -49, -19, 87, -59, -13, 44, -69, 20, 33, 6, 85, -101, -29, -17, 94, 49, 79, 127, 90, -92, 13, -126, 81, 73, 95, -70, 88, 28, 74, 22, -43, 23, -88, -110, 36, 31, -116, -1, -40, -82, 46, 1, -45, -83, 59, 75, -38, 70, -21, -55, -34, -102, -113, -121, -41, 58, -128, 111, 47, -56, -79, -76, 55, -9, 10, 34, 19, 40, 124, -52, 60, -119, -57, -61, -106, 86, 7, -65, 126, -16, 11, 43, -105, 82, 53, 65, 121, 97, -90, 76, 16, -2, -68, 38, -107, -120, -118, -80, -93, -5, -64, 24, -108, -14, -31, -27, -23, 93, -48, -36, 17, 102, 100, 92, -20, 89, 66, 117, 18, -11, 116, -100, -86, 35, 14, -122, -85, -66, 42, 2, -25, 103, -26, 68, -94, 108, -62, -109, -97, -15, -10, -6, 54, -46, 80, 104, -98, 98, 113, 21, 61, -42, 64, -60, -30, 15, -114, -125, 119, 107, 37, 5, 63, 12, 48, -22, 112, -73, -95, -24, -87, 101, -115, 39, 26, -37, -127, -77, -96, -12, 69, 122, 25, -33, -18, 120, 52, 96};
    private static final byte[] S1 = new byte[]{85, -62, 99, 113, 59, -56, 71, -122, -97, 60, -38, 91, 41, -86, -3, 119, -116, -59, -108, 12, -90, 26, 19, 0, -29, -88, 22, 114, 64, -7, -8, 66, 68, 38, 104, -106, -127, -39, 69, 62, 16, 118, -58, -89, -117, 57, 67, -31, 58, -75, 86, 42, -64, 109, -77, 5, 34, 102, -65, -36, 11, -6, 98, 72, -35, 32, 17, 6, 54, -55, -63, -49, -10, 39, 82, -69, 105, -11, -44, -121, 127, -124, 76, -46, -100, 87, -92, -68, 79, -102, -33, -2, -42, -115, 122, -21, 43, 83, -40, 92, -95, 20, 23, -5, 35, -43, 125, 48, 103, 115, 8, 9, -18, -73, 112, 63, 97, -78, 25, -114, 78, -27, 75, -109, -113, 93, -37, -87, -83, -15, -82, 46, -53, 13, -4, -12, 45, 70, 110, 29, -105, -24, -47, -23, 77, 55, -91, 117, 94, -125, -98, -85, -126, -99, -71, 28, -32, -51, 73, -119, 1, -74, -67, 88, 36, -94, 95, 56, 120, -103, 21, -112, 80, -72, -107, -28, -48, -111, -57, -50, -19, 15, -76, 111, -96, -52, -16, 2, 74, 121, -61, -34, -93, -17, -22, 81, -26, 107, 24, -20, 27, 44, -128, -9, 116, -25, -1, 33, 90, 106, 84, 30, 65, 49, -110, 53, -60, 51, 7, 10, -70, 126, 14, 52, -120, -79, -104, 124, -13, 61, 96, 108, 123, -54, -45, 31, 50, 101, 4, 40, 100, -66, -123, -101, 47, 89, -118, -41, -80, 37, -84, -81, 18, 3, -30, -14};
    private static final short[] EK_d = new short[]{17623, 9916, 25195, 4958, 22409, 13794, 28981, 2479, 19832, 12051, 27588, 6897, 24102, 15437, 30874, 18348};
    private final int[] LFSR = new int[16];
    private final int[] F = new int[2];
    private final int[] BRC = new int[4];
    private int theIndex;
    private final byte[] keyStream = new byte[4];
    private int theIterations;
    private Zuc128CoreEngine theResetState;

    public Zuc128CoreEngine() {
    }

    public Zuc128CoreEngine(Zuc128CoreEngine zuc128CoreEngine) {
        this.reset(zuc128CoreEngine);
    }

    public static void encode32be(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        byArray[n4] = (byte)(n3 >> 24);
        n3 = n4 + 1;
        byArray[n3] = (byte)(n7 >> 16);
        n3 = n4 + 2;
        byArray[n3] = (byte)(n6 >> 8);
        n3 = n4 + 3;
        byArray[n3] = (byte)n5;
    }

    private int AddM(int n3, int n4) {
        int n5 = n3 + n4;
        return (n5 & Integer.MAX_VALUE) + (n5 >>> 31);
    }

    private static int MulByPow2(int n3, int n4) {
        return (n3 << n4 | n3 >>> 31 - n4) & Integer.MAX_VALUE;
    }

    private void LFSRWithInitialisationMode(int n3) {
        Zuc128CoreEngine zuc128CoreEngine = this;
        int n4 = zuc128CoreEngine.LFSR[0];
        int n5 = zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(n4, Zuc128CoreEngine.MulByPow2(n4, 8)), Zuc128CoreEngine.MulByPow2(this.LFSR[4], 20)), Zuc128CoreEngine.MulByPow2(this.LFSR[10], 21)), Zuc128CoreEngine.MulByPow2(this.LFSR[13], 17)), Zuc128CoreEngine.MulByPow2(this.LFSR[15], 15)), n3);
        int[] nArray = zuc128CoreEngine.LFSR;
        nArray[0] = nArray[1];
        nArray[1] = nArray[2];
        nArray[2] = nArray[3];
        nArray[3] = nArray[4];
        nArray[4] = nArray[5];
        nArray[5] = nArray[6];
        nArray[6] = nArray[7];
        nArray[7] = nArray[8];
        nArray[8] = nArray[9];
        nArray[9] = nArray[10];
        nArray[10] = nArray[11];
        nArray[11] = nArray[12];
        nArray[12] = nArray[13];
        nArray[13] = nArray[14];
        nArray[14] = nArray[15];
        zuc128CoreEngine.LFSR[15] = n5;
    }

    private void LFSRWithWorkMode() {
        Zuc128CoreEngine zuc128CoreEngine = this;
        int n3 = zuc128CoreEngine.LFSR[0];
        int n4 = zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(zuc128CoreEngine.AddM(n3, Zuc128CoreEngine.MulByPow2(n3, 8)), Zuc128CoreEngine.MulByPow2(this.LFSR[4], 20)), Zuc128CoreEngine.MulByPow2(this.LFSR[10], 21)), Zuc128CoreEngine.MulByPow2(this.LFSR[13], 17)), Zuc128CoreEngine.MulByPow2(this.LFSR[15], 15));
        int[] nArray = zuc128CoreEngine.LFSR;
        nArray[0] = nArray[1];
        nArray[1] = nArray[2];
        nArray[2] = nArray[3];
        nArray[3] = nArray[4];
        nArray[4] = nArray[5];
        nArray[5] = nArray[6];
        nArray[6] = nArray[7];
        nArray[7] = nArray[8];
        nArray[8] = nArray[9];
        nArray[9] = nArray[10];
        nArray[10] = nArray[11];
        nArray[11] = nArray[12];
        nArray[12] = nArray[13];
        nArray[13] = nArray[14];
        nArray[14] = nArray[15];
        zuc128CoreEngine.LFSR[15] = n4;
    }

    private void BitReorganization() {
        int[] nArray = ((Zuc128CoreEngine)object).BRC;
        Object object = ((Zuc128CoreEngine)object).LFSR;
        nArray[0] = (object[15] & 0x7FFF8000) << 1 | object[14] & 0xFFFF;
        nArray[1] = (object[11] & 0xFFFF) << 16 | object[9] >>> 15;
        nArray[2] = (object[7] & 0xFFFF) << 16 | object[5] >>> 15;
        ((Zuc128CoreEngine)object).BRC[3] = (((Zuc128CoreEngine)object).LFSR[2] & 0xFFFF) << 16 | object[0] >>> 15;
    }

    public static int ROT(int n3, int n4) {
        return n3 << n4 | n3 >>> 32 - n4;
    }

    private static int L1(int n3) {
        int n4 = n3;
        return n4 ^ Zuc128CoreEngine.ROT(n4, 2) ^ Zuc128CoreEngine.ROT(n3, 10) ^ Zuc128CoreEngine.ROT(n3, 18) ^ Zuc128CoreEngine.ROT(n3, 24);
    }

    private static int L2(int n3) {
        int n4 = n3;
        return n4 ^ Zuc128CoreEngine.ROT(n4, 8) ^ Zuc128CoreEngine.ROT(n3, 14) ^ Zuc128CoreEngine.ROT(n3, 22) ^ Zuc128CoreEngine.ROT(n3, 30);
    }

    private static int MAKEU32(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    private static int MAKEU31(byte by, short s2, byte by2) {
        return (by & 0xFF) << 23 | (s2 & 0xFFFF) << 8 | by2 & 0xFF;
    }

    private void setKeyAndIV(byte[] byArray, byte[] byArray2) {
        Zuc128CoreEngine zuc128CoreEngine = this;
        zuc128CoreEngine.setKeyAndIV(zuc128CoreEngine.LFSR, byArray, byArray2);
        zuc128CoreEngine.F[0] = 0;
        zuc128CoreEngine.F[1] = 0;
        for (int i3 = 32; i3 > 0; --i3) {
            Zuc128CoreEngine zuc128CoreEngine2 = this;
            zuc128CoreEngine2.BitReorganization();
            zuc128CoreEngine2.LFSRWithInitialisationMode(zuc128CoreEngine2.F() >>> 1);
        }
        Zuc128CoreEngine zuc128CoreEngine3 = this;
        zuc128CoreEngine3.BitReorganization();
        zuc128CoreEngine3.F();
        zuc128CoreEngine3.LFSRWithWorkMode();
    }

    private void makeKeyStream() {
        Zuc128CoreEngine.encode32be(this.makeKeyStreamWord(), this.keyStream, 0);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray2 = parametersWithIV.getIV();
            cipherParameters = parametersWithIV.getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            byArray = ((KeyParameter)cipherParameters).getKey();
        }
        Zuc128CoreEngine zuc128CoreEngine = this;
        Zuc128CoreEngine zuc128CoreEngine2 = this;
        zuc128CoreEngine2.theIndex = 0;
        zuc128CoreEngine2.theIterations = 0;
        zuc128CoreEngine.setKeyAndIV(byArray, byArray2);
        zuc128CoreEngine.theResetState = (Zuc128CoreEngine)zuc128CoreEngine.copy();
    }

    public int getMaxIterations() {
        return 2047;
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc-128";
    }

    @Override
    public int processBytes(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        if (this.theResetState != null) {
            if (n3 + n4 <= byArray.length) {
                if (n5 + n4 <= byArray2.length) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n6 = i3 + n5;
                        byArray2[n6] = this.returnByte(byArray[i3 + n3]);
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        Zuc128CoreEngine zuc128CoreEngine = this.theResetState;
        if (zuc128CoreEngine != null) {
            this.reset(zuc128CoreEngine);
        }
    }

    @Override
    public byte returnByte(byte by) {
        if (this.theIndex == 0) {
            this.makeKeyStream();
        }
        int n3 = this.theIndex;
        this.theIndex = (n3 + 1) % 4;
        return (byte)(this.keyStream[n3] ^ by);
    }

    public int F() {
        int[] nArray = this.BRC;
        int[] byArray = this.F;
        int n3 = this.F[0];
        int by11 = byArray[1];
        Zuc128CoreEngine zuc128CoreEngine = this;
        byte by = n3 + nArray[1];
        int n4 = by11 ^ nArray[2];
        int by2 = Zuc128CoreEngine.L1(by << 16 | n4 >>> 16);
        by = Zuc128CoreEngine.L2(n4 << 16 | by >>> 16);
        byte[] byArray2 = S0;
        byte[] byArray3 = S1;
        byte by3 = byArray3[by2 >>> 16 & 0xFF];
        byte by4 = byArray2[by2 >>> 8 & 0xFF];
        byte by5 = S1[by2 & 0xFF];
        zuc128CoreEngine.F[0] = Zuc128CoreEngine.MAKEU32(S0[by2 >>> 24], by3, by4, by5);
        byte by6 = byArray2[by >>> 24];
        byte by7 = by;
        byte by8 = by;
        by = byArray3[by >>> 16 & 0xFF];
        byte by9 = byArray2[by8 >>> 8 & 0xFF];
        byte by10 = byArray3[by7 & 0xFF];
        zuc128CoreEngine.F[1] = Zuc128CoreEngine.MAKEU32(by6, by, by9, by10);
        return (this.BRC[0] ^ n3) + by11;
    }

    public void setKeyAndIV(int[] nArray, byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray.length == 16) {
            if (byArray2 != null && byArray2.length == 16) {
                Zuc128CoreEngine zuc128CoreEngine = object;
                Object object = EK_d;
                Object object2 = EK_d[0];
                zuc128CoreEngine.LFSR[0] = Zuc128CoreEngine.MAKEU31(byArray[0], object2, byArray2[0]);
                object2 = object[1];
                zuc128CoreEngine.LFSR[1] = Zuc128CoreEngine.MAKEU31(byArray[1], object2, byArray2[1]);
                object2 = object[2];
                zuc128CoreEngine.LFSR[2] = Zuc128CoreEngine.MAKEU31(byArray[2], object2, byArray2[2]);
                object2 = object[3];
                zuc128CoreEngine.LFSR[3] = Zuc128CoreEngine.MAKEU31(byArray[3], object2, byArray2[3]);
                object2 = object[4];
                zuc128CoreEngine.LFSR[4] = Zuc128CoreEngine.MAKEU31(byArray[4], object2, byArray2[4]);
                object2 = object[5];
                zuc128CoreEngine.LFSR[5] = Zuc128CoreEngine.MAKEU31(byArray[5], object2, byArray2[5]);
                object2 = object[6];
                zuc128CoreEngine.LFSR[6] = Zuc128CoreEngine.MAKEU31(byArray[6], object2, byArray2[6]);
                object2 = object[7];
                zuc128CoreEngine.LFSR[7] = Zuc128CoreEngine.MAKEU31(byArray[7], object2, byArray2[7]);
                object2 = object[8];
                zuc128CoreEngine.LFSR[8] = Zuc128CoreEngine.MAKEU31(byArray[8], object2, byArray2[8]);
                object2 = object[9];
                zuc128CoreEngine.LFSR[9] = Zuc128CoreEngine.MAKEU31(byArray[9], object2, byArray2[9]);
                object2 = object[10];
                zuc128CoreEngine.LFSR[10] = Zuc128CoreEngine.MAKEU31(byArray[10], object2, byArray2[10]);
                object2 = object[11];
                zuc128CoreEngine.LFSR[11] = Zuc128CoreEngine.MAKEU31(byArray[11], object2, byArray2[11]);
                object2 = object[12];
                zuc128CoreEngine.LFSR[12] = Zuc128CoreEngine.MAKEU31(byArray[12], object2, byArray2[12]);
                object2 = object[13];
                zuc128CoreEngine.LFSR[13] = Zuc128CoreEngine.MAKEU31(byArray[13], object2, byArray2[13]);
                object2 = object[14];
                zuc128CoreEngine.LFSR[14] = Zuc128CoreEngine.MAKEU31(byArray[14], object2, byArray2[14]);
                Object object3 = object[15];
                zuc128CoreEngine.LFSR[15] = Zuc128CoreEngine.MAKEU31(byArray[15], (short)object3, byArray2[15]);
                return;
            }
            throw new IllegalArgumentException("An IV of 16 bytes is needed");
        }
        throw new IllegalArgumentException("A key of 16 bytes is needed");
    }

    public int makeKeyStreamWord() {
        int n3 = this.theIterations;
        this.theIterations = n3 + 1;
        if (n3 < this.getMaxIterations()) {
            Zuc128CoreEngine zuc128CoreEngine = this;
            zuc128CoreEngine.BitReorganization();
            int n4 = zuc128CoreEngine.F() ^ this.BRC[3];
            this.LFSRWithWorkMode();
            return n4;
        }
        throw new IllegalStateException("Too much data processed by singleKey/IV");
    }

    @Override
    public Memoable copy() {
        return new Zuc128CoreEngine(this);
    }

    @Override
    public void reset(Memoable memoable) {
        Zuc128CoreEngine zuc128CoreEngine = object;
        memoable = (Zuc128CoreEngine)memoable;
        int[] nArray = ((Zuc128CoreEngine)object).LFSR;
        int n3 = ((Zuc128CoreEngine)object).LFSR.length;
        System.arraycopy(((Zuc128CoreEngine)memoable).LFSR, 0, nArray, 0, n3);
        nArray = ((Zuc128CoreEngine)object).F;
        n3 = ((Zuc128CoreEngine)object).F.length;
        System.arraycopy(((Zuc128CoreEngine)memoable).F, 0, nArray, 0, n3);
        nArray = ((Zuc128CoreEngine)object).BRC;
        n3 = ((Zuc128CoreEngine)object).BRC.length;
        System.arraycopy(((Zuc128CoreEngine)memoable).BRC, 0, nArray, 0, n3);
        Object object = ((Zuc128CoreEngine)object).keyStream;
        int n4 = ((Zuc128CoreEngine)object).keyStream.length;
        System.arraycopy(((Zuc128CoreEngine)memoable).keyStream, 0, object, 0, n4);
        zuc128CoreEngine.theIndex = ((Zuc128CoreEngine)memoable).theIndex;
        zuc128CoreEngine.theIterations = ((Zuc128CoreEngine)memoable).theIterations;
        zuc128CoreEngine.theResetState = memoable;
    }
}

