/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc128CoreEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public class Zuc256CoreEngine
extends Zuc128CoreEngine {
    private static final byte[] EK_d = new byte[]{34, 47, 36, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private static final byte[] EK_d32 = new byte[]{34, 47, 37, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private static final byte[] EK_d64 = new byte[]{35, 47, 36, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private static final byte[] EK_d128 = new byte[]{35, 47, 37, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private byte[] theD;

    public Zuc256CoreEngine() {
        this.theD = EK_d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Zuc256CoreEngine(int n3) {
        if (n3 != 32) {
            if (n3 != 64) {
                if (n3 != 128) throw new IllegalArgumentException(a.a("Unsupported length: ", n3));
                this.theD = EK_d128;
                return;
            } else {
                this.theD = EK_d64;
            }
            return;
        } else {
            this.theD = EK_d32;
        }
    }

    public Zuc256CoreEngine(Zuc256CoreEngine zuc256CoreEngine) {
        super(zuc256CoreEngine);
    }

    private static int MAKEU31(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 23 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    @Override
    public int getMaxIterations() {
        return 625;
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc-256";
    }

    @Override
    public void setKeyAndIV(int[] nArray, byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray.length == 32) {
            if (byArray2 != null && byArray2.length == 25) {
                byte by = this.theD[0];
                byte by2 = byArray[21];
                byte by3 = byArray[16];
                nArray[0] = Zuc256CoreEngine.MAKEU31(byArray[0], by, by2, by3);
                by = this.theD[1];
                by2 = byArray[22];
                by3 = byArray[17];
                nArray[1] = Zuc256CoreEngine.MAKEU31(byArray[1], by, by2, by3);
                by = this.theD[2];
                by2 = byArray[23];
                by3 = byArray[18];
                nArray[2] = Zuc256CoreEngine.MAKEU31(byArray[2], by, by2, by3);
                by = this.theD[3];
                by2 = byArray[24];
                by3 = byArray[19];
                nArray[3] = Zuc256CoreEngine.MAKEU31(byArray[3], by, by2, by3);
                by = this.theD[4];
                by2 = byArray[25];
                by3 = byArray[20];
                nArray[4] = Zuc256CoreEngine.MAKEU31(byArray[4], by, by2, by3);
                by = (byte)(this.theD[5] | byArray2[17] & 0x3F);
                by2 = byArray[5];
                by3 = byArray[26];
                nArray[5] = Zuc256CoreEngine.MAKEU31(byArray2[0], by, by2, by3);
                by = (byte)(this.theD[6] | byArray2[18] & 0x3F);
                by2 = byArray[6];
                by3 = byArray[27];
                nArray[6] = Zuc256CoreEngine.MAKEU31(byArray2[1], by, by2, by3);
                by = (byte)(this.theD[7] | byArray2[19] & 0x3F);
                by2 = byArray[7];
                by3 = byArray2[2];
                nArray[7] = Zuc256CoreEngine.MAKEU31(byArray2[10], by, by2, by3);
                by = (byte)(this.theD[8] | byArray2[20] & 0x3F);
                by2 = byArray2[3];
                by3 = byArray2[11];
                nArray[8] = Zuc256CoreEngine.MAKEU31(byArray[8], by, by2, by3);
                by = (byte)(this.theD[9] | byArray2[21] & 0x3F);
                by2 = byArray2[12];
                by3 = byArray2[4];
                nArray[9] = Zuc256CoreEngine.MAKEU31(byArray[9], by, by2, by3);
                by = (byte)(this.theD[10] | byArray2[22] & 0x3F);
                by2 = byArray[10];
                by3 = byArray[28];
                nArray[10] = Zuc256CoreEngine.MAKEU31(byArray2[5], by, by2, by3);
                by = (byte)(this.theD[11] | byArray2[23] & 0x3F);
                by2 = byArray2[6];
                by3 = byArray2[13];
                nArray[11] = Zuc256CoreEngine.MAKEU31(byArray[11], by, by2, by3);
                by = (byte)(this.theD[12] | byArray2[24] & 0x3F);
                by2 = byArray2[7];
                by3 = byArray2[14];
                nArray[12] = Zuc256CoreEngine.MAKEU31(byArray[12], by, by2, by3);
                by = this.theD[13];
                by2 = byArray2[15];
                by3 = byArray2[8];
                nArray[13] = Zuc256CoreEngine.MAKEU31(byArray[13], by, by2, by3);
                by = (byte)(this.theD[14] | byArray[31] >>> 4 & 0xF);
                byte by4 = byArray2[16];
                by2 = byArray2[9];
                nArray[14] = Zuc256CoreEngine.MAKEU31(byArray[14], by, by4, by2);
                byte by5 = (byte)(this.theD[15] | byArray[31] & 0xF);
                by = byArray[30];
                byte by6 = byArray[29];
                nArray[15] = Zuc256CoreEngine.MAKEU31(byArray[15], by5, by, by6);
                return;
            }
            throw new IllegalArgumentException("An IV of 25 bytes is needed");
        }
        throw new IllegalArgumentException("A key of 32 bytes is needed");
    }

    @Override
    public Memoable copy() {
        return new Zuc256CoreEngine(this);
    }

    @Override
    public void reset(Memoable memoable) {
        Zuc256CoreEngine zuc256CoreEngine = zuc256CoreEngine2;
        Memoable memoable2 = memoable;
        Zuc256CoreEngine zuc256CoreEngine2 = (Zuc256CoreEngine)memoable2;
        super.reset(memoable2);
        zuc256CoreEngine.theD = zuc256CoreEngine2.theD;
    }
}

