/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.Blake2bDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Argon2Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Longs;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Argon2BytesGenerator {
    private static final int ARGON2_BLOCK_SIZE = 1024;
    private static final int ARGON2_QWORDS_IN_BLOCK = 128;
    private static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    private static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
    private static final int ARGON2_PREHASH_SEED_LENGTH = 72;
    private static final int ARGON2_SYNC_POINTS = 4;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = 0x1000000;
    private static final int MIN_OUTLEN = 4;
    private static final int MIN_ITERATIONS = 1;
    private static final long M32L = 0xFFFFFFFFL;
    private static final byte[] ZERO_BYTES = new byte[4];
    private Argon2Parameters parameters;
    private Block[] memory;
    private int segmentLength;
    private int laneLength;

    private void reset() {
        if (this.memory != null) {
            int n3 = 0;
            while (true) {
                Object object = this.memory;
                if (n3 >= this.memory.length) break;
                if ((object = object[n3]) != null) {
                    ((Block)object).clear();
                }
                ++n3;
            }
        }
    }

    private void doInit(Argon2Parameters argon2Parameters) {
        int n3;
        int n4 = argon2Parameters.getMemory();
        if (n4 < argon2Parameters.getLanes() * 8) {
            n4 = argon2Parameters.getLanes() * 8;
        }
        this.segmentLength = n3 = n4 / (argon2Parameters.getLanes() * 4);
        this.laneLength = n3 * 4;
        this.initMemory(argon2Parameters.getLanes() * 4 * n3);
    }

    private void initMemory(int n3) {
        this.memory = new Block[n3];
        n3 = 0;
        while (true) {
            Block block;
            Object object = this.memory;
            if (n3 >= this.memory.length) break;
            Block[] blockArray = object;
            object = block;
            block = new Block(null);
            blockArray[n3] = object;
            ++n3;
        }
    }

    private void fillMemoryBlocks() {
        Position position;
        FillBlock fillBlock;
        FillBlock fillBlock2 = fillBlock;
        fillBlock = new FillBlock(null);
        Position position2 = position;
        position = new Position();
        for (int i3 = 0; i3 < this.parameters.getIterations(); ++i3) {
            position2.pass = i3;
            for (int i4 = 0; i4 < 4; ++i4) {
                position2.slice = i4;
                int n3 = 0;
                while (n3 < this.parameters.getLanes()) {
                    position2.lane = n3++;
                    this.fillSegment(fillBlock2, position2);
                }
            }
        }
    }

    private void fillSegment(FillBlock fillBlock, Position position) {
        Block block = null;
        Block block2 = null;
        boolean bl = this.isDataIndependentAddressing(position);
        Position position2 = position;
        int n3 = Argon2BytesGenerator.getStartingIndex(position2);
        int n4 = position2.lane * this.laneLength;
        n4 = position2.slice * this.segmentLength + n4 + n3;
        int n5 = this.getPrevOffset(n4);
        if (bl) {
            FillBlock fillBlock2 = fillBlock;
            block = fillBlock2.addressBlock.clear();
            block2 = fillBlock2.inputBlock.clear();
            this.initAddressBlocks(fillBlock2, position, block2, block);
        }
        boolean bl2 = this.isWithXor(position);
        while (n3 < this.segmentLength) {
            long l3 = this.getPseudoRandom(fillBlock, n3, block, block2, n5, bl);
            int n6 = this.getRefLane(position, l3);
            boolean bl3 = n6 == position.lane;
            Argon2BytesGenerator argon2BytesGenerator = this;
            int n7 = argon2BytesGenerator.getRefColumn(position, n3, l3, bl3);
            Object object = argon2BytesGenerator.memory;
            Block block3 = object[n5];
            Block block4 = object[this.laneLength * n6 + n7];
            object = argon2BytesGenerator.memory[n4];
            if (bl2) {
                fillBlock.fillBlockWithXor(block3, block4, (Block)object);
            } else {
                fillBlock.fillBlock(block3, block4, (Block)object);
            }
            n5 = n4 + 1;
            ++n3;
            int n8 = n4;
            n4 = n5;
            n5 = n8;
        }
    }

    private boolean isDataIndependentAddressing(Position position) {
        return this.parameters.getType() == 1 || this.parameters.getType() == 2 && position.pass == 0 && position.slice < 2;
    }

    private void initAddressBlocks(FillBlock fillBlock, Position position, Block block, Block block2) {
        long l3;
        Block block3 = block;
        ((Block)block3).v[0] = l3 = this.intToLong(position.pass);
        ((Block)block3).v[1] = l3 = this.intToLong(position.lane);
        ((Block)block3).v[2] = l3 = this.intToLong(position.slice);
        Argon2BytesGenerator argon2BytesGenerator = this;
        ((Block)block3).v[3] = l3 = argon2BytesGenerator.intToLong(argon2BytesGenerator.memory.length);
        Argon2BytesGenerator argon2BytesGenerator2 = this;
        ((Block)block3).v[4] = l3 = argon2BytesGenerator2.intToLong(argon2BytesGenerator2.parameters.getIterations());
        Argon2BytesGenerator argon2BytesGenerator3 = this;
        ((Block)block3).v[5] = l3 = argon2BytesGenerator3.intToLong(argon2BytesGenerator3.parameters.getType());
        if (position.pass == 0 && position.slice == 0) {
            this.nextAddresses(fillBlock, block, block2);
        }
    }

    private boolean isWithXor(Position position) {
        return position.pass != 0 && this.parameters.getVersion() != 16;
    }

    private int getPrevOffset(int n3) {
        int n4 = this.laneLength;
        if (n3 % n4 == 0) {
            return n3 + n4 - 1;
        }
        return n3 - 1;
    }

    private static int getStartingIndex(Position position) {
        if (position.pass == 0 && position.slice == 0) {
            return 2;
        }
        return 0;
    }

    private void nextAddresses(FillBlock fillBlock, Block block, Block block2) {
        long l3;
        Block block3 = block;
        long[] lArray = block3.v;
        lArray[6] = l3 = lArray[6] + 1L;
        fillBlock.fillBlock(block3, block2);
        fillBlock.fillBlock(block2, block2);
    }

    private long getPseudoRandom(FillBlock fillBlock, int n3, Block block, Block block2, int n4, boolean bl) {
        if (bl) {
            if ((n3 %= 128) == 0) {
                this.nextAddresses(fillBlock, block2, block);
            }
            return block.v[n3];
        }
        return this.memory[n4].v[0];
    }

    private int getRefLane(Position position, long l3) {
        int n3 = (int)((l3 >>> 32) % (long)this.parameters.getLanes());
        if (position.pass == 0 && position.slice == 0) {
            n3 = position.lane;
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    private int getRefColumn(Position position, int n3, long l3, boolean bl) {
        void var5_12;
        int n4;
        if (position.pass == 0) {
            boolean bl2 = false;
            if (bl) {
                n4 = position.slice * this.segmentLength + n3 - 1;
            } else {
                n4 = position.slice * this.segmentLength;
                n3 = n3 == 0 ? -1 : 0;
                n4 += n3;
            }
        } else {
            n4 = this.segmentLength;
            int n5 = this.laneLength;
            int n6 = (position.slice + 1) * n4 % n5;
            if (bl) {
                n4 = n5 - n4 + n3 - 1;
                int n7 = n6;
            } else {
                n4 = n5 - n4;
                n3 = n3 == 0 ? -1 : 0;
                n4 += n3;
                int n8 = n6;
            }
        }
        long l4 = l3 & 0xFFFFFFFFL;
        long l5 = l4 * l4 >>> 32;
        long l6 = (long)(n4 - 1) - ((long)n4 * l5 >>> 32);
        return (int)((long)var5_12 + l6) % this.laneLength;
    }

    private void digest(byte[] byArray, byte[] byArray2, int n3, int n4) {
        Block block = this.memory[this.laneLength - 1];
        for (int i3 = 1; i3 < this.parameters.getLanes(); ++i3) {
            Argon2BytesGenerator argon2BytesGenerator = this;
            int n5 = argon2BytesGenerator.laneLength;
            int n6 = i3 * n5;
            n6 = n5 - 1 + n6;
            block.xorWith(argon2BytesGenerator.memory[n6]);
        }
        block.toBytes(byArray);
        this.hash(byArray, byArray2, n3, n4);
    }

    private void hash(byte[] byArray, byte[] byArray2, int n3, int n4) {
        int n5 = n4;
        int n6 = 4;
        byte[] byArray3 = new byte[4];
        Pack.intToLittleEndian(n5, byArray3, 0);
        int n7 = 64;
        if (n5 <= 64) {
            Blake2bDigest blake2bDigest;
            Blake2bDigest blake2bDigest2 = blake2bDigest;
            blake2bDigest2(n4 * 8);
            blake2bDigest2.update(byArray3, 0, n6);
            blake2bDigest2.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray2, n3);
        } else {
            Blake2bDigest blake2bDigest;
            Blake2bDigest blake2bDigest3;
            Blake2bDigest blake2bDigest4 = blake2bDigest3;
            blake2bDigest3 = new Blake2bDigest(512);
            byte[] byArray4 = new byte[n7];
            blake2bDigest4.update(byArray3, 0, n6);
            blake2bDigest4.update(byArray, 0, byArray.length);
            blake2bDigest4.doFinal(byArray4, 0);
            n6 = 32;
            System.arraycopy(byArray4, 0, byArray2, n3, n6);
            int n8 = n3 + n6;
            n3 = (n4 + 31) / 32 - 2;
            int n9 = 2;
            while (n9 <= n3) {
                Blake2bDigest blake2bDigest5 = blake2bDigest4;
                blake2bDigest5.update(byArray4, 0, n7);
                blake2bDigest5.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, n8, n6);
                ++n9;
                n8 += n6;
            }
            n6 = n4 - n3 * 32;
            Blake2bDigest blake2bDigest6 = blake2bDigest;
            blake2bDigest6(n6 * 8);
            blake2bDigest6.update(byArray4, 0, n7);
            blake2bDigest.doFinal(byArray2, n8);
        }
    }

    private static void roundFunction(Block block, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        long[] lArray = block.v;
        Argon2BytesGenerator.F(lArray, n3, n7, n11, n15);
        Argon2BytesGenerator.F(lArray, n4, n8, n12, n16);
        Argon2BytesGenerator.F(lArray, n5, n9, n13, n17);
        Argon2BytesGenerator.F(lArray, n6, n10, n14, n18);
        Argon2BytesGenerator.F(lArray, n3, n8, n13, n18);
        Argon2BytesGenerator.F(lArray, n4, n9, n14, n15);
        Argon2BytesGenerator.F(lArray, n5, n10, n11, n16);
        Argon2BytesGenerator.F(lArray, n6, n7, n12, n17);
    }

    private static void F(long[] lArray, int n3, int n4, int n5, int n6) {
        long[] lArray2 = lArray;
        long[] lArray3 = lArray;
        Argon2BytesGenerator.quarterRound(lArray2, n3, n4, n6, 32);
        Argon2BytesGenerator.quarterRound(lArray3, n5, n6, n4, 24);
        Argon2BytesGenerator.quarterRound(lArray2, n3, n4, n6, 16);
        Argon2BytesGenerator.quarterRound(lArray3, n5, n6, n4, 63);
    }

    private static void quarterRound(long[] lArray, int n3, int n4, int n5, int n6) {
        long l3 = lArray[n3];
        long l4 = lArray[n4];
        l3 = a.a((l3 & 0xFFFFFFFFL) * 2L, l4 & 0xFFFFFFFFL, l4, l3);
        l4 = Longs.rotateRight(lArray[n5] ^ l3, n6);
        lArray[n3] = l3;
        lArray[n5] = l4;
    }

    private void initialize(byte[] byArray, byte[] objectArray, int n3) {
        Blake2bDigest blake2bDigest;
        Argon2BytesGenerator argon2BytesGenerator = object;
        Blake2bDigest blake2bDigest2 = blake2bDigest;
        byte[] byArray2 = objectArray;
        blake2bDigest2(512);
        int[] nArray = new int[6];
        objectArray = nArray;
        objectArray[0] = ((Argon2BytesGenerator)object).parameters.getLanes();
        objectArray[1] = n3;
        objectArray[2] = ((Argon2BytesGenerator)object).parameters.getMemory();
        objectArray[3] = ((Argon2BytesGenerator)object).parameters.getIterations();
        objectArray[4] = ((Argon2BytesGenerator)object).parameters.getVersion();
        objectArray[5] = ((Argon2BytesGenerator)object).parameters.getType();
        Pack.intToLittleEndian(nArray, byArray, 0);
        blake2bDigest2.update(byArray, 0, 24);
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, byArray2);
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, ((Argon2BytesGenerator)object).parameters.getSalt());
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, ((Argon2BytesGenerator)object).parameters.getSecret());
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, ((Argon2BytesGenerator)object).parameters.getAdditional());
        byte[] byArray3 = new byte[72];
        Object object = byArray3;
        blake2bDigest.doFinal(byArray3, 0);
        argon2BytesGenerator.fillFirstBlocks(byArray, (byte[])object);
    }

    private static void addByteString(byte[] byArray, Digest digest, byte[] byArray2) {
        if (byArray2 == null) {
            digest.update(ZERO_BYTES, 0, 4);
            return;
        }
        Pack.intToLittleEndian(byArray2.length, byArray, 0);
        digest.update(byArray, 0, 4);
        digest.update(byArray2, 0, byArray2.length);
    }

    private void fillFirstBlocks(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[72];
        byte[] byArray4 = byArray3;
        System.arraycopy(byArray2, 0, byArray4, 0, 64);
        byArray3[64] = 1;
        for (int i3 = 0; i3 < this.parameters.getLanes(); ++i3) {
            Argon2BytesGenerator argon2BytesGenerator = this;
            Argon2BytesGenerator argon2BytesGenerator2 = this;
            Pack.intToLittleEndian(i3, byArray2, 68);
            Pack.intToLittleEndian(i3, byArray4, 68);
            argon2BytesGenerator2.hash(byArray2, byArray, 0, 1024);
            argon2BytesGenerator2.memory[i3 * this.laneLength + 0].fromBytes(byArray);
            argon2BytesGenerator.hash(byArray4, byArray, 0, 1024);
            argon2BytesGenerator.memory[i3 * this.laneLength + 1].fromBytes(byArray);
        }
    }

    private long intToLong(int n3) {
        return (long)n3 & 0xFFFFFFFFL;
    }

    public void init(Argon2Parameters argon2Parameters) {
        this.parameters = argon2Parameters;
        if (argon2Parameters.getLanes() >= 1) {
            if (argon2Parameters.getLanes() <= 0x1000000) {
                if (argon2Parameters.getMemory() >= argon2Parameters.getLanes() * 2) {
                    if (argon2Parameters.getIterations() >= 1) {
                        this.doInit(argon2Parameters);
                        return;
                    }
                    throw new IllegalStateException("iterations is less than: 1");
                }
                throw new IllegalStateException(b.a("memory is less than: ").append(argon2Parameters.getLanes() * 2).append(" expected ").append(argon2Parameters.getLanes() * 2).toString());
            }
            throw new IllegalStateException("lanes must be less than 16777216");
        }
        throw new IllegalStateException("lanes must be greater than 1");
    }

    public int generateBytes(char[] cArray, byte[] byArray) {
        Argon2BytesGenerator argon2BytesGenerator = this;
        return argon2BytesGenerator.generateBytes(argon2BytesGenerator.parameters.getCharToByteConverter().convert(cArray), byArray);
    }

    public int generateBytes(char[] cArray, byte[] byArray, int n3, int n4) {
        Argon2BytesGenerator argon2BytesGenerator = this;
        return argon2BytesGenerator.generateBytes(argon2BytesGenerator.parameters.getCharToByteConverter().convert(cArray), byArray, n3, n4);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2) {
        int n3 = byArray2.length;
        return this.generateBytes(byArray, byArray2, 0, n3);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2, int n3, int n4) {
        if (n4 >= 4) {
            Argon2BytesGenerator argon2BytesGenerator = object;
            byte[] byArray3 = new byte[1024];
            Object object = byArray3;
            argon2BytesGenerator.initialize(byArray3, byArray, n4);
            argon2BytesGenerator.fillMemoryBlocks();
            argon2BytesGenerator.digest((byte[])object, byArray2, n3, n4);
            argon2BytesGenerator.reset();
            return n4;
        }
        throw new IllegalStateException("output length less than 4");
    }

    public static class Position {
        public int pass;
        public int lane;
        public int slice;
    }

    public static class Block {
        private static final int SIZE = 128;
        private final long[] v = new long[128];

        private Block() {
        }

        private void copyBlock(Block block) {
            System.arraycopy(block.v, 0, this.v, 0, 128);
        }

        private void xor(Block object, Block object2) {
            Object object3 = ((Block)object3).v;
            object = ((Block)object).v;
            object2 = ((Block)object2).v;
            for (int i3 = 0; i3 < 128; ++i3) {
                object3[i3] = object[i3] ^ object2[i3];
            }
        }

        private void xorWith(Block object) {
            Object object2 = ((Block)object2).v;
            object = ((Block)object).v;
            for (int i3 = 0; i3 < 128; ++i3) {
                object2[i3] = object2[i3] ^ object[i3];
            }
        }

        private void xorWith(Block object, Block object2) {
            Object object3 = ((Block)object3).v;
            object = ((Block)object).v;
            object2 = ((Block)object2).v;
            for (int i3 = 0; i3 < 128; ++i3) {
                object3[i3] = object3[i3] ^ (object[i3] ^ object2[i3]);
            }
        }

        public /* synthetic */ Block(1 var1_1) {
            this();
        }

        public void fromBytes(byte[] byArray) {
            if (byArray.length >= 1024) {
                Pack.littleEndianToLong(byArray, 0, this.v);
                return;
            }
            throw new IllegalArgumentException("input shorter than blocksize");
        }

        public void toBytes(byte[] byArray) {
            if (byArray.length >= 1024) {
                Pack.longToLittleEndian(this.v, byArray, 0);
                return;
            }
            throw new IllegalArgumentException("output shorter than blocksize");
        }

        public Block clear() {
            Block block = this;
            Arrays.fill(block.v, 0L);
            return block;
        }
    }

    public static class FillBlock {
        public Block R;
        public Block Z;
        public Block addressBlock;
        public Block inputBlock;

        private FillBlock() {
            Block block;
            Block block2;
            Block block3;
            Block block4;
            Object object = block4;
            block4 = new Block(null);
            v1.R = object;
            object = block3;
            block3 = new Block(null);
            v1.Z = object;
            object = block2;
            block2 = new Block(null);
            v1.addressBlock = object;
            object = block;
            block = new Block(null);
            v1.inputBlock = object;
        }

        private void applyBlake() {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            for (n17 = 0; n17 < 8; ++n17) {
                int n18 = n16 = n17 * 16;
                n15 = n18 + 1;
                n14 = n16 + 3;
                n13 = n16 + 4;
                n12 = n16 + 5;
                n11 = n16 + 6;
                n10 = n16 + 7;
                n9 = n16 + 8;
                n8 = n16 + 9;
                n7 = n16 + 10;
                n6 = n16 + 11;
                n5 = n16 + 12;
                n4 = n16 + 13;
                n3 = n16 + 14;
                Argon2BytesGenerator.roundFunction(this.Z, n18, n15, n16 + 2, n14, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3, n16 += 15);
            }
            for (n17 = 0; n17 < 8; ++n17) {
                int n19 = n16 = n17 * 2;
                n15 = n19 + 1;
                n14 = n16 + 17;
                n13 = n16 + 32;
                n12 = n16 + 33;
                n11 = n16 + 48;
                n10 = n16 + 49;
                n9 = n16 + 64;
                n8 = n16 + 65;
                n7 = n16 + 80;
                n6 = n16 + 81;
                n5 = n16 + 96;
                n4 = n16 + 97;
                n3 = n16 + 112;
                Argon2BytesGenerator.roundFunction(this.Z, n19, n15, n16 + 16, n14, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3, n16 += 113);
            }
        }

        private void fillBlock(Block block, Block block2) {
            FillBlock fillBlock = this;
            fillBlock.Z.copyBlock(block);
            fillBlock.applyBlake();
            block2.xor(block, fillBlock.Z);
        }

        private void fillBlock(Block block, Block block2, Block block3) {
            FillBlock fillBlock = block4;
            fillBlock.R.xor(block, block2);
            fillBlock.Z.copyBlock(((FillBlock)((Object)block4)).R);
            fillBlock.applyBlake();
            Block block4 = fillBlock.R;
            block3.xor(block4, fillBlock.Z);
        }

        private void fillBlockWithXor(Block block, Block block2, Block block3) {
            FillBlock fillBlock = block4;
            fillBlock.R.xor(block, block2);
            fillBlock.Z.copyBlock(((FillBlock)((Object)block4)).R);
            fillBlock.applyBlake();
            Block block4 = fillBlock.R;
            block3.xorWith(block4, fillBlock.Z);
        }

        public /* synthetic */ FillBlock(1 var1_1) {
            this();
        }
    }
}

