/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DigestDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ISO18033KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class BaseKDFBytesGenerator
implements DigestDerivationFunction {
    private int counterStart;
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BaseKDFBytesGenerator(int n3, Digest digest) {
        this.counterStart = n3;
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        block4: {
            block3: {
                block2: {
                    if (!(derivationParameters instanceof KDFParameters)) break block2;
                    BaseKDFBytesGenerator baseKDFBytesGenerator = kDFParameters;
                    KDFParameters kDFParameters = (KDFParameters)derivationParameters;
                    baseKDFBytesGenerator.shared = kDFParameters.getSharedSecret();
                    baseKDFBytesGenerator.iv = kDFParameters.getIV();
                    break block3;
                }
                if (!(derivationParameters instanceof ISO18033KDFParameters)) break block4;
                BaseKDFBytesGenerator baseKDFBytesGenerator = kDFParameters;
                baseKDFBytesGenerator.shared = ((ISO18033KDFParameters)derivationParameters).getSeed();
                baseKDFBytesGenerator.iv = null;
            }
            return;
        }
        throw new IllegalArgumentException("KDF parameters required for generator");
    }

    @Override
    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        if (byArray.length - n4 >= n3) {
            long l3 = n4;
            int n5 = this.digest.getDigestSize();
            if (l3 <= 0x1FFFFFFFFL) {
                BaseKDFBytesGenerator baseKDFBytesGenerator = this;
                long l4 = n5;
                int n6 = (int)((l3 + l4 - 1L) / l4);
                byte[] byArray2 = new byte[baseKDFBytesGenerator.digest.getDigestSize()];
                int n7 = 4;
                byte[] byArray3 = new byte[4];
                Pack.intToBigEndian(baseKDFBytesGenerator.counterStart, byArray3, 0);
                int n8 = baseKDFBytesGenerator.counterStart & 0xFFFFFF00;
                for (int i3 = 0; i3 < n6; ++i3) {
                    byte by;
                    BaseKDFBytesGenerator baseKDFBytesGenerator2 = this;
                    baseKDFBytesGenerator2.digest.update(this.shared, 0, this.shared.length);
                    baseKDFBytesGenerator2.digest.update(byArray3, 0, n7);
                    byte[] byArray4 = baseKDFBytesGenerator2.iv;
                    if (baseKDFBytesGenerator2.iv != null) {
                        this.digest.update(byArray4, 0, byArray4.length);
                    }
                    this.digest.doFinal(byArray2, 0);
                    if (n4 > n5) {
                        System.arraycopy(byArray2, 0, byArray, n3, n5);
                        n3 += n5;
                        n4 -= n5;
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n3, n4);
                    }
                    byArray3[3] = by = (byte)(byArray3[3] + 1);
                    if (by != 0) continue;
                    Pack.intToBigEndian(n8 += 256, byArray3, 0);
                }
                this.digest.reset();
                return (int)l3;
            }
            throw new IllegalArgumentException("Output length too large");
        }
        throw new OutputLengthException("output buffer too small");
    }
}

